package com.ejianc.business.pro.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
public interface IContractRegisterService extends IBaseService<ContractRegisterEntity> {

    ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO);

    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    List<ContractRegisterVO> excelExport(QueryParam param);

    ContractRegisterVO addRegisterByRevId(Long reviewId);
    
    ContractRegisterVO addSupplementByConId(Long mainContractId);
    
    RegisterSupplementHistoryVO querySupplementRecord(Long id);

    List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId);

    boolean pushContract(ContractRegisterVO map,Boolean updateLevel);

    boolean delContractFromPool(Long billId);

    List<Map<String,Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryCostWarnContract(List<SqlParam> sqlParamList);

    ContractReviewVO queryReviewByProject(Long projectId);

    List<Map<String,Object>> querySettleReportWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryFinalizedWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryBudgetInWarnContract(List<SqlParam> sqlParamList);

}
