package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.mapper.ClaimMapper;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 洽商签证索赔
 * 
 * @author generator
 * 
 */
@Service("claimService")
public class ClaimServiceImpl extends BaseServiceImpl<ClaimMapper, ClaimEntity> implements IClaimService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IClaimService claimService;

    @Autowired
    private IContractPoolApi contractPoolApi;
    
    @Override
    public ClaimRecordVO queryRecordByContractId(Long contractId) {
        ContractRegisterEntity entity = registerService.selectById(contractId);
        ClaimRecordVO claimRecordVO = new ClaimRecordVO();
        claimRecordVO.setChangeStatus(entity.getChangeStatus());
        claimRecordVO.setIsFinish(entity.getIsFinish());
        claimRecordVO.setIsRelieve(entity.getIsRelieve());
        claimRecordVO.setIsSuspend(entity.getIsSuspend());

        LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimEntity::getContractId,contractId);
        wrapper.eq(ClaimEntity::getDr,0);
        wrapper.in(ClaimEntity::getBillState,1,3);
        wrapper.eq(ClaimEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<ClaimEntity> list = this.list(wrapper);

        BigDecimal sumNegotiateMny = BigDecimal.ZERO; //变更洽商总金额(无税)
        BigDecimal sumNegotiateTaxMny = BigDecimal.ZERO; //变更洽商总金额

        BigDecimal sumVisaMny = BigDecimal.ZERO; //经济签证总金额(无税)
        BigDecimal sumVisaTaxMny= BigDecimal.ZERO; //经济签证总金额

        BigDecimal sumClaimMny = BigDecimal.ZERO; //索赔总金额(无税)
        BigDecimal sumClaimTaxMny = BigDecimal.ZERO; //索赔总金额

        BigDecimal sumMny = BigDecimal.ZERO; //二次经营总金额(无税)
        BigDecimal sumTaxMny = BigDecimal.ZERO; //二次经营总金额

        List<ClaimVO> claimVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            claimVOS = BeanMapper.mapList(list, ClaimVO.class);

            for (ClaimVO vo: claimVOS){
                if ("QS".equals(vo.getBillType())){
                    vo.setBillType("变更洽商单");
                    sumNegotiateMny = MathUtil.safeAdd(sumNegotiateMny,vo.getClaimMny());
                    sumNegotiateTaxMny = MathUtil.safeAdd(sumNegotiateTaxMny,vo.getClaimTaxMny());
                }else if("QZ".equals(vo.getBillType())){
                    vo.setBillType("经济签证单");
                    sumVisaMny = MathUtil.safeAdd(sumVisaMny,vo.getClaimMny());
                    sumVisaTaxMny = MathUtil.safeAdd(sumVisaTaxMny,vo.getClaimTaxMny());
                }else if("SP".equals(vo.getBillType())){
                    vo.setBillType("索赔单");
                    sumClaimMny = MathUtil.safeAdd(sumClaimMny,vo.getClaimMny());
                    sumClaimTaxMny = MathUtil.safeAdd(sumClaimTaxMny,vo.getClaimTaxMny());
                }
                sumMny = MathUtil.safeAdd(sumMny,vo.getClaimMny());
                sumTaxMny = MathUtil.safeAdd(sumTaxMny,vo.getClaimTaxMny());
            }
        }
        claimRecordVO.setContractId(contractId);

        claimRecordVO.setSumNegotiateMny(sumNegotiateMny);
        claimRecordVO.setSumNegotiateTaxMny(sumNegotiateTaxMny);

        claimRecordVO.setSumVisaMny(sumVisaMny);
        claimRecordVO.setSumVisaTaxMny(sumVisaTaxMny);

        claimRecordVO.setSumClaimMny(sumClaimMny);
        claimRecordVO.setSumClaimTaxMny(sumClaimTaxMny);

        claimRecordVO.setSumMny(sumMny);
        claimRecordVO.setSumTaxMny(sumTaxMny);

        claimRecordVO.setClaimRecord(claimVOS);
        return claimRecordVO;
    }


    /**
     * 更新合同池
     *
     * @param claimEntity
     * @return
     */
    @Override
    public boolean updateContract(ClaimEntity claimEntity,Boolean flag){
        ContractPoolVO data = new ContractPoolVO();
        try {

            LambdaQueryWrapper<ClaimEntity> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ClaimEntity::getContractId,claimEntity.getContractId());
            queryWrapper.ne(ClaimEntity::getId,claimEntity.getId());
            queryWrapper.in(ClaimEntity::getBillState,1,3);
            queryWrapper.eq(ClaimEntity::getDr,0);
            //queryWrapper.eq(ClaimEntity::getTenantId,InvocationInfoProxy.getTenantid());
            List<ClaimEntity> list = claimService.list(queryWrapper);

            BigDecimal totalClaimTaxMny = BigDecimal.ZERO;
            BigDecimal totalClaimMny = BigDecimal.ZERO;
            BigDecimal totalClaimTax = BigDecimal.ZERO;

            BigDecimal totalReplyTaxMny = BigDecimal.ZERO;
            BigDecimal totalReplyMny = BigDecimal.ZERO;
            BigDecimal totalReplyTax = BigDecimal.ZERO;

            if (CollectionUtils.isNotEmpty(list)){
                totalClaimTaxMny = list.stream().map(ClaimEntity::getClaimTaxMny).reduce(BigDecimal::add).get();
                totalClaimMny = list.stream().map(ClaimEntity::getClaimMny).reduce(BigDecimal::add).get();
                totalClaimTax = list.stream().map(ClaimEntity::getClaimTax).reduce(BigDecimal::add).get();

                List<ClaimEntity> collect = list.stream().filter(e -> "1".equals(e.getReplyStatus())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    totalReplyTaxMny = collect.stream().map(ClaimEntity::getReplyTaxMny).reduce(BigDecimal::add).get();
                    totalReplyMny = collect.stream().map(ClaimEntity::getReplyMny).reduce(BigDecimal::add).get();
                    totalReplyTax = collect.stream().map(ClaimEntity::getReplyTax).reduce(BigDecimal::add).get();
                }
            }

            if (flag){
                totalClaimTaxMny = MathUtil.safeAdd(totalClaimTaxMny,claimEntity.getClaimTaxMny());
                totalClaimMny = MathUtil.safeAdd(totalClaimMny,claimEntity.getClaimMny());
                totalClaimTax = MathUtil.safeAdd(totalClaimTax,claimEntity.getClaimTax());

                if ("1".equals(claimEntity.getReplyStatus())){
                    totalReplyTaxMny = MathUtil.safeAdd(totalReplyTaxMny,claimEntity.getReplyTaxMny());
                    totalReplyMny = MathUtil.safeAdd(totalReplyMny,claimEntity.getReplyMny());
                    totalReplyTax = MathUtil.safeAdd(totalReplyTax,claimEntity.getReplyTax());
                }
            }

            data.setId(claimEntity.getContractId());

            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(claimEntity.getContractId());

            data.setTotalClaimTaxMny(totalClaimTaxMny);
            data.setTotalClaimMny(totalClaimMny);
            data.setTotalClaimTax(totalClaimTax);

            data.setTotalTeplyTaxMny(totalReplyTaxMny);
            data.setTotalTeplyMny(totalReplyMny);
            data.setTotalTeplyTax(totalReplyTax);
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}更新合同池失败，{}",claimEntity.getContractId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}更新合同池失败，", claimEntity.getContractId(), e);
        }

        return false;

    }

    @Override
    public Boolean updateCostAdjustId(Long costAdjustId, List<Long> claimIdsList) {

        LambdaUpdateWrapper<ClaimEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ClaimEntity::getCostAdjustId, costAdjustId);
        updateWrapper.set(ClaimEntity::getCostAdjustId, null);
        this.update(updateWrapper);

        if (ListUtil.isNotEmpty(claimIdsList)) {
            LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.in(ClaimEntity::getId, claimIdsList);
            wrapper.set(ClaimEntity::getCostAdjustId, costAdjustId);
            this.update(wrapper);
        }

        return true;
    }

}
