package com.ejianc.business.pro.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.income.bean.UnsettleDetailEntity;
/**
 * 项目竣工未结推进表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_unsettle")
public class UnsettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 基层单位id
    @TableField(value="org_code")
    private String orgCode; // 基层单位编码
    @TableField(value="org_name")
    private String orgName; // 基层单位名称
    @TableField(value="unsettle_mny")
    private BigDecimal unsettleMny; // 截至目前竣工未结金额
    @TableField(value="finalize_back_mny")
    private BigDecimal finalizeBackMny; // 定案返回金额
    @TableField(value="disputed_mny")
    private BigDecimal disputedMny; // 争议金额
    @TableField(value="month_disputed_mny")
    private BigDecimal monthDisputedMny; // 本月已解决争议金额
    @TableField(value="month_disputed_num")
    private Integer monthDisputedNum; // 本月核销争议个数
    @TableField(value="sum_disputed_mny")
    private BigDecimal sumDisputedMny; // 累计已解决争议金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_code")
    private String departmentCode; // 经办人部门编码
    @TableField(value="department_name")
    private String departmentName; // 经办人部门名称
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="unsettleDetailService", pidName = "unsettleId")
    private List<UnsettleDetailEntity> unsettleDetailList = new ArrayList<>(); // 竣工未结明细
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getUnsettleMny() {
        return unsettleMny;
    }

    public void setUnsettleMny(BigDecimal unsettleMny) {
        this.unsettleMny = unsettleMny;
    }

    public BigDecimal getFinalizeBackMny() {
        return finalizeBackMny;
    }

    public void setFinalizeBackMny(BigDecimal finalizeBackMny) {
        this.finalizeBackMny = finalizeBackMny;
    }

    public BigDecimal getDisputedMny() {
        return disputedMny;
    }

    public void setDisputedMny(BigDecimal disputedMny) {
        this.disputedMny = disputedMny;
    }
    public BigDecimal getMonthDisputedMny() {
        return monthDisputedMny;
    }

    public void setMonthDisputedMny(BigDecimal monthDisputedMny) {
        this.monthDisputedMny = monthDisputedMny;
    }
    public Integer getMonthDisputedNum() {
        return monthDisputedNum;
    }

    public void setMonthDisputedNum(Integer monthDisputedNum) {
        this.monthDisputedNum = monthDisputedNum;
    }
    public BigDecimal getSumDisputedMny() {
        return sumDisputedMny;
    }

    public void setSumDisputedMny(BigDecimal sumDisputedMny) {
        this.sumDisputedMny = sumDisputedMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<UnsettleDetailEntity> getUnsettleDetailList() {
        return unsettleDetailList;
    }

    public void setUnsettleDetailList(List<UnsettleDetailEntity> unsettleDetailList) {
        this.unsettleDetailList = unsettleDetailList;
    }
}
