package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 项目竣工未结推进表
 *
 * @author generator
 */
@Controller
@RequestMapping("unsettle")
public class UnsettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "UNSETTLE_CODE";//此处需要根据实际修改

    @Autowired
    private IUnsettleService service;

    @Autowired
    private IUnsettleDetailService unsettleDetailService;

    @Autowired
    private IContractRegisterService contractRegisterService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private ISettleReportService settleReportService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnsettleVO> saveOrUpdate(@RequestBody UnsettleVO saveOrUpdateVO) {
        UnsettleEntity entity = BeanMapper.map(saveOrUpdateVO, UnsettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        UnsettleVO vo = BeanMapper.map(entity, UnsettleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnsettleVO> queryDetail(Long id) {
        UnsettleEntity entity = service.selectById(id);
        UnsettleVO vo = BeanMapper.map(entity, UnsettleVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param
     * @Description queryMny 查询详情
     */
    @RequestMapping(value = "/queryMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnsettleDetailVO> queryMny(Long projectId) {
        UnsettleDetailVO vo = new UnsettleDetailVO();
        // 合同金额  带项目的收入合同金额
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getProjectId, projectId);
        lambda.in(ContractRegisterEntity::getBillState, 1, 3);
        lambda.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> contractRegisterList = contractRegisterService.list(lambda);
        if (CollectionUtils.isNotEmpty(contractRegisterList)) {
            BigDecimal contractMny = contractRegisterList.stream().filter(item -> null != item.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setContractMny(contractMny);
            vo.setContractProgressScale(contractRegisterList.get(0).getContractPromisePaymentRate());
            vo.setContractSettleScale(contractRegisterList.get(0).getContractSettleRate());
        } else {
            vo.setContractMny(BigDecimal.ZERO);
            vo.setContractProgressScale(BigDecimal.ZERO);
            vo.setContractSettleScale(BigDecimal.ZERO);
        }
        // 累计实际完成产值   取项目下已生效的【产值报量】中的“产值金额”累计值
        LambdaQueryWrapper<ProductionEntity> lambda2 = Wrappers.<ProductionEntity>lambdaQuery();
        lambda2.eq(ProductionEntity::getProjectId, projectId);
        lambda2.in(ProductionEntity::getBillState, 1, 3);
        List<ProductionEntity> productionList = productionService.list(lambda2);
        if (CollectionUtils.isNotEmpty(productionList)) {
            BigDecimal productionTaxMny = productionList.stream().filter(item -> null != item.getProductionTaxMny()).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setSumCompleteMny(productionTaxMny);
        } else {
            vo.setSumCompleteMny(BigDecimal.ZERO);
        }

        LambdaQueryWrapper<SettleReportEntity> lambda3 = Wrappers.<SettleReportEntity>lambdaQuery();
        lambda3.eq(SettleReportEntity::getProjectId, projectId);
        lambda3.in(SettleReportEntity::getBillState, 1, 3);
        lambda3.orderByDesc(SettleReportEntity::getCreateTime);
        List<SettleReportEntity> settleReportList = settleReportService.list(lambda3);
        if (CollectionUtils.isNotEmpty(settleReportList)) {
            BigDecimal reportSettleTaxMny = settleReportList.stream().filter(item -> null != item.getReportSettleTaxMny()).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setDetailSubmitMny(reportSettleTaxMny);// 送审金额   取项目下已生效【结算报审】中的“报审结算金额”累计值
            vo.setDetailSubmitDate(settleReportList.get(0).getPredictCheckDate()); // 送审日期  取项目下已生效【结算报审】中最新一期的“报审结算日期”
        } else {
            vo.setDetailSubmitMny(BigDecimal.ZERO);// 送审金额   取项目下已生效【结算报审】中的“报审结算金额”累计值
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param
     * @Description queryYears 查询年列表
     */
    @RequestMapping(value = "/queryYears", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> queryYears() {
        Date signDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(signDate);
        calendar.add(Calendar.YEAR, -1);//签订时间减去一年，即签订一年前的时间
        calendar.getTime();//获取一年前的时间，或者一个月前的时间
        Date beforeDate = calendar.getTime();


        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date());
        calendar2.add(Calendar.YEAR, 1);//当前时间加一年，即一年后的时间
        Date endDate = calendar2.getTime();


        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        List<String> list = new ArrayList<>();
        do {
            list.add(sdf.format(endDate));
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(endDate);
            calendar3.add(Calendar.YEAR, -1);
            endDate = calendar3.getTime();
        } while (beforeDate.before(endDate));
        {
        }
        list.add(sdf.format(beforeDate));
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     * @param id 单据主键
     * @Description queryYears 查询年列表
     */
    @RequestMapping(value = "/queryMonths", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MonthVO>> queryMonths(Long id, String year) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String currentMonth = dateFormat.format(new Date());
        List<MonthVO> list = service.getMonths(id, year);
        Map<String, MonthVO> map = new HashMap<>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                map.put(e.getMonth(), e);
            });
        }
        List<MonthVO> listMonth = new ArrayList<>();
        for (int i = 1; i < 13; i++) {
            MonthVO vo = new MonthVO();
            if (i < 10) {
                vo.setMonth(year + "-0" + i);
                if (map.containsKey(vo.getMonth())) {
                    vo.setNum(map.get(vo.getMonth()).getNum());
                    vo.setResolvedDisputedMny(map.get(vo.getMonth()).getResolvedDisputedMny());
                } else {
                    vo.setNum(0);
                    vo.setResolvedDisputedMny(BigDecimal.ZERO);
                }
            } else {
                vo.setMonth(year + "-" + i);
                if (map.containsKey(vo.getMonth())) {
                    vo.setNum(map.get(vo.getMonth()).getNum());
                    vo.setResolvedDisputedMny(map.get(vo.getMonth()).getResolvedDisputedMny());
                } else {
                    vo.setNum(0);
                    vo.setResolvedDisputedMny(BigDecimal.ZERO);
                }
            }
            if (vo.getMonth().endsWith(currentMonth)) {
                vo.setFlag(true);
            } else {
                vo.setFlag(false);
            }
            listMonth.add(vo);
        }
        return CommonResponse.success("查询详情数据成功！", listMonth);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnsettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UnsettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UnsettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnsettleListVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        IPage<UnsettleEntity> page = service.queryPage(param, false);
        IPage<UnsettleListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<UnsettleListVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), UnsettleListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<UnsettleDetailEntity> lambda = Wrappers.<UnsettleDetailEntity>lambdaQuery();
            lambda.in(UnsettleDetailEntity::getUnsettleId, ids);
            List<UnsettleDetailEntity> resList = unsettleDetailService.list(lambda);
            List<UnsettleListVO> unsettleListVOList = BeanMapper.mapList(resList, UnsettleListVO.class);
            if (CollectionUtils.isNotEmpty(unsettleListVOList)) {
                unsettleListVOList.forEach(e -> {
                    e.setBillState(map.get(e.getUnsettleId()));
                    e.setFinalizeBackMny(e.getFinalizeMny() == null ? BigDecimal.ZERO : e.getFinalizeMny());
                    e.setDisputedMny(e.getDetailDisputedMny() == null ? BigDecimal.ZERO : e.getDetailDisputedMny());
                    if (e.getSubmissionFlag() != null) {
                        e.setSubmissionFlagName(e.getSubmissionFlag() == 0 ? "未送审" : "已送审");
                    }
                    ;
                    if (e.getSettleStage() != null) {
                        switch (e.getSettleStage()) {
                            case 1:
                                e.setSettleStageName("第一阶段");
                                break;
                            case 2:
                                e.setSettleStageName("第二阶段");
                                break;
                            case 3:
                                e.setSettleStageName("第三阶段");
                                break;
                            case 4:
                                e.setSettleStageName("第四阶段");
                                break;
                            case 5:
                                e.setSettleStageName("第五阶段");
                                break;
                        }
                    }
                });

                resDatas.addAll(unsettleListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnsettleListVO.class));
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnsettleEntity> list = service.queryList(param);
        List<UnsettleListVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> ids = list.stream().map(UnsettleEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<UnsettleDetailEntity> lambda = Wrappers.<UnsettleDetailEntity>lambdaQuery();
            lambda.in(UnsettleDetailEntity::getUnsettleId, ids);
            List<UnsettleDetailEntity> resList = unsettleDetailService.list(lambda);
            for (int i = 0; i < list.size(); i++) {
                resDatas.add(BeanMapper.map(list.get(i), UnsettleListVO.class));
                for (int k = 0; k < resList.size(); k++) {
                    if (list.get(i).getId().equals(resList.get(k).getUnsettleId())) {
                        UnsettleListVO e = BeanMapper.map(resList.get(k), UnsettleListVO.class);
                        e.setFinalizeBackMny(e.getFinalizeMny() == null ? BigDecimal.ZERO : e.getFinalizeMny());
                        e.setDisputedMny(e.getDetailDisputedMny() == null ? BigDecimal.ZERO : e.getDetailDisputedMny());
                        resDatas.add(e);
                    }
                }
            }


        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        resDatas.forEach(e -> {
            //送审状态
            if (e.getSubmissionFlag() != null) {
                if (e.getSubmissionFlag() == 1) {
                    e.setSubmissionFlagName("已送审");
                } else {
                    e.setSubmissionFlagName("未送审");
                }
            }

            //结算阶段
            if (e.getSettleStage() != null) {
                switch (e.getSettleStage()) {
                    case 1:
                        e.setSettleStageName("第一阶段");
                        break;
                    case 2:
                        e.setSettleStageName("第二阶段");
                        break;
                    case 3:
                        e.setSettleStageName("第三阶段");
                        break;
                    case 4:
                        e.setSettleStageName("第四阶段");
                        break;
                    case 5:
                        e.setSettleStageName("第五阶段");
                        break;
                }
            }

            //指标等级
            if (e.getIndexGrade() != null) {
                switch (e.getIndexGrade()) {
                    case 1:
                        e.setIndexGradeName("一类");
                        break;
                    case 2:
                        e.setIndexGradeName("二类");
                        break;
                }
            }
            //计划完成日期
            if (e.getScheduleCompletionDate() != null) {
                switch (e.getScheduleCompletionDate()) {
                    case 1:
                        e.setScheduleCompletionDateName("第一季度");
                        break;
                    case 2:
                        e.setScheduleCompletionDateName("第二季度");
                        break;
                    case 3:
                        e.setScheduleCompletionDateName("第三季度");
                        break;
                    case 4:
                        e.setScheduleCompletionDateName("第四季度");
                        break;
                }
            }
        });
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Unsettle-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refUnsettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnsettleVO>> refUnsettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnsettleEntity> page = service.queryPage(param, false);
        IPage<UnsettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnsettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
