/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IMemorandumService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.vo.MemorandumVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memorandum/"})
public class MemorandumController {
    @Autowired
    private IMemorandumService memorandumService;
    @Autowired
    private ISettleReportService settleReportService;

    @PostMapping(value={"saveOrUpdateBatch"})
    public CommonResponse<List<MemorandumVO>> saveOrUpdateBatch(@RequestBody List<MemorandumVO> memoList) {
        return CommonResponse.success(this.memorandumService.saveOrUpdateMemoBatch(memoList));
    }

    @GetMapping(value={"getListBySettleReport"})
    public CommonResponse<List<MemorandumVO>> getListBySettleReport(@RequestParam Long settleReportId, @RequestParam String settleStage) {
        List<String> list = Arrays.asList(settleStage.split(","));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"settle_report_id", (Object)settleReportId);
        query.in((Object)"settle_stage", list);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List entities = this.memorandumService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            return CommonResponse.success((Object)BeanMapper.mapList((Iterable)entities, MemorandumVO.class));
        }
        return CommonResponse.success(new ArrayList());
    }

    @GetMapping(value={"getMemorandumByProjectId"})
    public CommonResponse<List<MemorandumVO>> getMemorandumByProjectId(@RequestParam Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SettleReportEntity::getProjectId, (Object)projectId);
        lambda.in(SettleReportEntity::getBillState, new Object[]{1, 2, 3, 5});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List settleReportList = this.settleReportService.list((Wrapper)lambda);
        ArrayList ids = new ArrayList();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settleReportList)) {
            settleReportList.forEach(e -> {
                ids.add(e.getId());
                map.put(e.getId(), e.getBillCode());
            });
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"settle_report_id", ids);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List entities = this.memorandumService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                List resList = BeanMapper.mapList((Iterable)entities, MemorandumVO.class);
                resList.forEach(e -> e.setBillCode((String)map.get(e.getSettleReportId())));
                return CommonResponse.success((Object)resList);
            }
        }
        return CommonResponse.success(new ArrayList());
    }
}

