/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.PlancompletionDetailEntity;
import com.ejianc.business.pro.income.bean.PlancompletionEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IPlancompletionDetailService;
import com.ejianc.business.pro.income.service.IPlancompletionService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.PlancompletionDetailVO;
import com.ejianc.business.pro.income.vo.PlancompletionListVO;
import com.ejianc.business.pro.income.vo.PlancompletionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"plancompletion"})
public class PlancompletionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLANCOMPLETION_CODE";
    @Autowired
    private IPlancompletionService service;
    @Autowired
    private IPlancompletionDetailService plancompletionDetailService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private ISettleReportService settleReportService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlancompletionVO> saveOrUpdate(@RequestBody PlancompletionVO saveOrUpdateVO) {
        PlancompletionEntity entity;
        List list;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlancompletionEntity::getYear, (Object)saveOrUpdateVO.getYear());
        lambda.in(PlancompletionEntity::getOrgId, new Object[]{saveOrUpdateVO.getOrgId()});
        if (null != saveOrUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)lambda)))) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5728\u8be5\u5e74\u4efd\u4e0b\u5df2\u5b58\u5728\u5bf9\u6bd4\u8868\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5e74\u4efd\uff01");
        }
        List detailVOList = saveOrUpdateVO.getPlancompletionDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            detailVOList.forEach(e -> {
                if (null != e.getParentProjectId()) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(PlancompletionDetailEntity::getParentProjectId, (Object)e.getParentProjectId());
                    lambda2.orderByDesc(BaseEntity::getCreateTime);
                    List resList = this.plancompletionDetailService.list((Wrapper)lambda2);
                    if (CollectionUtils.isNotEmpty((Collection)resList) && !e.getApproveDate().equals(((PlancompletionDetailEntity)((Object)((Object)resList.get(0)))).getApproveDate())) {
                        throw new BusinessException("\u7236\u9879\u76ee\u540d\u79f0\u4e3a\u3010" + e.getParentProjectName() + "\u3011\u4e0e\u5df2\u6709\u5355\u636e\u4e2d\u7684\u8ba1\u5212\u5ba1\u5b9a\u65e5\u671f\u3010" + ((PlancompletionDetailEntity)((Object)((Object)resList.get(0)))).getApproveDate() + "\u3011\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6c9f\u901a\u540e\u8c03\u6574");
                    }
                }
            });
        }
        if ((entity = (PlancompletionEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlancompletionEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlancompletionVO vo = (PlancompletionVO)BeanMapper.map((Object)((Object)entity), PlancompletionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlancompletionVO> queryDetail(Long id) {
        PlancompletionEntity entity = (PlancompletionEntity)((Object)this.service.selectById(id));
        PlancompletionVO vo = (PlancompletionVO)BeanMapper.map((Object)((Object)entity), PlancompletionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlancompletionDetailVO> queryMny(Long projectId) {
        PlancompletionDetailVO vo = new PlancompletionDetailVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        lambda.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        List contractRegisterList = this.contractRegisterService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterList)) {
            BigDecimal contractMny = contractRegisterList.stream().filter(item -> null != item.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setContractMny(contractMny);
        } else {
            vo.setContractMny(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(ProductionEntity::getProjectId, (Object)projectId);
        lambda2.in(ProductionEntity::getBillState, new Object[]{1, 3});
        List productionList = this.productionService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)productionList)) {
            BigDecimal productionTaxMny = productionList.stream().filter(item -> null != item.getProductionTaxMny()).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setSumCompleteMny(productionTaxMny);
        } else {
            vo.setSumCompleteMny(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(SettleReportEntity::getProjectId, (Object)projectId);
        lambda3.in(SettleReportEntity::getBillState, new Object[]{1, 3});
        lambda3.orderByDesc(BaseEntity::getCreateTime);
        List settleReportList = this.settleReportService.list((Wrapper)lambda3);
        if (CollectionUtils.isNotEmpty((Collection)settleReportList)) {
            BigDecimal reportSettleTaxMny = settleReportList.stream().filter(item -> null != item.getReportSettleTaxMny()).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal predictCheckMny = settleReportList.stream().filter(item -> null != item.getPredictCheckMny()).map(SettleReportEntity::getPredictCheckMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setDetailSubmitMny(reportSettleTaxMny);
            vo.setYdApproveMny(predictCheckMny);
            vo.setDetailSubmitDate(((SettleReportEntity)((Object)settleReportList.get(0))).getReportDate());
            String unitProperty = ((SettleReportEntity)((Object)settleReportList.get(0))).getUnitProperty() == null ? "1" : ((SettleReportEntity)((Object)settleReportList.get(0))).getUnitProperty();
            vo.setGroupType(Integer.valueOf(Integer.parseInt(unitProperty)));
        } else {
            vo.setDetailSubmitMny(BigDecimal.ZERO);
            vo.setYdApproveMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlancompletionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlancompletionVO plancompletionVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlancompletionListVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlancompletionListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlancompletionDetailEntity::getCompletionId, ids);
            List resList = this.plancompletionDetailService.list((Wrapper)lambda);
            List plancompletionListVOList = BeanMapper.mapList((Iterable)resList, PlancompletionListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)plancompletionListVOList)) {
                plancompletionListVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getCompletionId()));
                    e.setYearApproveMny(e.getYdApproveMny() == null ? BigDecimal.ZERO : e.getYdApproveMny());
                    e.setYearSubmitMny(e.getDetailSubmitMny() == null ? BigDecimal.ZERO : e.getDetailSubmitMny());
                    e.setGroupMny(e.getFinalizeMny() == null ? BigDecimal.ZERO : e.getFinalizeMny());
                });
                resDatas.addAll(plancompletionListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlancompletionListVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<Object> resDatas = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlancompletionDetailEntity::getCompletionId, ids);
            List resList = this.plancompletionDetailService.list((Wrapper)lambda);
            for (int i = 0; i < list.size(); ++i) {
                resDatas.add(BeanMapper.map(list.get(i), PlancompletionListVO.class));
                for (int k = 0; k < resList.size(); ++k) {
                    PlancompletionListVO e2;
                    if (!((PlancompletionEntity)((Object)list.get(i))).getId().equals(((PlancompletionDetailEntity)((Object)resList.get(k))).getCompletionId())) continue;
                    e2.setYearApproveMny((e2 = (PlancompletionListVO)BeanMapper.map(resList.get(k), PlancompletionListVO.class)).getYdApproveMny() == null ? BigDecimal.ZERO : e2.getYdApproveMny());
                    e2.setYearSubmitMny(e2.getDetailSubmitMny() == null ? BigDecimal.ZERO : e2.getDetailSubmitMny());
                    e2.setGroupMny(e2.getFinalizeMny() == null ? BigDecimal.ZERO : e2.getFinalizeMny());
                    resDatas.add(e2);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(resDatas)) {
            resDatas.forEach(e -> {
                if (null != e.getGroupType()) {
                    e.setGroupTypeName(e.getGroupType() == 1 ? "\u5185" : "\u5916");
                }
                if (null != e.getYearPlanFlag()) {
                    e.setYearPlanFlagName(e.getYearPlanFlag() == 0 ? "\u662f" : "\u5426");
                }
            });
        }
        HashMap<String, ArrayList<Object>> beans = new HashMap<String, ArrayList<Object>>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plancompletion-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlancompletionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlancompletionVO>> refPlancompletionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlancompletionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

