package com.ejianc.business.pro.income.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 施工合同交底
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_contract_confess")
public class ContractConfessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 交底人
    @TableField(value="employee_name")
    private String employeeName; // 交底人名称
    @TableField(value="dept_id")
    private Long deptId; // 交底部门
    @TableField(value="dept_name")
    private String deptName; // 交底部门名称
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方
    @TableField(value="customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value="architect_id")
    private Long architectId; // 建造师
    @TableField(value="architect_name")
    private String architectName; // 建造师名称
    @TableField(value="manager_id")
    private Long managerId; // 项目责任人
    @TableField(value="manager_name")
    private String managerName; // 项目责任人名称
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类型
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类型名称
    @TableField(value="confess_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date confessDate; // 交底日期
    @TableField(value="contract_scope")
    private String contractScope; // 承包范围
    @TableField(value="funds_source")
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @TableField(value="schedule")
    private Integer schedule; // 工期
    @TableField(value="quality_requirement")
    private String qualityRequirement; // 质量要求
    @TableField(value="safety_goal")
    private String safetyGoal; // 安全目标
    @TableField(value="civilization_construction_goal")
    private String civilizationConstructionGoal; // 文明施工目标
    @TableField(value="advance_payment")
    private Integer advancePayment; // 预付款：0-无，1-有
    @TableField(value="progress_payment")
    private Integer progressPayment; // 工程进度款支付：0-按节点支付，1-按月支付
    @TableField(value="node_payment")
    private String nodePayment; // 按节点支付
    @TableField(value="month_payment")
    private String monthPayment; // 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
    @TableField(value="quality_deposit")
    private String qualityDeposit; // 质量保证金：0-3%，1-5%
    @TableField(value="price_adjustment")
    private String priceAdjustment; // 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
    @TableField(value="breach")
    private String breach; // 违约
    @TableField(value="bill_type")
    private Integer billType; // 单据类型
    @TableField(value="other_terms")
    private String otherTerms; // 其它条款
    @TableField(value="advance_payment_info")
    private java.lang.String advancePaymentInfo; // 预付款信息
    @TableField(value="price_adjustment_second")
    private java.lang.String priceAdjustmentSecond; // 价格调整2：0-采用造价信息进行价格调整，1-采用价格指数进行价格调整，2-专用合同条款约定的其他方式
    @TableField(value="price_adjustment_third")
    private java.lang.String priceAdjustmentThird; // 价格调整3：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    @TableField(value="price_adjustment_info")
    private java.lang.String priceAdjustmentInfo; // 法律变化引起的调整信息
    @TableField(value="price_adjustment_third_two")
    private java.lang.String priceAdjustmentThirdTwo; // 采用价格指数进行价格调整信息
    @TableField(value="price_adjustment_third_three")
    private java.lang.String priceAdjustmentThirdThree; // 专用合同条款约定的其他方式信息
    @TableField(value="price_adjustment_third_one")
    private java.lang.String priceAdjustmentThirdOne; // 采用价格信息进行价格调整信息
    @TableField(value="precautions")
    private String precautions; //履约注意事项/
    @TableField(value="payment_term")
    private String paymentTerm; //支付条款描述
    @TableField(value="fixed_payment_rate")
    private BigDecimal fixedPaymentRate; //固定付款比例

    @TableField(exist=false)
    @SubEntity(serviceName="contractConfessDetailService", pidName = "confessId")
    private List<ContractConfessDetailEntity> clauseList = new ArrayList<>(); // 合同交底明细

    @TableField(value="funds_source_id")
    private Long fundsSourceId; // 资金来源(自定义档案)

    public String getPriceAdjustmentThirdOne() {
        return priceAdjustmentThirdOne;
    }

    public void setPriceAdjustmentThirdOne(String priceAdjustmentThirdOne) {
        this.priceAdjustmentThirdOne = priceAdjustmentThirdOne;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 交底人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 交底人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 交底人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 交底人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 交底部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 交底部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 交底部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 交底部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 合同甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 建造师
     */
    public Long getArchitectId() {
        return architectId;
    }

    /**
     * 建造师
     */
    public void setArchitectId(Long architectId) {
        this.architectId = architectId;
    }
    /**
     * 建造师名称
     */
    public String getArchitectName() {
        return architectName;
    }

    /**
     * 建造师名称
     */
    public void setArchitectName(String architectName) {
        this.architectName = architectName;
    }
    /**
     * 项目责任人
     */
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 项目责任人
     */
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    /**
     * 项目责任人名称
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 项目责任人名称
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 工程类型
     */
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类型
     */
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 交底日期
     */
    public java.util.Date getConfessDate() {
        return confessDate;
    }

    /**
     * 交底日期
     */
    public void setConfessDate(java.util.Date confessDate) {
        this.confessDate = confessDate;
    }
    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }
    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }
    /**
     * 质量要求
     */
    public String getQualityRequirement() {
        return qualityRequirement;
    }

    /**
     * 质量要求
     */
    public void setQualityRequirement(String qualityRequirement) {
        this.qualityRequirement = qualityRequirement;
    }
    /**
     * 安全目标
     */
    public String getSafetyGoal() {
        return safetyGoal;
    }

    /**
     * 安全目标
     */
    public void setSafetyGoal(String safetyGoal) {
        this.safetyGoal = safetyGoal;
    }
    /**
     * 文明施工目标
     */
    public String getCivilizationConstructionGoal() {
        return civilizationConstructionGoal;
    }

    /**
     * 文明施工目标
     */
    public void setCivilizationConstructionGoal(String civilizationConstructionGoal) {
        this.civilizationConstructionGoal = civilizationConstructionGoal;
    }
    /**
     * 预付款：0-无，1-有
     */
    public Integer getAdvancePayment() {
        return advancePayment;
    }

    /**
     * 预付款：0-无，1-有
     */
    public void setAdvancePayment(Integer advancePayment) {
        this.advancePayment = advancePayment;
    }
    /**
     * 工程进度款支付：0-按节点支付，1-按月支付
     */
    public Integer getProgressPayment() {
        return progressPayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，1-按月支付
     */
    public void setProgressPayment(Integer progressPayment) {
        this.progressPayment = progressPayment;
    }
    /**
     * 按节点支付
     */
    public String getNodePayment() {
        return nodePayment;
    }

    /**
     * 按节点支付
     */
    public void setNodePayment(String nodePayment) {
        this.nodePayment = nodePayment;
    }
    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public String getMonthPayment() {
        return monthPayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public void setMonthPayment(String monthPayment) {
        this.monthPayment = monthPayment;
    }
    /**
     * 质量保证金：0-3%，1-5%
     */
    public String getQualityDeposit() {
        return qualityDeposit;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public void setQualityDeposit(String qualityDeposit) {
        this.qualityDeposit = qualityDeposit;
    }
    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public String getPriceAdjustment() {
        return priceAdjustment;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public void setPriceAdjustment(String priceAdjustment) {
        this.priceAdjustment = priceAdjustment;
    }

    /**
     * 违约
     */
    public String getBreach() {
        return breach;
    }

    /**
     * 违约
     */
    public void setBreach(String breach) {
        this.breach = breach;
    }

    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getOtherTerms() {
        return otherTerms;
    }

    public void setOtherTerms(String otherTerms) {
        this.otherTerms = otherTerms;
    }

    public String getAdvancePaymentInfo() {
        return advancePaymentInfo;
    }

    public void setAdvancePaymentInfo(String advancePaymentInfo) {
        this.advancePaymentInfo = advancePaymentInfo;
    }

    public String getPriceAdjustmentSecond() {
        return priceAdjustmentSecond;
    }

    public void setPriceAdjustmentSecond(String priceAdjustmentSecond) {
        this.priceAdjustmentSecond = priceAdjustmentSecond;
    }

    public String getPriceAdjustmentThird() {
        return priceAdjustmentThird;
    }

    public void setPriceAdjustmentThird(String priceAdjustmentThird) {
        this.priceAdjustmentThird = priceAdjustmentThird;
    }

    public String getPriceAdjustmentInfo() {
        return priceAdjustmentInfo;
    }

    public void setPriceAdjustmentInfo(String priceAdjustmentInfo) {
        this.priceAdjustmentInfo = priceAdjustmentInfo;
    }

    public String getPriceAdjustmentThirdTwo() {
        return priceAdjustmentThirdTwo;
    }

    public void setPriceAdjustmentThirdTwo(String priceAdjustmentThirdTwo) {
        this.priceAdjustmentThirdTwo = priceAdjustmentThirdTwo;
    }

    public String getPriceAdjustmentThirdThree() {
        return priceAdjustmentThirdThree;
    }

    public void setPriceAdjustmentThirdThree(String priceAdjustmentThirdThree) {
        this.priceAdjustmentThirdThree = priceAdjustmentThirdThree;
    }

    public List<ContractConfessDetailEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractConfessDetailEntity> clauseList) {
        this.clauseList = clauseList;
    }


    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    public String getPrecautions() {
        return precautions;
    }

    public void setPrecautions(String precautions) {
        this.precautions = precautions;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getFixedPaymentRate() {
        return fixedPaymentRate;
    }

    public void setFixedPaymentRate(BigDecimal fixedPaymentRate) {
        this.fixedPaymentRate = fixedPaymentRate;
    }
}
