package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 施工合同登记
 *
 * @author generator
 */
@TableName("ejc_income_contract_register")
public class ContractRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "review_id")
    private Long reviewId; // 合同评审
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编号
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_code")
    private String orgCode; // 组织编码
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "bear_type")
    private Long bearType; // 承揽方式
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_type")
    private Long contractType; // 合同类型
    @TableField(value = "contract_category_id")
    private Long contractCategoryId; //合同类别
    @TableField(value = "sign_date")
    private java.util.Date signDate; // 签约日期
    @TableField(value = "customer_id")
    private Long customerId; // 合同甲方
    @TableField(value = "customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 合同乙方
    @TableField(value = "supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value = "construction_partner")
    private String constructionPartner; // 施工联合方
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @TableField(value = "start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @TableField(value = "end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @TableField(value = "schedule")
    private Integer schedule; // 工期
    @TableField(value = "contract_valuation_type")
    private Long contractValuationType; // 合同计价形式，档案
    @TableField(value = "contract_status")
    private String contractStatus; // 合同状态：0-未签订，1-履约中, 2-已终止，3-已解除，4-已冻结
    @TableField(value = "contract_partyc")
    private String contractPartyc; // 合同丙方
    @TableField(value = "conjoined_contract_total_mny")
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额
    @TableField(value = "cost_change_total_mny")
    private BigDecimal costChangeTotalMny; // 工程造价及变动计总金额(无税)
    @TableField(value = "cost_change_total_tax_mny")
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    @TableField(value = "provisional_mny")
    private BigDecimal provisionalMny; // 暂列金额
    @TableField(value = "contract_promise_payment_rate")
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "dept_id")
    private Long deptId; // 经办部门
    @TableField(value = "dept_name")
    private String deptName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value = "base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value = "base_tax")
    private BigDecimal baseTax; // 初始版本税额
    @TableField(value = "before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value = "before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value = "changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value = "changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value = "change_status")
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value = "change_code")
    private String changeCode; // 变更单号
    @TableField(value = "change_id")
    private Long changeId; // 变更主键
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因
    @TableField(value = "main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value = "main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value = "main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value = "sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    @TableField(value = "sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值报量
    @TableField(value = "sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    @TableField(value = "sum_quote_mny")
    private BigDecimal sumQuoteMny; // 累计甲方报量
    @TableField(value = "sum_collect_mny")
    private BigDecimal sumCollectMny; // 累计收款
    @TableField(value = "sum_invoicing_tax_mny")
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    @TableField(value = "sum_invoicing_mny")
    private BigDecimal sumInvoicingMny; // 累计开票
    @TableField(value = "sum_negotiate_mny")
    private BigDecimal sumNegotiateMny; // 变更洽商总金额(无税)
    @TableField(value = "sum_negotiate_tax_mny")
    private BigDecimal sumNegotiateTaxMny; // 变更洽商总金额
    @TableField(value = "sum_visa_mny")
    private BigDecimal sumVisaMny; // 经济签证总金额(无税)
    @TableField(value = "sum_visa_tax_mny")
    private BigDecimal sumVisaTaxMny; // 经济签证总金额
    @TableField(value = "sum_claim_mny")
    private BigDecimal sumClaimMny; // 索赔总金额(无税)
    @TableField(value = "sum_claim_tax_mny")
    private BigDecimal sumClaimTaxMny; // 索赔总金额
    @TableField(value = "sum_operate_mny")
    private BigDecimal sumOperateMny; // 累计变更洽商金额(无税)
    @TableField(value = "sum_operate_tax_mny")
    private BigDecimal sumOperateTaxMny; // 累计变更洽商金额
    @TableField(value = "sum_material_settle_mny")
    private BigDecimal sumMaterialSettleMny; // 累计甲供材结算金额(无税)
    @TableField(value = "sum_material_settle_tax_mny")
    private BigDecimal sumMaterialSettleTaxMny; // 累计甲供材结算金额
    @TableField(value = "supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value = "is_finish")
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    @TableField(value = "is_relieve")
    private Integer isRelieve; // 是否已解除：0-否，1-是
    @TableField(value = "supplier_phone")
    private String supplierPhone; // 乙方电话
    @TableField(value = "customer_phone")
    private String customerPhone; // 甲方电话
    @TableField(value = "customer_entrusted_agent")
    private String customerEntrustedAgent; // 甲方委托代理人
    @TableField(value = "supplier_entrusted_agent")
    private String supplierEntrustedAgent; // 乙方委托代理人
    @TableField(value = "dispute_resolution")
    private Long disputeResolution; // 争议解决方式
    @TableField(value = "dispute_resolution_agency")
    private String disputeResolutionAgency; // 争议解决机构
    @TableField(value = "settlement_type")
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算

    @TableField(value = "supplement_content")
    private String supplementContent; // 协议内容
    @TableField(value = "contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value = "is_suspend")
    private Integer isSuspend; // 是否中止：0-否，1-是
    @TableField(value = "construct_id")
    private Long constructId;
    @TableField(value = "construct_name")
    private String constructName;//建设单位

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "contract_sign_date")
    private java.util.Date contractSignDate; // 合同标注签订日期

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "contract_stamp_date")
    private java.util.Date contractStampDate; // 合同盖章日期

    @TableField(value = "contract_stamp_num")
    private Integer contractStampNum; // 盖章份数

    @TableField(value = "contract_back")
    private Integer contractBack; // 合同是否返回：1-是，2-否

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "contract_back_date")
    private java.util.Date contractBackDate; // 合同返回日期

    @TableField(value = "back_num")
    private Integer backNum; // 返回份数

    @TableField(value = "report_jt")
    private Integer reportJt; // 是否上报集团：1-是，2-否

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "report_jt_date")
    private java.util.Date reportJtDate; // 合同上报集团时间

    @TableField(value = "contract_presentation")
    private Integer contractPresentation; // 合同是否交底：1-是，2-否


    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    @TableField(value = "not_include_provisional_mny")
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)

    @TableField(value = "is_estimation")
    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    @TableField(value = "total_cost_adjust_tax_mny")
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    @TableField(value = "total_cost_adjust_mny")
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    @TableField(value = "total_cost_adjust_tax")
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    @TableField(value = "total_after_cost_adjust_tax_mny")
    private BigDecimal totalAfterCostAdjustTaxMny; // 工程造价调整后总金额
    @TableField(value = "total_after_cost_adjust_mny")
    private BigDecimal totalAfterCostAdjustMny; // 工程造价调整后总金额(无税)
    @TableField(value = "total_after_cost_adjust_tax")
    private BigDecimal totalAfterCostAdjustTax; // 工程造价调整后税额
    @TableField(value = "nic_contract_mny")
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)
    @TableField(value = "progress_payment_clause")
    private String progressPaymentClause; // 工程进度款支付条款
    @TableField(value="project_address")
    private String projectAddress; // 工程地点

    @TableField(value="contract_range")
    private String contractRange; // 合同范围
    @TableField(value="schedule_default_mny")
    private String scheduleDefaultMny; // 工期违约金
    @TableField(value="quality_require")
    private String qualityRequire; // 质量要求
    @TableField(value="execute_project_manager")
    private String executeProjectManager; // 执行项目经理
    @TableField(value="performance_mny_type_id")
    private Long performanceMnyTypeId; // 履约保证金
    @TableField(value="performance_mny_type_name")
    private String performanceMnyTypeName; // 履约保证金类型名称
    @TableField(value="performance_mny_type_rate")
    private String performanceMnyTypeRate; // 履约保证金-比例
    @TableField(value="advance_payment_rate")
    private BigDecimal advancePaymentRate; // 预付款比例（%）
    @TableField(value="progress_payment_condition")
    private String progressPaymentCondition; // 进度款支付条件
    @TableField(value="defect_response_time")
    private String defectResponseTime; // 缺陷责任期
    @TableField(value="retention_mny_rate")
    private BigDecimal retentionMnyRate; // 质保金比例（%）

    /**
     * 建设模式Id
     */
    @TableField(value = "construction_mode_id")
    private Long constructionModeId;
    /**
     * 建设模式名称
     */
    @TableField(value = "construction_mode_name")
    private String constructionModeName;

    /**
     * 是否联合体：0-否，1-是
     */
    @TableField(value = "combo_flag")
    private String comboFlag;

    /**
     * 联合体单位：（供应商Id）
     */
    @TableField(value = "combo_id")
    private Long comboId;
    /**
     * 联合体单位编码（供应商编码）
     */
    @TableField(value = "combo_code")
    private String comboCode;
    /**
     * 联合体单位名称（供应商名称）
     */
    @TableField(value = "combo_name")
    private String comboName;

    /**
     * 项目经理
     */
    @TableField(value = "project_manager_name")
    private String projectManagerName;

    /**
     * 合同金额（集团项目）
     */
    @TableField(value = "project_contract_mny")
    private BigDecimal projectContractMny;

    /**
     * 合同金额（集团项目）万元
     */
    @TableField(value = "project_contract_mny_wan")
    private BigDecimal projectContractMnyWan;

    /**
     * 建设单位分类id
     */
    @TableField(value = "construction_units_id")
    private Long constructionUnitsId;

    /**
     * 建设单位分类名称
     */
    @TableField(value = "construction_units_name")
    private String constructionUnitsName;

    @TableField(value="contract_settle_rate")
    private BigDecimal contractSettleRate; //合同约定竣工结算支付比例
    @TableField(value="settle_condition")
    private String settleCondition; //竣工结算支付条件


    @TableField(value = "is_parent_project")
    private Integer isParentProject; // 是否父项目：1 是 2否
    @TableField(value="contract_register_name")
    private String contractRegisterName; //上游合同项目名称
    @TableField(value = "construction_unit")
    private Integer constructionUnit; // 建设单位性质：1集团内/2集团外


    public Integer getIsParentProject() {
        return isParentProject;
    }

    public void setIsParentProject(Integer isParentProject) {
        this.isParentProject = isParentProject;
    }

    public String getContractRegisterName() {
        return contractRegisterName;
    }

    public void setContractRegisterName(String contractRegisterName) {
        this.contractRegisterName = contractRegisterName;
    }

    public Integer getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Integer constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    public BigDecimal getContractSettleRate() {
        return contractSettleRate;
    }

    public void setContractSettleRate(BigDecimal contractSettleRate) {
        this.contractSettleRate = contractSettleRate;
    }

    public String getSettleCondition() {
        return settleCondition;
    }

    public void setSettleCondition(String settleCondition) {
        this.settleCondition = settleCondition;
    }

    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }

    public Date getContractStampDate() {
        return contractStampDate;
    }

    public void setContractStampDate(Date contractStampDate) {
        this.contractStampDate = contractStampDate;
    }

    public Integer getContractStampNum() {
        return contractStampNum;
    }

    public void setContractStampNum(Integer contractStampNum) {
        this.contractStampNum = contractStampNum;
    }

    public Integer getContractBack() {
        return contractBack;
    }

    public void setContractBack(Integer contractBack) {
        this.contractBack = contractBack;
    }

    public Date getContractBackDate() {
        return contractBackDate;
    }

    public void setContractBackDate(Date contractBackDate) {
        this.contractBackDate = contractBackDate;
    }

    public Integer getBackNum() {
        return backNum;
    }

    public void setBackNum(Integer backNum) {
        this.backNum = backNum;
    }

    public Integer getReportJt() {
        return reportJt;
    }

    public void setReportJt(Integer reportJt) {
        this.reportJt = reportJt;
    }

    public Date getReportJtDate() {
        return reportJtDate;
    }

    public void setReportJtDate(Date reportJtDate) {
        this.reportJtDate = reportJtDate;
    }

    public Integer getContractPresentation() {
        return contractPresentation;
    }

    public void setContractPresentation(Integer contractPresentation) {
        this.contractPresentation = contractPresentation;
    }

    public Long getConstructionModeId() {
        return constructionModeId;
    }

    public void setConstructionModeId(Long constructionModeId) {
        this.constructionModeId = constructionModeId;
    }

    public String getConstructionModeName() {
        return constructionModeName;
    }

    public void setConstructionModeName(String constructionModeName) {
        this.constructionModeName = constructionModeName;
    }

    public String getComboFlag() {
        return comboFlag;
    }

    public void setComboFlag(String comboFlag) {
        this.comboFlag = comboFlag;
    }

    public Long getComboId() {
        return comboId;
    }

    public void setComboId(Long comboId) {
        this.comboId = comboId;
    }

    public String getComboCode() {
        return comboCode;
    }

    public void setComboCode(String comboCode) {
        this.comboCode = comboCode;
    }

    public String getComboName() {
        return comboName;
    }

    public void setComboName(String comboName) {
        this.comboName = comboName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProgressPaymentClause() {
        return progressPaymentClause;
    }

    public void setProgressPaymentClause(String progressPaymentClause) {
        this.progressPaymentClause = progressPaymentClause;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalAfterCostAdjustTaxMny() {
        return totalAfterCostAdjustTaxMny;
    }

    public void setTotalAfterCostAdjustTaxMny(BigDecimal totalAfterCostAdjustTaxMny) {
        this.totalAfterCostAdjustTaxMny = totalAfterCostAdjustTaxMny;
    }

    public BigDecimal getTotalAfterCostAdjustMny() {
        return totalAfterCostAdjustMny;
    }

    public void setTotalAfterCostAdjustMny(BigDecimal totalAfterCostAdjustMny) {
        this.totalAfterCostAdjustMny = totalAfterCostAdjustMny;
    }

    public BigDecimal getTotalAfterCostAdjustTax() {
        return totalAfterCostAdjustTax;
    }

    public void setTotalAfterCostAdjustTax(BigDecimal totalAfterCostAdjustTax) {
        this.totalAfterCostAdjustTax = totalAfterCostAdjustTax;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 合同评审
     */
    public Long getReviewId() {
        return reviewId;
    }

    /**
     * 合同评审
     */
    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    /**
     * 承揽方式
     */
    public Long getBearType() {
        return bearType;
    }

    /**
     * 承揽方式
     */
    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 合同类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }

    /**
     * 合同甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 合同乙方
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }

    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    /**
     * 合同(签订)金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同(签订)金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }

    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约中, 2-已封账，3-已解除
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    /**
     * 联体合同总金额
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总金额
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额(无税)
     */
    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额(无税)
     */
    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额
     */
    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    /**
     * 工程造价及变动合
     * <p>
     * 计总金额
     */
    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    /**
     * 暂列金额
     */
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    /**
     * 暂列金额
     */
    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    /**
     * 合同约定收款比例
     */
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    /**
     * 合同约定收款比例
     */
    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }

    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    /**
     * 初始版本税额
     */
    public BigDecimal getBaseTax() {
        return baseTax;
    }

    /**
     * 初始版本税额
     */
    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public String getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量
     */
    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计甲方报量
     */
    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    /**
     * 累计收款
     */
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    /**
     * 累计收款
     */
    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    /**
     * 累计开票（含税）
     */
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计开票（含税）
     */
    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }

    /**
     * 累计开票
     */
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计开票
     */
    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    /**
     * 变更洽商总金额(无税)
     */
    public BigDecimal getSumNegotiateMny() {
        return sumNegotiateMny;
    }

    /**
     * 变更洽商总金额(无税)
     */
    public void setSumNegotiateMny(BigDecimal sumNegotiateMny) {
        this.sumNegotiateMny = sumNegotiateMny;
    }

    /**
     * 变更洽商总金额
     */
    public BigDecimal getSumNegotiateTaxMny() {
        return sumNegotiateTaxMny;
    }

    /**
     * 变更洽商总金额
     */
    public void setSumNegotiateTaxMny(BigDecimal sumNegotiateTaxMny) {
        this.sumNegotiateTaxMny = sumNegotiateTaxMny;
    }

    /**
     * 经济签证总金额(无税)
     */
    public BigDecimal getSumVisaMny() {
        return sumVisaMny;
    }

    /**
     * 经济签证总金额(无税)
     */
    public void setSumVisaMny(BigDecimal sumVisaMny) {
        this.sumVisaMny = sumVisaMny;
    }

    /**
     * 经济签证总金额
     */
    public BigDecimal getSumVisaTaxMny() {
        return sumVisaTaxMny;
    }

    /**
     * 经济签证总金额
     */
    public void setSumVisaTaxMny(BigDecimal sumVisaTaxMny) {
        this.sumVisaTaxMny = sumVisaTaxMny;
    }

    /**
     * 索赔总金额(无税)
     */
    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    /**
     * 索赔总金额(无税)
     */
    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    /**
     * 索赔总金额
     */
    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    /**
     * 索赔总金额
     */
    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    /**
     * 累计变更洽商金额(无税)
     */
    public BigDecimal getSumOperateMny() {
        return sumOperateMny;
    }

    /**
     * 累计变更洽商金额(无税)
     */
    public void setSumOperateMny(BigDecimal sumOperateMny) {
        this.sumOperateMny = sumOperateMny;
    }

    /**
     * 累计变更洽商金额
     */
    public BigDecimal getSumOperateTaxMny() {
        return sumOperateTaxMny;
    }

    /**
     * 累计变更洽商金额
     */
    public void setSumOperateTaxMny(BigDecimal sumOperateTaxMny) {
        this.sumOperateTaxMny = sumOperateTaxMny;
    }

    /**
     * 累计甲供材结算金额(无税)
     */
    public BigDecimal getSumMaterialSettleMny() {
        return sumMaterialSettleMny;
    }

    /**
     * 累计甲供材结算金额(无税)
     */
    public void setSumMaterialSettleMny(BigDecimal sumMaterialSettleMny) {
        this.sumMaterialSettleMny = sumMaterialSettleMny;
    }

    /**
     * 累计甲供材结算金额
     */
    public BigDecimal getSumMaterialSettleTaxMny() {
        return sumMaterialSettleTaxMny;
    }

    /**
     * 累计甲供材结算金额
     */
    public void setSumMaterialSettleTaxMny(BigDecimal sumMaterialSettleTaxMny) {
        this.sumMaterialSettleTaxMny = sumMaterialSettleTaxMny;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public Integer getIsFinish() {
        return isFinish;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    /**
     * 是否已解除：0-否，1-是
     */
    public Integer getIsRelieve() {
        return isRelieve;
    }

    /**
     * 是否已解除：0-否，1-是
     */
    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    /**
     * 乙方电话
     */
    public String getSupplierPhone() {
        return supplierPhone;
    }

    /**
     * 乙方电话
     */
    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    /**
     * 甲方电话
     */
    public String getCustomerPhone() {
        return customerPhone;
    }

    /**
     * 甲方电话
     */
    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    /**
     * 甲方委托代理人
     */
    public String getCustomerEntrustedAgent() {
        return customerEntrustedAgent;
    }

    /**
     * 甲方委托代理人
     */
    public void setCustomerEntrustedAgent(String customerEntrustedAgent) {
        this.customerEntrustedAgent = customerEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public String getSupplierEntrustedAgent() {
        return supplierEntrustedAgent;
    }

    /**
     * 乙方委托代理人
     */
    public void setSupplierEntrustedAgent(String supplierEntrustedAgent) {
        this.supplierEntrustedAgent = supplierEntrustedAgent;
    }

    /**
     * 争议解决方式
     */
    public Long getDisputeResolution() {
        return disputeResolution;
    }

    /**
     * 争议解决方式
     */
    public void setDisputeResolution(Long disputeResolution) {
        this.disputeResolution = disputeResolution;
    }

    /**
     * 争议解决机构
     */
    public String getDisputeResolutionAgency() {
        return disputeResolutionAgency;
    }

    /**
     * 争议解决机构
     */
    public void setDisputeResolutionAgency(String disputeResolutionAgency) {
        this.disputeResolutionAgency = disputeResolutionAgency;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public String getSettlementType() {
        return settlementType;
    }

    /**
     * 结算方式：0-过程结算，1-竣工结算
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 协议内容
     */
    public String getSupplementContent() {
        return supplementContent;
    }

    /**
     * 协议内容
     */
    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    /**
     * 承包模式
     */
    public Long getContractualModel() {
        return contractualModel;
    }

    /**
     * 承包模式
     */
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getContractRange() {
        return contractRange;
    }

    public void setContractRange(String contractRange) {
        this.contractRange = contractRange;
    }

    public String getScheduleDefaultMny() {
        return scheduleDefaultMny;
    }

    public void setScheduleDefaultMny(String scheduleDefaultMny) {
        this.scheduleDefaultMny = scheduleDefaultMny;
    }

    public String getQualityRequire() {
        return qualityRequire;
    }

    public void setQualityRequire(String qualityRequire) {
        this.qualityRequire = qualityRequire;
    }

    public String getExecuteProjectManager() {
        return executeProjectManager;
    }

    public void setExecuteProjectManager(String executeProjectManager) {
        this.executeProjectManager = executeProjectManager;
    }

    public Long getPerformanceMnyTypeId() {
        return performanceMnyTypeId;
    }

    public void setPerformanceMnyTypeId(Long performanceMnyTypeId) {
        this.performanceMnyTypeId = performanceMnyTypeId;
    }

    public String getPerformanceMnyTypeName() {
        return performanceMnyTypeName;
    }

    public void setPerformanceMnyTypeName(String performanceMnyTypeName) {
        this.performanceMnyTypeName = performanceMnyTypeName;
    }

    public String getPerformanceMnyTypeRate() {
        return performanceMnyTypeRate;
    }

    public void setPerformanceMnyTypeRate(String performanceMnyTypeRate) {
        this.performanceMnyTypeRate = performanceMnyTypeRate;
    }

    public BigDecimal getAdvancePaymentRate() {
        return advancePaymentRate;
    }

    public void setAdvancePaymentRate(BigDecimal advancePaymentRate) {
        this.advancePaymentRate = advancePaymentRate;
    }

    public String getProgressPaymentCondition() {
        return progressPaymentCondition;
    }

    public void setProgressPaymentCondition(String progressPaymentCondition) {
        this.progressPaymentCondition = progressPaymentCondition;
    }

    public String getDefectResponseTime() {
        return defectResponseTime;
    }

    public void setDefectResponseTime(String defectResponseTime) {
        this.defectResponseTime = defectResponseTime;
    }

    public BigDecimal getRetentionMnyRate() {
        return retentionMnyRate;
    }

    public void setRetentionMnyRate(BigDecimal retentionMnyRate) {
        this.retentionMnyRate = retentionMnyRate;
    }

    public BigDecimal getProjectContractMny() {
        return projectContractMny;
    }

    public void setProjectContractMny(BigDecimal projectContractMny) {
        this.projectContractMny = projectContractMny;
    }

    public BigDecimal getProjectContractMnyWan() {
        return projectContractMnyWan;
    }

    public void setProjectContractMnyWan(BigDecimal projectContractMnyWan) {
        this.projectContractMnyWan = projectContractMnyWan;
    }

    public Long getConstructionUnitsId() {
        return constructionUnitsId;
    }

    public void setConstructionUnitsId(Long constructionUnitsId) {
        this.constructionUnitsId = constructionUnitsId;
    }

    public String getConstructionUnitsName() {
        return constructionUnitsName;
    }

    public void setConstructionUnitsName(String constructionUnitsName) {
        this.constructionUnitsName = constructionUnitsName;
    }
}
