package com.ejianc.business.pro.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 建设项目年度结算计划与完成对比表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_plan_completion")
public class PlancompletionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 基层单位id
    @TableField(value="org_code")
    private String orgCode; // 基层单位编码
    @TableField(value="org_name")
    private String orgName; // 基层单位名称
    @TableField(value="year")
    private String year; //  计划年份
    @TableField(value="year_approve_mny")
    private BigDecimal yearApproveMny; // 年度计划审定金额
    @TableField(value="year_submit_mny")
    private BigDecimal yearSubmitMny; // 其中已送审金额
    @TableField(value="group_inner_mny")
    private BigDecimal groupInnerMny; // 集团内定案返回确认金额
    @TableField(value="group_out_mny")
    private BigDecimal groupOutMny; // 集团外定案返回确认金额
    @TableField(value="group_mny")
    private BigDecimal groupMny; // 定案返回确认金额
    @TableField(value="completion_rate")
    private BigDecimal completionRate; // 总完成率
    @TableField(value="un_year_completion_rate")
    private BigDecimal unYearCompletionRate; // 未进入年度目标完成率
    @TableField(value="year_completion_rate")
    private BigDecimal yearCompletionRate; // 年度目标完成率
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_code")
    private String departmentCode; // 经办人部门编码
    @TableField(value="department_name")
    private String departmentName; // 经办人部门名称
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="plancompletionDetailService", pidName = "completionId")
    private List<PlancompletionDetailEntity> plancompletionDetailList = new ArrayList<>();

    public List<PlancompletionDetailEntity> getPlancompletionDetailList() {
        return plancompletionDetailList;
    }

    public void setPlancompletionDetailList(List<PlancompletionDetailEntity> plancompletionDetailList) {
        this.plancompletionDetailList = plancompletionDetailList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public BigDecimal getYearApproveMny() {
        return yearApproveMny;
    }

    public void setYearApproveMny(BigDecimal yearApproveMny) {
        this.yearApproveMny = yearApproveMny;
    }
    public BigDecimal getYearSubmitMny() {
        return yearSubmitMny;
    }

    public void setYearSubmitMny(BigDecimal yearSubmitMny) {
        this.yearSubmitMny = yearSubmitMny;
    }
    public BigDecimal getGroupInnerMny() {
        return groupInnerMny;
    }

    public void setGroupInnerMny(BigDecimal groupInnerMny) {
        this.groupInnerMny = groupInnerMny;
    }
    public BigDecimal getGroupOutMny() {
        return groupOutMny;
    }

    public void setGroupOutMny(BigDecimal groupOutMny) {
        this.groupOutMny = groupOutMny;
    }
    public BigDecimal getGroupMny() {
        return groupMny;
    }

    public void setGroupMny(BigDecimal groupMny) {
        this.groupMny = groupMny;
    }
    public BigDecimal getCompletionRate() {
        return completionRate;
    }

    public void setCompletionRate(BigDecimal completionRate) {
        this.completionRate = completionRate;
    }
    public BigDecimal getUnYearCompletionRate() {
        return unYearCompletionRate;
    }

    public void setUnYearCompletionRate(BigDecimal unYearCompletionRate) {
        this.unYearCompletionRate = unYearCompletionRate;
    }
    public BigDecimal getYearCompletionRate() {
        return yearCompletionRate;
    }

    public void setYearCompletionRate(BigDecimal yearCompletionRate) {
        this.yearCompletionRate = yearCompletionRate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
