package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 工程定案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("finalized")
public class FinalizedController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private IFinalizedService service;

    @Autowired
    private IContractRegisterService registerService;
    
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
    	FinalizedEntity entity = service.selectById(id);
    	FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List<Long> ids = vos.stream().map(FinalizedVO::getId).collect(Collectors.toList());
        
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(FinalizedEntity::getId, ids);
        List<FinalizedEntity> list = service.list(wrapper);
        if(ListUtil.isNotEmpty(list)){
            List<Long> contractIds = list.stream().filter(e -> e.getFinalStage().equals(FinalStageEnum.终审.getCode())).map(FinalizedEntity::getContractId).collect(Collectors.toList());
            if(ListUtil.isNotEmpty(contractIds)){
                // 删除终审单据后回写合同终审状态
                LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(ContractRegisterEntity::getIsFinish, 0);
                updateWrapper.set(ContractRegisterEntity::getContractStatus, 1);
                updateWrapper.in(ContractRegisterEntity::getId, contractIds);
                registerService.update(updateWrapper);
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
//        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 筛选条件所属组织过滤
        if(null == param.getParams().get("parentOrgId")) {
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        List<FinalizedEntity> list = service.queryList(param);
        List<FinalizedVO> voList = BeanMapper.mapList(list, FinalizedVO.class);
        for (FinalizedVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.一审.getCode())) {
                vo.setFinalStageName("一审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.二审.getCode())) {
                vo.setFinalStageName("二审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.三审.getCode())) {
                vo.setFinalStageName("三审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.终审.getCode())) {
                vo.setFinalStageName("终审");
            }
            //结算阶段  settleStage
            if ("1".equals(vo.getSettleStage())) {
                vo.setSettleStageName("第一阶段");
            }
            if ("2".equals(vo.getSettleStage())) {
                vo.setSettleStageName("第二阶段");
            }
            if ("3".equals(vo.getSettleStage())) {
                vo.setSettleStageName("第三阶段");
            }
            if ("4".equals(vo.getSettleStage())) {
                vo.setSettleStageName("第四阶段");
            }
            if ("5".equals(vo.getSettleStage())) {
                vo.setSettleStageName("第五阶段");
            }
            //建设单位性质  unitProperty
            if ("1".equals(vo.getUnitProperty())) {
                vo.setUnitProperty("集团内");
            }
            if ("2".equals(vo.getUnitProperty())) {
                vo.setUnitProperty("集团外");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }
    
    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refFinalizedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize
            , String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    
    /**
     * 根据项目id、合同id查询结算报审单数据
     * @param projectId
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySettleReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required = false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success("查询数据成功！", service.querySettleReport(projectId, contractId));
    }
    
    /**
     * 根据项目id、合同id,结算阶段校验是否可以新增数据
     * @return
     */
    @RequestMapping(value = "/validStage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> validStage(@RequestBody FinalizedVO vo) {
        FinalizedVO finalizedVO = service.validStage(vo.getProjectId(), vo.getContractId(), vo.getSettleStageList());
        return CommonResponse.success("查询数据成功！", finalizedVO);
    }
    /**
     * 根据项目id、合同id查询工程定案单数据
     * @return
     */
    @RequestMapping(value = "/queryFinalizedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestBody FinalizedVO vo) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedList(vo.getProjectId(), vo.getContractId(), vo.getId(),vo.getSettleStageList()));
    }

    /**
     * 根据项目id、合同id查询工程定案单数据
     * @return
     */
    @RequestMapping(value = "/validateFinalStage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestBody FinalizedVO vo) {
        return CommonResponse.success("查询数据成功！", service.validateFinalStage(vo.getProjectId(), vo.getContractId(), vo.getFinalStage(), vo.getId(),vo.getSettleStageList()));   }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedRecord(id));
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        FinalizedEntity finalizedEntity = service.selectById(id);
        FinalizedVO vo = BeanMapper.map(finalizedEntity, FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())){
            boolean pool = service.pushSettleToPool(vo);
            if(!pool){
                return CommonResponse.error("推送结算池失败");
            }
        } else {
            return CommonResponse.success("无需推送！", true);
        }
        return CommonResponse.success("同步结算池成功！", true);
    }
    
}
