package com.ejianc.business.pro.income.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.MemorandumEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IMemorandumService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.vo.MemorandumVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2023/2/13 20:02
 */
@RestController
@RequestMapping(value = "/memorandum/")
public class MemorandumController {

    @Autowired
    private IMemorandumService memorandumService;

    @Autowired
    private ISettleReportService settleReportService;

    @PostMapping(value = "saveOrUpdateBatch")
    public CommonResponse<List<MemorandumVO>> saveOrUpdateBatch(@RequestBody List<MemorandumVO> memoList) {
        return CommonResponse.success(memorandumService.saveOrUpdateMemoBatch(memoList));
    }

    /**
     * 根据结算报审查询对应的备忘录列表
     *
     * @param settleReportId
     * @return
     */
    @GetMapping(value = "getListBySettleReport")
    public CommonResponse<List<MemorandumVO>> getListBySettleReport(@RequestParam Long settleReportId,@RequestParam String settleStage) {
        List<String> list = Arrays.asList(settleStage.split(","));
        QueryWrapper<MemorandumEntity> query = new QueryWrapper<>();
        query.eq("settle_report_id", settleReportId);
        query.in("settle_stage", list);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MemorandumEntity> entities = memorandumService.list(query);
        if(CollectionUtils.isNotEmpty(entities)) {
            return CommonResponse.success(BeanMapper.mapList(entities, MemorandumVO.class));
        }
        return CommonResponse.success(new ArrayList<>());
    }

    /**
     * 根据项目主键  查询对应的备忘录列表
     *
     * @param
     * @return
     */
    @GetMapping(value = "getMemorandumByProjectId")
    public CommonResponse<List<MemorandumVO>> getMemorandumByProjectId(@RequestParam Long projectId) {
        LambdaQueryWrapper<SettleReportEntity> lambda = Wrappers.<SettleReportEntity>lambdaQuery();
        lambda.eq(SettleReportEntity::getProjectId,projectId);
        lambda.in(SettleReportEntity::getBillState,1,2,3,5);
        lambda.orderByDesc(SettleReportEntity::getCreateTime);
        List<SettleReportEntity> settleReportList = settleReportService.list(lambda);

        List<Long> ids = new ArrayList<>();
        Map<Long,String> map = new HashMap<>();

        if(CollectionUtils.isNotEmpty(settleReportList)){
            settleReportList.forEach(e->{
                ids.add(e.getId());
                map.put(e.getId(),e.getBillCode());
            });

            QueryWrapper<MemorandumEntity> query = new QueryWrapper<>();
            query.in("settle_report_id", ids);
            query.eq("dr", BaseVO.DR_UNDELETE);

            List<MemorandumEntity> entities = memorandumService.list(query);
            if(CollectionUtils.isNotEmpty(entities)) {
                List<MemorandumVO> resList = BeanMapper.mapList(entities, MemorandumVO.class);
                resList.forEach(e->{
                    e.setBillCode(map.get(e.getSettleReportId()));
                });
                return CommonResponse.success(resList);
            }
        }

        return CommonResponse.success(new ArrayList<>());
    }

}
