package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.pro.income.vo.SettleReportHistoryVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 结算报审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settleReport")
public class SettleReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ValidateUtil validateUtil;

    private static final String BILL_CODE = "SETTLE_REPORT";//此处需要根据实际修改

    @Autowired
    private ISettleReportService service;

    @Autowired
    private IProductionService productionService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleReportVO> saveOrUpdate(@RequestBody SettleReportVO saveOrUpdateVO) {


        //同一个项目同一个结算阶段只能存在一个自由态的结算报审单
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        queryParam.getParams().put("settleStage", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSettleStage()));
        if (null != saveOrUpdateVO.getId()) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        }
        List<SettleReportEntity> list = service.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("该项目该阶段下已有结算报审的单据，不允许新增!");
        }

    	SettleReportEntity entity = BeanMapper.map(saveOrUpdateVO, SettleReportEntity.class);
        // 保存时校验合同version是否一致
        if(!validateUtil.validateUpStreamVersion(String.valueOf( saveOrUpdateVO.getContractId()),
                BillTypeCodeEnum.施工合同.getCode(),  saveOrUpdateVO.getContractVersion())){
            throw new BusinessException("该合同已被更新，请刷新后重做！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SettleReportVO vo = BeanMapper.map(entity, SettleReportVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportVO> queryDetail(Long id) {
    	SettleReportEntity entity = service.selectById(id);
    	SettleReportVO vo = BeanMapper.map(entity, SettleReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleReportVO> vos) {
        service.removeBatchByIds(vos.stream().map(SettleReportVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 筛选条件所属组织过滤
//        if(null == param.getParams().get("parentOrgId")) {
//            /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//            } else {
//                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            }
//        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {
            //pc端
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            //移动端 需要取orgId的本下
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<SettleReportEntity> page = service.queryPage(param,false);
        IPage<SettleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<SettleReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<SettleReportVO> vos = BeanMapper.mapList(list, SettleReportVO.class);
        vos.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            if ("1".equals(e.getSettleStage())){
                e.setSettleStageName("第一阶段");
            }
            if ("2".equals(e.getSettleStage())){
                e.setSettleStageName("第二阶段");
            }
            if ("3".equals(e.getSettleStage())){
                e.setSettleStageName("第三阶段");
            }
            if ("4".equals(e.getSettleStage())){
                e.setSettleStageName("第四阶段");
            }
            if ("5".equals(e.getSettleStage())){
                e.setSettleStageName("第五阶段");
            }
            //建设单位性质  unitProperty
            if ("1".equals(e.getUnitProperty())){
                e.setUnitProperty("集团内");
            }
            if ("2".equals(e.getUnitProperty())){
                e.setUnitProperty("集团外");
            }
        });

        beans.put("records", vos);
        ExcelExport.getInstance().export("SettleReport-export.xlsx", beans, response);
    }

    
    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refSettleReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettleReportVO>> refSettleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleReportEntity> page = service.queryPage(param,false);
        IPage<SettleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

//    同一份合同下面只能有一份未生效的单据
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId,@RequestParam(value = "id",required = false) Long id) {
        LambdaQueryWrapper<SettleReportEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleReportEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(SettleReportEntity::getDr,0);
        queryWrapper.notIn(SettleReportEntity::getBillState, 1,3);
        if (id != null){
            queryWrapper.ne(SettleReportEntity::getId,id);
        }
        queryWrapper.eq(SettleReportEntity::getContractId,contractId);
        List<SettleReportEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同下存在非审批通过态的结算报审，不允许新增!");
        }
        return CommonResponse.success("校验成功！");
    }

    /*
   获取产值报量已生效单据单据的表头字段【产值金额】
    */
    @RequestMapping(value = "/getProductionMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionVO>>  getProductionMny(@RequestParam("contractId") Long contractId){
        LambdaQueryWrapper<ProductionEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProductionEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ProductionEntity::getDr,0);
        queryWrapper.in(ProductionEntity::getBillState, 1,3);
        queryWrapper.eq(ProductionEntity::getContractId,contractId);
        List<ProductionEntity> list = productionService.list(queryWrapper);
        List<ProductionVO> vos = BeanMapper.mapList(list, ProductionVO.class);
        return CommonResponse.success(vos);
    }

    /**
     * 结算报审历史记录
     * @param id 合同ID
     * @return
     */
    @RequestMapping(value = "/querySettleReportHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportHistoryVO> querySettleReportHistory(@RequestParam Long id) {
        SettleReportHistoryVO vo = service.querySettleReportHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        SettleReportEntity settleReportEntity = service.selectById(id);
        SettleReportVO vo = BeanMapper.map(settleReportEntity, SettleReportVO.class);

        return CommonResponse.success("同步结算池成功！", service.pushSettleToPool(vo));
    }

    /**
     *
     */
    @GetMapping(value = "/getSettleReportByProjectId")
    @ResponseBody
    public CommonResponse<Boolean> getSettleReportByProjectId(@RequestParam Long projectId) {
        LambdaQueryWrapper<SettleReportEntity> lambda = Wrappers.<SettleReportEntity>lambdaQuery();
        lambda.eq(SettleReportEntity::getProjectId,projectId);
        lambda.in(SettleReportEntity::getBillState,1,2,3,5);
        lambda.orderByDesc(SettleReportEntity::getCreateTime);
        List<SettleReportEntity> settleReportList = service.list(lambda);
        if(CollectionUtils.isNotEmpty(settleReportList)){
            return CommonResponse.success(true);
        }else{
            return CommonResponse.success(false);
        }
    }

}
