package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.home.consts.ProjectStatusEnum;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.*;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

/**
 *
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("warnTiming")
public class WarnTimingController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IQuoteService quoteService;

    @Autowired
    private IFinalizedService finalizedService;

    @Autowired
    private ISettlementFinalizationService settlementFinalizationService;

    @Autowired
    private ISettleReportService settleReportService;

    @Autowired
    private IMemorandumService memorandumService;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    /**
     *  定时预警--项目竣工到期  未提交工程定案
     */
    @RequestMapping(value = "/notFinalizedTimingWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> notFinalizedTimingWarn(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        LambdaQueryWrapper<QuoteEntity> lambda = new LambdaQueryWrapper<QuoteEntity>();
        lambda.eq(QuoteEntity::getTenantId, 999999L);
        lambda.in(QuoteEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.orderByDesc(QuoteEntity::getPredictCompleteDate);
        List<QuoteEntity> list = quoteService.list(lambda);
        logger.info("对甲保量条数：{}",list.size());
        Map<Long, QuoteEntity> quoteProjectcIdMap = new HashMap<>();
        //按照项目id分组 根据预计完（竣）工日期  取最新一期
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                if(quoteProjectcIdMap.containsKey(e.getProjectId())){
                    QuoteEntity quoteEntity = quoteProjectcIdMap.get(e.getProjectId());
                    if(null!=quoteEntity.getPredictCompleteDate()&&e.getPredictCompleteDate().after(quoteEntity.getPredictCompleteDate())){
                        quoteProjectcIdMap.put(e.getProjectId(),e);
                    }
                }else{
                    quoteProjectcIdMap.put(e.getProjectId(),e);
                }
            });
        }
        //按照项目id分组 根据预计完（竣）工日期  取最新一期
//        Comparator<QuoteEntity> ageComparator = Comparator.comparing(QuoteEntity::getPredictCompleteDate);
//        Map<Long, Optional<QuoteEntity>> quoteProjectcIdMap = list.stream().collect(Collectors.groupingBy(QuoteEntity::getProjectId,Collectors.reducing(BinaryOperator.maxBy(ageComparator))));



        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户纬度，查询出来需要预警的数据
            // 2、根据单据所属组织，找到对应的预警设置，也就是这条适用于那个设置
            // 3、根据预警设置判断该数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            //获取项目
            //获取未生成工程定案的项目
            LambdaQueryWrapper<FinalizedEntity> lambda2 = new LambdaQueryWrapper<FinalizedEntity>();
            lambda2.eq(FinalizedEntity::getTenantId, 999999L);
            lambda2.in(FinalizedEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            lambda2.in(FinalizedEntity::getProjectId,quoteProjectcIdMap.keySet());
            List<FinalizedEntity> finalizedList = finalizedService.list(lambda2);

            Map<Long, List<FinalizedEntity>> finalizedMap = finalizedList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(FinalizedEntity::getProjectId));
            List<QuoteEntity> unFinalizedList = new ArrayList<>();

            quoteProjectcIdMap.forEach((key, value) ->{
                if(!finalizedMap.containsKey(key)){
                    //未提交工程定案的数据  取第一条(时间为最新一期的)
                    unFinalizedList.add(value);
                } });

            if (null!=unFinalizedList && ListUtil.isNotEmpty(unFinalizedList)) {
                for (QuoteEntity quoteEntity : unFinalizedList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = quoteEntity.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        //按照项目分组
//                        List<ShareEntity> shareList = null==costTenantIdMap.get(tenantId) ? new ArrayList<>(): costTenantIdMap.get(tenantId);
//                        Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
//                        List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        //获取时间
                        Date date = new Date();
                        Date oneDate = quoteEntity.getPredictCompleteDate();
                        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                        Integer day = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            day = set.getIntValue("parameterValue");
                            logger.info("当前日期：{},项目竣工日期：{}，差值：{},对甲报量信息：{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,JSONObject.toJSONString(quoteEntity));
                            if ("高".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +quoteEntity.getProjectName());
                            vo.setPcTitle("项目竣工日期后未完成工程定案");
//                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(quoteEntity.getOrgId());
                         //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(quoteEntity.getOrgId()+"");
                            vo.setOrgName(quoteEntity.getOrgName());
                            vo.setSourceId(quoteEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



    /**
     *  定时预警--  定案返回日期前  没  定案确认的单据
     */
    @RequestMapping(value = "/notSettleFinalizationWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> notSettleFinalizationWarn(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        LambdaQueryWrapper<FinalizedEntity> lambda = new LambdaQueryWrapper<FinalizedEntity>();
        lambda.eq(FinalizedEntity::getTenantId, 999999L);
        lambda.in(FinalizedEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.orderByDesc(FinalizedEntity::getReturnDate);
        List<FinalizedEntity> list = finalizedService.list(lambda);
        logger.info("对甲保量条数：{}",list.size());
        Map<Long, FinalizedEntity> finalizedProjectcIdMap = new HashMap<>();
        //按照项目id分组 根据预计完（竣）工日期  取第一期
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                if(finalizedProjectcIdMap.containsKey(e.getProjectId())){
                    FinalizedEntity finalizedEntity = finalizedProjectcIdMap.get(e.getProjectId());
                    if(null!=finalizedEntity.getReturnDate()&&e.getReturnDate().before(finalizedEntity.getReturnDate())){
                        finalizedProjectcIdMap.put(e.getProjectId(),e);
                    }
                }else{
                    finalizedProjectcIdMap.put(e.getProjectId(),e);
                }
            });
        }


//        Comparator<FinalizedEntity> ageComparator = Comparator.comparing(FinalizedEntity::getReturnDate);
//        Map<Long, Optional<FinalizedEntity>> finalizedProjectcIdMap = list.stream().collect(Collectors.groupingBy(FinalizedEntity::getProjectId,Collectors.reducing(BinaryOperator.maxBy(ageComparator))));

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户纬度，查询出来需要预警的数据
            // 2、根据单据所属组织，找到对应的预警设置，也就是这条适用于那个设置
            // 3、根据预警设置判断该数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            //获取项目
            //获取未生成 定案返回确认单
            LambdaQueryWrapper<SettlementFinalizationEntity> lambda2 = new LambdaQueryWrapper<SettlementFinalizationEntity>();
            lambda2.eq(SettlementFinalizationEntity::getTenantId, 999999L);
            lambda2.in(SettlementFinalizationEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            lambda2.in(SettlementFinalizationEntity::getProjectId,finalizedProjectcIdMap.keySet());
            List<SettlementFinalizationEntity> settlementFinalizationList = settlementFinalizationService.list(lambda2);

            Map<Long, List<SettlementFinalizationEntity>> settlementFinalizationMap = settlementFinalizationList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(SettlementFinalizationEntity::getProjectId));
            List<FinalizedEntity> unFinalizedList = new ArrayList<>();

            finalizedProjectcIdMap.forEach((key, value) ->{
                if(!settlementFinalizationMap.containsKey(key)){
                    //未提交工程定案的数据  取第一条(时间为最新一期的)
                    unFinalizedList.add(value);
                } });

            if (null!=unFinalizedList && ListUtil.isNotEmpty(unFinalizedList)) {
                for (FinalizedEntity finalizedEntity : unFinalizedList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = finalizedEntity.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        //按照项目分组
//                        List<ShareEntity> shareList = null==costTenantIdMap.get(tenantId) ? new ArrayList<>(): costTenantIdMap.get(tenantId);
//                        Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
//                        List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        //获取时间
                        Date date = new Date();
                        Date oneDate = finalizedEntity.getReturnDate();
                        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                        Integer day = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            day = set.getIntValue("parameterValue");
                            logger.info("当前日期：{},项目竣工日期：{}，差值：{},对甲报量信息：{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,JSONObject.toJSONString(finalizedEntity));
                            if ("高".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +finalizedEntity.getProjectName());
                            vo.setPcTitle("定案返回日期前没定案确认的单据");
//                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(finalizedEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(finalizedEntity.getOrgId()+"");
                            vo.setOrgName(finalizedEntity.getOrgName());
                            vo.setSourceId(finalizedEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#",DateFormatUtil.formatDate("yyyy-MM-dd",finalizedEntity.getReturnDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#",DateFormatUtil.formatDate("yyyy-MM-dd",finalizedEntity.getReturnDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#",DateFormatUtil.formatDate("yyyy-MM-dd",finalizedEntity.getReturnDate())).replaceAll("#day#",String.valueOf(day))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }


    /**
     *  定时预警--  结算报审未维护备忘录
     */
    @RequestMapping(value = "/notMemorandumWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> notMemorandumWarn(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        LambdaQueryWrapper<SettleReportEntity> lambda = new LambdaQueryWrapper<SettleReportEntity>();
        lambda.eq(SettleReportEntity::getTenantId, 999999L);
        lambda.in(SettleReportEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<SettleReportEntity> list = settleReportService.list(lambda);
        logger.info("结算报审条数：{}",list.size());
        List<Long> ids = list.stream().map(SettleReportEntity::getId).collect(Collectors.toList());
        //按照项目id分组 根据预计完（竣）工日期  取最新一期
//        Comparator<FinalizedEntity> ageComparator = Comparator.comparing(FinalizedEntity::getReturnDate);
//        Map<Long, Optional<FinalizedEntity>> finalizedProjectcIdMap = list.stream().collect(Collectors.groupingBy(FinalizedEntity::getProjectId,Collectors.reducing(BinaryOperator.maxBy(ageComparator))));

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            //获取 未维护备忘录的数据
            LambdaQueryWrapper<MemorandumEntity> lambda2 = new LambdaQueryWrapper<MemorandumEntity>();
            lambda2.eq(MemorandumEntity::getTenantId, 999999L);
            lambda2.in(MemorandumEntity::getSettleReportId,ids);
            List<MemorandumEntity> memorandumList = memorandumService.list(lambda2);

            Map<Long, List<MemorandumEntity>> memorandumMap = memorandumList.stream().collect(Collectors.groupingBy(MemorandumEntity::getSettleReportId));

            logger.info("维护的备忘录数据：{}",JSONObject.toJSONString(memorandumMap));
            List<SettleReportEntity> unFinalizedList = new ArrayList<>();
            list.forEach(e->{
                if(!memorandumMap.containsKey(e.getId())){
                    unFinalizedList.add(e);
                }
            });
            logger.info("没有维护的备忘录数据：{}",JSONObject.toJSONString(unFinalizedList));
            if (null!=unFinalizedList && ListUtil.isNotEmpty(unFinalizedList)) {
                for (SettleReportEntity settleReportEntity : unFinalizedList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = settleReportEntity.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        //按照项目分组
//                        List<ShareEntity> shareList = null==costTenantIdMap.get(tenantId) ? new ArrayList<>(): costTenantIdMap.get(tenantId);
//                        Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
//                        List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        JSONObject useSetHigh = null;
                        //获取时间
                        Date date = new Date();
                        Date oneDate = settleReportEntity.getEffectDate();
                        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                        Integer day = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            day = set.getIntValue("parameterValue");
                            logger.info("当前日期：{},生效日期：{}，差值：{},实体信息：{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,JSONObject.toJSONString(settleReportEntity));
                            if(!(betweenDays<day)){
                                high = true;
                                useSetHigh = set;
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +settleReportEntity.getProjectName());
                            vo.setPcTitle("结算报审维护备忘录提醒");
//                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(settleReportEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(settleReportEntity.getOrgId()+"");
                            vo.setOrgName(settleReportEntity.getOrgName());
                            vo.setSourceId(settleReportEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(settleReportEntity.getProjectName())).replaceAll("#billCode#",String.valueOf(settleReportEntity.getBillCode())).replaceAll("#day#",String.valueOf(day))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



    /**
     *  定时预警--  项目竣工后未完成结算报审
     */
    @RequestMapping(value = "/quoteNotSettleReportWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> quoteNotSettleReportWarn(@RequestBody JSONArray jsonParam) {
        logger.info("项目竣工后未完成结算报审接收到 Task 参数：{}", jsonParam);

        //改为mapper查询
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        LambdaQueryWrapper<QuoteEntity> lambda = new LambdaQueryWrapper<QuoteEntity>();
        lambda.eq(QuoteEntity::getTenantId, 999999L);
        lambda.in(QuoteEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.orderByDesc(QuoteEntity::getPredictCompleteDate);
        List<QuoteEntity> list = quoteService.list(lambda);
        list.sort((t1, t2)-> t2.getPredictCompleteDate().compareTo(t1.getPredictCompleteDate()));


        logger.info("对甲报量条数：{}",list.size());
        if (CollectionUtils.isEmpty(list) || list.size() == 0){
            return CommonResponse.success("无对甲报量数据！");
        }

        // 取预计完（竣）工日期”的最大值（或者最新一期）
        Map<Long, QuoteEntity> quoteProjectIdMap = new HashMap<>();
        for (QuoteEntity quoteEntity : list) {
            if (!quoteProjectIdMap.containsKey(quoteEntity.getProjectId())){
                quoteProjectIdMap.put(quoteEntity.getProjectId(), quoteEntity);
            }
        }
        logger.info("对甲报量条数：{}", quoteProjectIdMap.size());


        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户纬度，查询出来需要预警的数据
            // 2、根据单据所属组织，找到对应的预警设置，也就是这条适用于那个设置
            // 3、根据预警设置判断该数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            //获取项目
            //获取未生成 结算报审
            LambdaQueryWrapper<SettleReportEntity> lambda2 = new LambdaQueryWrapper<SettleReportEntity>();
            lambda2.eq(SettleReportEntity::getTenantId, 999999L);
            lambda2.in(SettleReportEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            lambda2.in(SettleReportEntity::getProjectId,quoteProjectIdMap.keySet());
            List<SettleReportEntity> settleReportList = settleReportService.list(lambda2);

            List<Long> settleReportProjectIdList = settleReportList.stream().map(SettleReportEntity::getProjectId).distinct().collect(Collectors.toList());
            logger.info("已做结算报审的项目id：{}", JSONObject.toJSONString(settleReportProjectIdList));
            List<QuoteEntity> unSettleList = new ArrayList<>();

            quoteProjectIdMap.forEach((key, value) ->{
                if(!settleReportProjectIdList.contains(key)){
                    //未提交结算报审的数据  取第一条(时间为最新一期的)
                    unSettleList.add(quoteProjectIdMap.get(key));
                } });

            if (null!=unSettleList && ListUtil.isNotEmpty(unSettleList)) {
                for (QuoteEntity quoteEntity : unSettleList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = quoteEntity.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        //获取时间
                        Date date = new Date();
                        Date oneDate = quoteEntity.getPredictCompleteDate();
                        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                        Integer day = null;
                        Integer lowDay = null;
                        Integer highDay = null;
                        Integer meddleDay = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            day = set.getIntValue("parameterValue");
                            logger.info("当前日期：{},预计完（竣）工日期：{}，差值：{},对甲报量信息：{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,JSONObject.toJSONString(quoteEntity));
                            if ("高".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    high = true;
                                    useSetHigh = set;
                                    highDay = day;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    meddle = true;
                                    useSetMeddle = set;
                                    meddleDay = day;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if(!(betweenDays<day)){
                                    low = true;
                                    useSetLow = set;
                                    lowDay = day;
                                }
                            }
                        }
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +quoteEntity.getProjectName());
                            vo.setPcTitle("项目竣工后未完成结算报审");
                            vo.setOrgId(quoteEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(quoteEntity.getOrgId()+"");
                            vo.setOrgName(quoteEntity.getOrgName());
                            vo.setSourceId(quoteEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            logger.info("tmContent:{}", tmpContent);
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(highDay))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(meddleDay))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#",DateFormatUtil.formatDate("yyyy-MM-dd",quoteEntity.getPredictCompleteDate())).replaceAll("#day#",String.valueOf(lowDay))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }


    /**
     *  定时预警--  竣工未结项目未完成结算报审
     */
    @RequestMapping(value = "/projectNotSettleReportWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> projectNotSettleReportWarn(@RequestBody JSONArray jsonParam) {
        logger.info("竣工未结项目未完成结算报审收到 Task 参数：{}", jsonParam);

        Map<Long, ProjectPoolSetVO> projectIdMap = new HashMap<>();
        CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectPoolList(ProjectStatusEnum.竣工.getCode(), null, null);
        if(jsonArrayCommonResponse.isSuccess() && null!=jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty(jsonArrayCommonResponse.getData())){
            JSONArray data = jsonArrayCommonResponse.getData();
            List<ProjectPoolSetVO> projectData = JSONObject.parseArray(data.toJSONString(), ProjectPoolSetVO.class);
            if (CollectionUtils.isNotEmpty(projectData)){
                for (ProjectPoolSetVO project : projectData) {
                    if (null != project.getTenantId() && project.getTenantId() == 999999L && null != project.getSettleStatus() && project.getSettleStatus().equals("1")){
                        projectIdMap.put(project.getId(), project);
                    }
                }
            }
            logger.info("项目信息条数：{}",projectData.size());
            logger.info("项目信息map条数：{}",projectIdMap.size());
            if (null == projectIdMap){
                return CommonResponse.success("无对应状态项目数据！");
            }
        }

        logger.info("放置数据");
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if(null!=tenantId&&tenantId!=999999L){
                continue;
            }
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户纬度，查询出来需要预警的数据
            // 2、根据单据所属组织，找到对应的预警设置，也就是这条适用于那个设置
            // 3、根据预警设置判断该数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            //获取项目
            //获取未生成 结算报审
            LambdaQueryWrapper<SettleReportEntity> lambda2 = new LambdaQueryWrapper<SettleReportEntity>();
            lambda2.eq(SettleReportEntity::getTenantId, 999999L);
            lambda2.in(SettleReportEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            lambda2.in(SettleReportEntity::getProjectId, projectIdMap.keySet());
            List<SettleReportEntity> settleReportList = settleReportService.list(lambda2);

            List<Long> settleReportProjectIdList = settleReportList.stream().map(SettleReportEntity::getProjectId).distinct().collect(Collectors.toList());
            logger.info("已做结算报审的项目id：{}", JSONObject.toJSONString(settleReportProjectIdList));
            List<ProjectPoolSetVO> unSettleList = new ArrayList<>();

            projectIdMap.forEach((key, value) ->{
                if(!settleReportProjectIdList.contains(key)){
                    //未提交结算报审的数据  取第一条(时间为最新一期的)
                    unSettleList.add(projectIdMap.get(key));
                } });

            if (null!=unSettleList && ListUtil.isNotEmpty(unSettleList)) {
                for (ProjectPoolSetVO project : unSettleList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = project.getOrgId();
                    if(orgId==null){
                        continue;
                    }
                    OrgVO orgVO = orgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            logger.info("项目信息：{}", JSONObject.toJSONString(project));
                            if ("高".equals(set.getString("warningLevel"))) {
                                    high = true;
                                    useSetHigh = set;
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                    meddle = true;
                                    useSetMeddle = set;
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                    low = true;
                                    useSetLow = set;
                            }
                        }
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +project.getName());
                            vo.setPcTitle("竣工未结项目未完成结算报审");
                            vo.setOrgId(project.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(project.getOrgId()+"");
                            vo.setOrgName(project.getOrgName());
                            vo.setSourceId(project.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            logger.info("tmContent:{}", tmpContent);
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#",String.valueOf(project.getName()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
