package com.ejianc.business.pro.income.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
@Mapper
public interface QuoteMapper extends BaseCrudMapper<QuoteEntity> {

    /**
     * 计算合同累计批复金额
     * @param contractId
     * @return
     */
    @Select("select sum(reply_tax_mny) FROM ejc_income_quote where contract_id = #{contractId} and dr = 0 and reply_status = 1")
    BigDecimal calculateSumCheckProduction(Long contractId);
    @Select("select sum(reply_tax_mny) FROM ejc_income_quote where contract_id = #{contractId} and dr = 0 and reply_status = 1 and id !=  #{id}")
    BigDecimal calculateSumCheck(Long contractId,Long id);


    /**
     * 计算累计审定产值
     * @param contractId
     * @return
     */
    @Select("select IFNULL( sum(IFNULL( check_production_company, 0 )), 0 ) as lastCheckProductionCompany,IFNULL( sum(IFNULL( check_production_group, 0 )), 0 ) as lastCheckProductionGroup FROM ejc_income_quote where contract_id = #{contractId} and dr = 0 and bill_state in (1,3)")
    Map<String, BigDecimal> calculateSumProduction(Long contractId);
}
