package com.ejianc.business.pro.income.service;

import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.pro.income.vo.QuoteHistoryVO;
import com.ejianc.business.pro.income.vo.QuoteVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.income.bean.QuoteEntity;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
public interface IQuoteService extends IBaseService<QuoteEntity> {

    QuoteVO saveOrUpdate(QuoteVO saveorUpdateVO);

    QuoteVO queryDetail(Long id);

    String validateContract(Long id);

    QuoteHistoryVO queryQuoteHistory(Long id);

    boolean pushSettleToPool(QuoteVO vo);

    boolean delSettleFromPool(Long id);

    BigDecimal calculateSumCheckProduction(Long contractId);
    BigDecimal calculateSumCheck(Long contractId,Long id);

    Map<String, BigDecimal> calculateSumProduction(Long contractId);

    QuoteVO queryApproveMnyByContractId(Long contractId);
}
