package com.ejianc.business.pro.income.service;

import com.ejianc.business.pro.income.vo.SettleReportHistoryVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.income.bean.SettleReportEntity;

import java.util.List;

/**
 * 结算报审
 * 
 * @author generator
 * 
 */
public interface ISettleReportService extends IBaseService<SettleReportEntity> {

    SettleReportHistoryVO querySettleReportHistory(Long id);

    boolean pushSettleToPool(SettleReportVO vo);

    boolean delSettleFromPool(Long id);

    void removeBatchByIds(List<Long> collect);

    /**
     * 查询是否存在 需要维护备忘录的 结算报审单据
     * 条件：结算报审单生效，但不存在生效的工程定案，则从结算报审单生效日期开始，每隔days天 发送消息
     *
     *
     * @return
     */
    List<SettleReportEntity> checkMemoMaintenance(Integer days);
}
