package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.MemorandumEntity;
import com.ejianc.business.pro.income.mapper.MemorandumMapper;
import com.ejianc.business.pro.income.service.IMemorandumService;
import com.ejianc.business.pro.income.vo.MemorandumVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 备忘录服务实现
 *
 * @author CJ
 * @Description: 备忘录服务实现
 * @date 2023/2/13 17:47
 */
@Service("memorandumService")
public class MemorandumServiceImpl extends BaseServiceImpl<MemorandumMapper, MemorandumEntity> implements IMemorandumService {

    @Autowired
    private MemorandumMapper memorandumMapper;

    @Override
    public void removeBatchBySettleReportIds(List<Long> ids) {
        QueryWrapper<MemorandumEntity> delWrapper = new QueryWrapper<>();
        delWrapper.in("settle_report_id", ids);
        memorandumMapper.delete(delWrapper);
    }

    @Override
    public List<MemorandumVO> saveOrUpdateMemoBatch(List<MemorandumVO> memoList) {
        List<Long> delIds = new ArrayList<>();
        List<MemorandumEntity> saveList = new ArrayList<>();
        memoList.stream().forEach(item -> {
            if("del".equals(item.getRowState())) {
                delIds.add(item.getId());
            } else {
                saveList.add(BeanMapper.map(item, MemorandumEntity.class));
            }
        });

        if(CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, false);
        }
        if(CollectionUtils.isNotEmpty(saveList)) {
            super.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        return BeanMapper.mapList(saveList, MemorandumVO.class);
    }
}
