package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.mapper.QuoteMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IQuoteDetailService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.*;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
@Service("quoteService")
public class QuoteServiceImpl extends BaseServiceImpl<QuoteMapper, QuoteEntity> implements IQuoteService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "PRO_INCOME_QUOTE";//此处需要根据实际修改

    @Autowired
    private ValidateUtil validateUtil;

    @Autowired
    private DetailListUtil detailListUtil;

    @Autowired
    private IQuoteDetailService detailService;

    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private QuoteMapper quoteMapper;
    @Autowired
    private IProductionService productionService;

    @Override
    public QuoteVO saveOrUpdate(QuoteVO saveorUpdateVO) {
        // 保存时校验合同version是否一致
        if(!validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getContractId()),
                BillTypeCodeEnum.施工合同.getCode(), saveorUpdateVO.getContractVersion())){
            throw new BusinessException("该合同已被更新，请刷新后重做！");
        }
        // 保存时校验项目预算书version是否一致
        List<QuoteDetailVO> detailVOList = saveorUpdateVO.getDetailList();
        if(CollectionUtils.isNotEmpty(detailVOList)){
            for(QuoteDetailVO detail : detailVOList){
                if("add".equals(detail.getRowState())){
                    if(!validateUtil.validateUpStreamVersion(String.valueOf(detail.getBudgetId()),
                            BillTypeCodeEnum.项目预算书.getCode(), detail.getBudgetVersion())){
                        throw new BusinessException("【" + detail.getBudgetCode() + "】项目预算书已被更新，请刷新后重做！");
                    }
                }
            };
        }
        //同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveorUpdateVO.getContractId()));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(saveorUpdateVO.getId() != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveorUpdateVO.getId()));
        }
        List<QuoteEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的对甲报量，不允许保存!");
        }

        QuoteEntity entity = BeanMapper.map(saveorUpdateVO, QuoteEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        List<QuoteDetailEntity> detailList = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            for(QuoteDetailEntity detail : detailList){
                detail.setQuoteId(entity.getId());
                if("del".equals(detail.getRowState())){
                    detailService.removeById(detail.getId(), false);
                } else {
                    detailService.saveOrUpdate(detail, false);
                    // 处理父子级关系
                    this.dealParentId(detail);
                    detailService.saveOrUpdate(detail, false);
                }
            };
        }
        return this.queryDetail(entity.getId());
    }

    /**
     * 处理父子级关系
     * @param detail
     */
    private void dealParentId(QuoteDetailEntity detail) {
        List<QuoteDetailCostEntity> costList = detail.getCostList();// 费用项清单
        if(CollectionUtils.isNotEmpty(costList)){
            Map<String, Long> idMap = new HashMap<>();
            costList.forEach(i->{
                idMap.put(i.getTid(), i.getId());
            });
            costList.forEach(i->{
                if(StringUtils.isNotEmpty(i.getTpid())){
                    i.setParentId(idMap.get(i.getTpid()));
                }
            });
        }
        List<QuoteDetailSubEntity> subList = detail.getSubList();// 分部分项清单
        if(CollectionUtils.isNotEmpty(subList)){
            Map<String, Long> idMap = new HashMap<>();
            subList.forEach(i->{
                idMap.put(i.getTid(), i.getId());
            });
            subList.forEach(i->{
                if(StringUtils.isNotEmpty(i.getTpid())){
                    i.setParentId(idMap.get(i.getTpid()));
                }
            });
        }
        List<QuoteDetailMeasureEntity> measureList = detail.getMeasureList();// 措施项清单
        if(CollectionUtils.isNotEmpty(measureList)){
            Map<String, Long> idMap = new HashMap<>();
            measureList.forEach(i->{
                idMap.put(i.getTid(), i.getId());
            });
            measureList.forEach(i->{
                if(StringUtils.isNotEmpty(i.getTpid())){
                    i.setParentId(idMap.get(i.getTpid()));
                }
            });
        }
        List<QuoteDetailOtherEntity> otherList = detail.getOtherList();// 其他项清单
        if(CollectionUtils.isNotEmpty(otherList)){
            Map<String, Long> idMap = new HashMap<>();
            otherList.forEach(i->{
                idMap.put(i.getTid(), i.getId());
            });
            otherList.forEach(i->{
                if(StringUtils.isNotEmpty(i.getTpid())){
                    i.setParentId(idMap.get(i.getTpid()));
                }
            });
        }
        List<QuoteDetailFeeEntity> feeList = detail.getFeeList();// 费税清单
        if(CollectionUtils.isNotEmpty(feeList)){
            Map<String, Long> idMap = new HashMap<>();
            feeList.forEach(i->{
                idMap.put(i.getTid(), i.getId());
            });
            feeList.forEach(i->{
                if(StringUtils.isNotEmpty(i.getTpid())){
                    i.setParentId(idMap.get(i.getTpid()));
                }
            });
        }
    }

    @Override
    public QuoteVO queryDetail(Long id) {
        QuoteEntity entity = super.selectById(id);
        detailListUtil.setDetailList(entity.getDetailList());// 解决queryList没有查询子表
        QuoteVO vo = BeanMapper.map(entity, QuoteVO.class);
        if (entity != null) {
            List<QuoteDetailVO> detailList = vo.getDetailList();
            // 构造子表树形
            if (CollectionUtils.isNotEmpty(detailList)) {
                for (QuoteDetailVO detail : detailList) {
                    List<QuoteDetailCostVO> costList = detail.getCostList();// 费用项清单
                    if(CollectionUtils.isNotEmpty(costList)){
                        costList.forEach(i->{
                            i.setTid(i.getId().toString());
                            i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                            i.setShadowId(i.getTid());
                            i.setRowState("edit");
                        });
                        new TreeSortUtil<QuoteDetailCostVO>().entryListToSort(costList);
                        detail.setCostList(TreeNodeBUtil.buildTree(costList));
                    }
                    List<QuoteDetailSubVO> subList = detail.getSubList();// 分部分项清单
                    if(CollectionUtils.isNotEmpty(subList)){
                        subList.forEach(i->{
                            i.setTid(i.getId().toString());
                            i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                            i.setShadowId(i.getTid());
                            i.setRowState("edit");
                        });
                        new TreeSortUtil<QuoteDetailSubVO>().entryListToSort(subList);
                        detail.setSubList(TreeNodeBUtil.buildTree(subList));
                    }
                    List<QuoteDetailMeasureVO> measureList = detail.getMeasureList();// 措施项清单
                    if(CollectionUtils.isNotEmpty(measureList)){
                        measureList.forEach(i->{
                            i.setTid(i.getId().toString());
                            i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                            i.setShadowId(i.getTid());
                            i.setRowState("edit");
                        });
                        new TreeSortUtil<QuoteDetailMeasureVO>().entryListToSort(measureList);
                        detail.setMeasureList(TreeNodeBUtil.buildTree(measureList));
                    }
                    List<QuoteDetailOtherVO> otherList = detail.getOtherList();// 其他项清单
                    if(CollectionUtils.isNotEmpty(otherList)){
                        otherList.forEach(i->{
                            i.setTid(i.getId().toString());
                            i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                            i.setShadowId(i.getTid());
                            i.setRowState("edit");
                        });
                        new TreeSortUtil<QuoteDetailOtherVO>().entryListToSort(otherList);
                        detail.setOtherList(TreeNodeBUtil.buildTree(otherList));
                    }
                    List<QuoteDetailFeeVO> feeList = detail.getFeeList();// 费税清单
                    if(CollectionUtils.isNotEmpty(feeList)){
                        feeList.forEach(i->{
                            i.setTid(i.getId().toString());
                            i.setTpid(i.getParentId() != null && i.getParentId() > 0 ? i.getParentId().toString() : "");
                            i.setShadowId(i.getTid());
                            i.setRowState("edit");
                        });
                        new TreeSortUtil<QuoteDetailFeeVO>().entryListToSort(feeList);
                        detail.setFeeList(TreeNodeBUtil.buildTree(feeList));
                    }
                }
            }
        }
        return vo;
    }

    @Override
    public String validateContract(Long id) {
        //同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        List<QuoteEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的对甲报量，不允许新增!");
        }
        return "校验通过！";
    }

    @Override
    public QuoteHistoryVO queryQuoteHistory(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);
        QuoteHistoryVO vo = new QuoteHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("quoteDate", QueryParam.DESC);
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<QuoteEntity> list = super.queryList(queryParam);
        
        if(CollectionUtils.isEmpty(list)){
            return vo;
        }
        BigDecimal sumQuoteMny = list.stream().map(QuoteEntity::getQuoteMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumQuoteTaxMny = list.stream().map(QuoteEntity::getQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReplyMny = list.stream().filter(e -> e.getReplyMny() != null).map(QuoteEntity::getReplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReplyTaxMny = list.stream().filter(e -> e.getReplyTaxMny() != null).map(QuoteEntity::getReplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumQuoteMny(sumQuoteMny);// 上报总金额(无税)
        vo.setSumQuoteTaxMny(sumQuoteTaxMny);// 上报总金额
        vo.setSumReplyMny(sumReplyMny);// 甲方批复总金额(无税)
        vo.setSumReplyTaxMny(sumReplyTaxMny);// 甲方批复总金额
        vo.setQuoteRecord(BeanMapper.mapList(list, QuoteVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(QuoteVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",id, res.getMsg());
            }
        }catch (Exception e){
            logger.error("结算单弃审推送结算池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送结算池异常!");
        }
        return flag;
    }


    @Override
    public BigDecimal calculateSumCheck(Long contractId, Long id) {
        return quoteMapper.calculateSumCheck(contractId,id);
    }

    @Override
    public BigDecimal calculateSumCheckProduction(Long contractId) {
        return quoteMapper.calculateSumCheckProduction(contractId);
    }

    @Override
    public Map<String, BigDecimal> calculateSumProduction(Long contractId) {
        return quoteMapper.calculateSumProduction(contractId);
    }

    @Override
    public QuoteVO queryApproveMnyByContractId(Long contractId) {
        //
        LambdaQueryWrapper<QuoteEntity> lambda = Wrappers.<QuoteEntity>lambdaQuery();
        lambda.eq(QuoteEntity::getContractId,contractId);
        lambda.in(QuoteEntity::getBillState,1,3);
        List<QuoteEntity> quoteEntityList = super.list(lambda);
        QuoteVO quoteVO = new QuoteVO();
        if (CollectionUtils.isNotEmpty(quoteEntityList)){
            BigDecimal replyMny = quoteEntityList.stream().filter(s ->s.getReplyMny() != null).map(QuoteEntity::getReplyMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal replyTaxMny = quoteEntityList.stream().filter(s ->s.getReplyTaxMny() != null).map(QuoteEntity::getReplyTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            quoteVO.setReplyMny(replyMny);
            quoteVO.setReplyTaxMny(replyTaxMny);
        }

        //4、获取“累计产值”，合同下产值报量每一期的【产值金额】累计值，单位元，不支持修改，显示含税，记录含税、无税

        LambdaQueryWrapper<ProductionEntity> lambdaProduction = Wrappers.<ProductionEntity>lambdaQuery();
        lambdaProduction.eq(ProductionEntity::getContractId,contractId);
        lambdaProduction.in(ProductionEntity::getBillState,1,3);
        List<ProductionEntity> productionEntityList = productionService.list(lambdaProduction);

        if (CollectionUtils.isNotEmpty(productionEntityList)){
            BigDecimal productionTaxMny = productionEntityList.stream().filter(s ->s.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal productionMny = productionEntityList.stream().filter(s ->s.getProductionMny() != null).map(ProductionEntity::getProductionMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            quoteVO.setSumMnyTax(productionTaxMny);
            quoteVO.setSumMny(productionMny);
        }
        return quoteVO;
    }

    // 将SettleReportVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(QuoteVO vo, SettlePoolVO spv) {
        spv.setSourceType("product_value_first");//结算类型
        spv.setSourceId(vo.getId());//结算单id
        spv.setId(vo.getId());
        spv.setSettleProperty(1);//属性类别=收入
        spv.setUltimateFlag(0);//是否最终结算=否
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setCurTax(ComputeUtil.safeSub(vo.getReplyTaxMny(), vo.getReplyMny()));// 税额
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/quote/card?id=" + vo.getId());// 穿透地址
        if(vo.getContractId()!=null){//有合同需要推送的字段
            //查询合同
            ContractRegisterEntity contractEntity = registerService.selectById(vo.getContractId());
            spv.setContractType("contraction");
            spv.setContractFlag(1);//合同标识
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setPartybId(contractEntity.getSupplierId());//乙方id
            spv.setPartybName(contractEntity.getSupplierName());//乙方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            BigDecimal lastTaxMny = BigDecimal.ZERO; // 截止本期累计结算金额
            BigDecimal lastMny = BigDecimal.ZERO; // 截止本期累计结算金额（无税）
            BigDecimal lastTax = BigDecimal.ZERO; // 截止本期累计结算税额
            /*获取除本次累计结算金额*/
            LambdaQueryWrapper<QuoteEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.orderByDesc(QuoteEntity::getCreateTime);
            wrapper.in(QuoteEntity::getBillState, 1,3);
            wrapper.eq(QuoteEntity::getDr, 0);
            wrapper.eq(QuoteEntity::getContractId, vo.getContractId());
            wrapper.ne(QuoteEntity::getId,vo.getId());
            List<QuoteEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (QuoteEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getReplyTaxMny()==null?BigDecimal.ZERO:settlementEntity.getReplyTaxMny();
                    BigDecimal settMny = settlementEntity.getReplyMny()==null?BigDecimal.ZERO:settlementEntity.getReplyMny();
                    BigDecimal settTax = ComputeUtil.safeSub(settTaxMny, settMny);
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(lastMny);//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(lastTax);//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成");
    }
}
