package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.mapper.SettleReportMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IMemorandumService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.vo.SettleReportHistoryVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 结算报审
 * 
 * @author generator
 * 
 */
@Service("settleReportService")
public class SettleReportServiceImpl extends BaseServiceImpl<SettleReportMapper, SettleReportEntity> implements ISettleReportService{
    @Autowired
    private IContractRegisterService registerService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private IContractRegisterService contractService;

    @Autowired
    private IMemorandumService memorandumService;

    @Autowired
    private SettleReportMapper settleReportMapper;

    @Override
    public SettleReportHistoryVO querySettleReportHistory(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);
        SettleReportHistoryVO vo = new SettleReportHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("reportDate", QueryParam.DESC);
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<SettleReportEntity> list = super.queryList(queryParam);

        if(CollectionUtils.isEmpty(list)){
            return vo;
        }
        BigDecimal sumReportSettleMny = list.stream().map(SettleReportEntity::getReportSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReportSettleTaxMny = list.stream().map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumReportSettleMny(sumReportSettleMny);// 报审结算总金额
        vo.setSumReportSettleTaxMny(sumReportSettleTaxMny);// 报审结算总金额(含税)
        vo.setReportRecord(BeanMapper.mapList(list, SettleReportVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(SettleReportVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送合同池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送合同池异常!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",id, res.getMsg());
            }
        }catch (Exception e){
            logger.error("结算单弃审推送合同池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送合同池异常!");
        }
        return flag;
    }

    @Override
    public void removeBatchByIds(List<Long> ids) {
        //先删除对应的备忘录
        memorandumService.removeBatchBySettleReportIds(ids);
        super.removeByIds(ids, false);
    }

    @Override
    public List<SettleReportEntity> checkMemoMaintenance(Integer days) {
        return settleReportMapper.checkMemoMaintenance(days);
    }

    // 将SettleReportVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(SettleReportVO vo, SettlePoolVO spv) {
        spv.setSourceType("settle_verify");//结算类型
        spv.setSourceId(vo.getId());//结算单id
        spv.setId(vo.getId());
        spv.setSettleProperty(1);//属性类别=收入
        spv.setUltimateFlag(0);//是否最终结算=否
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/settleReport/card?id=" + vo.getId());// 穿透地址
        if(vo.getContractId()!=null){//有合同需要推送的字段
            //查询合同
            ContractRegisterEntity contractEntity = contractService.selectById(vo.getContractId());
            spv.setContractType("contraction");
            spv.setContractFlag(1);//合同标识
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setPartybId(contractEntity.getSupplierId());//乙方id
            spv.setPartybName(contractEntity.getSupplierName());//乙方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            BigDecimal lastTaxMny = BigDecimal.ZERO; // 截止本期累计结算金额
            BigDecimal lastMny = BigDecimal.ZERO; // 截止本期累计结算金额（无税）
            BigDecimal lastTax = BigDecimal.ZERO; // 截止本期累计结算税额
            /*获取除本次累计结算金额*/
            LambdaQueryWrapper<SettleReportEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.orderByDesc(SettleReportEntity::getCreateTime);
            wrapper.in(SettleReportEntity::getBillState, 1,3);
            wrapper.eq(SettleReportEntity::getDr, 0);
            wrapper.eq(SettleReportEntity::getContractId, vo.getContractId());
            wrapper.ne(SettleReportEntity::getId,vo.getId());
            List<SettleReportEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (SettleReportEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getReportSettleTaxMny()==null?BigDecimal.ZERO:settlementEntity.getReportSettleTaxMny();
                    BigDecimal settMny = settlementEntity.getReportSettleMny()==null?BigDecimal.ZERO:settlementEntity.getReportSettleMny();
                    BigDecimal settTax = settlementEntity.getTax()==null?BigDecimal.ZERO:settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(lastMny);//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(lastTax);//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成");
    }

}
