package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.service.ISettlementFinalizationDetailService;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.QuoteDetailMeasureVO;
import com.ejianc.business.pro.income.vo.SettlementFinalizationDetailVO;
import com.ejianc.business.pro.income.vo.SettlementFinalizationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.SettlementFinalizationMapper;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 工程结算定案表返回确认单主实体
 * 
 * @author generator
 * 
 */
@Service("settlementFinalizationService")
public class SettlementFinalizationServiceImpl extends BaseServiceImpl<SettlementFinalizationMapper, SettlementFinalizationEntity> implements ISettlementFinalizationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "SETTLEMENT_FINALIZATION";//此处需要根据实际修改
    @Autowired
    private IProductionService productionService;
    @Autowired
    private ISettleReportService settleReportService;
    @Autowired
    private ISettlementFinalizationDetailService settlementFinalizationDetailService;


    @Override
    public SettlementFinalizationVO saveOrUpdate(SettlementFinalizationVO saveOrUpdateVO) {
        //同一个合同只能存在一个自由态或审批中的单据
        if (null != saveOrUpdateVO.getContractId()){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getContractId()));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
            if(saveOrUpdateVO.getId() != null){
                queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
            }
            List<SettlementFinalizationEntity> list = super.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(list)) {
                throw new BusinessException("当前合同存在非审批通过态的工程结算定案表返回确认单，不允许保存!");
            }
        }

        SettlementFinalizationEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementFinalizationEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        保存前清空主键和父主键，重新生成
        List<SettlementFinalizationDetailEntity> entityDetailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(entityDetailList) && null == entity.getId()) {
            for (SettlementFinalizationDetailEntity detailEntity : entityDetailList) {
                detailEntity.setId(null);
                detailEntity.setParentId(null);
            }
        }

        super.saveOrUpdate(entity, false);
        List<SettlementFinalizationDetailEntity> entityDetailList2 = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(entityDetailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (SettlementFinalizationDetailEntity detailEntity2 : entityDetailList2) {
                idMap.put(detailEntity2.getTid(), detailEntity2.getId());
            }
            for (SettlementFinalizationDetailEntity detailEntity2 : entityDetailList2) {
                if (StringUtils.isNotEmpty(detailEntity2.getTpid())) {
                    detailEntity2.setParentId(idMap.get(detailEntity2.getTpid()));
                }
            }
            settlementFinalizationDetailService.saveOrUpdateBatch(entityDetailList2);
        }

        return queryDetail(entity.getId());
    }

    @Override
    public Boolean querySettleFinalization(Long projectId, Long id) {
        LambdaQueryWrapper<SettlementFinalizationEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(SettlementFinalizationEntity::getProjectId, projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(SettlementFinalizationEntity::getId, id);
        }
        wrapper.notIn(SettlementFinalizationEntity::getBillState,1,3);
        List<SettlementFinalizationEntity> list = this.list(wrapper);

        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("该项目下已存在未生效的工程结算返回确认单!");
        }
        return true;
    }

    @Override
    public SettlementFinalizationDetailVO getDataByProjectId(Long id, Long projectId,  Long childProjectId,String settleStage) {
        //选择项目时判断，该执行项目是否已被父项目+结算阶段引用过，引用过选择时toast提示：选择失败，该执行项目已经被【单据编号】引用！，
        LambdaQueryWrapper<SettlementFinalizationEntity> wrappersettlementFinalization = new LambdaQueryWrapper<>();
        wrappersettlementFinalization.eq(SettlementFinalizationEntity::getProjectId, projectId);
        if (id != null){
            wrappersettlementFinalization.ne(SettlementFinalizationEntity::getId, id);
        }
        wrappersettlementFinalization.eq(SettlementFinalizationEntity::getSettleStage, settleStage);
        List<SettlementFinalizationEntity> finalizationEntityList = super.list(wrappersettlementFinalization);
        if (CollectionUtils.isNotEmpty(finalizationEntityList)){
            List<Long> ids = finalizationEntityList.stream().map(SettlementFinalizationEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<SettlementFinalizationDetailEntity> wrappersettlementFinalizationDetail = new LambdaQueryWrapper<>();
            wrappersettlementFinalizationDetail.eq(SettlementFinalizationDetailEntity::getChildProjectId, childProjectId);
            wrappersettlementFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List<SettlementFinalizationDetailEntity> settlementFinalizationDetailEntities = settlementFinalizationDetailService.list(wrappersettlementFinalizationDetail);

            if (settlementFinalizationDetailEntities != null && settlementFinalizationDetailEntities.size() > 0) {
                Long finalizationId = settlementFinalizationDetailEntities.stream().findFirst().get().getFinalizationId();
                List<SettlementFinalizationEntity> settlementFinalizationEntityList = finalizationEntityList.stream().filter(s -> s.getId().equals(finalizationId)).collect(Collectors.toList());
                String billCode = settlementFinalizationEntityList.stream().findFirst().get().getBillCode();
                throw new BusinessException("选择失败，该执行项目已经被【"+billCode + "】引用！");
            }
        }

        SettlementFinalizationDetailVO settlementFinalizationDetailVO = new SettlementFinalizationDetailVO();
        LambdaQueryWrapper<ProductionEntity> wrapperProduction = new LambdaQueryWrapper<>();
        wrapperProduction.eq(ProductionEntity::getProjectId, childProjectId);
        wrapperProduction.in(ProductionEntity::getBillState, 1,3);
        List<ProductionEntity> productionEntityList = productionService.list(wrapperProduction);

        if (CollectionUtils.isNotEmpty(productionEntityList)){
            // 汇总累计产值
            BigDecimal productionMny = productionEntityList.stream().filter(e -> e.getProductionMny() != null).map(ProductionEntity::getProductionMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal productionTaxMny = productionEntityList.stream().filter(e -> e.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settlementFinalizationDetailVO.setChildSumProductionMny(productionMny);
            settlementFinalizationDetailVO.setChildSumProductionTaxMny(productionTaxMny);
        }

        //获取结算报审
        LambdaQueryWrapper<SettleReportEntity> wrapperSettleReport = new LambdaQueryWrapper<>();
        wrapperSettleReport.eq(SettleReportEntity::getProjectId, childProjectId);
        wrapperSettleReport.in(SettleReportEntity::getBillState, 1,3);
        wrapperSettleReport.eq(SettleReportEntity::getSettleStage, settleStage);
        List<SettleReportEntity> settleReportEntityList = settleReportService.list(wrapperSettleReport);

        if (CollectionUtils.isNotEmpty(settleReportEntityList)){
            // 汇总累计产值
            BigDecimal reportSettleTaxMny = settleReportEntityList.stream().filter(e -> e.getReportSettleTaxMny() != null).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reportSettleMny = settleReportEntityList.stream().filter(e -> e.getReportSettleMny() != null).map(SettleReportEntity::getReportSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settlementFinalizationDetailVO.setChildReportSettleMny(reportSettleMny);
            settlementFinalizationDetailVO.setChildReportSettleTaxMny(reportSettleTaxMny);
            String checkUnit = settleReportEntityList.stream().findFirst().get().getCheckUnit();
            settlementFinalizationDetailVO.setChildCheckUnit(checkUnit);
        }

        return settlementFinalizationDetailVO;
    }

    @Override
    public SettlementFinalizationVO queryDetail(Long id) {
        SettlementFinalizationEntity settlementFinalizationEntity = super.selectById(id);

        SettlementFinalizationVO vo = BeanMapper.map(settlementFinalizationEntity, SettlementFinalizationVO.class);
        List<SettlementFinalizationDetailVO> detailList = vo.getDetailList();
        detailList.forEach(val->{
            val.setTid(this.objToString(val.getId()));
            val.setTpid(this.objToString(val.getParentId()));
            val.setRowState("edit");
        });
        List<SettlementFinalizationDetailVO> settlementFinalizationDetailVOS = TreeNodeBUtil.buildTree(detailList);
        vo.setDetailList(settlementFinalizationDetailVOS);
        return vo;
    }

    /**
     * Object转String
     * @param obj 需要转换的obj
     * @return 转换后的String
     */
    private String objToString(Object obj){
        if (obj == null) return null;
        return String.valueOf(obj);
    }
}
