/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.ParamUtil;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"claim"})
public class ClaimController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INCOME_NEGOTIATE_CODE = "INCOME_NEGOTIATE";
    private static final String INCOME_VISA_CODE = "INCOME_VISA";
    private static final String PROINCOME_CLAIM_CODE = "PROINCOME_CLAIM";
    private static final String QS = "QS";
    private static final String QZ = "QZ";
    private static final String SP = "SP";
    public static final Map<String, String> BillCodeMap = new HashMap<String, String>();
    public static final Map<String, String> ReplyStatusMap;
    @Autowired
    private IClaimService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IClaimRecordsService claimRecordsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimVO> saveOrUpdate(@RequestBody ClaimVO saveorUpdateVO) {
        ClaimEntity entity = (ClaimEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ClaimEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BillCodeMap.get(saveorUpdateVO.getBillType()), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.budgetService.updateUseId(entity.getId(), entity.getBillType(), saveorUpdateVO.getBudgetIds());
        this.claimRecordsService.updateClaimRecords(entity.getId(), entity.getReplyStatus(), saveorUpdateVO.getClaimRecordIds());
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimVO> queryDetail(Long id) {
        ClaimEntity entity = (ClaimEntity)((Object)this.service.selectById(id));
        ClaimVO vo = (ClaimVO)BeanMapper.map((Object)((Object)entity), ClaimVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVO> vos) {
        this.service.removeByIds(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()), true);
        this.budgetService.deleteUseId(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()));
        this.claimRecordsService.deleteClaimId(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (null == param.getParams().get("parentOrgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        List claimVOS = BeanMapper.mapList((Iterable)page.getRecords(), ClaimVO.class);
        Date now = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        for (ClaimVO claimVO : claimVOS) {
            this.logger.info("\u5355\u636e\u4fe1\u606f\uff1a", (Object)JSONObject.toJSONString((Object)claimVO));
            this.logger.info("commitDate", (Object)claimVO.getCommitDate());
            claimVO.setReplyStatusName(ReplyStatusMap.get(claimVO.getReplyStatus()));
            claimVO.setRealCommitDate(claimVO.getCommitDate());
            if (!BillStateEnum.PASSED_STATE.getBillStateCode().equals(claimVO.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(claimVO.getBillState()) || !"0".equals(claimVO.getReplyStatus()) || null == claimVO.getCommitDate() || DateUtils.addDays((Date)claimVO.getCommitDate(), (int)10).compareTo(now) != -1) continue;
            System.out.println("------\u5f53\u524d\u65f6\u95f4--------\uff1a" + sd.format(now));
            System.out.println("------\u5b9e\u9645\u63d0\u4ea4\u65f6\u95f4--------\uff1a" + sd.format(claimVO.getCommitDate()));
            System.out.println("------\u5b9e\u9645\u63d0\u4ea4\u65f6\u95f4 + 10\u5929--------\uff1a" + sd.format(DateUtils.addDays((Date)claimVO.getCommitDate(), (int)10)));
            claimVO.setReplyStatusRedFlag(Integer.valueOf(1));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(claimVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static void main(String[] args) {
        Date now = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        System.out.println("------\u5f53\u524d\u65f6\u95f4--------\uff1a" + sd.format(now));
        System.out.println(DateUtils.addDays((Date)DateUtils.addDays((Date)now, (int)-11), (int)10).compareTo(now));
        if (DateUtils.addDays((Date)DateUtils.addDays((Date)now, (int)-10), (int)10).compareTo(now) == -1) {
            System.out.println("\u5076\u54c8\u6709\uff01\uff01");
        }
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String billType = (String)((Parameter)param.getParams().get("billType")).getValue();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List claimVOS = BeanMapper.mapList((Iterable)list, ClaimVO.class);
        claimVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setReplyStatusName(ReplyStatusMap.get(e.getReplyStatus()));
        });
        beans.put("records", claimVOS);
        if (QS.equals(billType)) {
            ExcelExport.getInstance().export("negotiate-export.xlsx", beans, response);
        } else if (QZ.equals(billType)) {
            ExcelExport.getInstance().export("visa-export.xlsx", beans, response);
        } else if (SP.equals(billType)) {
            ExcelExport.getInstance().export("claim-export.xlsx", beans, response);
        }
    }

    @PostMapping(value={"*"})
    @ResponseBody
    public CommonResponse<String> updateReplyDate(@RequestBody ClaimVO claim) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.service.selectById(claim.getId()));
        if (claimEntity != null) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)claim.getId());
            wrapper.set(ClaimEntity::getReplyDate, (Object)claim.getReplyDate());
            wrapper.set(ClaimEntity::getReplyStatus, (Object)claim.getReplyStatus());
            wrapper.set(ClaimEntity::getReplyMny, (Object)claim.getReplyMny());
            wrapper.set(ClaimEntity::getReplyTaxMny, (Object)claim.getReplyTaxMny());
            wrapper.set(ClaimEntity::getReplyTax, (Object)claim.getReplyTax());
            wrapper.set(ClaimEntity::getReplyDuration, (Object)claim.getReplyDuration());
            ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntity.getContractId()));
            if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(contractRegisterEntity.getBillPushFlag())) {
                claimEntity.setReplyTaxMny(claim.getReplyTaxMny());
                claimEntity.setReplyMny(claim.getReplyMny());
                claimEntity.setReplyTax(claim.getReplyTax());
                claimEntity.setReplyStatus(claim.getReplyStatus());
                boolean pushResult = this.service.updateContract(claimEntity, true);
                if (pushResult) {
                    wrapper.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    wrapper.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
            }
            this.service.update((Wrapper)wrapper);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(ClaimRecordsEntity::getClaimId, (Object)claim.getId());
            updateWrapper.set(ClaimRecordsEntity::getReplyStatus, (Object)claim.getReplyStatus());
            this.claimRecordsService.update((Wrapper)updateWrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
    }

    @GetMapping(value={"queryBudgetList"})
    @ResponseBody
    public CommonResponse<List<BudgetVO>> queryBudgetList(@RequestParam(value="id") Long id) {
        List<BudgetVO> budgetVOS = this.budgetService.selectByUseId(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", budgetVOS);
    }

    @GetMapping(value={"queryClaimRecordsList"})
    @ResponseBody
    public CommonResponse<List<ClaimRecordsVO>> queryClaimRecordsList(@RequestParam(value="id") Long id) {
        List<ClaimRecordsVO> claimRecordsVOS = this.claimRecordsService.selectByClaimId(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", claimRecordsVOS);
    }

    @GetMapping(value={"queryRecordByContractId"})
    @ResponseBody
    public CommonResponse<ClaimRecordVO> queryRecordByContractId(@RequestParam(value="id") Long contractId) {
        ClaimRecordVO vo = this.service.queryRecordByContractId(contractId);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"connectAppendix"})
    @ResponseBody
    public CommonResponse<String> connectAppendix(@RequestBody AttachmentVO vo) {
        ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
        vo.setId(null);
        vo.setSourceType("102345678");
        vo.setRowState("add");
        list.add(vo);
        this.attachmentApi.insertBatch(list);
        return CommonResponse.success();
    }

    @GetMapping(value={"relevanceBudget"})
    @ResponseBody
    public CommonResponse relevanceBudget(@RequestParam(value="id") Long id, @RequestParam(value="budgetIds") List<Long> budgetIds, @RequestParam(value="billType") String billType) {
        this.budgetService.relevanceBudget(id, budgetIds, billType);
        return CommonResponse.success((String)"\u5173\u8054\u6210\u529f");
    }

    @GetMapping(value={"deleteRelevanceBudget"})
    @ResponseBody
    public CommonResponse deleteRelevanceBudget(@RequestParam(value="budgetIds") List<Long> budgetIds) {
        this.budgetService.deleteRelevanceBudget(budgetIds);
        return CommonResponse.success((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f");
    }

    @PostMapping(value={"updateMny"})
    @ResponseBody
    public CommonResponse updateMny(@RequestBody ClaimVO claimVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)claimVO.getId());
        wrapper.set(ClaimEntity::getClaimMny, (Object)claimVO.getClaimMny());
        wrapper.set(ClaimEntity::getClaimTaxMny, (Object)claimVO.getClaimTaxMny());
        wrapper.set(ClaimEntity::getClaimTax, (Object)claimVO.getClaimTax());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u91d1\u989d\u6210\u529f");
    }

    @GetMapping(value={"/syncUpdateContract"})
    @ResponseBody
    public CommonResponse<Boolean> syncUpdateContract(@RequestParam(value="id") Long id) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.service.selectById(id));
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntity.getContractId()));
        if (null != contractRegisterEntity) {
            if (contractRegisterEntity.getBillPushFlag() == null || contractRegisterEntity.getBillPushFlag().equals(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus())) {
                CommonResponse.error((String)"\u8bf7\u5148\u5c06\u5408\u540c\u63a8\u9001\u81f3\u5408\u540c\u6c60\uff01");
            }
        } else {
            CommonResponse.error((String)"\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.updateContract(claimEntity, true));
    }

    @RequestMapping(value={"/refClaimData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> refClaimData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("claimTitle");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getParams().put("reply_status", new Parameter("eq", (Object)"1"));
        queryParam.getOrderMap().put("createTime", "desc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            }
            if (null != conditionMap.get("applyAdjustDate")) {
                String applyAdjustDate = conditionMap.get("applyAdjustDate").toString();
                if (null == conditionMap.get("lastApplyAdjustDate")) {
                    queryParam.getParams().put("commit_date", new Parameter("le", (Object)applyAdjustDate));
                } else {
                    String lastApplyAdjustDate = conditionMap.get("lastApplyAdjustDate").toString();
                    queryParam.getParams().put("commit_date", new Parameter("between", (Object)(lastApplyAdjustDate + "," + applyAdjustDate)));
                }
            }
            if (null != conditionMap.get("useFlag")) {
                int useFlag = Integer.parseInt(conditionMap.get("useFlag").toString());
                if (useFlag == 0) {
                    if (null != conditionMap.get("costAdjustId")) {
                        Long costAdjustId = Long.valueOf(conditionMap.get("costAdjustId").toString());
                        ComplexParam complexParam = ParamUtil.getOrParam("costAdjustId", new Parameter("eq", null), new Parameter("eq", (Object)costAdjustId));
                        queryParam.getComplexParams().add(complexParam);
                    } else {
                        queryParam.getParams().put("costAdjustId", new Parameter("eq", null));
                    }
                } else {
                    queryParam.getParams().put("costAdjustId", new Parameter("ne", null));
                }
            }
        }
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ClaimVO.class);
        for (ClaimVO vo : list) {
            if (QS.equals(vo.getBillType())) {
                vo.setBillTypeName("\u53d8\u66f4\u6d3d\u5546\u5355");
            } else if (QZ.equals(vo.getBillType())) {
                vo.setBillTypeName("\u7ecf\u6d4e\u7b7e\u8bc1\u5355");
            } else if (SP.equals(vo.getBillType())) {
                vo.setBillTypeName("\u7d22\u8d54\u5355");
            } else {
                vo.setBillTypeName(null);
            }
            if ("0".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u672a\u6279\u590d");
                continue;
            }
            if ("1".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u5df2\u6279\u590d");
                continue;
            }
            if ("2".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("\u672a\u901a\u8fc7");
                continue;
            }
            vo.setReplyStatusName(null);
        }
        result.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    static {
        BillCodeMap.put(QS, INCOME_NEGOTIATE_CODE);
        BillCodeMap.put(QZ, INCOME_VISA_CODE);
        BillCodeMap.put(SP, PROINCOME_CLAIM_CODE);
        ReplyStatusMap = new HashMap<String, String>();
        ReplyStatusMap.put("0", "\u672a\u6279\u590d");
        ReplyStatusMap.put("1", "\u5df2\u6279\u590d");
        ReplyStatusMap.put("2", "\u672a\u901a\u8fc7");
    }
}

