/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.CostAdjustEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.ICostAdjustService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costAdjust")
public class CostAdjustBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostAdjustService service;
    @Autowired
    private IContractRegisterService registerService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u56de\u5199\u5408\u540c\u5408\u540c\u5de5\u7a0b\u9020\u4ef7\u53ca\u53d8\u52a8\u5408\u8ba1\u603b\u91d1\u989d\u5f00\u59cb");
        CostAdjustEntity entity = (CostAdjustEntity)((Object)this.service.selectById(billId));
        ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(entity.getContractId()));
        BigDecimal totalCostAdjustTaxMny = ComputeUtil.safeAdd((BigDecimal)registerEntity.getTotalCostAdjustTaxMny(), (BigDecimal)entity.getApplyChangeTaxMny());
        BigDecimal totalCostAdjustMny = ComputeUtil.safeAdd((BigDecimal)registerEntity.getTotalCostAdjustMny(), (BigDecimal)entity.getApplyChangeMny());
        BigDecimal applyChangeTax = ComputeUtil.safeSub((BigDecimal)entity.getApplyChangeTaxMny(), (BigDecimal)entity.getApplyChangeMny());
        BigDecimal totalCostAdjustTax = ComputeUtil.safeAdd((BigDecimal)registerEntity.getTotalCostAdjustTax(), (BigDecimal)applyChangeTax);
        registerEntity.setCostChangeTotalTaxMny(entity.getCostChangeTotalTaxMny());
        registerEntity.setCostChangeTotalMny(entity.getCostChangeTotalMny());
        registerEntity.setTotalCostAdjustTaxMny(totalCostAdjustTaxMny);
        registerEntity.setTotalCostAdjustMny(totalCostAdjustMny);
        registerEntity.setTotalCostAdjustTax(totalCostAdjustTax);
        registerEntity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseTaxMoney(), (BigDecimal)totalCostAdjustTaxMny));
        registerEntity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseMoney(), (BigDecimal)totalCostAdjustMny));
        registerEntity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseTax(), (BigDecimal)totalCostAdjustTax));
        registerEntity.setNicContractMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getNotIncludeProvisionalMny(), (BigDecimal)totalCostAdjustTaxMny));
        this.registerService.saveOrUpdate((Object)registerEntity);
        this.logger.info("\u56de\u5199\u5408\u540c\u5408\u540c\u5de5\u7a0b\u9020\u4ef7\u53ca\u53d8\u52a8\u5408\u8ba1\u603b\u91d1\u989d\u7ed3\u675f");
        this.service.updateContractPool(registerEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CostAdjustEntity entity = (CostAdjustEntity)((Object)this.service.selectById(billId));
        ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(entity.getContractId()));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CostAdjustEntity::getContractId, (Object)entity.getContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
            if (count > 0L) {
                throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5de5\u7a0b\u9020\u4ef7\u8c03\u6574\u7533\u8bf7\uff0c\u65e0\u6cd5\u64a4\u56de\uff01");
            }
            CostAdjustEntity adjustEntity = (CostAdjustEntity)((Object)list.get(0));
            if (Objects.equals(entity.getId(), adjustEntity.getId())) {
                if (list.size() >= 2) {
                    CostAdjustEntity costAdjustEntity = (CostAdjustEntity)((Object)list.get(1));
                    BigDecimal totalCostAdjustTaxMny = ComputeUtil.safeSub((BigDecimal)registerEntity.getTotalCostAdjustTaxMny(), (BigDecimal)adjustEntity.getApplyChangeTaxMny());
                    BigDecimal totalCostAdjustMny = ComputeUtil.safeSub((BigDecimal)registerEntity.getTotalCostAdjustMny(), (BigDecimal)adjustEntity.getApplyChangeMny());
                    BigDecimal applyChangeTax = ComputeUtil.safeSub((BigDecimal)adjustEntity.getApplyChangeTaxMny(), (BigDecimal)adjustEntity.getApplyChangeMny());
                    BigDecimal totalCostAdjustTax = ComputeUtil.safeSub((BigDecimal)registerEntity.getTotalCostAdjustTaxMny(), (BigDecimal)applyChangeTax);
                    registerEntity.setCostChangeTotalTaxMny(costAdjustEntity.getCostChangeTotalTaxMny());
                    registerEntity.setCostChangeTotalMny(costAdjustEntity.getCostChangeTotalMny());
                    registerEntity.setTotalCostAdjustTaxMny(totalCostAdjustTaxMny);
                    registerEntity.setTotalCostAdjustMny(totalCostAdjustMny);
                    registerEntity.setTotalCostAdjustTax(totalCostAdjustTax);
                    registerEntity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseTaxMoney(), (BigDecimal)totalCostAdjustTaxMny));
                    registerEntity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseMoney(), (BigDecimal)totalCostAdjustMny));
                    registerEntity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)registerEntity.getBaseTax(), (BigDecimal)totalCostAdjustTax));
                    registerEntity.setNicContractMny(ComputeUtil.safeAdd((BigDecimal)registerEntity.getNotIncludeProvisionalMny(), (BigDecimal)totalCostAdjustTaxMny));
                } else {
                    registerEntity.setCostChangeTotalTaxMny(null);
                    registerEntity.setCostChangeTotalMny(null);
                    registerEntity.setTotalCostAdjustTaxMny(null);
                    registerEntity.setTotalCostAdjustMny(null);
                    registerEntity.setTotalCostAdjustTax(null);
                    registerEntity.setTotalAfterCostAdjustTaxMny(registerEntity.getBaseTaxMoney());
                    registerEntity.setTotalAfterCostAdjustMny(registerEntity.getBaseMoney());
                    registerEntity.setTotalAfterCostAdjustTax(registerEntity.getBaseTax());
                    registerEntity.setNicContractMny(registerEntity.getNotIncludeProvisionalMny());
                }
                this.registerService.saveOrUpdate((Object)registerEntity);
                this.service.updateContractPool(registerEntity);
            } else {
                throw new BusinessException("\u5b58\u5728\u6bd4\u5f53\u524d\u521b\u5efa\u65f6\u95f4\u66f4\u665a\u7684\u5de5\u7a0b\u9020\u4ef7\u8c03\u6574\u7533\u8bf7\uff0c\u65e0\u6cd5\u64a4\u56de!");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

