/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finalized")
public class FinalizedBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFinalizedService service;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IProjectSetApi projectSetApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u56de\u5199\u5408\u540c\u72b6\u6001\u5f00\u59cb");
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(billId));
        if (Objects.equals(FinalStageEnum.\u7ec8\u5ba1.getCode(), entity.getFinalStage()) && entity.getFinalFlag() == "1") {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u5df2\u7ec8\u6b62.getCode());
            wrapper.set(ContractRegisterEntity::getIsFinish, (Object)1);
            wrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
            this.registerService.update((Wrapper)wrapper);
        }
        this.logger.info("\u7ec8\u5ba1\u56de\u5199\u5408\u540c\u7ed3\u675f");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(billId));
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(entity.getContractId()));
        if ("4".equals(entity.getFinalStage())) {
            boolean pushResult;
            if ("sucPushed".equals(contractRegisterEntity.getBillPushFlag()) && !(pushResult = this.service.pushContract((ContractRegisterVO)BeanMapper.map((Object)((Object)contractRegisterEntity), ContractRegisterVO.class), "3"))) {
                return CommonResponse.error((String)"\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25");
            }
            FinalizedVO settlementVO = (FinalizedVO)BeanMapper.map((Object)((Object)entity), FinalizedVO.class);
            boolean pool = this.service.pushSettleToPool(settlementVO);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
            CommonResponse res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, "9", null, null);
            if (!res.isSuccess()) {
                this.logger.info("\u5de5\u7a0b\u5b9a\u6848\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u5df2\u51b3\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)entity.getBillCode(), (Object)res.getMsg());
                throw new BusinessException("\u5de5\u7a0b\u5b9a\u6848\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u5df2\u51b3\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(billId));
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(entity.getContractId()));
        if ("4".equals(entity.getFinalStage())) {
            boolean pushResult;
            if ("sucPushed".equals(contractRegisterEntity.getBillPushFlag()) && !(pushResult = this.service.pushContract((ContractRegisterVO)BeanMapper.map((Object)((Object)contractRegisterEntity), ContractRegisterVO.class), "2"))) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25");
            }
            boolean pool = this.service.delSettleFromPool(billId);
            if (!pool) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u64a4\u56de\u56de\u5199\u5408\u540c\u7ec8\u5ba1\u6807\u8bc6\u5f00\u59cb");
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, entity.getProjectId())) {
            wrapper.eq(FinalizedEntity::getProjectId, (Object)entity.getProjectId());
        }
        wrapper.eq(FinalizedEntity::getContractId, (Object)entity.getContractId());
        wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        List list = this.service.list((Wrapper)wrapper);
        long count = list.stream().filter(e -> !e.getFinalStage().equals(entity.getFinalStage())).filter(e -> Integer.parseInt(e.getFinalStage()) > Integer.parseInt(entity.getFinalStage())).count();
        if (count > 0L) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u5176\u4ed6\u5b9a\u6848\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        if (Objects.equals(FinalStageEnum.\u7ec8\u5ba1.getCode(), entity.getFinalStage()) && entity.getFinalFlag() == "1") {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractRegisterEntity::getIsFinish, (Object)0);
            updateWrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
            this.registerService.update((Wrapper)updateWrapper);
        }
        this.logger.info("\u64a4\u56de\u56de\u5199\u5408\u540c\u7ec8\u5ba1\u6807\u8bc6\u5f00\u59cb");
        return CommonResponse.success();
    }
}

