package com.ejianc.business.pro.income.controller.api;

import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/budgetApi")
public class BudgetApi {

    @Autowired
    private IBudgetService budgetService;

    @GetMapping("/querySumBudgetMny")
    public CommonResponse<List<BudgetReportVO>> querySumBudgetMny(@RequestParam(value = "projectId") Long projectId,
                                                                  @RequestParam(value = "beginPeriod", required = false) String beginPeriod,
                                                                  @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询成功！", budgetService.querySumBudgetMny(projectId,beginPeriod,endDate));
    }
    @GetMapping("/querySumBudgetMnyNew")
    public CommonResponse<List<BudgetReportVO>> querySumBudgetMnyNew(@RequestParam(value = "projectId") Long projectId,
                                                                      @RequestParam(value = "beginPeriod", required = false) String beginPeriod,
                                                                      @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询成功！", budgetService.querySumBudgetMnyNew(projectId,beginPeriod,endDate));
    }

    @GetMapping("/queryAllBudgetMny")
    public CommonResponse<BigDecimal> queryAllBudgetMny(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询成功！", budgetService.queryAllBudgetMny(projectId));
    }
}
