/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.UnsettleDetailEntity;
import com.ejianc.business.pro.income.bean.UnsettleDisputedEntity;
import com.ejianc.business.pro.income.bean.UnsettleEntity;
import com.ejianc.business.pro.income.service.IUnsettleDetailService;
import com.ejianc.business.pro.income.service.IUnsettleDisputedService;
import com.ejianc.business.pro.income.service.IUnsettleService;
import com.ejianc.business.pro.income.vo.UnsettleDisputedVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"unsettleDisputed"})
public class UnsettleDisputedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IUnsettleDisputedService service;
    @Autowired
    private IUnsettleService unsettleService;
    @Autowired
    private IUnsettleDetailService unsettleDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody List<UnsettleDisputedVO> saveOrUpdateVOs) {
        if (CollectionUtils.isNotEmpty(saveOrUpdateVOs)) {
            ArrayList saveVOList = new ArrayList();
            ArrayList delVOList = new ArrayList();
            saveOrUpdateVOs.forEach(e -> {
                if (null != e.getRowState() && "del".equals(e.getRowState())) {
                    delVOList.add(e.getId());
                } else {
                    saveVOList.add(e);
                }
            });
            if (CollectionUtils.isNotEmpty(saveVOList)) {
                this.service.saveOrUpdateBatch(BeanMapper.mapList(saveVOList, UnsettleDisputedEntity.class));
            }
            if (CollectionUtils.isNotEmpty(delVOList)) {
                this.service.removeByIds(delVOList);
            }
            BigDecimal detailDisputedMny = saveVOList.stream().filter(item -> null != item.getAllDisputedMny()).map(UnsettleDisputedVO::getAllDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(UnsettleDetailEntity::getUnsettleId, new Object[]{saveOrUpdateVOs.get(0).getUnsettleId()});
            updateWrapper.eq(UnsettleDetailEntity::getProjectId, (Object)saveOrUpdateVOs.get(0).getProjectId());
            updateWrapper.set(UnsettleDetailEntity::getDetailDisputedMny, (Object)detailDisputedMny);
            this.unsettleDetailService.update((Wrapper)updateWrapper);
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(UnsettleDisputedEntity::getUnsettleId, (Object)saveOrUpdateVOs.get(0).getUnsettleId());
            List unsettleDisputedEntityList = this.service.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)unsettleDisputedEntityList)) {
                BigDecimal resolvedDisputedMny = unsettleDisputedEntityList.stream().filter(item -> null != item.getResolvedDisputedMny()).map(UnsettleDisputedEntity::getResolvedDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allDisputedMny = unsettleDisputedEntityList.stream().filter(item -> null != item.getAllDisputedMny()).map(UnsettleDisputedEntity::getAllDisputedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                LambdaUpdateWrapper updateWrapperh = new LambdaUpdateWrapper();
                updateWrapperh.in(BaseEntity::getId, new Object[]{saveOrUpdateVOs.get(0).getUnsettleId()});
                updateWrapperh.set(UnsettleEntity::getDisputedMny, (Object)allDisputedMny);
                updateWrapperh.set(UnsettleEntity::getSumDisputedMny, (Object)resolvedDisputedMny);
                this.unsettleService.update((Wrapper)updateWrapperh);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UnsettleDisputedVO> queryDetail(Long id) {
        UnsettleDisputedEntity entity = (UnsettleDisputedEntity)((Object)this.service.selectById(id));
        UnsettleDisputedVO vo = (UnsettleDisputedVO)BeanMapper.map((Object)((Object)entity), UnsettleDisputedVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UnsettleDisputedVO>> queryDetailList(Long unsettleId, Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(UnsettleDisputedEntity::getUnsettleId, (Object)unsettleId);
        lambda.eq(UnsettleDisputedEntity::getProjectId, (Object)projectId);
        List contractRegisterList = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)contractRegisterList, UnsettleDisputedVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", new ArrayList());
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnsettleDisputedVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UnsettleDisputedVO unsettleDisputedVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnsettleDisputedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnsettleDisputedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("UnsettleDisputed-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refUnsettleDisputedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UnsettleDisputedVO>> refUnsettleDisputedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnsettleDisputedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

