/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.income.bean.BudgetCostEntity;
import com.ejianc.business.pro.income.bean.BudgetDetailEntity;
import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.BudgetFeeEntity;
import com.ejianc.business.pro.income.bean.BudgetMeasureEntity;
import com.ejianc.business.pro.income.bean.BudgetOtherEntity;
import com.ejianc.business.pro.income.bean.BudgetSubEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailCostEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailFeeEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailMeasureEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailOtherEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailSubEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.cons.DetailLengthCons;
import com.ejianc.business.pro.income.mapper.BudgetMapper;
import com.ejianc.business.pro.income.service.IBudgetCostService;
import com.ejianc.business.pro.income.service.IBudgetDetailService;
import com.ejianc.business.pro.income.service.IBudgetFeeService;
import com.ejianc.business.pro.income.service.IBudgetMeasureService;
import com.ejianc.business.pro.income.service.IBudgetOtherService;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IBudgetSubService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionDetailCostService;
import com.ejianc.business.pro.income.service.IProductionDetailFeeService;
import com.ejianc.business.pro.income.service.IProductionDetailMeasureService;
import com.ejianc.business.pro.income.service.IProductionDetailOtherService;
import com.ejianc.business.pro.income.service.IProductionDetailService;
import com.ejianc.business.pro.income.service.IProductionDetailSubService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.DetailIndexExcelReader;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.utils.SortUtil;
import com.ejianc.business.pro.income.utils.SubjectEnum;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.utils.UpSumUtil;
import com.ejianc.business.pro.income.vo.BudgetCostVO;
import com.ejianc.business.pro.income.vo.BudgetDetailVO;
import com.ejianc.business.pro.income.vo.BudgetFeeVO;
import com.ejianc.business.pro.income.vo.BudgetHistoryVO;
import com.ejianc.business.pro.income.vo.BudgetMeasureVO;
import com.ejianc.business.pro.income.vo.BudgetOtherVO;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.business.pro.income.vo.BudgetSubVO;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.business.pro.income.vo.ImportErrorVo;
import com.ejianc.business.pro.income.vo.ImportVo;
import com.ejianc.business.pro.income.vo.ThreeReportVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="budgetService")
public class BudgetServiceImpl
extends BaseServiceImpl<BudgetMapper, BudgetEntity>
implements IBudgetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "INCOME_BUDGET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetSubService budgetSubService;
    @Autowired
    private IBudgetMeasureService budgetMeasureService;
    @Autowired
    private IBudgetOtherService budgetOtherService;
    @Autowired
    private IBudgetFeeService budgetFeeService;
    @Autowired
    private IBudgetCostService budgetCostService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private IProductionDetailSubService productionDetailSubService;
    @Autowired
    private IProductionDetailMeasureService productionDetailMeasureService;
    @Autowired
    private IProductionDetailOtherService productionDetailOtherService;
    @Autowired
    private IProductionDetailFeeService productionDetailFeeService;
    @Autowired
    private IProductionDetailCostService productionDetailCostService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BudgetVO saveOrUpdate(BudgetVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (BudgetEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetEntity.class));
            operateType = "edit";
            if (saveorUpdateVO.getBillState() == 1 || saveorUpdateVO.getBillState() == 3) {
                BigDecimal newbudgetTaxMny;
                BudgetEntity budgetEntity = (BudgetEntity)((Object)((BudgetMapper)this.baseMapper).selectById(saveorUpdateVO.getId()));
                BigDecimal oldbudgetTaxMny = budgetEntity.getBudgetTaxMny() == null ? BigDecimal.ZERO : budgetEntity.getBudgetTaxMny();
                BigDecimal bigDecimal = newbudgetTaxMny = saveorUpdateVO.getBudgetTaxMny() == null ? BigDecimal.ZERO : saveorUpdateVO.getBudgetTaxMny();
                if (oldbudgetTaxMny.compareTo(newbudgetTaxMny) == 0) {
                    // empty if block
                }
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantId, (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                saveorUpdateVO.setBillCode((String)billCode.getData());
            }
            entity = (BudgetEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        if (entity.getBudgetModel() != 0 && entity.getBudgetModel() != 2) {
            this.detailCost(saveorUpdateVO, entity.getId());
            return this.queryDetail(entity.getId());
        }
        this.detailInfo(saveorUpdateVO, entity.getId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public BudgetVO queryDetail(Long id) {
        BudgetEntity entity = (BudgetEntity)((Object)super.selectById((Serializable)id));
        BudgetVO vo = (BudgetVO)BeanMapper.map((Object)((Object)entity), BudgetVO.class);
        Integer detailLength = 0;
        if (vo.getBudgetModel() == 0 || entity.getBudgetModel() == 2) {
            ArrayList detailList;
            List subVos = vo.getSubVos();
            List measureVos = vo.getMeasureVos();
            List otherVos = vo.getOtherVos();
            List feeVos = vo.getFeeVos();
            Integer a = subVos.size() > measureVos.size() ? subVos.size() : measureVos.size();
            Integer b = otherVos.size() > feeVos.size() ? otherVos.size() : feeVos.size();
            detailLength = a > b ? a : b;
            vo.setDetailLength(detailLength);
            HashMap bdMap = new HashMap();
            boolean lengthFlag = false;
            if (DetailLengthCons.DETAIL_LENGTH == null || detailLength <= DetailLengthCons.DETAIL_LENGTH) {
                lengthFlag = true;
                LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                lambda.eq(BaseEntity::getDr, (Object)0);
                lambda.eq(BudgetDetailEntity::getBudgetId, (Object)id);
                List budgetDetailEntities = this.budgetDetailService.list((Wrapper)lambda);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    List<BudgetDetailVO> entities;
                    BudgetDetailVO bdevo = (BudgetDetailVO)BeanMapper.map((Object)((Object)bde), BudgetDetailVO.class);
                    bdevo.setRowState("edit");
                    bdevo.setTid(bdevo.getId().toString());
                    bdevo.setTpid(bdevo.getParentId() != null && bdevo.getParentId() > 0L ? bdevo.getParentId().toString() : "");
                    if (bdMap.containsKey(bdevo.getBudgetBid())) {
                        entities = (List)bdMap.get(bdevo.getBudgetBid());
                        entities.add(bdevo);
                        bdMap.put(bdevo.getBudgetBid(), entities);
                        continue;
                    }
                    entities = new ArrayList<BudgetDetailVO>();
                    entities.add(bdevo);
                    bdMap.put(bdevo.getBudgetBid(), entities);
                }
            }
            if (subVos != null && subVos.size() > 0) {
                for (BudgetSubVO cdVo : subVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0L ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (!lengthFlag || !cdVo.getLeafFlag().booleanValue()) continue;
                    detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList() : (List)bdMap.get(cdVo.getId());
                    new SortUtil().entryListToSort(detailList);
                    cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                }
                new SortUtil().entryListToSort(subVos);
                vo.setSubVos(TreeNodeBUtil.buildTree((List)subVos));
            }
            if (measureVos != null && measureVos.size() > 0) {
                for (BudgetSubVO cdVo : measureVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0L ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (!lengthFlag || !cdVo.getLeafFlag().booleanValue()) continue;
                    detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList() : (List)bdMap.get(cdVo.getId());
                    new SortUtil().entryListToSort(detailList);
                    cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                }
                new SortUtil().entryListToSort(measureVos);
                vo.setMeasureVos(TreeNodeBUtil.buildTree((List)measureVos));
            }
            if (otherVos != null && otherVos.size() > 0) {
                for (BudgetSubVO cdVo : otherVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0L ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (!lengthFlag || !cdVo.getLeafFlag().booleanValue()) continue;
                    detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList() : (List)bdMap.get(cdVo.getId());
                    new SortUtil().entryListToSort(detailList);
                    cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                }
                new SortUtil().entryListToSort(otherVos);
                vo.setOtherVos(TreeNodeBUtil.buildTree((List)otherVos));
            }
            if (feeVos != null && feeVos.size() > 0) {
                for (BudgetSubVO cdVo : feeVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0L ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (!lengthFlag || !cdVo.getLeafFlag().booleanValue()) continue;
                    detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList() : (List)bdMap.get(cdVo.getId());
                    new SortUtil().entryListToSort(detailList);
                    cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                }
                new SortUtil().entryListToSort(feeVos);
                vo.setFeeVos(TreeNodeBUtil.buildTree((List)feeVos));
            }
        } else {
            List costVos = vo.getCostVos();
            detailLength = costVos.size();
            vo.setDetailLength(detailLength);
            if (costVos != null && costVos.size() > 0) {
                for (BudgetCostVO cdVo : costVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0L ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                }
                new SortUtil().entryListToSort(costVos);
                vo.setCostVos(TreeNodeBUtil.buildTree((List)costVos));
            }
        }
        return vo;
    }

    @Override
    public BudgetVO queryBudgetDetail(Long id) {
        BudgetEntity entity = (BudgetEntity)((Object)((BudgetMapper)this.baseMapper).selectById(id));
        BudgetVO vo = (BudgetVO)BeanMapper.map((Object)((Object)entity), BudgetVO.class);
        return vo;
    }

    @Override
    public BudgetVO saveBudget(BudgetVO saveorUpdateVO) {
        List attachIds;
        Long tenantId = InvocationInfoProxy.getTenantid();
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            operateType = "edit";
        } else {
            operateType = "add";
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        }
        BudgetEntity entity = (BudgetEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetEntity.class));
        super.saveOrUpdate((Object)entity);
        if ("add".equals(operateType) && (attachIds = saveorUpdateVO.getAttachIds()) != null && attachIds.size() > 0) {
            this.fileApi.updateAttachRef(entity.getId(), attachIds);
        }
        return (BudgetVO)BeanMapper.map((Object)((Object)entity), BudgetVO.class);
    }

    @Override
    public void delete(List<BudgetVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BaseEntity::getId, ids);
        List list = this.list((Wrapper)wrapper);
        for (BudgetEntity entity : list) {
            if (entity.getUseId() == null) continue;
            throw new BusinessException("\u5355\u636e\u7f16\u53f7\u4e3a" + entity.getBillCode() + "\u7684\u9884\u7b97\u4e66\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.budgetSubService.delSubBatchByBudgetId(ids);
        this.budgetMeasureService.delMeasureBatchByBudgetId(ids);
        this.budgetOtherService.delOtherBatchByBudgetId(ids);
        this.budgetFeeService.delFeeBatchByBudgetId(ids);
        this.budgetCostService.delCostBatchByBudgetId(ids);
        this.budgetDetailService.delDetailBatchByBudgetId(ids);
        super.removeByIds(ids, true);
    }

    @Override
    public CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("budgetId"))) {
            return CommonResponse.error((String)"\u9884\u7b97\u4e66\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        budgetId = Long.valueOf(request.getParameter("budgetId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetCostVO> detailVoList = new ArrayList<BudgetCostVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                if (datas.size() < 15) {
                    return CommonResponse.error((String)"\u6587\u4ef6\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
                }
                BudgetCostVO vo = new BudgetCostVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String costUnit = datas.get(3);
                String costNum = datas.get(4);
                String costTaxRate = datas.get(5);
                String costPrice = datas.get(6);
                String costTaxPrice = datas.get(7);
                String costMny = datas.get(8);
                String costTaxMny = datas.get(9);
                String costTax = datas.get(10);
                String additionTaxRate = datas.get(11);
                String additionTaxPrice = datas.get(12);
                String additionTaxMny = datas.get(13);
                String costMemo = datas.get(14);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setCostCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setCostCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setCostName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setCostName(costName);
                }
                vo.setCostUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setCostNum(null);
                } else {
                    try {
                        vo.setCostNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setCostNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxRate)) {
                    vo.setCostTaxRate(null);
                } else {
                    try {
                        vo.setCostTaxRate(new BigDecimal(costTaxRate));
                    }
                    catch (Exception e) {
                        vo.setCostTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setCostPrice(null);
                } else {
                    try {
                        vo.setCostPrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setCostPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxPrice)) {
                    vo.setCostTaxPrice(null);
                } else {
                    try {
                        vo.setCostTaxPrice(new BigDecimal(costTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setCostTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setCostMny(null);
                } else {
                    try {
                        vo.setCostMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setCostMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxMny)) {
                    vo.setCostTaxMny(null);
                } else {
                    try {
                        vo.setCostTaxMny(new BigDecimal(costTaxMny));
                    }
                    catch (Exception e) {
                        vo.setCostTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTax)) {
                    vo.setCostTax(null);
                } else {
                    try {
                        vo.setCostTax(new BigDecimal(costTax));
                    }
                    catch (Exception e) {
                        vo.setCostTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setCostAdditionalTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setCostAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setCostAdditionalTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setCostAdditionalTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setCostAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setCostAdditionalTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setCostAdditionalTaxMny(null);
                    warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setCostAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setCostAdditionalTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setCostMemo(costMemo);
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BudgetCostVO> successList = new ArrayList<BudgetCostVO>();
            ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
            for (BudgetCostVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Object leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag((Boolean)leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    if (!((Boolean)leafFlag).booleanValue()) {
                        vo.setCostNum(null);
                        vo.setCostTaxRate(null);
                        vo.setCostPrice(null);
                        vo.setCostTaxPrice(null);
                        vo.setCostMny(null);
                        vo.setCostTaxMny(null);
                        vo.setCostTax(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u8d39\u7528\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCostCode());
                errorVo.setName(vo.getCostName());
                errorVo.setUnit(vo.getCostUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            if (errorList.size() == 0) {
                new TaxCalculateUtil().calculate(successList);
                List budgetCostVOS = TreeNodeBUtil.buildTree(successList);
                new UpSumUtil().upSum(budgetCostVOS, "costMny", "costTaxMny", "costTax", "costAdditionalTaxMny");
                BigDecimal budgetMny = BigDecimal.ZERO;
                BigDecimal budgetTaxMny = BigDecimal.ZERO;
                for (BudgetCostVO bv : budgetCostVOS) {
                    budgetMny = MathUtil.safeAdd(budgetMny, bv.getCostMny());
                    budgetTaxMny = MathUtil.safeAdd(budgetTaxMny, bv.getCostTaxMny());
                }
                List budgetCostVOS1 = new UpSumUtil().treeToList(budgetCostVOS);
                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", (Object)budgetCostVOS1.size());
                resp.put("errorNum", (Object)0);
                this.budgetCostService.delCostByBudgetId(budgetId);
                List budgetCostEntities = BeanMapper.mapList(budgetCostVOS1, BudgetCostEntity.class);
                this.budgetCostService.saveOrUpdateBatch(budgetCostEntities, budgetCostEntities.size(), false);
                LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
                lambd.set(BudgetEntity::getBudgetMny, (Object)budgetMny);
                lambd.set(BudgetEntity::getBudgetTaxMny, (Object)budgetTaxMny);
                lambd.eq(BaseEntity::getId, (Object)budgetId);
                super.update((Wrapper)lambd);
            } else {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            }
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("budgetId"))) {
            return CommonResponse.error((String)"\u9884\u7b97\u4e66\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        budgetId = Long.valueOf(request.getParameter("budgetId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size == null || size != 4) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result0 = resList.get(0);
        if (result0.size() > 0 && result0.get(0).size() < 16) {
            return CommonResponse.error((String)"[\u5206\u90e8\u5206\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result1 = resList.get(1);
        if (result1.size() > 0 && result1.get(0).size() < 16) {
            return CommonResponse.error((String)"[\u63aa\u65bd\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result2 = resList.get(2);
        if (result2.size() > 0 && result2.get(0).size() < 16) {
            return CommonResponse.error((String)"[\u5176\u5b83\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result3 = resList.get(3);
        if (result3.size() > 0 && result3.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u8d39\u7a0e\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ImportVo importVo0 = this.excelImportSub(result0, budgetId);
        ImportVo importVo1 = this.excelImportMeasure(result1, budgetId);
        ImportVo importVo2 = this.excelImportOther(result2, budgetId);
        ImportVo importVo3 = this.excelImportFee(result3, budgetId);
        ArrayList errorList = new ArrayList();
        errorList.addAll(importVo0.getErrorList());
        errorList.addAll(importVo1.getErrorList());
        errorList.addAll(importVo2.getErrorList());
        errorList.addAll(importVo3.getErrorList());
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            List subList = importVo0.getSubList();
            new TaxCalculateUtil().calculate((Collection)subList);
            List subVOS = TreeNodeBUtil.buildTree((List)subList);
            new UpSumUtil().upSum(subVOS, "subMny", "subTaxMny", "subTax", "subAdditionalTaxMny");
            BigDecimal subTotalMny = BigDecimal.ZERO;
            BigDecimal subTotalTaxMny = BigDecimal.ZERO;
            for (BudgetSubVO bv : subVOS) {
                subTotalMny = MathUtil.safeAdd(subTotalMny, bv.getSubMny());
                subTotalTaxMny = MathUtil.safeAdd(subTotalTaxMny, bv.getSubTaxMny());
            }
            List budgetSubVOS = new UpSumUtil().treeToList(subVOS);
            List measureList = importVo1.getMeasureList();
            new TaxCalculateUtil().calculate((Collection)measureList);
            List measureVOS = TreeNodeBUtil.buildTree((List)measureList);
            new UpSumUtil().upSum(measureVOS, "measureMny", "measureTaxMny", "measureTax", "measureAdditionalTaxMny");
            BigDecimal measureTotalMny = BigDecimal.ZERO;
            BigDecimal measureTotalTaxMny = BigDecimal.ZERO;
            for (BudgetMeasureVO bv : measureVOS) {
                measureTotalMny = MathUtil.safeAdd(measureTotalMny, bv.getMeasureMny());
                measureTotalTaxMny = MathUtil.safeAdd(measureTotalTaxMny, bv.getMeasureTaxMny());
            }
            List budgetMeasureVOS = new UpSumUtil().treeToList(measureVOS);
            List otherList = importVo2.getOtherList();
            new TaxCalculateUtil().calculate((Collection)otherList);
            List otherVOS = TreeNodeBUtil.buildTree((List)otherList);
            new UpSumUtil().upSum(otherVOS, "otherMny", "otherTaxMny", "otherTax", "otherAdditionalTaxMny");
            BigDecimal otherTotalMny = BigDecimal.ZERO;
            BigDecimal otherTotalTaxMny = BigDecimal.ZERO;
            for (BudgetOtherVO bv : otherVOS) {
                otherTotalMny = MathUtil.safeAdd(otherTotalMny, bv.getOtherMny());
                otherTotalTaxMny = MathUtil.safeAdd(otherTotalTaxMny, bv.getOtherTaxMny());
            }
            List budgetOtherVOS = new UpSumUtil().treeToList(otherVOS);
            List feeList = importVo3.getFeeList();
            new TaxCalculateUtil().calculate((Collection)feeList);
            List feeVOS = TreeNodeBUtil.buildTree((List)feeList);
            new UpSumUtil().upSum(feeVOS, "feeMny", "feeTaxMny", "feeTax", "feeAdditionalTaxMny");
            BigDecimal feeTotalMny = BigDecimal.ZERO;
            BigDecimal feeTotalTaxMny = BigDecimal.ZERO;
            for (BudgetFeeVO bv : feeVOS) {
                feeTotalMny = MathUtil.safeAdd(feeTotalMny, bv.getFeeMny());
                feeTotalTaxMny = MathUtil.safeAdd(feeTotalTaxMny, bv.getFeeTaxMny());
            }
            List budgetFeeVOS = new UpSumUtil().treeToList(feeVOS);
            resp.put("successList", null);
            resp.put("errorList", null);
            resp.put("successNum", (Object)(budgetSubVOS.size() + budgetMeasureVOS.size() + budgetOtherVOS.size() + budgetFeeVOS.size()));
            resp.put("errorNum", (Object)0);
            this.budgetDetailService.delDetailByBudgetId(budgetId);
            this.budgetSubService.delSubByBudgetId(budgetId);
            if (budgetSubVOS.size() > 0) {
                List budgetSubEntities = BeanMapper.mapList(budgetSubVOS, BudgetSubEntity.class);
                this.budgetSubService.saveOrUpdateBatch(budgetSubEntities, budgetSubEntities.size(), false);
            }
            this.budgetMeasureService.delMeasureByBudgetId(budgetId);
            if (budgetMeasureVOS.size() > 0) {
                List budgetMeasureEntities = BeanMapper.mapList(budgetMeasureVOS, BudgetMeasureEntity.class);
                this.budgetMeasureService.saveOrUpdateBatch(budgetMeasureEntities, budgetMeasureEntities.size(), false);
            }
            this.budgetOtherService.delOtherByBudgetId(budgetId);
            if (budgetOtherVOS.size() > 0) {
                List budgetOtherEntities = BeanMapper.mapList(budgetOtherVOS, BudgetOtherEntity.class);
                this.budgetOtherService.saveOrUpdateBatch(budgetOtherEntities, budgetOtherEntities.size(), false);
            }
            this.budgetFeeService.delFeeByBudgetId(budgetId);
            if (budgetFeeVOS.size() > 0) {
                List budgetFeeEntities = BeanMapper.mapList(budgetFeeVOS, BudgetFeeEntity.class);
                this.budgetFeeService.saveOrUpdateBatch(budgetFeeEntities, budgetFeeEntities.size(), false);
            }
            BigDecimal budgetMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalMny, measureTotalMny), MathUtil.safeAdd(otherTotalMny, feeTotalMny));
            BigDecimal budgetTaxMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTaxMny, measureTotalTaxMny), MathUtil.safeAdd(otherTotalTaxMny, feeTotalTaxMny));
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(BudgetEntity::getSubTotalMny, (Object)subTotalMny);
            lambd.set(BudgetEntity::getSubTotalTaxMny, (Object)subTotalTaxMny);
            lambd.set(BudgetEntity::getMeasureTotalMny, (Object)measureTotalMny);
            lambd.set(BudgetEntity::getMeasureTotalTaxMny, (Object)measureTotalTaxMny);
            lambd.set(BudgetEntity::getOtherTotalMny, (Object)otherTotalMny);
            lambd.set(BudgetEntity::getOtherTotalTaxMny, (Object)otherTotalTaxMny);
            lambd.set(BudgetEntity::getFeeTotalMny, (Object)feeTotalMny);
            lambd.set(BudgetEntity::getFeeTotalTaxMny, (Object)feeTotalTaxMny);
            lambd.set(BudgetEntity::getBudgetMny, (Object)budgetMny);
            lambd.set(BudgetEntity::getBudgetTaxMny, (Object)budgetTaxMny);
            lambd.eq(BaseEntity::getId, (Object)budgetId);
            super.update((Wrapper)lambd);
        }
        return CommonResponse.success((Object)resp);
    }

    private ImportVo excelImportSub(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetSubVO> detailVoList = new ArrayList<BudgetSubVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetSubVO vo = new BudgetSubVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String additionTaxRate = datas.get(12);
                String additionTaxPrice = datas.get(13);
                String additionTaxMny = datas.get(14);
                String costMemo = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setSubCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSubCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setSubName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setSubName(costName);
                }
                vo.setSubFeature(feeFeature);
                vo.setSubUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setSubNum(null);
                } else {
                    try {
                        vo.setSubNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setSubNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxRate)) {
                    vo.setSubTaxRate(null);
                } else {
                    try {
                        vo.setSubTaxRate(new BigDecimal(costTaxRate));
                    }
                    catch (Exception e) {
                        vo.setSubTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setSubPrice(null);
                } else {
                    try {
                        vo.setSubPrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setSubPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxPrice)) {
                    vo.setSubTaxPrice(null);
                } else {
                    try {
                        vo.setSubTaxPrice(new BigDecimal(costTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSubTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setSubMny(null);
                } else {
                    try {
                        vo.setSubMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setSubMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxMny)) {
                    vo.setSubTaxMny(null);
                } else {
                    try {
                        vo.setSubTaxMny(new BigDecimal(costTaxMny));
                    }
                    catch (Exception e) {
                        vo.setSubTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTax)) {
                    vo.setSubTax(null);
                } else {
                    try {
                        vo.setSubTax(new BigDecimal(costTax));
                    }
                    catch (Exception e) {
                        vo.setSubTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setSubAdditionalTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setSubAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setSubAdditionalTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setSubAdditionalTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setSubAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setSubAdditionalTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setSubAdditionalTaxMny(null);
                    warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setSubAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setSubAdditionalTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setSubMemo(costMemo);
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BudgetSubVO> successList = new ArrayList<BudgetSubVO>();
            for (BudgetSubVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    if (!leafFlag.booleanValue()) {
                        vo.setSubNum(null);
                        vo.setSubTaxRate(null);
                        vo.setSubPrice(null);
                        vo.setSubTaxPrice(null);
                        vo.setSubMny(null);
                        vo.setSubTaxMny(null);
                        vo.setSubTax(null);
                        vo.setSubAdditionalTaxMny(null);
                        vo.setSubAdditionalTaxPrice(null);
                        vo.setSubAdditionalTaxRate(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5206\u90e8\u5206\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getSubCode());
                errorVo.setName(vo.getSubName());
                errorVo.setUnit(vo.getSubUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setSubList(successList);
        }
        return res;
    }

    private ImportVo excelImportMeasure(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetMeasureVO> detailVoList = new ArrayList<BudgetMeasureVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetMeasureVO vo = new BudgetMeasureVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String additionTaxRate = datas.get(12);
                String additionTaxPrice = datas.get(13);
                String additionTaxMny = datas.get(14);
                String costMemo = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setMeasureCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMeasureCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setMeasureName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMeasureName(costName);
                }
                vo.setMeasureFeature(feeFeature);
                vo.setMeasureUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxRate)) {
                    vo.setMeasureTaxRate(null);
                } else {
                    try {
                        vo.setMeasureTaxRate(new BigDecimal(costTaxRate));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxPrice)) {
                    vo.setMeasureTaxPrice(null);
                } else {
                    try {
                        vo.setMeasureTaxPrice(new BigDecimal(costTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxMny)) {
                    vo.setMeasureTaxMny(null);
                } else {
                    try {
                        vo.setMeasureTaxMny(new BigDecimal(costTaxMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTax)) {
                    vo.setMeasureTax(null);
                } else {
                    try {
                        vo.setMeasureTax(new BigDecimal(costTax));
                    }
                    catch (Exception e) {
                        vo.setMeasureTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setMeasureAdditionalTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setMeasureAdditionalTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setMeasureAdditionalTaxMny(null);
                    warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMeasureMemo(costMemo);
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BudgetMeasureVO> successList = new ArrayList<BudgetMeasureVO>();
            for (BudgetMeasureVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    if (!leafFlag.booleanValue()) {
                        vo.setMeasureNum(null);
                        vo.setMeasureTaxRate(null);
                        vo.setMeasurePrice(null);
                        vo.setMeasureTaxPrice(null);
                        vo.setMeasureMny(null);
                        vo.setMeasureTaxMny(null);
                        vo.setMeasureTax(null);
                        vo.setMeasureAdditionalTaxMny(null);
                        vo.setMeasureAdditionalTaxPrice(null);
                        vo.setMeasureAdditionalTaxRate(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u63aa\u65bd\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMeasureCode());
                errorVo.setName(vo.getMeasureName());
                errorVo.setUnit(vo.getMeasureUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setMeasureList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetOtherVO> detailVoList = new ArrayList<BudgetOtherVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetOtherVO vo = new BudgetOtherVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String additionTaxRate = datas.get(12);
                String additionTaxPrice = datas.get(13);
                String additionTaxMny = datas.get(14);
                String costMemo = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setOtherCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOtherCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setOtherName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOtherName(costName);
                }
                vo.setOtherFeature(feeFeature);
                vo.setOtherUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxRate)) {
                    vo.setOtherTaxRate(null);
                } else {
                    try {
                        vo.setOtherTaxRate(new BigDecimal(costTaxRate));
                    }
                    catch (Exception e) {
                        vo.setOtherTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setOtherPrice(null);
                } else {
                    try {
                        vo.setOtherPrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxPrice)) {
                    vo.setOtherTaxPrice(null);
                } else {
                    try {
                        vo.setOtherTaxPrice(new BigDecimal(costTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxMny)) {
                    vo.setOtherTaxMny(null);
                } else {
                    try {
                        vo.setOtherTaxMny(new BigDecimal(costTaxMny));
                    }
                    catch (Exception e) {
                        vo.setOtherTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTax)) {
                    vo.setOtherTax(null);
                } else {
                    try {
                        vo.setOtherTax(new BigDecimal(costTax));
                    }
                    catch (Exception e) {
                        vo.setOtherTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setOtherAdditionalTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setOtherAdditionalTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setOtherAdditionalTaxMny(null);
                    warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setOtherMemo(costMemo);
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BudgetOtherVO> successList = new ArrayList<BudgetOtherVO>();
            for (BudgetOtherVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    if (!leafFlag.booleanValue()) {
                        vo.setOtherNum(null);
                        vo.setOtherTaxRate(null);
                        vo.setOtherPrice(null);
                        vo.setOtherTaxPrice(null);
                        vo.setOtherMny(null);
                        vo.setOtherTaxMny(null);
                        vo.setOtherTax(null);
                        vo.setOtherAdditionalTaxMny(null);
                        vo.setOtherAdditionalTaxPrice(null);
                        vo.setOtherAdditionalTaxRate(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u5b83\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getOtherCode());
                errorVo.setName(vo.getOtherName());
                errorVo.setUnit(vo.getOtherUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportFee(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetFeeVO> detailVoList = new ArrayList<BudgetFeeVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetFeeVO vo = new BudgetFeeVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costTaxRate = datas.get(4);
                String costMny = datas.get(5);
                String costTaxMny = datas.get(6);
                String costTax = datas.get(7);
                String additionTaxRate = datas.get(8);
                String additionTaxPrice = datas.get(9);
                String additionTaxMny = datas.get(10);
                String costMemo = datas.get(11);
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setFeeCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setFeeCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setFeeName(null);
                    warnType = warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setFeeName(costName);
                }
                vo.setFeeFeature(feeFeature);
                if (StringUtils.isEmpty((CharSequence)costTaxRate)) {
                    vo.setFeeTaxRate(null);
                } else {
                    try {
                        vo.setFeeTaxRate(new BigDecimal(costTaxRate));
                    }
                    catch (Exception e) {
                        vo.setFeeTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387(%)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setFeeMny(null);
                } else {
                    try {
                        vo.setFeeMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setFeeMny(null);
                        warnType = warnType + "[\u91d1\u989d(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTaxMny)) {
                    vo.setFeeTaxMny(null);
                } else {
                    try {
                        vo.setFeeTaxMny(new BigDecimal(costTaxMny));
                    }
                    catch (Exception e) {
                        vo.setFeeTaxMny(null);
                        warnType = warnType + "[\u91d1\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costTax)) {
                    vo.setFeeTax(null);
                } else {
                    try {
                        vo.setFeeTax(new BigDecimal(costTax));
                    }
                    catch (Exception e) {
                        vo.setFeeTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setFeeAdditionalTaxRate(null);
                    warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setFeeAdditionalTaxPrice(null);
                    warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setFeeAdditionalTaxMny(null);
                    warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setFeeMemo(costMemo);
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            ArrayList<BudgetFeeVO> successList = new ArrayList<BudgetFeeVO>();
            for (BudgetFeeVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    if (!leafFlag.booleanValue()) {
                        vo.setFeeTaxRate(null);
                        vo.setFeeMny(null);
                        vo.setFeeTaxMny(null);
                        vo.setFeeTax(null);
                        vo.setFeeAdditionalTaxMny(null);
                        vo.setFeeAdditionalTaxPrice(null);
                        vo.setFeeAdditionalTaxRate(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u8d39\u7a0e\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getFeeCode());
                errorVo.setName(vo.getFeeName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setFeeList(successList);
        }
        return res;
    }

    private void detailInfo(BudgetVO saveorUpdateVO, Long budgetId) {
        ArrayList<Object> saveOrUpldates = new ArrayList<Object>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        HashMap<String, Long> detailIdMap = new HashMap<String, Long>();
        List detailsVos = saveorUpdateVO.getSubVos();
        ArrayList<BudgetSubEntity> saveOrUpldates1 = new ArrayList<BudgetSubEntity>();
        ArrayList<Long> deleteIds1 = new ArrayList<Long>();
        for (BudgetSubVO detailsVo : detailsVos) {
            BudgetSubEntity details;
            if ("add".equals(detailsVo.getRowState())) {
                details = (BudgetSubEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetSubEntity.class));
                details.setBudgetId(budgetId);
                saveOrUpldates1.add(details);
                List budgetDetailEntities = BeanMapper.mapList((Iterable)detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (Object bde : budgetDetailEntities) {
                    ((BudgetDetailEntity)((Object)bde)).setBudgetId(budgetId);
                    ((BudgetDetailEntity)((Object)bde)).setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                Object bde;
                details = (BudgetSubEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetSubEntity.class));
                saveOrUpldates1.add(details);
                List detailVOList = detailsVo.getDetailVos();
                if (detailVOList == null || detailVOList.size() <= 0) continue;
                List budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                bde = budgetDetailEntities.iterator();
                while (bde.hasNext()) {
                    BudgetDetailEntity bde2 = (BudgetDetailEntity)((Object)bde.next());
                    if ("del".equals(bde2.getRowState())) {
                        deleteIds.add(bde2.getId());
                        continue;
                    }
                    bde2.setBudgetId(budgetId);
                    bde2.setBudgetBid(details.getId());
                    bde2.setTbid(details.getTid());
                    saveOrUpldates.add((Object)bde2);
                }
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds1.add(detailsVo.getId());
            List budgetDetailVos = detailsVo.getDetailVos();
            for (BudgetDetailVO bdv : budgetDetailVos) {
                if (bdv.getId() == null || bdv.getId() <= 0L) continue;
                deleteIds.add(bdv.getId());
            }
        }
        if (saveOrUpldates1.size() > 0) {
            this.budgetSubService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
            for (BudgetSubEntity cdEntity : saveOrUpldates1) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetSubEntity cdEntity : saveOrUpldates1) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.budgetSubService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
        }
        if (deleteIds1.size() > 0) {
            this.budgetSubService.removeByIds(deleteIds1, false);
        }
        List measureVos = saveorUpdateVO.getMeasureVos();
        ArrayList<BudgetMeasureEntity> saveOrUpldates2 = new ArrayList<BudgetMeasureEntity>();
        ArrayList<Long> deleteIds2 = new ArrayList<Long>();
        for (BudgetMeasureVO detailsVo : measureVos) {
            BudgetMeasureEntity details;
            if ("add".equals(detailsVo.getRowState())) {
                details = (BudgetMeasureEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetMeasureEntity.class));
                details.setBudgetId(budgetId);
                saveOrUpldates2.add(details);
                List budgetDetailEntities = BeanMapper.mapList((Iterable)detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (Object bde : budgetDetailEntities) {
                    ((BudgetDetailEntity)((Object)bde)).setBudgetId(budgetId);
                    ((BudgetDetailEntity)((Object)bde)).setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                Object bde;
                details = (BudgetMeasureEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetMeasureEntity.class));
                saveOrUpldates2.add(details);
                List detailVOList = detailsVo.getDetailVos();
                if (detailVOList == null || detailVOList.size() <= 0) continue;
                List budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                bde = budgetDetailEntities.iterator();
                while (bde.hasNext()) {
                    BudgetDetailEntity bde3 = (BudgetDetailEntity)((Object)bde.next());
                    if ("del".equals(bde3.getRowState())) {
                        deleteIds.add(bde3.getId());
                        continue;
                    }
                    bde3.setBudgetId(budgetId);
                    bde3.setBudgetBid(details.getId());
                    bde3.setTbid(details.getTid());
                    saveOrUpldates.add((Object)bde3);
                }
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds2.add(detailsVo.getId());
            List budgetDetailVos = detailsVo.getDetailVos();
            for (BudgetDetailVO bdv : budgetDetailVos) {
                if (bdv.getId() == null || bdv.getId() <= 0L) continue;
                deleteIds.add(bdv.getId());
            }
        }
        if (saveOrUpldates2.size() > 0) {
            this.budgetMeasureService.saveOrUpdateBatch(saveOrUpldates2, saveOrUpldates2.size(), false);
            for (BudgetMeasureEntity cdEntity : saveOrUpldates2) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetMeasureEntity cdEntity : saveOrUpldates2) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.budgetMeasureService.saveOrUpdateBatch(saveOrUpldates2, saveOrUpldates2.size(), false);
        }
        if (deleteIds2.size() > 0) {
            this.budgetMeasureService.removeByIds(deleteIds2, false);
        }
        List otherVos = saveorUpdateVO.getOtherVos();
        ArrayList<BudgetOtherEntity> saveOrUpldates3 = new ArrayList<BudgetOtherEntity>();
        ArrayList<Long> deleteIds3 = new ArrayList<Long>();
        for (BudgetOtherVO detailsVo : otherVos) {
            BudgetOtherEntity details;
            if ("add".equals(detailsVo.getRowState())) {
                details = (BudgetOtherEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetOtherEntity.class));
                details.setBudgetId(budgetId);
                saveOrUpldates3.add(details);
                List budgetDetailEntities = BeanMapper.mapList((Iterable)detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (Object bde : budgetDetailEntities) {
                    ((BudgetDetailEntity)((Object)bde)).setBudgetId(budgetId);
                    ((BudgetDetailEntity)((Object)bde)).setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                Object bde;
                details = (BudgetOtherEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetOtherEntity.class));
                saveOrUpldates3.add(details);
                List detailVOList = detailsVo.getDetailVos();
                if (detailVOList == null || detailVOList.size() <= 0) continue;
                List list = BeanMapper.mapList((Iterable)detailVOList, BudgetDetailEntity.class);
                bde = list.iterator();
                while (bde.hasNext()) {
                    BudgetDetailEntity bde4 = (BudgetDetailEntity)((Object)bde.next());
                    if ("del".equals(bde4.getRowState())) {
                        deleteIds.add(bde4.getId());
                        continue;
                    }
                    bde4.setBudgetId(budgetId);
                    bde4.setBudgetBid(details.getId());
                    bde4.setTbid(details.getTid());
                    saveOrUpldates.add((Object)bde4);
                }
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds3.add(detailsVo.getId());
            List budgetDetailVos = detailsVo.getDetailVos();
            for (BudgetDetailVO budgetDetailVO : budgetDetailVos) {
                if (budgetDetailVO.getId() == null || budgetDetailVO.getId() <= 0L) continue;
                deleteIds.add(budgetDetailVO.getId());
            }
        }
        if (saveOrUpldates3.size() > 0) {
            this.budgetOtherService.saveOrUpdateBatch(saveOrUpldates3, saveOrUpldates3.size(), false);
            for (BudgetOtherEntity cdEntity : saveOrUpldates3) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetOtherEntity cdEntity : saveOrUpldates3) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.budgetOtherService.saveOrUpdateBatch(saveOrUpldates3, saveOrUpldates3.size(), false);
        }
        if (deleteIds3.size() > 0) {
            this.budgetOtherService.removeByIds(deleteIds3, false);
        }
        List feeVos = saveorUpdateVO.getFeeVos();
        ArrayList<BudgetFeeEntity> saveOrUpldates4 = new ArrayList<BudgetFeeEntity>();
        ArrayList<Long> deleteIds4 = new ArrayList<Long>();
        for (BudgetFeeVO budgetFeeVO : feeVos) {
            BudgetFeeEntity details;
            if ("add".equals(budgetFeeVO.getRowState())) {
                details = (BudgetFeeEntity)((Object)BeanMapper.map((Object)budgetFeeVO, BudgetFeeEntity.class));
                details.setBudgetId(budgetId);
                saveOrUpldates4.add(details);
                List budgetDetailEntities = BeanMapper.mapList((Iterable)budgetFeeVO.getDetailVos(), BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    bde.setBudgetId(budgetId);
                    saveOrUpldates.add((Object)bde);
                }
                continue;
            }
            if ("edit".equals(budgetFeeVO.getRowState())) {
                details = (BudgetFeeEntity)((Object)BeanMapper.map((Object)budgetFeeVO, BudgetFeeEntity.class));
                saveOrUpldates4.add(details);
                List detailVOList = budgetFeeVO.getDetailVos();
                if (detailVOList == null || detailVOList.size() <= 0) continue;
                List budgetDetailEntities = BeanMapper.mapList((Iterable)detailVOList, BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    if ("del".equals(bde.getRowState())) {
                        deleteIds.add(bde.getId());
                        continue;
                    }
                    bde.setBudgetId(budgetId);
                    bde.setBudgetBid(details.getId());
                    bde.setTbid(details.getTid());
                    saveOrUpldates.add((Object)bde);
                }
                continue;
            }
            if (!"del".equals(budgetFeeVO.getRowState())) continue;
            deleteIds4.add(budgetFeeVO.getId());
            List budgetDetailVos = budgetFeeVO.getDetailVos();
            for (BudgetDetailVO bdv : budgetDetailVos) {
                if (bdv.getId() == null || bdv.getId() <= 0L) continue;
                deleteIds.add(bdv.getId());
            }
        }
        if (saveOrUpldates4.size() > 0) {
            this.budgetFeeService.saveOrUpdateBatch(saveOrUpldates4, saveOrUpldates4.size(), false);
            for (BudgetFeeEntity budgetFeeEntity : saveOrUpldates4) {
                idMap.put(budgetFeeEntity.getTid(), budgetFeeEntity.getId());
            }
            for (BudgetFeeEntity budgetFeeEntity : saveOrUpldates4) {
                if (!StringUtils.isNotEmpty((CharSequence)budgetFeeEntity.getTpid())) continue;
                budgetFeeEntity.setParentId((Long)idMap.get(budgetFeeEntity.getTpid()));
            }
            this.budgetFeeService.saveOrUpdateBatch(saveOrUpldates4, saveOrUpldates4.size(), false);
        }
        if (deleteIds4.size() > 0) {
            this.budgetFeeService.removeByIds(deleteIds4, false);
        }
        if (saveOrUpldates.size() > 0) {
            for (BudgetDetailEntity budgetDetailEntity : saveOrUpldates) {
                budgetDetailEntity.setBudgetBid((Long)idMap.get(budgetDetailEntity.getTbid()));
            }
            this.budgetDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            for (BudgetDetailEntity budgetDetailEntity : saveOrUpldates) {
                detailIdMap.put(budgetDetailEntity.getTid(), budgetDetailEntity.getId());
            }
            for (BudgetDetailEntity budgetDetailEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)budgetDetailEntity.getTpid())) continue;
                budgetDetailEntity.setParentId((Long)detailIdMap.get(budgetDetailEntity.getTpid()));
            }
            this.budgetDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.budgetDetailService.removeByIds(deleteIds, false);
        }
    }

    private void detailCost(BudgetVO saveorUpdateVO, Long budgetId) {
        List costVos = saveorUpdateVO.getCostVos();
        ArrayList<BudgetCostEntity> saveOrUpldates1 = new ArrayList<BudgetCostEntity>();
        ArrayList<Long> deleteIds1 = new ArrayList<Long>();
        for (BudgetCostVO detailsVo : costVos) {
            BudgetCostEntity details;
            if ("add".equals(detailsVo.getRowState())) {
                details = (BudgetCostEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetCostEntity.class));
                details.setBudgetId(budgetId);
                saveOrUpldates1.add(details);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                details = (BudgetCostEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetCostEntity.class));
                saveOrUpldates1.add(details);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds1.add(detailsVo.getId());
        }
        if (saveOrUpldates1.size() > 0) {
            this.budgetCostService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetCostEntity cdEntity : saveOrUpldates1) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetCostEntity cdEntity : saveOrUpldates1) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.budgetCostService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
        }
        if (deleteIds1.size() > 0) {
            this.budgetCostService.removeByIds(deleteIds1, false);
        }
    }

    private ImportVo excelImportZzyj(List<List<String>> result, BudgetEntity entity) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetDetailVO> detailVoList = new ArrayList<BudgetDetailVO>();
            ArrayList<String> subjectList = new ArrayList<String>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetDetailVO detailVO = new BudgetDetailVO();
                boolean flag = false;
                Object warnType = "";
                String indexCode = datas.get(0);
                Pattern pattern = Pattern.compile("(-?\\d+\\.?\\d*)[Ee]{1}[\\+-]?[0-9]*");
                boolean isMache = pattern.matcher(indexCode.trim()).matches();
                if (isMache) {
                    indexCode = new BigDecimal(indexCode).toPlainString();
                }
                String code = datas.get(1);
                String name = datas.get(2);
                String feature = datas.get(3);
                String unit = datas.get(4);
                String num = datas.get(5);
                String price = datas.get(6);
                String mny = datas.get(7);
                String additionTaxRate = datas.get(8);
                String additionTaxPrice = datas.get(9);
                String additionTaxMny = datas.get(10);
                String str = datas.get(11);
                if (StringUtils.isNotEmpty((CharSequence)str)) {
                    String subject;
                    int index = 0;
                    for (int j = 0; j < str.length(); ++j) {
                        if (Character.isDigit(str.charAt(j))) continue;
                        index = j;
                        break;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(subject = str.substring(index).trim()))) {
                        detailVO.setDetailSubjectName(subject);
                    }
                }
                Long id = IdWorker.getId();
                detailVO.setId(id);
                detailVO.setBudgetId(entity.getId());
                if (StringUtils.isEmpty((CharSequence)code)) {
                    detailVO.setDetailCode(null);
                    warnType = (String)warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if (SubjectEnum.\u589e\u503c\u7a0e.getSubjectCode().equals(code)) continue;
                    if (SubjectEnum.getCodeList().contains(code)) {
                        detailVO.setDetailSubjectName(SubjectEnum.getNameByCode((String)code));
                    }
                    detailVO.setDetailCode(code);
                }
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    detailVO.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    detailVO.setNodeLevel(Integer.valueOf(split.length));
                    if (split.length > 1) {
                        detailVO.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    detailVO.setDetailIndex(i + "");
                    if (split.length > 3) {
                        warnType = (String)warnType + "[\u5e8f\u53f7\u53ea\u652f\u6301\u4e09\u7ea7\u7ed3\u6784]";
                        flag = true;
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = (String)warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    detailVO.setIndexCode(null);
                    warnType = (String)warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                    detailVO.setNodeLevel(Integer.valueOf(0));
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    detailVO.setDetailName(null);
                    warnType = (String)warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    detailVO.setDetailName(name);
                }
                detailVO.setDetailSpec(feature);
                detailVO.setDetailUnit(unit);
                if (StringUtils.isEmpty((CharSequence)num)) {
                    detailVO.setDetailNum(null);
                    if (detailVO.getNodeLevel() == 1) {
                        warnType = (String)warnType + "[\u4e00\u7ea7\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a]";
                        flag = true;
                    }
                } else {
                    try {
                        detailVO.setDetailNum(new BigDecimal(num));
                    }
                    catch (Exception e) {
                        detailVO.setDetailNum(null);
                        warnType = (String)warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    detailVO.setDetailPrice(BigDecimal.ZERO);
                } else {
                    try {
                        detailVO.setDetailPrice(new BigDecimal(price));
                    }
                    catch (Exception e) {
                        detailVO.setDetailPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    detailVO.setDetailMny(BigDecimal.ZERO);
                } else {
                    try {
                        detailVO.setDetailMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        detailVO.setDetailMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    detailVO.setDetailAdditionalTaxRate(null);
                    warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        detailVO.setDetailAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        detailVO.setDetailAdditionalTaxRate(null);
                        warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    detailVO.setDetailAdditionalTaxPrice(null);
                    warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        detailVO.setDetailAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        detailVO.setDetailAdditionalTaxPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    detailVO.setDetailAdditionalTaxMny(null);
                    warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        detailVO.setDetailAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        detailVO.setDetailAdditionalTaxMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                detailVO.setImportFlag(Boolean.valueOf(!flag));
                detailVO.setWarnType((String)warnType);
                detailVoList.add(detailVO);
                if (!StringUtils.isNotEmpty((CharSequence)detailVO.getDetailSubjectName())) continue;
                subjectList.add(detailVO.getDetailSubjectName());
            }
            HashMap<String, Long> subjectMap = new HashMap<String, Long>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter("in", subjectList));
                CommonResponse commonResponse = this.subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List data = (List)commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("\u6210\u672c\u79d1\u76ee\u67e5\u8be2\u5931\u8d25!");
                }
            }
            ArrayList<BudgetDetailVO> successList = new ArrayList<BudgetDetailVO>();
            this.logger.info("\u4f20\u5165\u6570\u636e---->detailVoList:{}", (Object)JSONObject.toJSONString(detailVoList));
            for (BudgetDetailVO vo : detailVoList) {
                this.logger.info("\u4f20\u5165\u6570\u636e---->vo:{}", (Object)JSONObject.toJSONString((Object)vo));
                String indexCode = vo.getIndexCode();
                Boolean leafFlag = true;
                if (vo.getNodeLevel() != 1 && indexCode != null) {
                    for (String code : detailIndexList) {
                        String sub;
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                        leafFlag = false;
                        break;
                    }
                }
                vo.setLeafFlag(leafFlag);
                if (!parentMap.containsKey(vo.getTpid()) && vo.getNodeLevel() != 1) {
                    if (vo.getTpid() != null) {
                        vo.setWarnType(vo.getWarnType() + "[\u7f3a\u5c11\u5e8f\u53f7'" + vo.getTpid() + "'\u65e0\u6cd5\u5f62\u6210\u4e09\u7ea7\u7ed3\u6784]");
                    }
                    vo.setImportFlag(Boolean.valueOf(false));
                }
                if (leafFlag.booleanValue() && vo.getNodeLevel() != 1) {
                    if (vo.getDetailPrice() == null) {
                        vo.setWarnType(vo.getWarnType() + "[\u6e05\u5355\u660e\u7ec6\u672b\u7ea7\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a]");
                        vo.setImportFlag(Boolean.valueOf(false));
                    }
                    if (vo.getDetailMny() == null) {
                        vo.setWarnType(vo.getWarnType() + "[\u6e05\u5355\u660e\u7ec6\u672b\u7ea7\u5408\u4ef7(\u65e0\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a]");
                        vo.setImportFlag(Boolean.valueOf(false));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getDetailSubjectName())) {
                    if (subjectMap.containsKey(vo.getDetailSubjectName())) {
                        vo.setDetailSubjectId((Long)subjectMap.get(vo.getDetailSubjectName()));
                    } else {
                        vo.setDetailSubjectId(null);
                        vo.setDetailSubjectName(null);
                    }
                }
                if (!vo.getImportFlag().booleanValue()) {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("\u5206\u90e8\u5206\u9879\u6e05\u5355");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getDetailCode());
                    errorVo.setName(vo.getDetailName());
                    errorVo.setUnit(vo.getDetailUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                    continue;
                }
                vo.setParentId((Long)parentMap.get(vo.getTpid()));
                if (!leafFlag.booleanValue()) {
                    vo.setContent(null);
                    vo.setDetailNum(null);
                    vo.setDetailPrice(null);
                    vo.setDetailMny(null);
                    vo.setDetailAdditionalTaxPrice(null);
                    vo.setDetailAdditionalTaxRate(null);
                    vo.setDetailAdditionalTaxMny(null);
                } else {
                    vo.setDetailTaxRate(entity.getTaxRate());
                }
                successList.add(vo);
            }
            res.setErrorList(errorList);
            if (errorList.size() <= 0) {
                res.setDetailList(this.dealContent(successList));
            }
        }
        return res;
    }

    private ImportVo excelImportMeasure(List<List<String>> result, BudgetEntity entity) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetMeasureVO> detailVoList = new ArrayList<BudgetMeasureVO>();
            ArrayList<String> subjectList = new ArrayList<String>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetMeasureVO vo = new BudgetMeasureVO();
                boolean flag = false;
                Object warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costPrice = datas.get(6);
                String costMny = datas.get(7);
                BigDecimal costTaxRate = entity.getTaxRate();
                String additionTaxRate = datas.get(8);
                String additionTaxPrice = datas.get(9);
                String additionTaxMny = datas.get(10);
                String str = datas.get(11);
                if (StringUtils.isNotEmpty((CharSequence)str)) {
                    String subject;
                    int index = 0;
                    for (int j = 0; j < str.length(); ++j) {
                        if (Character.isDigit(str.charAt(j))) continue;
                        index = j;
                        break;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(subject = str.substring(index).trim()))) {
                        vo.setMeasureSubjectName(subject);
                    }
                }
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(entity.getId());
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = (String)warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = (String)warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setMeasureCode(null);
                    warnType = (String)warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if (SubjectEnum.\u589e\u503c\u7a0e.getSubjectCode().equals(costCode)) continue;
                    if (SubjectEnum.getCodeList().contains(costCode)) {
                        vo.setMeasureSubjectName(SubjectEnum.getNameByCode((String)costCode));
                    }
                    vo.setMeasureCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setMeasureName(null);
                    warnType = (String)warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setMeasureName(costName);
                }
                vo.setMeasureFeature(feeFeature);
                vo.setMeasureUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = (String)warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMeasureTaxRate(costTaxRate);
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setMeasureAdditionalTaxRate(null);
                    warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxRate(null);
                        warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setMeasureAdditionalTaxPrice(null);
                    warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setMeasureAdditionalTaxMny(null);
                    warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setMeasureAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setMeasureAdditionalTaxMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType((String)warnType);
                detailVoList.add(vo);
                if (!StringUtils.isNotEmpty((CharSequence)vo.getMeasureSubjectName())) continue;
                subjectList.add(vo.getMeasureSubjectName());
            }
            HashMap<String, Long> subjectMap = new HashMap<String, Long>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter("in", subjectList));
                CommonResponse commonResponse = this.subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List data = (List)commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("\u6210\u672c\u79d1\u76ee\u67e5\u8be2\u5931\u8d25!");
                }
            }
            ArrayList<BudgetMeasureVO> successList = new ArrayList<BudgetMeasureVO>();
            for (BudgetMeasureVO vo : detailVoList) {
                String indexCode = vo.getIndexCode();
                Boolean leafFlag = true;
                for (String code : detailIndexList) {
                    String sub;
                    if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                    leafFlag = false;
                    break;
                }
                vo.setLeafFlag(leafFlag);
                vo.setParentId((Long)parentMap.get(vo.getTpid()));
                if (leafFlag.booleanValue()) {
                    vo.setMeasureNum(vo.getMeasureNum() == null ? BigDecimal.ZERO : vo.getMeasureNum());
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getMeasureTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);
                    if (vo.getMeasurePrice() == null) {
                        vo.setMeasurePrice(BigDecimal.ZERO);
                    } else {
                        vo.setMeasureTaxPrice(MathUtil.safeMultiply(rate, vo.getMeasurePrice()));
                    }
                    if (vo.getMeasureMny() == null) {
                        vo.setMeasureMny(BigDecimal.ZERO);
                    } else {
                        vo.setMeasureTaxMny(MathUtil.safeMultiply(rate, vo.getMeasureMny()));
                        vo.setMeasureTax(MathUtil.safeSub(vo.getMeasureTaxMny(), vo.getMeasureMny()));
                    }
                } else {
                    vo.setMeasureNum(null);
                    vo.setMeasureTaxRate(null);
                    vo.setMeasurePrice(null);
                    vo.setMeasureTaxPrice(null);
                    vo.setMeasureMny(null);
                    vo.setMeasureTaxMny(null);
                    vo.setMeasureTax(null);
                    vo.setMeasureAdditionalTaxRate(null);
                    vo.setMeasureAdditionalTaxPrice(null);
                    vo.setMeasureAdditionalTaxMny(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getMeasureSubjectName())) {
                    if (subjectMap.containsKey(vo.getMeasureSubjectName())) {
                        vo.setMeasureSubjectId((Long)subjectMap.get(vo.getMeasureSubjectName()));
                    } else {
                        vo.setMeasureSubjectId(null);
                        vo.setMeasureSubjectName(null);
                    }
                }
                if (vo.getImportFlag().booleanValue()) {
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u63aa\u65bd\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getMeasureCode());
                errorVo.setName(vo.getMeasureName());
                errorVo.setUnit(vo.getMeasureUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setMeasureList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, BudgetEntity entity) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetOtherVO> detailVoList = new ArrayList<BudgetOtherVO>();
            ArrayList<String> subjectList = new ArrayList<String>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetOtherVO vo = new BudgetOtherVO();
                boolean flag = false;
                Object warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costPrice = datas.get(6);
                String costMny = datas.get(7);
                BigDecimal costTaxRate = entity.getTaxRate();
                String additionTaxRate = datas.get(8);
                String additionTaxPrice = datas.get(9);
                String additionTaxMny = datas.get(10);
                String str = datas.get(11);
                if (StringUtils.isNotEmpty((CharSequence)str)) {
                    String subject;
                    int index = 0;
                    for (int j = 0; j < str.length(); ++j) {
                        if (Character.isDigit(str.charAt(j))) continue;
                        index = j;
                        break;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(subject = str.substring(index).trim()))) {
                        vo.setOtherSubjectName(subject);
                    }
                }
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(entity.getId());
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = (String)warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = (String)warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setOtherCode(null);
                    warnType = (String)warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if (SubjectEnum.\u589e\u503c\u7a0e.getSubjectCode().equals(costCode)) continue;
                    if (SubjectEnum.getCodeList().contains(costCode)) {
                        vo.setOtherSubjectName(SubjectEnum.getNameByCode((String)costCode));
                    }
                    vo.setOtherCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setOtherName(null);
                    warnType = (String)warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setOtherName(costName);
                }
                vo.setOtherFeature(feeFeature);
                vo.setOtherUnit(costUnit);
                if (StringUtils.isEmpty((CharSequence)costNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(costNum));
                    }
                    catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = (String)warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setOtherTaxRate(costTaxRate);
                if (StringUtils.isEmpty((CharSequence)costPrice)) {
                    vo.setOtherPrice(null);
                } else {
                    try {
                        vo.setOtherPrice(new BigDecimal(costPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setOtherAdditionalTaxRate(null);
                    warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxRate(null);
                        warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setOtherAdditionalTaxPrice(null);
                    warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setOtherAdditionalTaxMny(null);
                    warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setOtherAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setOtherAdditionalTaxMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType((String)warnType);
                detailVoList.add(vo);
                if (!StringUtils.isNotEmpty((CharSequence)vo.getOtherSubjectName())) continue;
                subjectList.add(vo.getOtherSubjectName());
            }
            HashMap<String, Long> subjectMap = new HashMap<String, Long>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter("in", subjectList));
                CommonResponse commonResponse = this.subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List data = (List)commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("\u6210\u672c\u79d1\u76ee\u67e5\u8be2\u5931\u8d25!");
                }
            }
            ArrayList<BudgetOtherVO> successList = new ArrayList<BudgetOtherVO>();
            for (BudgetOtherVO vo : detailVoList) {
                String indexCode = vo.getIndexCode();
                Boolean leafFlag = true;
                for (String code : detailIndexList) {
                    String sub;
                    if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                    leafFlag = false;
                    break;
                }
                vo.setLeafFlag(leafFlag);
                vo.setParentId((Long)parentMap.get(vo.getTpid()));
                if (leafFlag.booleanValue()) {
                    vo.setOtherNum(vo.getOtherNum() == null ? BigDecimal.ZERO : vo.getOtherNum());
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getOtherTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);
                    if (vo.getOtherPrice() == null) {
                        vo.setOtherPrice(BigDecimal.ZERO);
                    } else {
                        vo.setOtherTaxPrice(MathUtil.safeMultiply(rate, vo.getOtherPrice()));
                    }
                    if (vo.getOtherMny() == null) {
                        vo.setOtherMny(BigDecimal.ZERO);
                    } else {
                        vo.setOtherTaxMny(MathUtil.safeMultiply(rate, vo.getOtherMny()));
                        vo.setOtherTax(MathUtil.safeSub(vo.getOtherTaxMny(), vo.getOtherMny()));
                    }
                } else {
                    vo.setOtherNum(null);
                    vo.setOtherTaxRate(null);
                    vo.setOtherPrice(null);
                    vo.setOtherTaxPrice(null);
                    vo.setOtherMny(null);
                    vo.setOtherTaxMny(null);
                    vo.setOtherTax(null);
                    vo.setOtherAdditionalTaxRate(null);
                    vo.setOtherAdditionalTaxPrice(null);
                    vo.setOtherAdditionalTaxMny(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getOtherSubjectName())) {
                    if (subjectMap.containsKey(vo.getOtherSubjectName())) {
                        vo.setOtherSubjectId((Long)subjectMap.get(vo.getOtherSubjectName()));
                    } else {
                        vo.setOtherSubjectId(null);
                        vo.setOtherSubjectName(null);
                    }
                }
                if (vo.getImportFlag().booleanValue()) {
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u5b83\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getOtherCode());
                errorVo.setName(vo.getOtherName());
                errorVo.setUnit(vo.getOtherUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportFee(List<List<String>> result, BudgetEntity entity) {
        ImportVo res = new ImportVo();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<BudgetFeeVO> detailVoList = new ArrayList<BudgetFeeVO>();
            ArrayList<String> subjectList = new ArrayList<String>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                BudgetFeeVO vo = new BudgetFeeVO();
                boolean flag = false;
                Object warnType = "";
                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costMny = datas.get(4);
                BigDecimal costTaxRate = entity.getTaxRate();
                String additionTaxRate = datas.get(5);
                String additionTaxPrice = datas.get(6);
                String additionTaxMny = datas.get(7);
                String str = datas.get(8);
                if (StringUtils.isNotEmpty((CharSequence)str)) {
                    String subject;
                    int index = 0;
                    for (int j = 0; j < str.length(); ++j) {
                        if (Character.isDigit(str.charAt(j))) continue;
                        index = j;
                        break;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(subject = str.substring(index).trim()))) {
                        vo.setFeeSubjectName(subject);
                    }
                }
                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(entity.getId());
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = (String)warnType + "[\u5e8f\u53f7\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = (String)warnType + "[\u5e8f\u53f7\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)costCode)) {
                    vo.setFeeCode(null);
                    warnType = (String)warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    if (SubjectEnum.\u589e\u503c\u7a0e.getSubjectCode().equals(costCode)) continue;
                    if (SubjectEnum.getCodeList().contains(costCode)) {
                        vo.setFeeSubjectName(SubjectEnum.getNameByCode((String)costCode));
                    }
                    vo.setFeeCode(costCode);
                }
                if (StringUtils.isEmpty((CharSequence)costName)) {
                    vo.setFeeName(null);
                    warnType = (String)warnType + "[\u8d39\u7528\u9879\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setFeeName(costName);
                }
                vo.setFeeFeature(feeFeature);
                vo.setFeeTaxRate(costTaxRate);
                if (StringUtils.isEmpty((CharSequence)costMny)) {
                    vo.setFeeMny(null);
                } else {
                    try {
                        vo.setFeeMny(new BigDecimal(costMny));
                    }
                    catch (Exception e) {
                        vo.setFeeMny(null);
                        warnType = (String)warnType + "[\u91d1\u989d(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxRate)) {
                    vo.setFeeAdditionalTaxRate(null);
                    warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxRate(new BigDecimal(additionTaxRate));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxRate(null);
                        warnType = (String)warnType + "[\u7a0e\u7387\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxPrice)) {
                    vo.setFeeAdditionalTaxPrice(null);
                    warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxPrice(new BigDecimal(additionTaxPrice));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxPrice(null);
                        warnType = (String)warnType + "[\u7efc\u5408\u5355\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)additionTaxMny)) {
                    vo.setFeeAdditionalTaxMny(null);
                    warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setFeeAdditionalTaxMny(new BigDecimal(additionTaxMny));
                    }
                    catch (Exception e) {
                        vo.setFeeAdditionalTaxMny(null);
                        warnType = (String)warnType + "[\u5408\u4ef7\uff08\u542b\u9644\u52a0\u7a0e\uff09\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType((String)warnType);
                detailVoList.add(vo);
                if (!StringUtils.isNotEmpty((CharSequence)vo.getFeeSubjectName())) continue;
                subjectList.add(vo.getFeeSubjectName());
            }
            HashMap<String, Long> subjectMap = new HashMap<String, Long>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter("in", subjectList));
                CommonResponse commonResponse = this.subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List data = (List)commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("\u6210\u672c\u79d1\u76ee\u67e5\u8be2\u5931\u8d25!");
                }
            }
            ArrayList<BudgetFeeVO> successList = new ArrayList<BudgetFeeVO>();
            for (BudgetFeeVO vo : detailVoList) {
                String indexCode = vo.getIndexCode();
                Boolean leafFlag = true;
                for (String code : detailIndexList) {
                    String sub;
                    if (!code.startsWith(indexCode) || code.equals(indexCode) || "-/.".indexOf(sub = code.substring(indexCode.length(), indexCode.length() + 1)) == -1) continue;
                    leafFlag = false;
                    break;
                }
                vo.setLeafFlag(leafFlag);
                vo.setParentId((Long)parentMap.get(vo.getTpid()));
                if (leafFlag.booleanValue()) {
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getFeeTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);
                    if (vo.getFeeMny() == null) {
                        vo.setFeeMny(BigDecimal.ZERO);
                    } else {
                        vo.setFeeTaxMny(MathUtil.safeMultiply(rate, vo.getFeeMny()));
                        vo.setFeeTax(MathUtil.safeSub(vo.getFeeTaxMny(), vo.getFeeMny()));
                    }
                } else {
                    vo.setFeeTaxRate(null);
                    vo.setFeeMny(null);
                    vo.setFeeTaxMny(null);
                    vo.setFeeTax(null);
                    vo.setFeeAdditionalTaxRate(null);
                    vo.setFeeAdditionalTaxPrice(null);
                    vo.setFeeAdditionalTaxMny(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getFeeSubjectName())) {
                    if (subjectMap.containsKey(vo.getFeeSubjectName())) {
                        vo.setFeeSubjectId((Long)subjectMap.get(vo.getFeeSubjectName()));
                    } else {
                        vo.setFeeSubjectId(null);
                        vo.setFeeSubjectName(null);
                    }
                }
                if (vo.getImportFlag().booleanValue()) {
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u8d39\u7a0e\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getFeeCode());
                errorVo.setName(vo.getFeeName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            res.setErrorList(errorList);
            res.setFeeList(successList);
        }
        return res;
    }

    private List<BudgetDetailVO> dealContent(List<BudgetDetailVO> list) {
        this.logger.info("delContent---list:{}", (Object)JSONObject.toJSONString(list));
        HashMap<String, BudgetDetailVO> map = new HashMap<String, BudgetDetailVO>();
        for (BudgetDetailVO budgetDetailVO : list) {
            map.put(budgetDetailVO.getIndexCode(), budgetDetailVO);
        }
        Boolean treeFlag = false;
        for (BudgetDetailVO budgetDetailVO : list) {
            if (treeFlag.booleanValue() || budgetDetailVO.getNodeLevel() == 1) continue;
            treeFlag = true;
        }
        for (BudgetDetailVO vo : list) {
            String[] split = vo.getIndexCode().split("[-/.]");
            BudgetDetailVO detailVO = (BudgetDetailVO)map.get(split[0]);
            vo.setBudgetBid(detailVO.getId());
            if ((vo.getNodeLevel() == 1 || !vo.getLeafFlag().booleanValue()) && treeFlag.booleanValue()) continue;
            BigDecimal taxRate = MathUtil.safeDiv(vo.getDetailTaxRate(), new BigDecimal("100"));
            BigDecimal taxPrice = MathUtil.safeAdd(MathUtil.safeMultiply(vo.getDetailPrice(), taxRate), vo.getDetailPrice());
            BigDecimal taxMny = MathUtil.safeAdd(MathUtil.safeMultiply(vo.getDetailMny(), taxRate), vo.getDetailMny());
            BigDecimal tax = MathUtil.safeSub(taxMny, vo.getDetailMny());
            vo.setDetailNum(detailVO.getDetailNum());
            vo.setDetailTaxPrice(taxPrice);
            vo.setDetailTaxMny(taxMny);
            vo.setDetailTax(tax);
        }
        List list2 = TreeNodeBUtil.buildTree(list);
        new UpSumUtil().upSum(list2, "detailMny", "detailTaxMny", "detailTax");
        List<BudgetDetailVO> budgetVOS = new UpSumUtil().treeToList(list2);
        this.logger.info("delContent---budgetVOS:{}", (Object)JSONObject.toJSONString(budgetVOS));
        return budgetVOS;
    }

    @Override
    public CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (!StringUtils.isNotEmpty((CharSequence)request.getParameter("budgetId"))) {
            return CommonResponse.error((String)"\u9884\u7b97\u4e66\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        budgetId = Long.valueOf(request.getParameter("budgetId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size == null) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result0 = resList.get(0);
        if (result0.size() > 0 && result0.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u5206\u90e8\u5206\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result1 = resList.get(1);
        if (result1.size() > 0 && result1.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u63aa\u65bd\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result2 = resList.get(2);
        if (result2.size() > 0 && result2.get(0).size() < 12) {
            return CommonResponse.error((String)"[\u5176\u5b83\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<String>> result3 = resList.get(3);
        if (result3.size() > 0 && result3.get(0).size() < 9) {
            return CommonResponse.error((String)"[\u8d39\u7a0e\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        BudgetEntity entity = (BudgetEntity)((Object)((BudgetMapper)this.baseMapper).selectById(budgetId));
        ImportVo importVo = this.excelImportZzyj(result0, entity);
        ImportVo importVo1 = this.excelImportMeasure(result1, entity);
        ImportVo importVo2 = this.excelImportOther(result2, entity);
        ImportVo importVo3 = this.excelImportFee(result3, entity);
        ArrayList errorList = new ArrayList();
        errorList.addAll(importVo.getErrorList());
        errorList.addAll(importVo1.getErrorList());
        errorList.addAll(importVo2.getErrorList());
        errorList.addAll(importVo3.getErrorList());
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            List successList = importVo.getDetailList();
            BigDecimal subTotalMny = BigDecimal.ZERO;
            BigDecimal subTotalTaxMny = BigDecimal.ZERO;
            BigDecimal subTotalTax = BigDecimal.ZERO;
            ArrayList<BudgetSubEntity> subList = new ArrayList<BudgetSubEntity>();
            ArrayList<BudgetDetailVO> detailList = new ArrayList<BudgetDetailVO>();
            for (BudgetDetailVO bv : successList) {
                if (bv.getNodeLevel() == 1) {
                    BudgetSubEntity subVo = new BudgetSubEntity();
                    subVo.setId(bv.getId());
                    subVo.setBudgetId(bv.getBudgetId());
                    subVo.setParentId(bv.getParentId());
                    subVo.setDetailIndex(bv.getDetailIndex());
                    subVo.setSubCode(bv.getDetailCode());
                    subVo.setSubName(bv.getDetailName());
                    subVo.setSubFeature(bv.getDetailSpec());
                    subVo.setSubUnit(bv.getDetailUnit());
                    subVo.setSubNum(bv.getDetailNum());
                    subVo.setSubTaxRate(bv.getDetailTaxRate());
                    subVo.setSubPrice(MathUtil.safeDiv(bv.getDetailMny(), bv.getDetailNum()));
                    subVo.setSubTaxPrice(MathUtil.safeDiv(bv.getDetailTaxMny(), bv.getDetailNum()));
                    subVo.setSubMny(bv.getDetailMny());
                    subVo.setSubTaxMny(bv.getDetailTaxMny());
                    subVo.setSubTax(bv.getDetailTax());
                    subVo.setSubMemo(bv.getDetailMemo());
                    subVo.setLeafFlag(bv.getLeafFlag());
                    subVo.setTid(bv.getTid());
                    subVo.setTpid(bv.getTpid());
                    subVo.setSubAdditionalTaxMny(bv.getDetailAdditionalTaxMny());
                    subVo.setSubAdditionalTaxPrice(bv.getDetailAdditionalTaxPrice());
                    subVo.setSubAdditionalTaxRate(bv.getDetailAdditionalTaxRate());
                    subVo.setSubSubjectId(bv.getDetailSubjectId());
                    subVo.setSubSubjectName(bv.getDetailSubjectName());
                    subList.add(subVo);
                    subTotalMny = MathUtil.safeAdd(subTotalMny, subVo.getSubMny());
                    subTotalTaxMny = MathUtil.safeAdd(subTotalTaxMny, subVo.getSubTaxMny());
                    subTotalTax = MathUtil.safeAdd(subTotalTax, subVo.getSubTax());
                    continue;
                }
                if (bv.getNodeLevel() == 2) {
                    bv.setParentId(null);
                }
                detailList.add(bv);
            }
            List measureList = importVo1.getMeasureList();
            List measureVOS = TreeNodeBUtil.buildTree((List)measureList);
            new UpSumUtil().upSum(measureVOS, "measureMny", "measureTaxMny", "measureTax", "measureAdditionalTaxMny");
            BigDecimal measureTotalMny = BigDecimal.ZERO;
            BigDecimal measureTotalTaxMny = BigDecimal.ZERO;
            BigDecimal measureTotalTax = BigDecimal.ZERO;
            for (BudgetMeasureVO bv : measureVOS) {
                measureTotalMny = MathUtil.safeAdd(measureTotalMny, bv.getMeasureMny());
                measureTotalTaxMny = MathUtil.safeAdd(measureTotalTaxMny, bv.getMeasureTaxMny());
                measureTotalTax = MathUtil.safeAdd(measureTotalTax, bv.getMeasureTax());
            }
            List budgetMeasureVOS = new UpSumUtil().treeToList(measureVOS);
            List otherList = importVo2.getOtherList();
            List otherVOS = TreeNodeBUtil.buildTree((List)otherList);
            new UpSumUtil().upSum(otherVOS, "otherMny", "otherTaxMny", "otherTax", "otherAdditionalTaxMny");
            BigDecimal otherTotalMny = BigDecimal.ZERO;
            BigDecimal otherTotalTaxMny = BigDecimal.ZERO;
            BigDecimal otherTotalTax = BigDecimal.ZERO;
            for (BudgetOtherVO bv : otherVOS) {
                otherTotalMny = MathUtil.safeAdd(otherTotalMny, bv.getOtherMny());
                otherTotalTaxMny = MathUtil.safeAdd(otherTotalTaxMny, bv.getOtherTaxMny());
                otherTotalTax = MathUtil.safeAdd(otherTotalTax, bv.getOtherTax());
            }
            List budgetOtherVOS = new UpSumUtil().treeToList(otherVOS);
            List feeList = importVo3.getFeeList();
            List feeVOS = TreeNodeBUtil.buildTree((List)feeList);
            new UpSumUtil().upSum(feeVOS, "feeMny", "feeTaxMny", "feeTax", "feeAdditionalTaxMny");
            BigDecimal feeTotalMny = BigDecimal.ZERO;
            BigDecimal feeTotalTaxMny = BigDecimal.ZERO;
            BigDecimal feeTotalTax = BigDecimal.ZERO;
            for (BudgetFeeVO bv : feeVOS) {
                feeTotalMny = MathUtil.safeAdd(feeTotalMny, bv.getFeeMny());
                feeTotalTaxMny = MathUtil.safeAdd(feeTotalTaxMny, bv.getFeeTaxMny());
                feeTotalTax = MathUtil.safeAdd(feeTotalTax, bv.getFeeTax());
            }
            List budgetFeeVOS = new UpSumUtil().treeToList(feeVOS);
            resp.put("successList", null);
            resp.put("errorList", null);
            resp.put("successNum", (Object)(successList.size() + budgetMeasureVOS.size() + budgetOtherVOS.size() + budgetFeeVOS.size()));
            resp.put("errorNum", (Object)0);
            this.budgetDetailService.delDetailByBudgetId(budgetId);
            if (detailList.size() > 0) {
                List detailEntities = BeanMapper.mapList(detailList, BudgetDetailEntity.class);
                this.budgetDetailService.saveOrUpdateBatch(detailEntities, detailEntities.size(), false);
            }
            this.budgetSubService.delSubByBudgetId(budgetId);
            if (subList.size() > 0) {
                this.budgetSubService.saveOrUpdateBatch(subList, subList.size(), false);
            }
            this.budgetMeasureService.delMeasureByBudgetId(budgetId);
            if (budgetMeasureVOS.size() > 0) {
                List budgetMeasureEntities = BeanMapper.mapList(budgetMeasureVOS, BudgetMeasureEntity.class);
                this.budgetMeasureService.saveOrUpdateBatch(budgetMeasureEntities, budgetMeasureEntities.size(), false);
            }
            this.budgetOtherService.delOtherByBudgetId(budgetId);
            if (budgetOtherVOS.size() > 0) {
                List budgetOtherEntities = BeanMapper.mapList(budgetOtherVOS, BudgetOtherEntity.class);
                this.budgetOtherService.saveOrUpdateBatch(budgetOtherEntities, budgetOtherEntities.size(), false);
            }
            this.budgetFeeService.delFeeByBudgetId(budgetId);
            if (budgetFeeVOS.size() > 0) {
                List budgetFeeEntities = BeanMapper.mapList(budgetFeeVOS, BudgetFeeEntity.class);
                this.budgetFeeService.saveOrUpdateBatch(budgetFeeEntities, budgetFeeEntities.size(), false);
            }
            BigDecimal budgetMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalMny, measureTotalMny), MathUtil.safeAdd(otherTotalMny, feeTotalMny));
            BigDecimal budgetTaxMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTaxMny, measureTotalTaxMny), MathUtil.safeAdd(otherTotalTaxMny, feeTotalTaxMny));
            BigDecimal budgetTax = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTax, measureTotalTax), MathUtil.safeAdd(otherTotalTax, feeTotalTax));
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(BudgetEntity::getSubTotalMny, (Object)subTotalMny);
            lambd.set(BudgetEntity::getSubTotalTaxMny, (Object)subTotalTaxMny);
            lambd.set(BudgetEntity::getSubTotalTax, (Object)subTotalTax);
            lambd.set(BudgetEntity::getMeasureTotalMny, (Object)measureTotalMny);
            lambd.set(BudgetEntity::getMeasureTotalTaxMny, (Object)measureTotalTaxMny);
            lambd.set(BudgetEntity::getMeasureTotalTax, (Object)measureTotalTax);
            lambd.set(BudgetEntity::getOtherTotalMny, (Object)otherTotalMny);
            lambd.set(BudgetEntity::getOtherTotalTaxMny, (Object)otherTotalTaxMny);
            lambd.set(BudgetEntity::getOtherTotalTax, (Object)otherTotalTax);
            lambd.set(BudgetEntity::getFeeTotalMny, (Object)feeTotalMny);
            lambd.set(BudgetEntity::getFeeTotalTaxMny, (Object)feeTotalTaxMny);
            lambd.set(BudgetEntity::getFeeTotalTax, (Object)feeTotalTax);
            lambd.set(BudgetEntity::getBudgetMny, (Object)budgetMny);
            lambd.set(BudgetEntity::getBudgetTaxMny, (Object)budgetTaxMny);
            lambd.set(BudgetEntity::getBudgetTax, (Object)budgetTax);
            lambd.eq(BaseEntity::getId, (Object)budgetId);
            super.update((Wrapper)lambd);
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public List<BudgetReportVO> querySumBudgetMny(Long projectId, String beginPeriod, String endDate) {
        BigDecimal num;
        BigDecimal taxMny;
        BigDecimal mny;
        BudgetReportVO reportVO;
        BaseEntity bentity;
        Long subjectId;
        List list;
        BudgetReportVO reportVO2;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(BudgetEntity::getProjectId, (Object)projectId);
        wrapper.in(BudgetEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entityList = super.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList<BudgetReportVO>();
        }
        List<Long> budegtIds = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<BudgetSubEntity> subList = this.budgetSubService.querySubByBudgetIds(budegtIds);
        List<BudgetMeasureEntity> measureList = this.budgetMeasureService.queryMeasureByBudgetIds(budegtIds);
        List<BudgetOtherEntity> otherList = this.budgetOtherService.queryOtherByBudgetIds(budegtIds);
        List<BudgetFeeEntity> feeList = this.budgetFeeService.queryFeeByBudgetIds(budegtIds);
        List<BudgetCostEntity> costList = this.budgetCostService.queryCostByBudgetIds(budegtIds);
        List<BudgetDetailEntity> detailList = this.budgetDetailService.queryDetailByBudgetIds(budegtIds);
        HashMap<Long, BudgetReportVO> resMap = new HashMap<Long, BudgetReportVO>();
        HashMap<Long, Object> subMap = new HashMap<Long, Object>();
        for (Object entity : subList) {
            Long subjectId4 = entity.getSubSubjectId();
            if (subjectId4 == null || subjectId4 <= 0L) continue;
            subMap.put(entity.getId(), entity);
            if (resMap.containsKey(subjectId4)) {
                BudgetReportVO reportVO3 = (BudgetReportVO)resMap.get(subjectId4);
                BigDecimal mny3 = MathUtil.safeAdd(reportVO3.getYsHappenMnyAll(), entity.getSubMny());
                BigDecimal bigDecimal = MathUtil.safeAdd(reportVO3.getYsHappenTaxMnyAll(), entity.getSubTaxMny());
                BigDecimal num3 = MathUtil.safeAdd(reportVO3.getYsNumAll(), entity.getSubNum());
                reportVO3.setYsHappenMnyAll(mny3);
                reportVO3.setYsHappenTaxMnyAll(bigDecimal);
                reportVO3.setYsNumAll(num3);
                resMap.put(subjectId4, reportVO3);
                continue;
            }
            BudgetReportVO reportVO3 = new BudgetReportVO();
            reportVO3.setSubjectId(subjectId4);
            reportVO3.setSubjectName(entity.getSubSubjectName());
            reportVO3.setYsHappenMnyAll(entity.getSubMny());
            reportVO3.setYsHappenTaxMnyAll(entity.getSubTaxMny());
            reportVO3.setYsNumAll(entity.getSubNum());
            resMap.put(subjectId4, reportVO3);
        }
        HashMap<Long, Object> measureMap = new HashMap<Long, Object>();
        for (Object entity : measureList) {
            Long subjectId5 = entity.getMeasureSubjectId();
            if (subjectId5 == null || subjectId5 <= 0L) continue;
            measureMap.put(entity.getId(), entity);
            if (resMap.containsKey(subjectId5)) {
                BudgetReportVO reportVO4 = (BudgetReportVO)resMap.get(subjectId5);
                BigDecimal bigDecimal = MathUtil.safeAdd(reportVO4.getYsHappenMnyAll(), entity.getMeasureMny());
                BigDecimal taxMny4 = MathUtil.safeAdd(reportVO4.getYsHappenTaxMnyAll(), entity.getMeasureTaxMny());
                BigDecimal num4 = MathUtil.safeAdd(reportVO4.getYsNumAll(), entity.getMeasureNum());
                reportVO4.setYsHappenMnyAll(bigDecimal);
                reportVO4.setYsHappenTaxMnyAll(taxMny4);
                reportVO4.setYsNumAll(num4);
                resMap.put(subjectId5, reportVO4);
                continue;
            }
            BudgetReportVO reportVO4 = new BudgetReportVO();
            reportVO4.setSubjectId(subjectId5);
            reportVO4.setSubjectName(entity.getMeasureSubjectName());
            reportVO4.setYsHappenMnyAll(entity.getMeasureMny());
            reportVO4.setYsHappenTaxMnyAll(entity.getMeasureTaxMny());
            reportVO4.setYsNumAll(entity.getMeasureNum());
            resMap.put(subjectId5, reportVO4);
        }
        HashMap<Long, Object> otherMap = new HashMap<Long, Object>();
        for (Object entity : otherList) {
            Long subjectId6 = entity.getOtherSubjectId();
            if (subjectId6 == null || subjectId6 <= 0L) continue;
            otherMap.put(entity.getId(), entity);
            if (resMap.containsKey(subjectId6)) {
                BudgetReportVO budgetReportVO = (BudgetReportVO)resMap.get(subjectId6);
                BigDecimal mny5 = MathUtil.safeAdd(budgetReportVO.getYsHappenMnyAll(), entity.getOtherMny());
                BigDecimal taxMny5 = MathUtil.safeAdd(budgetReportVO.getYsHappenTaxMnyAll(), entity.getOtherTaxMny());
                BigDecimal num5 = MathUtil.safeAdd(budgetReportVO.getYsNumAll(), entity.getOtherNum());
                budgetReportVO.setYsHappenMnyAll(mny5);
                budgetReportVO.setYsHappenTaxMnyAll(taxMny5);
                budgetReportVO.setYsNumAll(num5);
                resMap.put(subjectId6, budgetReportVO);
                continue;
            }
            BudgetReportVO budgetReportVO = new BudgetReportVO();
            budgetReportVO.setSubjectId(subjectId6);
            budgetReportVO.setSubjectName(entity.getOtherSubjectName());
            budgetReportVO.setYsHappenMnyAll(entity.getOtherMny());
            budgetReportVO.setYsHappenTaxMnyAll(entity.getOtherTaxMny());
            budgetReportVO.setYsNumAll(entity.getOtherNum());
            resMap.put(subjectId6, budgetReportVO);
        }
        HashMap<Long, Object> feeMap = new HashMap<Long, Object>();
        for (Object entity : feeList) {
            Long l = entity.getFeeSubjectId();
            if (l == null || l <= 0L) continue;
            feeMap.put(entity.getId(), entity);
            if (resMap.containsKey(l)) {
                BudgetReportVO reportVO5 = (BudgetReportVO)resMap.get(l);
                BigDecimal mny6 = MathUtil.safeAdd(reportVO5.getYsHappenMnyAll(), entity.getFeeMny());
                BigDecimal taxMny6 = MathUtil.safeAdd(reportVO5.getYsHappenTaxMnyAll(), entity.getFeeTaxMny());
                reportVO5.setYsHappenMnyAll(mny6);
                reportVO5.setYsHappenTaxMnyAll(taxMny6);
                resMap.put(l, reportVO5);
                continue;
            }
            BudgetReportVO reportVO6 = new BudgetReportVO();
            reportVO6.setSubjectId(l);
            reportVO6.setSubjectName(entity.getFeeSubjectName());
            reportVO6.setYsHappenMnyAll(entity.getFeeMny());
            reportVO6.setYsHappenTaxMnyAll(entity.getFeeTaxMny());
            resMap.put(l, reportVO6);
        }
        HashMap<Long, BudgetCostEntity> costMap = new HashMap<Long, BudgetCostEntity>();
        for (BudgetCostEntity budgetCostEntity : costList) {
            Long subjectId3 = budgetCostEntity.getCostSubjectId();
            if (subjectId3 == null || subjectId3 <= 0L) continue;
            costMap.put(budgetCostEntity.getId(), budgetCostEntity);
            if (resMap.containsKey(subjectId3)) {
                reportVO2 = (BudgetReportVO)resMap.get(subjectId3);
                BigDecimal mny2 = MathUtil.safeAdd(reportVO2.getYsHappenMnyAll(), budgetCostEntity.getCostMny());
                BigDecimal taxMny2 = MathUtil.safeAdd(reportVO2.getYsHappenTaxMnyAll(), budgetCostEntity.getCostTaxMny());
                BigDecimal num2 = MathUtil.safeAdd(reportVO2.getYsNumAll(), budgetCostEntity.getCostNum());
                reportVO2.setYsHappenMnyAll(mny2);
                reportVO2.setYsHappenTaxMnyAll(taxMny2);
                reportVO2.setYsNumAll(num2);
                resMap.put(subjectId3, reportVO2);
                continue;
            }
            BudgetReportVO reportVO22 = new BudgetReportVO();
            reportVO22.setSubjectId(subjectId3);
            reportVO22.setSubjectName(budgetCostEntity.getCostSubjectName());
            reportVO22.setYsHappenMnyAll(budgetCostEntity.getCostMny());
            reportVO22.setYsHappenTaxMnyAll(budgetCostEntity.getCostTaxMny());
            reportVO22.setYsNumAll(budgetCostEntity.getCostNum());
            resMap.put(subjectId3, reportVO22);
        }
        for (BudgetDetailEntity budgetDetailEntity : detailList) {
            Long subjectId2 = budgetDetailEntity.getDetailSubjectId();
            if (subjectId2 == null || subjectId2 <= 0L) continue;
            if (resMap.containsKey(subjectId2)) {
                reportVO2 = (BudgetReportVO)resMap.get(subjectId2);
                BigDecimal mny2 = MathUtil.safeAdd(reportVO2.getYsHappenMnyAll(), budgetDetailEntity.getDetailMny());
                BigDecimal taxMny2 = MathUtil.safeAdd(reportVO2.getYsHappenTaxMnyAll(), budgetDetailEntity.getDetailTaxMny());
                BigDecimal num2 = MathUtil.safeAdd(reportVO2.getYsNumAll(), budgetDetailEntity.getDetailNum());
                reportVO2.setYsHappenMnyAll(mny2);
                reportVO2.setYsHappenTaxMnyAll(taxMny2);
                reportVO2.setYsNumAll(num2);
                resMap.put(subjectId2, reportVO2);
                continue;
            }
            reportVO2 = new BudgetReportVO();
            reportVO2.setSubjectId(subjectId2);
            reportVO2.setSubjectName(budgetDetailEntity.getDetailSubjectName());
            reportVO2.setYsHappenMnyAll(budgetDetailEntity.getDetailMny());
            reportVO2.setYsHappenTaxMnyAll(budgetDetailEntity.getDetailTaxMny());
            reportVO2.setYsNumAll(budgetDetailEntity.getDetailNum());
            resMap.put(subjectId2, reportVO2);
        }
        LambdaQueryWrapper peoductionLambd = new LambdaQueryWrapper();
        peoductionLambd.eq(BaseEntity::getDr, (Object)0);
        peoductionLambd.eq(ProductionEntity::getProjectId, (Object)projectId);
        peoductionLambd.in(ProductionEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            beginPeriod = beginPeriod + "-1";
            endDate = endDate + "-31";
            peoductionLambd.ge(ProductionEntity::getProductionDate, (Object)beginPeriod);
            peoductionLambd.le(ProductionEntity::getProductionDate, (Object)endDate);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.productionService.list((Wrapper)peoductionLambd)))) {
            return new ArrayList<BudgetReportVO>(resMap.values());
        }
        List productionIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper peoduDetailLambd = new LambdaQueryWrapper();
        peoduDetailLambd.eq(BaseEntity::getDr, (Object)0);
        peoduDetailLambd.in(ProductionDetailEntity::getProductionId, productionIds);
        List productionDetails = this.productionDetailService.list((Wrapper)peoduDetailLambd);
        if (CollectionUtils.isEmpty((Collection)productionDetails)) {
            return new ArrayList<BudgetReportVO>(resMap.values());
        }
        List proDetailIds = productionDetails.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper proSubLambd = new LambdaQueryWrapper();
        proSubLambd.eq(BaseEntity::getDr, (Object)0);
        proSubLambd.in(ProductionDetailSubEntity::getDetailId, proDetailIds);
        List subDetails = this.productionDetailSubService.list((Wrapper)proSubLambd);
        LambdaQueryWrapper proMeasureLambd = new LambdaQueryWrapper();
        proMeasureLambd.eq(BaseEntity::getDr, (Object)0);
        proMeasureLambd.in(ProductionDetailMeasureEntity::getDetailId, proDetailIds);
        List measureDetails = this.productionDetailMeasureService.list((Wrapper)proMeasureLambd);
        LambdaQueryWrapper proOtherLambd = new LambdaQueryWrapper();
        proOtherLambd.eq(BaseEntity::getDr, (Object)0);
        proOtherLambd.in(ProductionDetailOtherEntity::getDetailId, proDetailIds);
        List otherDetails = this.productionDetailOtherService.list((Wrapper)proOtherLambd);
        LambdaQueryWrapper proFeeLambd = new LambdaQueryWrapper();
        proFeeLambd.eq(BaseEntity::getDr, (Object)0);
        proFeeLambd.in(ProductionDetailFeeEntity::getDetailId, proDetailIds);
        List feeDetails = this.productionDetailFeeService.list((Wrapper)proFeeLambd);
        LambdaQueryWrapper proCostLambd = new LambdaQueryWrapper();
        proCostLambd.eq(BaseEntity::getDr, (Object)0);
        proCostLambd.in(ProductionDetailCostEntity::getDetailId, proDetailIds);
        List costDetails = this.productionDetailCostService.list((Wrapper)proCostLambd);
        HashMap proSubMap = new HashMap();
        for (ProductionDetailSubEntity entity : subDetails) {
            List<ProductionDetailSubEntity> plist;
            Long l;
            BudgetSubEntity budgetSubEntity;
            Long subjectId2;
            if (subMap.containsKey(entity.getBudgetDetailId()) && resMap.containsKey(subjectId2 = (budgetSubEntity = (BudgetSubEntity)((Object)subMap.get(entity.getBudgetDetailId()))).getSubSubjectId())) {
                BudgetReportVO reportVO7 = (BudgetReportVO)resMap.get(subjectId2);
                BigDecimal mny7 = MathUtil.safeAdd(reportVO7.getYsHappenMny(), entity.getProductionMny());
                BigDecimal taxMny7 = MathUtil.safeAdd(reportVO7.getYsHappenTaxMny(), entity.getProductionTaxMny());
                BigDecimal num6 = MathUtil.safeAdd(reportVO7.getYsNum(), entity.getProductionNum());
                reportVO7.setYsHappenMny(mny7);
                reportVO7.setYsHappenTaxMny(taxMny7);
                reportVO7.setYsNum(num6);
                resMap.put(subjectId2, reportVO7);
            }
            if (proSubMap.containsKey(l = entity.getBudgetDetailId())) {
                plist = (List)proSubMap.get(l);
                plist.add(entity);
                proSubMap.put(l, plist);
                continue;
            }
            plist = new ArrayList();
            plist.add(entity);
            proSubMap.put(l, plist);
        }
        HashMap proMeasureMap = new HashMap();
        for (ProductionDetailMeasureEntity productionDetailMeasureEntity : measureDetails) {
            List<ProductionDetailMeasureEntity> plist;
            Long budgetDetailId;
            if (measureMap.containsKey(productionDetailMeasureEntity.getBudgetDetailId()) && resMap.containsKey(subjectId = (bentity = (BudgetMeasureEntity)((Object)measureMap.get(productionDetailMeasureEntity.getBudgetDetailId()))).getMeasureSubjectId())) {
                reportVO = (BudgetReportVO)resMap.get(subjectId);
                mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailMeasureEntity.getProductionMny());
                taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailMeasureEntity.getProductionTaxMny());
                num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailMeasureEntity.getProductionNum());
                reportVO.setYsHappenMny(mny);
                reportVO.setYsHappenTaxMny(taxMny);
                reportVO.setYsNum(num);
                resMap.put(subjectId, reportVO);
            }
            if (proMeasureMap.containsKey(budgetDetailId = productionDetailMeasureEntity.getBudgetDetailId())) {
                plist = (List)proMeasureMap.get(budgetDetailId);
                plist.add(productionDetailMeasureEntity);
                proMeasureMap.put(budgetDetailId, plist);
                continue;
            }
            plist = new ArrayList();
            plist.add(productionDetailMeasureEntity);
            proMeasureMap.put(budgetDetailId, plist);
        }
        for (ProductionDetailOtherEntity productionDetailOtherEntity : otherDetails) {
            if (!otherMap.containsKey(productionDetailOtherEntity.getBudgetDetailId()) || !resMap.containsKey(subjectId = (bentity = (BudgetOtherEntity)((Object)otherMap.get(productionDetailOtherEntity.getBudgetDetailId()))).getOtherSubjectId())) continue;
            reportVO = (BudgetReportVO)resMap.get(subjectId);
            mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailOtherEntity.getProductionMny());
            taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailOtherEntity.getProductionTaxMny());
            num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailOtherEntity.getProductionNum());
            reportVO.setYsHappenMny(mny);
            reportVO.setYsHappenTaxMny(taxMny);
            reportVO.setYsNum(num);
            resMap.put(subjectId, reportVO);
        }
        for (ProductionDetailFeeEntity productionDetailFeeEntity : feeDetails) {
            if (!feeMap.containsKey(productionDetailFeeEntity.getBudgetDetailId()) || !resMap.containsKey(subjectId = (bentity = (BudgetFeeEntity)((Object)feeMap.get(productionDetailFeeEntity.getBudgetDetailId()))).getFeeSubjectId())) continue;
            reportVO = (BudgetReportVO)resMap.get(subjectId);
            mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailFeeEntity.getProductionMny());
            taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailFeeEntity.getProductionTaxMny());
            num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailFeeEntity.getProductionNum());
            reportVO.setYsHappenMny(mny);
            reportVO.setYsHappenTaxMny(taxMny);
            reportVO.setYsNum(num);
            resMap.put(subjectId, reportVO);
        }
        for (ProductionDetailCostEntity productionDetailCostEntity : costDetails) {
            if (!costMap.containsKey(productionDetailCostEntity.getBudgetDetailId()) || !resMap.containsKey(subjectId = (bentity = (BudgetCostEntity)((Object)costMap.get(productionDetailCostEntity.getBudgetDetailId()))).getCostSubjectId())) continue;
            reportVO = (BudgetReportVO)resMap.get(subjectId);
            mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailCostEntity.getProductionMny());
            taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailCostEntity.getProductionTaxMny());
            num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailCostEntity.getProductionNum());
            reportVO.setYsHappenMny(mny);
            reportVO.setYsHappenTaxMny(taxMny);
            reportVO.setYsNum(num);
            resMap.put(subjectId, reportVO);
        }
        for (BudgetDetailEntity budgetDetailEntity : detailList) {
            BigDecimal dtaxMny;
            BigDecimal dmny;
            BigDecimal dnum;
            BigDecimal useNum;
            List pdList;
            Long subjectId3 = budgetDetailEntity.getDetailSubjectId();
            if (subjectId3 == null || subjectId3 <= 0L) continue;
            BigDecimal content = budgetDetailEntity.getContent();
            BigDecimal detailPrice = budgetDetailEntity.getDetailPrice();
            BigDecimal detailTaxPrice = budgetDetailEntity.getDetailTaxPrice();
            Long budgetBid = budgetDetailEntity.getBudgetBid();
            if (proSubMap.containsKey(budgetBid)) {
                pdList = (List)proSubMap.get(budgetBid);
                for (BaseEntity pdd : pdList) {
                    if (!resMap.containsKey(subjectId3)) continue;
                    BudgetReportVO reportVO8 = (BudgetReportVO)resMap.get(subjectId3);
                    useNum = pdd.getProductionNum();
                    dnum = MathUtil.safeMultiply(useNum, content);
                    dmny = MathUtil.safeMultiply(dnum, detailPrice);
                    dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                    BigDecimal mny8 = MathUtil.safeAdd(reportVO8.getYsHappenMny(), dmny);
                    BigDecimal taxMny8 = MathUtil.safeAdd(reportVO8.getYsHappenTaxMny(), dtaxMny);
                    BigDecimal num7 = MathUtil.safeAdd(reportVO8.getYsNum(), dnum);
                    reportVO8.setYsHappenMny(mny8);
                    reportVO8.setYsHappenTaxMny(taxMny8);
                    reportVO8.setYsNum(num7);
                    resMap.put(subjectId3, reportVO8);
                }
            }
            if (!proMeasureMap.containsKey(budgetBid)) continue;
            pdList = (List)proMeasureMap.get(budgetBid);
            for (BaseEntity pdd : pdList) {
                if (!resMap.containsKey(subjectId3)) continue;
                BudgetReportVO reportVO6 = (BudgetReportVO)resMap.get(subjectId3);
                useNum = pdd.getProductionNum();
                dnum = MathUtil.safeMultiply(useNum, content);
                dmny = MathUtil.safeMultiply(dnum, detailPrice);
                dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                BigDecimal mny3 = MathUtil.safeAdd(reportVO6.getYsHappenMny(), dmny);
                BigDecimal taxMny3 = MathUtil.safeAdd(reportVO6.getYsHappenTaxMny(), dtaxMny);
                BigDecimal num3 = MathUtil.safeAdd(reportVO6.getYsNum(), dnum);
                reportVO6.setYsHappenMny(mny3);
                reportVO6.setYsHappenTaxMny(taxMny3);
                reportVO6.setYsNum(num3);
                resMap.put(subjectId3, reportVO6);
            }
        }
        return new ArrayList<BudgetReportVO>(resMap.values());
    }

    @Override
    public List<BudgetReportVO> querySumBudgetMnyNew(Long projectId, String beginPeriod, String endDate) {
        String key;
        BigDecimal num;
        BigDecimal taxMny;
        BigDecimal mny;
        BudgetReportVO reportVO;
        String key2;
        String unitName;
        Long subjectId;
        BaseEntity bentity;
        List list;
        BudgetReportVO reportVO2;
        BudgetReportVO reportVO3;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(BudgetEntity::getProjectId, (Object)projectId);
        wrapper.in(BudgetEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entityList = super.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList<BudgetReportVO>();
        }
        List<Long> budegtIds = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<BudgetSubEntity> subList = this.budgetSubService.querySubByBudgetIds(budegtIds);
        List<BudgetMeasureEntity> measureList = this.budgetMeasureService.queryMeasureByBudgetIds(budegtIds);
        List<BudgetOtherEntity> otherList = this.budgetOtherService.queryOtherByBudgetIds(budegtIds);
        List<BudgetFeeEntity> feeList = this.budgetFeeService.queryFeeByBudgetIds(budegtIds);
        List<BudgetCostEntity> costList = this.budgetCostService.queryCostByBudgetIds(budegtIds);
        List<BudgetDetailEntity> detailList = this.budgetDetailService.queryDetailByBudgetIds(budegtIds);
        HashMap<String, BudgetReportVO> resMap = new HashMap<String, BudgetReportVO>();
        HashMap<Long, BudgetSubEntity> subMap = new HashMap<Long, BudgetSubEntity>();
        for (BudgetSubEntity budgetSubEntity : subList) {
            String string;
            Long l = budgetSubEntity.getSubSubjectId();
            String string2 = string = budgetSubEntity.getSubUnit() == null ? "" : budgetSubEntity.getSubUnit();
            if (l == null || l <= 0L) continue;
            String key5 = l.toString() + "," + string;
            subMap.put(budgetSubEntity.getId(), budgetSubEntity);
            if (resMap.containsKey(key5)) {
                BudgetReportVO budgetReportVO = (BudgetReportVO)resMap.get(key5);
                BigDecimal mny5 = MathUtil.safeAdd(budgetReportVO.getYsHappenMnyAll(), budgetSubEntity.getSubMny());
                BigDecimal taxMny5 = MathUtil.safeAdd(budgetReportVO.getYsHappenTaxMnyAll(), budgetSubEntity.getSubTaxMny());
                BigDecimal num4 = MathUtil.safeAdd(budgetReportVO.getYsNumAll(), budgetSubEntity.getSubNum());
                budgetReportVO.setYsHappenMnyAll(mny5);
                budgetReportVO.setYsHappenTaxMnyAll(taxMny5);
                budgetReportVO.setYsNumAll(num4);
                budgetReportVO.setYsUnitName(string);
                resMap.put(key5, budgetReportVO);
                continue;
            }
            BudgetReportVO budgetReportVO = new BudgetReportVO();
            budgetReportVO.setSubjectId(l);
            budgetReportVO.setSubjectName(budgetSubEntity.getSubSubjectName());
            budgetReportVO.setYsHappenMnyAll(budgetSubEntity.getSubMny());
            budgetReportVO.setYsHappenTaxMnyAll(budgetSubEntity.getSubTaxMny());
            budgetReportVO.setYsNumAll(budgetSubEntity.getSubNum());
            budgetReportVO.setYsUnitName(string);
            resMap.put(key5, budgetReportVO);
        }
        HashMap<Long, BudgetMeasureEntity> measureMap = new HashMap<Long, BudgetMeasureEntity>();
        for (BudgetMeasureEntity budgetMeasureEntity : measureList) {
            String unitName5;
            Long l = budgetMeasureEntity.getMeasureSubjectId();
            String string = unitName5 = budgetMeasureEntity.getMeasureUnit() == null ? "" : budgetMeasureEntity.getMeasureUnit();
            if (l == null || l <= 0L) continue;
            String string3 = l.toString() + "," + unitName5;
            measureMap.put(budgetMeasureEntity.getId(), budgetMeasureEntity);
            if (resMap.containsKey(string3)) {
                BudgetReportVO reportVO4 = (BudgetReportVO)resMap.get(string3);
                BigDecimal mny6 = MathUtil.safeAdd(reportVO4.getYsHappenMnyAll(), budgetMeasureEntity.getMeasureMny());
                BigDecimal taxMny6 = MathUtil.safeAdd(reportVO4.getYsHappenTaxMnyAll(), budgetMeasureEntity.getMeasureTaxMny());
                BigDecimal num5 = MathUtil.safeAdd(reportVO4.getYsNumAll(), budgetMeasureEntity.getMeasureNum());
                reportVO4.setYsHappenMnyAll(mny6);
                reportVO4.setYsHappenTaxMnyAll(taxMny6);
                reportVO4.setYsNumAll(num5);
                reportVO4.setYsUnitName(unitName5);
                resMap.put(string3, reportVO4);
                continue;
            }
            BudgetReportVO reportVO6 = new BudgetReportVO();
            reportVO6.setSubjectId(l);
            reportVO6.setSubjectName(budgetMeasureEntity.getMeasureSubjectName());
            reportVO6.setYsHappenMnyAll(budgetMeasureEntity.getMeasureMny());
            reportVO6.setYsHappenTaxMnyAll(budgetMeasureEntity.getMeasureTaxMny());
            reportVO6.setYsNumAll(budgetMeasureEntity.getMeasureNum());
            reportVO6.setYsUnitName(unitName5);
            resMap.put(string3, reportVO6);
        }
        HashMap<Long, BudgetOtherEntity> hashMap = new HashMap<Long, BudgetOtherEntity>();
        for (BudgetOtherEntity budgetOtherEntity : otherList) {
            String string;
            Long subjectId6 = budgetOtherEntity.getOtherSubjectId();
            String string4 = string = budgetOtherEntity.getOtherUnit() == null ? "" : budgetOtherEntity.getOtherUnit();
            if (subjectId6 == null || subjectId6 <= 0L) continue;
            String key4 = subjectId6.toString() + "," + string;
            hashMap.put(budgetOtherEntity.getId(), budgetOtherEntity);
            if (resMap.containsKey(key4)) {
                reportVO3 = (BudgetReportVO)resMap.get(key4);
                BigDecimal mny4 = MathUtil.safeAdd(reportVO3.getYsHappenMnyAll(), budgetOtherEntity.getOtherMny());
                BigDecimal taxMny4 = MathUtil.safeAdd(reportVO3.getYsHappenTaxMnyAll(), budgetOtherEntity.getOtherTaxMny());
                BigDecimal num6 = MathUtil.safeAdd(reportVO3.getYsNumAll(), budgetOtherEntity.getOtherNum());
                reportVO3.setYsHappenMnyAll(mny4);
                reportVO3.setYsHappenTaxMnyAll(taxMny4);
                reportVO3.setYsNumAll(num6);
                reportVO3.setYsUnitName(string);
                resMap.put(key4, reportVO3);
                continue;
            }
            BudgetReportVO reportVO4 = new BudgetReportVO();
            reportVO4.setSubjectId(subjectId6);
            reportVO4.setSubjectName(budgetOtherEntity.getOtherSubjectName());
            reportVO4.setYsHappenMnyAll(budgetOtherEntity.getOtherMny());
            reportVO4.setYsHappenTaxMnyAll(budgetOtherEntity.getOtherTaxMny());
            reportVO4.setYsNumAll(budgetOtherEntity.getOtherNum());
            reportVO4.setYsUnitName(string);
            resMap.put(key4, reportVO4);
        }
        HashMap<Long, Object> hashMap2 = new HashMap<Long, Object>();
        for (Object entity : feeList) {
            Long l = entity.getFeeSubjectId();
            if (l == null || l <= 0L) continue;
            String key3 = l.toString() + ",";
            hashMap2.put(entity.getId(), entity);
            if (resMap.containsKey(key3)) {
                reportVO3 = (BudgetReportVO)resMap.get(key3);
                BigDecimal mny2 = MathUtil.safeAdd(reportVO3.getYsHappenMnyAll(), entity.getFeeMny());
                BigDecimal taxMny2 = MathUtil.safeAdd(reportVO3.getYsHappenTaxMnyAll(), entity.getFeeTaxMny());
                reportVO3.setYsHappenMnyAll(mny2);
                reportVO3.setYsHappenTaxMnyAll(taxMny2);
                resMap.put(key3, reportVO3);
                continue;
            }
            reportVO3 = new BudgetReportVO();
            reportVO3.setSubjectId(l);
            reportVO3.setSubjectName(entity.getFeeSubjectName());
            reportVO3.setYsHappenMnyAll(entity.getFeeMny());
            reportVO3.setYsHappenTaxMnyAll(entity.getFeeTaxMny());
            resMap.put(key3, reportVO3);
        }
        HashMap<Long, BudgetCostEntity> hashMap3 = new HashMap<Long, BudgetCostEntity>();
        for (BudgetCostEntity budgetCostEntity : costList) {
            String unitName3;
            Long subjectId3 = budgetCostEntity.getCostSubjectId();
            String string = unitName3 = budgetCostEntity.getCostUnit() == null ? "" : budgetCostEntity.getCostUnit();
            if (subjectId3 == null || subjectId3 <= 0L) continue;
            String key3 = subjectId3.toString() + "," + unitName3;
            hashMap3.put(budgetCostEntity.getId(), budgetCostEntity);
            if (resMap.containsKey(key3)) {
                reportVO2 = (BudgetReportVO)resMap.get(key3);
                BigDecimal mny3 = MathUtil.safeAdd(reportVO2.getYsHappenMnyAll(), budgetCostEntity.getCostMny());
                BigDecimal taxMny3 = MathUtil.safeAdd(reportVO2.getYsHappenTaxMnyAll(), budgetCostEntity.getCostTaxMny());
                BigDecimal num3 = MathUtil.safeAdd(reportVO2.getYsNumAll(), budgetCostEntity.getCostNum());
                reportVO2.setYsHappenMnyAll(mny3);
                reportVO2.setYsHappenTaxMnyAll(taxMny3);
                reportVO2.setYsNumAll(num3);
                reportVO2.setYsUnitName(unitName3);
                resMap.put(key3, reportVO2);
                continue;
            }
            BudgetReportVO reportVO32 = new BudgetReportVO();
            reportVO32.setSubjectId(subjectId3);
            reportVO32.setSubjectName(budgetCostEntity.getCostSubjectName());
            reportVO32.setYsHappenMnyAll(budgetCostEntity.getCostMny());
            reportVO32.setYsHappenTaxMnyAll(budgetCostEntity.getCostTaxMny());
            reportVO32.setYsNumAll(budgetCostEntity.getCostNum());
            reportVO32.setYsUnitName(unitName3);
            resMap.put(key3, reportVO32);
        }
        for (BudgetDetailEntity budgetDetailEntity : detailList) {
            String unitName2;
            Long subjectId2 = budgetDetailEntity.getDetailSubjectId();
            String string = unitName2 = budgetDetailEntity.getDetailUnit() == null ? "" : budgetDetailEntity.getDetailUnit();
            if (subjectId2 == null || subjectId2 <= 0L) continue;
            String key4 = subjectId2.toString() + "," + unitName2;
            if (resMap.containsKey(key4)) {
                reportVO2 = (BudgetReportVO)resMap.get(key4);
                BigDecimal mny3 = MathUtil.safeAdd(reportVO2.getYsHappenMnyAll(), budgetDetailEntity.getDetailMny());
                BigDecimal taxMny3 = MathUtil.safeAdd(reportVO2.getYsHappenTaxMnyAll(), budgetDetailEntity.getDetailTaxMny());
                BigDecimal num2 = MathUtil.safeAdd(reportVO2.getYsNumAll(), budgetDetailEntity.getDetailNum());
                reportVO2.setYsHappenMnyAll(mny3);
                reportVO2.setYsHappenTaxMnyAll(taxMny3);
                reportVO2.setYsNumAll(num2);
                reportVO2.setYsUnitName(unitName2);
                resMap.put(key4, reportVO2);
                continue;
            }
            reportVO2 = new BudgetReportVO();
            reportVO2.setSubjectId(subjectId2);
            reportVO2.setSubjectName(budgetDetailEntity.getDetailSubjectName());
            reportVO2.setYsHappenMnyAll(budgetDetailEntity.getDetailMny());
            reportVO2.setYsHappenTaxMnyAll(budgetDetailEntity.getDetailTaxMny());
            reportVO2.setYsNumAll(budgetDetailEntity.getDetailNum());
            reportVO2.setYsUnitName(unitName2);
            resMap.put(key4, reportVO2);
        }
        LambdaQueryWrapper peoductionLambd = new LambdaQueryWrapper();
        peoductionLambd.eq(BaseEntity::getDr, (Object)0);
        peoductionLambd.eq(ProductionEntity::getProjectId, (Object)projectId);
        peoductionLambd.in(ProductionEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            beginPeriod = beginPeriod + "-1";
            endDate = endDate + "-31";
            peoductionLambd.ge(ProductionEntity::getProductionDate, (Object)beginPeriod);
            peoductionLambd.le(ProductionEntity::getProductionDate, (Object)endDate);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.productionService.list((Wrapper)peoductionLambd)))) {
            return new ArrayList<BudgetReportVO>(resMap.values());
        }
        List productionIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper peoduDetailLambd = new LambdaQueryWrapper();
        peoduDetailLambd.eq(BaseEntity::getDr, (Object)0);
        peoduDetailLambd.in(ProductionDetailEntity::getProductionId, productionIds);
        List productionDetails = this.productionDetailService.list((Wrapper)peoduDetailLambd);
        if (CollectionUtils.isEmpty((Collection)productionDetails)) {
            return new ArrayList<BudgetReportVO>(resMap.values());
        }
        List proDetailIds = productionDetails.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper proSubLambd = new LambdaQueryWrapper();
        proSubLambd.eq(BaseEntity::getDr, (Object)0);
        proSubLambd.in(ProductionDetailSubEntity::getDetailId, proDetailIds);
        List subDetails = this.productionDetailSubService.list((Wrapper)proSubLambd);
        LambdaQueryWrapper proMeasureLambd = new LambdaQueryWrapper();
        proMeasureLambd.eq(BaseEntity::getDr, (Object)0);
        proMeasureLambd.in(ProductionDetailMeasureEntity::getDetailId, proDetailIds);
        List measureDetails = this.productionDetailMeasureService.list((Wrapper)proMeasureLambd);
        LambdaQueryWrapper proOtherLambd = new LambdaQueryWrapper();
        proOtherLambd.eq(BaseEntity::getDr, (Object)0);
        proOtherLambd.in(ProductionDetailOtherEntity::getDetailId, proDetailIds);
        List otherDetails = this.productionDetailOtherService.list((Wrapper)proOtherLambd);
        LambdaQueryWrapper proFeeLambd = new LambdaQueryWrapper();
        proFeeLambd.eq(BaseEntity::getDr, (Object)0);
        proFeeLambd.in(ProductionDetailFeeEntity::getDetailId, proDetailIds);
        List feeDetails = this.productionDetailFeeService.list((Wrapper)proFeeLambd);
        LambdaQueryWrapper proCostLambd = new LambdaQueryWrapper();
        proCostLambd.eq(BaseEntity::getDr, (Object)0);
        proCostLambd.in(ProductionDetailCostEntity::getDetailId, proDetailIds);
        List costDetails = this.productionDetailCostService.list((Wrapper)proCostLambd);
        HashMap proSubMap = new HashMap();
        for (ProductionDetailSubEntity entity : subDetails) {
            List<ProductionDetailSubEntity> plist;
            Long l;
            if (subMap.containsKey(entity.getBudgetDetailId())) {
                BudgetSubEntity budgetSubEntity = (BudgetSubEntity)((Object)subMap.get(entity.getBudgetDetailId()));
                Long subjectId2 = budgetSubEntity.getSubSubjectId();
                String unitName2 = budgetSubEntity.getSubUnit() == null ? "" : budgetSubEntity.getSubUnit();
                String key22 = subjectId2.toString() + "," + unitName2;
                if (resMap.containsKey(key22)) {
                    BudgetReportVO reportVO22 = (BudgetReportVO)resMap.get(key22);
                    BigDecimal mny2 = MathUtil.safeAdd(reportVO22.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny2 = MathUtil.safeAdd(reportVO22.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num2 = MathUtil.safeAdd(reportVO22.getYsNum(), entity.getProductionNum());
                    reportVO22.setYsHappenMny(mny2);
                    reportVO22.setYsHappenTaxMny(taxMny2);
                    reportVO22.setYsNum(num2);
                    reportVO22.setYsUnitName(unitName2);
                    resMap.put(key22, reportVO22);
                }
            }
            if (proSubMap.containsKey(l = entity.getBudgetDetailId())) {
                plist = (List)proSubMap.get(l);
                plist.add(entity);
                proSubMap.put(l, plist);
                continue;
            }
            plist = new ArrayList();
            plist.add(entity);
            proSubMap.put(l, plist);
        }
        HashMap proMeasureMap = new HashMap();
        for (ProductionDetailMeasureEntity productionDetailMeasureEntity : measureDetails) {
            List<ProductionDetailMeasureEntity> plist;
            Long budgetDetailId;
            if (measureMap.containsKey(productionDetailMeasureEntity.getBudgetDetailId())) {
                bentity = (BudgetMeasureEntity)((Object)measureMap.get(productionDetailMeasureEntity.getBudgetDetailId()));
                subjectId = bentity.getMeasureSubjectId();
                unitName = bentity.getMeasureUnit() == null ? "" : bentity.getMeasureUnit();
                key2 = subjectId.toString() + "," + unitName;
                if (resMap.containsKey(key2)) {
                    reportVO = (BudgetReportVO)resMap.get(key2);
                    mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailMeasureEntity.getProductionMny());
                    taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailMeasureEntity.getProductionTaxMny());
                    num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailMeasureEntity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key2, reportVO);
                }
            }
            if (proMeasureMap.containsKey(budgetDetailId = productionDetailMeasureEntity.getBudgetDetailId())) {
                plist = (List)proMeasureMap.get(budgetDetailId);
                plist.add(productionDetailMeasureEntity);
                proMeasureMap.put(budgetDetailId, plist);
                continue;
            }
            plist = new ArrayList();
            plist.add(productionDetailMeasureEntity);
            proMeasureMap.put(budgetDetailId, plist);
        }
        for (ProductionDetailOtherEntity productionDetailOtherEntity : otherDetails) {
            if (!hashMap.containsKey(productionDetailOtherEntity.getBudgetDetailId())) continue;
            bentity = (BudgetOtherEntity)((Object)hashMap.get(productionDetailOtherEntity.getBudgetDetailId()));
            subjectId = bentity.getOtherSubjectId();
            String string = unitName = bentity.getOtherUnit() == null ? "" : bentity.getOtherUnit();
            key2 = subjectId.toString() + "," + unitName;
            if (!resMap.containsKey(key2)) continue;
            reportVO = (BudgetReportVO)resMap.get(key2);
            mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailOtherEntity.getProductionMny());
            taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailOtherEntity.getProductionTaxMny());
            num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailOtherEntity.getProductionNum());
            reportVO.setYsHappenMny(mny);
            reportVO.setYsHappenTaxMny(taxMny);
            reportVO.setYsNum(num);
            reportVO.setYsUnitName(unitName);
            resMap.put(key2, reportVO);
        }
        for (ProductionDetailFeeEntity productionDetailFeeEntity : feeDetails) {
            if (!hashMap2.containsKey(productionDetailFeeEntity.getBudgetDetailId()) || !resMap.containsKey(key = (subjectId = (bentity = (BudgetFeeEntity)((Object)hashMap2.get(productionDetailFeeEntity.getBudgetDetailId()))).getFeeSubjectId()).toString() + ",")) continue;
            BudgetReportVO reportVO5 = (BudgetReportVO)resMap.get(key);
            BigDecimal mny4 = MathUtil.safeAdd(reportVO5.getYsHappenMny(), productionDetailFeeEntity.getProductionMny());
            BigDecimal taxMny4 = MathUtil.safeAdd(reportVO5.getYsHappenTaxMny(), productionDetailFeeEntity.getProductionTaxMny());
            BigDecimal num3 = MathUtil.safeAdd(reportVO5.getYsNum(), productionDetailFeeEntity.getProductionNum());
            reportVO5.setYsHappenMny(mny4);
            reportVO5.setYsHappenTaxMny(taxMny4);
            reportVO5.setYsNum(num3);
            resMap.put(key, reportVO5);
        }
        for (ProductionDetailCostEntity productionDetailCostEntity : costDetails) {
            if (!hashMap3.containsKey(productionDetailCostEntity.getBudgetDetailId())) continue;
            bentity = (BudgetCostEntity)((Object)hashMap3.get(productionDetailCostEntity.getBudgetDetailId()));
            subjectId = bentity.getCostSubjectId();
            String string = unitName = bentity.getCostUnit() == null ? "" : bentity.getCostUnit();
            key2 = subjectId.toString() + "," + unitName;
            if (!resMap.containsKey(key2)) continue;
            reportVO = (BudgetReportVO)resMap.get(key2);
            mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), productionDetailCostEntity.getProductionMny());
            taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), productionDetailCostEntity.getProductionTaxMny());
            num = MathUtil.safeAdd(reportVO.getYsNum(), productionDetailCostEntity.getProductionNum());
            reportVO.setYsHappenMny(mny);
            reportVO.setYsHappenTaxMny(taxMny);
            reportVO.setYsNum(num);
            reportVO.setYsUnitName(unitName);
            resMap.put(key2, reportVO);
        }
        for (BudgetDetailEntity budgetDetailEntity : detailList) {
            BigDecimal dtaxMny;
            BigDecimal dmny;
            BigDecimal dnum;
            BigDecimal useNum;
            List pdList;
            String unitName3;
            Long subjectId3 = budgetDetailEntity.getDetailSubjectId();
            String string = unitName3 = budgetDetailEntity.getDetailUnit() == null ? "" : budgetDetailEntity.getDetailUnit();
            if (subjectId3 == null || subjectId3 <= 0L) continue;
            key = subjectId3.toString() + "," + unitName3;
            BigDecimal content = budgetDetailEntity.getContent();
            BigDecimal detailPrice = budgetDetailEntity.getDetailPrice();
            BigDecimal detailTaxPrice = budgetDetailEntity.getDetailTaxPrice();
            Long budgetBid = budgetDetailEntity.getBudgetBid();
            if (proSubMap.containsKey(budgetBid)) {
                pdList = (List)proSubMap.get(budgetBid);
                for (BaseEntity pdd : pdList) {
                    if (!resMap.containsKey(key)) continue;
                    BudgetReportVO reportVO7 = (BudgetReportVO)resMap.get(key);
                    useNum = pdd.getProductionNum();
                    dnum = MathUtil.safeMultiply(useNum, content);
                    dmny = MathUtil.safeMultiply(dnum, detailPrice);
                    dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                    BigDecimal mny7 = MathUtil.safeAdd(reportVO7.getYsHappenMny(), dmny);
                    BigDecimal taxMny7 = MathUtil.safeAdd(reportVO7.getYsHappenTaxMny(), dtaxMny);
                    BigDecimal num7 = MathUtil.safeAdd(reportVO7.getYsNum(), dnum);
                    reportVO7.setYsHappenMny(mny7);
                    reportVO7.setYsHappenTaxMny(taxMny7);
                    reportVO7.setYsNum(num7);
                    reportVO7.setYsUnitName(unitName3);
                    resMap.put(key, reportVO7);
                }
            }
            if (!proMeasureMap.containsKey(budgetBid)) continue;
            pdList = (List)proMeasureMap.get(budgetBid);
            for (BaseEntity pdd : pdList) {
                if (!resMap.containsKey(key)) continue;
                BudgetReportVO reportVO6 = (BudgetReportVO)resMap.get(key);
                useNum = pdd.getProductionNum();
                dnum = MathUtil.safeMultiply(useNum, content);
                dmny = MathUtil.safeMultiply(dnum, detailPrice);
                dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                BigDecimal mny5 = MathUtil.safeAdd(reportVO6.getYsHappenMny(), dmny);
                BigDecimal taxMny5 = MathUtil.safeAdd(reportVO6.getYsHappenTaxMny(), dtaxMny);
                BigDecimal num4 = MathUtil.safeAdd(reportVO6.getYsNum(), dnum);
                reportVO6.setYsHappenMny(mny5);
                reportVO6.setYsHappenTaxMny(taxMny5);
                reportVO6.setYsNum(num4);
                reportVO6.setYsUnitName(unitName3);
                resMap.put(key, reportVO6);
            }
        }
        return new ArrayList<BudgetReportVO>(resMap.values());
    }

    @Override
    public BigDecimal queryAllBudgetMny(Long projectId) {
        BigDecimal sumMny = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BudgetEntity::getProjectId, (Object)projectId);
        wrapper.in(BudgetEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entityList = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            sumMny = entityList.stream().map(item -> item.getBudgetTaxMny() == null ? BigDecimal.ZERO : item.getBudgetTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return sumMny;
    }

    @Override
    public List<ThreeReportVO> getThreeReports(Long projectId) {
        List<BudgetCostEntity> contOut;
        HashMap<String, ThreeReportVO> result = new HashMap<String, ThreeReportVO>();
        List<BudgetCostEntity> contResult = this.getResult(projectId, 0);
        if (CollectionUtils.isNotEmpty(contResult)) {
            Long rootId1 = IdWorker.getId();
            ThreeReportVO rootReport1 = new ThreeReportVO();
            rootReport1.setId(rootId1);
            rootReport1.setContLinkId(contResult.get(0).getBudgetId());
            rootReport1.setCostCode("001");
            rootReport1.setCostName("\u5408\u540c\u5185");
            for (Object costEntity : contResult) {
                if (null == costEntity.getParentId()) {
                    costEntity.setParentId(rootId1);
                }
                ThreeReportVO reportVO = (ThreeReportVO)BeanMapper.map((Object)costEntity, ThreeReportVO.class);
                reportVO.setContLinkId(costEntity.getBudgetId());
                reportVO.setContNum(costEntity.getCostNum());
                reportVO.setContMny(costEntity.getCostAdditionalTaxMny());
                reportVO.setContPrice(costEntity.getCostAdditionalTaxPrice());
                result.put(reportVO.getCostCode() + "@" + reportVO.getCostName(), reportVO);
            }
            List<BudgetCostEntity> mapResult = this.getResult(projectId, 4);
            for (Object costEntity : mapResult) {
                rootReport1.setMapLinkId(costEntity.getBudgetId());
                String key = costEntity.getCostCode() + "@" + costEntity.getCostName();
                if (!result.containsKey(key)) continue;
                ThreeReportVO reportVO = (ThreeReportVO)result.get(key);
                reportVO.setMapLinkId(costEntity.getBudgetId());
                reportVO.setMapNum(costEntity.getCostNum());
                reportVO.setMapMny(costEntity.getCostAdditionalTaxMny());
                reportVO.setMapPrice(costEntity.getCostAdditionalTaxPrice());
                result.put(key, reportVO);
            }
            List<BudgetCostEntity> settleResult = this.getResult(projectId, 7);
            for (BudgetCostEntity costEntity : settleResult) {
                rootReport1.setSettleLinkId(costEntity.getBudgetId());
                String key = costEntity.getCostCode() + "@" + costEntity.getCostName();
                if (!result.containsKey(key)) continue;
                ThreeReportVO reportVO = (ThreeReportVO)result.get(key);
                reportVO.setSettleLinkId(costEntity.getBudgetId());
                reportVO.setSettleNum(costEntity.getCostNum());
                reportVO.setSettleMny(costEntity.getCostAdditionalTaxMny());
                reportVO.setSettlePrice(costEntity.getCostAdditionalTaxPrice());
                result.put(key, reportVO);
            }
            for (ThreeReportVO reportVO : result.values()) {
                if (null == reportVO.getParentId() || !rootId1.equals(reportVO.getParentId())) continue;
                rootReport1.setContNum(ComputeUtil.safeAdd((BigDecimal)rootReport1.getContNum(), (BigDecimal)reportVO.getContNum()));
                rootReport1.setContMny(ComputeUtil.safeAdd((BigDecimal)rootReport1.getContMny(), (BigDecimal)reportVO.getContMny()));
                rootReport1.setContPrice(ComputeUtil.safeDiv((BigDecimal)rootReport1.getContMny(), (BigDecimal)rootReport1.getContNum()));
                rootReport1.setMapNum(ComputeUtil.safeAdd((BigDecimal)rootReport1.getMapNum(), (BigDecimal)reportVO.getMapNum()));
                rootReport1.setMapMny(ComputeUtil.safeAdd((BigDecimal)rootReport1.getMapMny(), (BigDecimal)reportVO.getMapMny()));
                rootReport1.setMapPrice(ComputeUtil.safeDiv((BigDecimal)rootReport1.getMapMny(), (BigDecimal)rootReport1.getMapNum()));
                rootReport1.setSettleNum(ComputeUtil.safeAdd((BigDecimal)rootReport1.getSettleNum(), (BigDecimal)reportVO.getSettleNum()));
                rootReport1.setSettleMny(ComputeUtil.safeAdd((BigDecimal)rootReport1.getSettleMny(), (BigDecimal)reportVO.getSettleMny()));
                rootReport1.setSettlePrice(ComputeUtil.safeDiv((BigDecimal)rootReport1.getSettleMny(), (BigDecimal)rootReport1.getSettleNum()));
            }
            result.put(rootReport1.getCostName(), rootReport1);
        }
        if (CollectionUtils.isNotEmpty(contOut = this.getResult(projectId, 2))) {
            Long rootId2 = IdWorker.getId();
            ThreeReportVO rootReport2 = new ThreeReportVO();
            rootReport2.setId(rootId2);
            rootReport2.setContLinkId(contOut.get(0).getBudgetId());
            rootReport2.setMapLinkId(contOut.get(0).getBudgetId());
            rootReport2.setCostCode("002");
            rootReport2.setCostName("\u5408\u540c\u5916");
            for (Object costEntity : contOut) {
                ThreeReportVO reportVO;
                if (null == costEntity.getParentId()) {
                    costEntity.setParentId(rootId2);
                }
                reportVO = (ThreeReportVO)BeanMapper.map((Object)costEntity, ThreeReportVO.class);
                reportVO.setContLinkId(costEntity.getBudgetId());
                reportVO.setContNum(costEntity.getCostNum());
                reportVO.setContMny(costEntity.getCostAdditionalTaxMny());
                reportVO.setContPrice(costEntity.getCostAdditionalTaxPrice());
                reportVO.setMapLinkId(costEntity.getBudgetId());
                reportVO.setMapNum(costEntity.getCostNum());
                reportVO.setMapMny(costEntity.getCostAdditionalTaxMny());
                reportVO.setMapPrice(costEntity.getCostAdditionalTaxPrice());
                result.put(reportVO.getCostCode() + "@" + reportVO.getCostName(), reportVO);
            }
            for (ThreeReportVO reportVO : result.values()) {
                if (null == reportVO.getParentId() || !rootId2.equals(reportVO.getParentId())) continue;
                rootReport2.setContNum(ComputeUtil.safeAdd((BigDecimal)rootReport2.getContNum(), (BigDecimal)reportVO.getContNum()));
                rootReport2.setContMny(ComputeUtil.safeAdd((BigDecimal)rootReport2.getContMny(), (BigDecimal)reportVO.getContMny()));
                rootReport2.setContPrice(ComputeUtil.safeDiv((BigDecimal)rootReport2.getContMny(), (BigDecimal)rootReport2.getContNum()));
                rootReport2.setMapNum(ComputeUtil.safeAdd((BigDecimal)rootReport2.getMapNum(), (BigDecimal)reportVO.getMapNum()));
                rootReport2.setMapMny(ComputeUtil.safeAdd((BigDecimal)rootReport2.getMapMny(), (BigDecimal)reportVO.getMapMny()));
                rootReport2.setMapPrice(ComputeUtil.safeDiv((BigDecimal)rootReport2.getMapMny(), (BigDecimal)rootReport2.getMapNum()));
                rootReport2.setSettleNum(ComputeUtil.safeAdd((BigDecimal)rootReport2.getSettleNum(), (BigDecimal)reportVO.getSettleNum()));
                rootReport2.setSettleMny(ComputeUtil.safeAdd((BigDecimal)rootReport2.getSettleMny(), (BigDecimal)reportVO.getSettleMny()));
                rootReport2.setSettlePrice(ComputeUtil.safeDiv((BigDecimal)rootReport2.getSettleMny(), (BigDecimal)rootReport2.getSettleNum()));
            }
            result.put(rootReport2.getCostName(), rootReport2);
        }
        ArrayList resultList = new ArrayList(result.values());
        resultList.sort(Comparator.comparing(ThreeReportVO::getCostCode));
        return TreeNodeBUtil.buildTree(resultList);
    }

    private List<BudgetCostEntity> getResult(Long projectId, Integer budgetSource) {
        HashMap<String, BudgetCostEntity> result = new HashMap<String, BudgetCostEntity>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BudgetEntity::getBudgetSource, (Object)budgetSource);
        queryWrapper.in(BudgetEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(BudgetCostEntity::getBudgetId, idList);
            List costEntities = this.budgetCostService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)costEntities)) {
                for (BudgetCostEntity costEntity : costEntities) {
                    String key = costEntity.getCostCode() + "@" + costEntity.getCostName();
                    if (!result.containsKey(key)) {
                        result.put(key, costEntity);
                        continue;
                    }
                    BudgetCostEntity entity = (BudgetCostEntity)((Object)result.get(key));
                    entity.setCostAdditionalTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getCostAdditionalTaxMny(), (BigDecimal)costEntity.getCostAdditionalTaxMny()));
                    entity.setCostNum(ComputeUtil.safeAdd((BigDecimal)entity.getCostNum(), (BigDecimal)costEntity.getCostNum()));
                    entity.setCostAdditionalTaxPrice(ComputeUtil.safeDiv((BigDecimal)entity.getCostAdditionalTaxMny(), (BigDecimal)entity.getCostNum()));
                }
            }
        }
        return !result.isEmpty() ? new ArrayList(result.values()) : new ArrayList();
    }

    @Override
    public void updateUseId(Long useId, String useType, List<Long> budgetIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BudgetEntity::getUseId, (Object)useId);
        wrapper.set(BudgetEntity::getUseType, null);
        wrapper.set(BudgetEntity::getUseId, null);
        this.update((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(budgetIds)) {
            budgetIds.forEach(e -> {
                LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                lambda.eq(BaseEntity::getId, e);
                lambda.set(BudgetEntity::getUseType, (Object)useType);
                lambda.set(BudgetEntity::getUseId, (Object)useId);
                this.update((Wrapper)lambda);
            });
        }
    }

    @Override
    public List<BudgetVO> selectByUseId(Long useId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BudgetEntity::getUseId, (Object)useId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.list((Wrapper)wrapper);
        List budgetVOS = BeanMapper.mapList((Iterable)list, BudgetVO.class);
        return budgetVOS;
    }

    @Override
    public void deleteUseId(List<Long> useId) {
        useId.forEach(e -> {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BudgetEntity::getUseId, e);
            wrapper.set(BudgetEntity::getUseType, null);
            wrapper.set(BudgetEntity::getUseId, null);
            this.update((Wrapper)wrapper);
        });
    }

    @Override
    public BudgetHistoryVO queryBudgetHistory(Long id, Long accountingId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.contractService.selectById(id));
        BudgetHistoryVO historyVO = new BudgetHistoryVO();
        historyVO.setId(entity.getId());
        historyVO.setRegisterId(entity.getId());
        historyVO.setChangeStatus(entity.getChangeStatus());
        historyVO.setIsFinish(entity.getIsFinish());
        historyVO.setIsRelieve(entity.getIsRelieve());
        historyVO.setProjectId(entity.getProjectId());
        historyVO.setIsSuspend(entity.getIsSuspend());
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(BaseEntity::getDr, (Object)0);
        lambd.eq(BudgetEntity::getContractId, (Object)id);
        lambd.in(BudgetEntity::getBillState, new Object[]{1, 3});
        List allList = super.list((Wrapper)lambd);
        BigDecimal allTaxMny = BigDecimal.ZERO;
        BigDecimal allMny = BigDecimal.ZERO;
        BigDecimal allTax = BigDecimal.ZERO;
        if (allList != null && allList.size() > 0) {
            for (BudgetEntity be : allList) {
                allTaxMny = MathUtil.safeAdd(allTaxMny, be.getBudgetTaxMny());
                allMny = MathUtil.safeAdd(allMny, be.getBudgetMny());
                allTax = MathUtil.safeAdd(allTax, be.getBudgetTax());
            }
        }
        historyVO.setAllTaxMny(allTaxMny);
        historyVO.setAllMny(allMny);
        historyVO.setAllTax(allTax);
        return historyVO;
    }

    @Override
    public void relevanceBudget(Long useId, List<Long> ids, String useType) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(BaseEntity::getId, ids);
        wrapper.set(BudgetEntity::getUseId, (Object)useId);
        wrapper.set(BudgetEntity::getUseType, (Object)useType);
        this.update((Wrapper)wrapper);
    }

    @Override
    public void deleteRelevanceBudget(List<Long> ids) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(BaseEntity::getId, ids);
        wrapper.set(BudgetEntity::getUseId, null);
        wrapper.set(BudgetEntity::getUseType, null);
        this.update((Wrapper)wrapper);
    }

    private void sendMsg(BudgetEntity entity) {
        String CODE = "WARNBUDGET001";
        CommonResponse response = this.warnCenterApi.getWarnSet(CODE, entity.getParentOrgId());
        this.logger.info("\u67e5\u8be2\u9884\u8b66\u4e2d\u5fc3\u8bbe\u7f6e\uff1a{} ", (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess()) {
            WarningDTO orgSet = (WarningDTO)response.getData();
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(orgSet.getModuleName() + "-" + entity.getBillCode());
            vo.setPcTitle("\u9879\u76ee\u9884\u7b97\u4e66\u4fee\u8ba2");
            vo.setOrgId(entity.getParentOrgId());
            OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(entity.getParentOrgId()).getData();
            vo.setOrgName(orgVO == null ? "" : orgVO.getName());
            vo.setSendOrgId(entity.getParentOrgId() + "");
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(InvocationInfoProxy.getTenantid());
            vo.setWarnSetId(orgSet.getId());
            vo.setEarlywarnName(orgSet.getName());
            vo.setWarnType(orgSet.getWarnType() + "");
            vo.setWarnLevel(((CustomWarnSettingVO)orgSet.getWarningSetings().get(0)).getWarningLevel());
            vo.setWarnSetParamId(((CustomWarnSettingVO)orgSet.getWarningSetings().get(0)).getId());
            vo.setEarlywarnContent(orgSet.getWarningContentTemplate().replaceAll("#projectName#", entity.getProjectName()).replaceAll("#budgetName#", entity.getBudgetName()));
            ArrayList<EarlyWarnTransVO> earlyWarnTransVOS = new ArrayList<EarlyWarnTransVO>();
            earlyWarnTransVOS.add(vo);
            this.logger.info("\u9884\u8b66\u4e2d\u5fc3\uff1a{} ", (Object)JSONObject.toJSONString(earlyWarnTransVOS));
            CommonResponse warnCenterByCode = this.warnCenterApi.sendToWarnCenterByCode(earlyWarnTransVOS, CODE);
            this.logger.info("\u9884\u8b66\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)warnCenterByCode));
        }
    }
}

