/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.warn;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/settleReportMemoTask/"})
public class SettleReportMemoTask {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettleReportService settleReportService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    private final String MSG_CONTENT = "\u8bf7\u7ef4\u62a4\u9879\u76ee\u5de5\u7a0b\u62a5\u5ba1\u5907\u5fd8\u5f55";
    private final String SYS_ADMIN_EMP_ID = "1247777316689256450";
    private final String SYS_ADMIN_UID = "303581417601122400";

    @PostMapping(value={"memoMaintenance"})
    public CommonResponse<String> memoMaintenance(@RequestParam Integer days, @RequestParam(required=false) String deptCode, @RequestParam(required=false) String roleName) {
        this.logger.info("\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5f85\u7ef4\u62a4\u3010\u5907\u5fd8\u5f55\u3011\u7684\u3010\u7ed3\u7b97\u62a5\u5ba1\u3011\u4efb\u52a1, \u95f4\u9694\u5929\u6570\u3010{}\u3011----START----", (Object)days);
        List<SettleReportEntity> reportEntities = this.settleReportService.checkMemoMaintenance(days);
        if (CollectionUtils.isEmpty(reportEntities)) {
            this.logger.info("\u5f85\u7ef4\u62a4\u5907\u5fd8\u5f55\u7684\u7ed3\u7b97\u62a5\u5ba1\u5217\u8868\u4e3a\u7a7a\uff0c\u672c\u6b21\u4efb\u52a1\u7ed3\u675f----END----");
            return CommonResponse.success((String)"\u5f85\u7ef4\u62a4\u5907\u5fd8\u5f55\u7684\u7ed3\u7b97\u62a5\u5ba1\u5217\u8868\u4e3a\u7a7a\uff0c\u672c\u6b21\u4efb\u52a1\u7ed3\u675f\uff01");
        }
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setSubject("\u8bf7\u7ef4\u62a4\u9879\u76ee\u5de5\u7a0b\u62a5\u5ba1\u5907\u5fd8\u5f55");
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(reportEntities.get(0).getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(Long.valueOf("303581417601122400"));
        msgParameter.setChannel(new String[]{"sys"});
        Map<Long, List<SettleReportEntity>> settleReportGroupByProject = reportEntities.stream().collect(Collectors.groupingBy(SettleReportEntity::getProjectId));
        settleReportGroupByProject.values().stream().forEach(settleReports -> {
            ArrayList recUserIds = new ArrayList();
            msgParameter.setContent("\u8bf7\u7ef4\u62a4\u9879\u76ee\u3010" + ((SettleReportEntity)((Object)((Object)settleReports.get(0)))).getProjectName() + "\u3011\u5de5\u7a0b\u62a5\u5ba1\u5907\u5fd8\u5f55\u3002");
            settleReports.stream().forEach(settleReport -> {
                if ("1247777316689256450".equals(settleReport.getEmployeeId().toString())) {
                    if (!recUserIds.contains("303581417601122400")) {
                        recUserIds.add("303581417601122400");
                    }
                } else if (!recUserIds.contains(settleReport.getEmployeeId().toString())) {
                    recUserIds.add(settleReport.getEmployeeId().toString());
                }
            });
            if (StringUtils.isNotBlank((String)deptCode)) {
                CommonResponse empResp = this.employeeApi.queryEmployeeByDeptCode(deptCode);
                if (!empResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u90e8\u95e8\u7f16\u7801{}\u67e5\u8be2\u5bf9\u5e94\u4eba\u5458\u5217\u8868\u5931\u8d25\uff0c{}, \u8df3\u8fc7\u5bf9\u6307\u5b9a\u89d2\u8272\u4e0b\u7528\u6237\u8fdb\u884c\u53d1\u9001\u6d88\u606f", (Object)deptCode, (Object)JSONObject.toJSONString((Object)empResp));
                } else {
                    ((List)empResp.getData()).forEach(emp -> {
                        if ("1247777316689256450".equals(emp.getId().toString())) {
                            if (!recUserIds.contains("303581417601122400")) {
                                recUserIds.add("303581417601122400");
                            }
                        } else if (!recUserIds.contains(emp.getId().toString())) {
                            recUserIds.add(emp.getId().toString());
                        }
                    });
                }
            }
            if (StringUtils.isNotBlank((String)roleName)) {
                ArrayList<String> roleNames = new ArrayList<String>();
                roleNames.add(roleName);
                CommonResponse userResp = this.userApi.findAllUserByRoleNameList(roleNames);
                if (!userResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u89d2\u8272\u540d\u79f0\uff1a{}\u83b7\u53d6\u7528\u6237\u5217\u8868\u5931\u8d25\uff1a{}, \u8df3\u8fc7\u5bf9\u6307\u5b9a\u89d2\u8272\u4e0b\u7528\u6237\u8fdb\u884c\u53d1\u9001\u6d88\u606f", (Object)roleName, (Object)JSONObject.toJSONString((Object)userResp));
                } else {
                    List users = (List)userResp.getData();
                    if (CollectionUtils.isNotEmpty((Collection)users)) {
                        users.forEach(u -> recUserIds.add(u.getId().toString()));
                    }
                }
            }
            msgParameter.setReceivers(recUserIds.toArray(new String[recUserIds.size()]));
            this.logger.info("\u9879\u76ee[{}]\u5907\u5fd8\u5f55\u63d0\u793a\u4eba\u5458\u5217\u8868: {}", (Object)((SettleReportEntity)((Object)((Object)settleReports.get(0)))).getProjectName(), recUserIds);
            this.pushMessageApi.pushMessage(msgParameter);
        });
        this.logger.info("\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5f85\u7ef4\u62a4\u3010\u5907\u5fd8\u5f55\u3011\u7684\u3010\u7ed3\u7b97\u62a5\u5ba1\u3011\u4efb\u52a1----END----");
        return CommonResponse.success((String)"\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5f85\u7ef4\u62a4\u3010\u5907\u5fd8\u5f55\u3011\u7684\u3010\u7ed3\u7b97\u62a5\u5ba1\u3011\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01");
    }
}

