package com.ejianc.business.pro.income.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.income.bean.QuoteDetailEntity;
/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_quote")
public class QuoteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="quote_date")
    private java.util.Date quoteDate; // 报量时间
    @TableField(value="quote_mny")
    private BigDecimal quoteMny; // 本次上报金额(无税)
    @TableField(value="quote_tax_mny")
    private BigDecimal quoteTaxMny; // 本次上报金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 部门id
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="reply_date")
    private java.util.Date replyDate; // 批复时间
    @TableField(value="reply_status")
    private Integer replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    @TableField(value="reply_mny")
    private BigDecimal replyMny; // 本次批复金额(无税)
    @TableField(value="reply_tax_mny")
    private BigDecimal replyTaxMny; // 本次批复金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="applied_tax_mny")
    private BigDecimal appliedTaxMny; //已申请金额(不含本次)
    @TableField(value="applied_mny")
    private BigDecimal appliedMny; //已申请金额(不含本次)(无税)

    @TableField(value = "financial_org_id")
    private Long financialOrgId; //财务组织Id
    @TableField(value = "financial_org_name")
    private String financialOrgName; //财务组织名称
    @TableField(value = "financial_org_code")
    private String financialOrgCode; //财务组织编码

    @TableField(value = "financial_number")
    private String financialNumber; //凭证号
    @TableField(value = "financial_collect_flag")
    private String financialCrossFlag; //是否传会计平台 1：是； 0：否
    @TableField(value = "bad_debt_provision_type_id")
    private Long badDebtProvisionTypeId; //坏账计提方式Id
    @TableField(value = "bad_debt_provision_type_name")
    private String badDebtProvisionTypeName; //坏账计提方式名称

    @TableField(exist=false)
    @SubEntity(serviceName="quoteDetailService", pidName = "quoteId")
    private List<QuoteDetailEntity> detailList = new ArrayList<>(); // 对甲报量子表

    public Long getFinancialOrgId() {
        return financialOrgId;
    }

    public void setFinancialOrgId(Long financialOrgId) {
        this.financialOrgId = financialOrgId;
    }

    public String getFinancialOrgName() {
        return financialOrgName;
    }

    public void setFinancialOrgName(String financialOrgName) {
        this.financialOrgName = financialOrgName;
    }

    public String getFinancialOrgCode() {
        return financialOrgCode;
    }

    public void setFinancialOrgCode(String financialOrgCode) {
        this.financialOrgCode = financialOrgCode;
    }

    public String getFinancialNumber() {
        return financialNumber;
    }

    public void setFinancialNumber(String financialNumber) {
        this.financialNumber = financialNumber;
    }

    public String getFinancialCrossFlag() {
        return financialCrossFlag;
    }

    public void setFinancialCrossFlag(String financialCrossFlag) {
        this.financialCrossFlag = financialCrossFlag;
    }

    public Long getBadDebtProvisionTypeId() {
        return badDebtProvisionTypeId;
    }

    public void setBadDebtProvisionTypeId(Long badDebtProvisionTypeId) {
        this.badDebtProvisionTypeId = badDebtProvisionTypeId;
    }

    public String getBadDebtProvisionTypeName() {
        return badDebtProvisionTypeName;
    }

    public void setBadDebtProvisionTypeName(String badDebtProvisionTypeName) {
        this.badDebtProvisionTypeName = badDebtProvisionTypeName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(无税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(无税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额(含税)
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 报量时间
     */
    public java.util.Date getQuoteDate() {
        return quoteDate;
    }

    /**
     * 报量时间
     */
    public void setQuoteDate(java.util.Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    /**
     * 本次上报金额(无税)
     */
    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 部门id
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 部门id
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 批复时间
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 批复时间
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public Integer getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 本次批复金额(无税)
     */
    public BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 本次批复金额(无税)
     */
    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 本次批复金额
     */
    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 本次批复金额
     */
    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
    /**
     * 对甲报量子表
     */
    public List<QuoteDetailEntity> getDetailList() {
        return detailList;
    }

    /**
     * 对甲报量子表
     */
    public void setDetailList(List<QuoteDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAppliedTaxMny() {
        return appliedTaxMny;
    }

    public void setAppliedTaxMny(BigDecimal appliedTaxMny) {
        this.appliedTaxMny = appliedTaxMny;
    }

    public BigDecimal getAppliedMny() {
        return appliedMny;
    }

    public void setAppliedMny(BigDecimal appliedMny) {
        this.appliedMny = appliedMny;
    }
}
