package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("finalized") 
public class FinalizedBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IFinalizedService service;
	
	@Autowired
	private IContractRegisterService registerService;
	@Autowired
	private IProjectSetApi projectSetApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		logger.info("终审回写合同状态开始");
		
//		FinalizedEntity entity = service.selectById(billId);

		// 终审的时候回写合同状态为已封账(已终止)
//		if (Objects.equals(FinalStageEnum.终审.getCode(), entity.getFinalStage())) {
//			LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
//			wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.已终止.getCode());
//			wrapper.set(ContractRegisterEntity::getIsFinish, 1);
//			wrapper.eq(ContractRegisterEntity::getId, entity.getContractId());
//			registerService.update(wrapper);
//		}
		
		logger.info("终审回写合同结束");
		
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		FinalizedEntity entity = service.selectById(billId);
//		ContractRegisterEntity contractRegisterEntity = registerService.selectById(entity.getContractId());
//		if ("4".equals(entity.getFinalStage())){
//			if ("sucPushed".equals(contractRegisterEntity.getBillPushFlag())){
//				boolean pushResult = service.pushContract(BeanMapper.map(contractRegisterEntity, ContractRegisterVO.class),"3");
//				if(!pushResult){
//					return CommonResponse.error("推送合同池失败");
//				}
//			}
//			//推送结算池所用vo
//			FinalizedVO settlementVO = BeanMapper.map(entity, FinalizedVO.class);
//			//推送结算池
//			boolean pool = service.pushSettleToPool(settlementVO);
//			if(!pool){
//				return CommonResponse.error("推送结算池失败");
//			}
//
//			// 更新【项目池】对应项目的结算状态为已决算
//			CommonResponse<String> res = projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, "9", null, null);
//			if (!res.isSuccess()) {
//				logger.info("工程定案【{}】更新【项目池】结算状态为已决算失败，失败原因：{}", entity.getBillCode(), res.getMsg());
//				throw new BusinessException("工程定案【" + entity.getBillCode() + "】更新【项目池】结算状态为已决算失败，失败原因：" + res.getMsg());
//			}
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		///结算池撤回
		FinalizedEntity entity = service.selectById(billId);

		if(!"0".equals(entity.getFinalStage())) {
			return CommonResponse.error("操作失败，单据报送后不支持该操作！");
		}

//		ContractRegisterEntity contractRegisterEntity = registerService.selectById(entity.getContractId());
//		if ("4".equals(entity.getFinalStage())) {
//			if ("sucPushed".equals(contractRegisterEntity.getBillPushFlag())){
//				boolean pushResult = service.pushContract(BeanMapper.map(contractRegisterEntity, ContractRegisterVO.class),"2");
//				if(!pushResult){
//					return CommonResponse.error("弃审推送合同池失败");
//				}
//			}
//			boolean pool = service.delSettleFromPool(billId);
//			if(!pool){
//				return CommonResponse.error("弃审推送结算池失败");
//			}
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		logger.info("撤回回写合同终审标识开始");
		FinalizedEntity entity = service.selectById(billId);
		if(!"0".equals(entity.getFinalStage())) {
			return CommonResponse.error("操作失败，单据报送后不支持该操作！");
		}
//
//		// 做过二审，一审不能撤回（包含自由态）
//		LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
//		if (!Objects.equals(null, entity.getProjectId())) {
//			wrapper.eq(FinalizedEntity::getProjectId, entity.getProjectId());
//		}
//		wrapper.eq(FinalizedEntity::getContractId, entity.getContractId());
//		wrapper.ne(BaseEntity::getId, entity.getId());
//		List<FinalizedEntity> list = service.list(wrapper);
//		long count = list.stream().filter(e -> !e.getFinalStage().equals(entity.getFinalStage()))
//				.filter(e -> Integer.parseInt(e.getFinalStage()) > Integer.parseInt(entity.getFinalStage()))
//				.count();
//
//		if (count > 0) {
//			throw new BusinessException("当前合同存在其他定案阶段，不允许撤回！");
//		}
//
//		if (Objects.equals(FinalStageEnum.终审.getCode(), entity.getFinalStage())) {
//			LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
//			updateWrapper.set(ContractRegisterEntity::getIsFinish, 0);
//			updateWrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
//			updateWrapper.eq(ContractRegisterEntity::getId, entity.getContractId());
//			registerService.update(updateWrapper);
//		}
		
		logger.info("撤回回写合同终审标识开始");
		
		return CommonResponse.success();
	}

}
