package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterResVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
//import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractRegister")
public class ContractRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IContractReviewService contractReviewService;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveorUpdateVO) {

    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }


    /**
     * @param projectId
     * @Description queryRegisterVO 根据项目查询施工合同+ 施工评审详情
     */
    @RequestMapping(value = "/queryRegisterVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterResVO> queryRegisterVO(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId,projectId);
        lambda.in(ContractRegisterEntity::getBillState,1,3);
        List<ContractRegisterEntity> list = service.list(lambda);
        RegisterResVO registerResVO = new RegisterResVO();
        if(CollectionUtils.isNotEmpty(list)){
            registerResVO = BeanMapper.map(list.get(0),RegisterResVO.class);
            registerResVO.setContractBaseMny(list.get(0).getBaseMoney());
            registerResVO.setContractBaseTaxMny(list.get(0).getBaseTaxMoney());
            registerResVO.setContractId(list.get(0).getId());
        }
        LambdaQueryWrapper<ContractReviewEntity> lambda2 = Wrappers.<ContractReviewEntity>lambdaQuery();
        lambda2.eq(ContractReviewEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ContractReviewEntity::getProjectId,projectId);
        lambda2.in(ContractReviewEntity::getBillState,1,3);
        List<ContractReviewEntity> list2 = contractReviewService.list(lambda2);
        if(CollectionUtils.isNotEmpty(list2)){
            ContractReviewEntity contractReviewEntity =  list2.get(0);
            registerResVO.setEngineeringTypeId(contractReviewEntity.getEngineeringTypeId());
            registerResVO.setEngineeringTypeName(contractReviewEntity.getEngineeringTypeName());
            registerResVO.setBuiltArea(contractReviewEntity.getBuiltArea());
            registerResVO.setContractualModel(contractReviewEntity.getContractualModel());
            registerResVO.setStartDate(contractReviewEntity.getStartDate());
            registerResVO.setEndDate(contractReviewEntity.getEndDate());
            registerResVO.setFundsSourceId(contractReviewEntity.getFundsSourceId());
            registerResVO.setFundsSource(contractReviewEntity.getFundsSource());
            registerResVO.setAddress(contractReviewEntity.getAddress());
        }
        return CommonResponse.success("查询详情数据成功！", registerResVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
    	ContractRegisterEntity entity = service.selectById(id);
    	ContractRegisterVO vo = BeanMapper.map(entity, ContractRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        service.removeByIds(vos.stream().map(ContractRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }

    /**
     * @param projectId
     * @Description queryRegisterVO 根据项目查询施工合同+ 施工评审详情
     */
    //@RequestMapping(value = "/queryRegisterVO", method = RequestMethod.GET)
    //@ResponseBody
    //public CommonResponse<RegisterResVO> queryRegisterVO(Long projectId) {
    //    LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
    //    lambda.eq(ContractRegisterEntity::getTenantId,InvocationInfoProxy.getTenantid());
    //    lambda.eq(ContractRegisterEntity::getProjectId,projectId);
    //    lambda.in(ContractRegisterEntity::getBillState,1,3);
    //    List<ContractRegisterEntity> list = service.list(lambda);
    //    RegisterResVO registerResVO = new RegisterResVO();
    //    if(CollectionUtils.isNotEmpty(list)){
    //        registerResVO = BeanMapper.map(list.get(0),RegisterResVO.class);
    //        registerResVO.setContractBaseMny(list.get(0).getBaseMoney());
    //        registerResVO.setContractBaseTaxMny(list.get(0).getBaseTaxMoney());
    //        registerResVO.setContractId(list.get(0).getId());
    //    }
    //    LambdaQueryWrapper<ContractReviewEntity> lambda2 = Wrappers.<ContractReviewEntity>lambdaQuery();
    //    lambda2.eq(ContractReviewEntity::getTenantId,InvocationInfoProxy.getTenantid());
    //    lambda2.eq(ContractReviewEntity::getProjectId,projectId);
    //    lambda2.in(ContractReviewEntity::getBillState,1,3);
    //    List<ContractReviewEntity> list2 = contractReviewService.list(lambda2);
    //    if(CollectionUtils.isNotEmpty(list2)){
    //        ContractReviewEntity contractReviewEntity =  list2.get(0);
    //        registerResVO.setEngineeringTypeId(contractReviewEntity.getEngineeringTypeId());
    //        registerResVO.setEngineeringTypeName(contractReviewEntity.getEngineeringTypeName());
    //        registerResVO.setBuiltArea(contractReviewEntity.getBuiltArea());
    //        registerResVO.setContractualModel(contractReviewEntity.getContractualModel());
    //        registerResVO.setStartDate(contractReviewEntity.getStartDate());
    //        registerResVO.setEndDate(contractReviewEntity.getEndDate());
    //        registerResVO.setFundsSourceId(contractReviewEntity.getFundsSourceId());
    //        registerResVO.setFundsSource(contractReviewEntity.getFundsSource());
    //        registerResVO.setAddress(contractReviewEntity.getAddress());
    //    }
    //    return CommonResponse.success("查询详情数据成功！", registerResVO);
    //}


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractRegisterVO> list = service.excelExport(param);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        ExcelExport.getInstance().export("contract-register-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refContractRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("supplementFlag", new Parameter("eq", 0));
        param.getParams().put("isFinish", new Parameter("eq", 0));
        param.getParams().put("isRelieve", new Parameter("eq", 0));
        param.getParams().put("isSuspend", new Parameter("eq", 0));
        param.getParams().put("isEstimation", new Parameter("eq", 0)); // 过滤暂估合同，只查询正式合同

        List<String> changeStatusList = new ArrayList<>();
        changeStatusList.add("1");
        changeStatusList.add("3");
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, changeStatusList));

        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinish")) {
                boolean isFinish = Boolean.parseBoolean(conditionMap.get("isFinish").toString());
                if (!isFinish) {
                    param.getParams().remove("isFinish");
                }
            }
            if (!Objects.equals(conditionMap.get("isRelieve"), null)) {
                boolean isRelieve = Boolean.parseBoolean(conditionMap.get("isRelieve").toString());
                if (!isRelieve) {
                    param.getParams().remove("isRelieve");
                }
            }
            if (!Objects.equals(conditionMap.get("isBudget"), null)) {
                boolean isBudget = Boolean.parseBoolean(conditionMap.get("isBudget").toString());
                if (!isBudget) {
                    param.getParams().remove("changeStatus");
                }
            }
        }

        if(null == param.getParams().get("projectId")) {
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractRegisterEntity> page = service.queryPage(param,false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 新增补充协议时根据评审id查询详情
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/addRegisterByRevId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addRegisterByRevId(Long reviewId) {
        return CommonResponse.success("新增转换数据成功！", service.addRegisterByRevId(reviewId));
    }

    /**
     * 新增补充协议时根据合同id查询详情
     * @param mainContractId
     * @return
     */
    @RequestMapping(value = "/addSupplementByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addSupplementByConId(Long mainContractId) {
        ContractRegisterVO vo = service.addSupplementByConId(mainContractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterSupplementHistoryVO> querySupplementRecord(@RequestParam Long id) {
        RegisterSupplementHistoryVO vo = service.querySupplementRecord(id);
        return CommonResponse.success(vo);
    }

    /**
     * 新增补充协议评审时校验主合同是否做过登记，并且是审批通过态
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/queryRegisterByReviewId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractRegisterEntity>> queryRegisterByReviewId(@RequestParam Long reviewId) {
        return CommonResponse.success("查询数据成功", service.queryRegisterByReviewId(reviewId));
    }

    /**
     * 同步合同池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushContract")
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value = "id") Long id) {
        ContractRegisterEntity registerEntity = service.selectById(id);
        ContractRegisterVO vo = BeanMapper.map(registerEntity, ContractRegisterVO.class);

        return CommonResponse.success("同步合同池成功！", service.pushContract(vo, false));
    }

    /**
     * 根据项目查询合同评审
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryReviewByProject")
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryReviewByProject(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("同步合同池成功！", service.queryReviewByProject(projectId));
    }

    /**
     * @param projectId
     * @Description queryRegisterVO 根据项目查询施工合同数据
     */
    @RequestMapping(value = "/queryContractVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryContractVO(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId,projectId);
        lambda.in(ContractRegisterEntity::getBillState,1,3);
        lambda.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> list = service.list(lambda);
        ContractRegisterVO result = new ContractRegisterVO();
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.success("未查询到该项目下生效施工合同！", result);
        }
        result = BeanMapper.map(list.get(0), ContractRegisterVO.class);
        result.setContractMny(list.stream().map(x->x.getContractMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        result.setContractTaxMny(list.stream().map(x->x.getContractTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        return CommonResponse.success("查询详情数据成功！", result);
    }
}
