package com.ejianc.business.pro.home.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.home.service.IHomePortalService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 门户首页 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@RestController
@RequestMapping("/homePortal")
public class HomePortalController {

    @Autowired
    private IHomePortalService service;

    /**
     * 产值甲方批复回款台账
     * @param param
     * month-月份，projectStatus-项目状态：项目状态：1、在建 2、停缓建 3、竣工验收 4、已完工 5、其他，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/productReplyReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReport(@RequestBody QueryParam param) {
        JSONObject result = service.productReplyReport(param);
        return CommonResponse.success(result);
    }

    /**
     * 产值甲方批复回款台账导出
     * @param param
     * month-月份，projectStatus-项目状态：项目状态：1、在建 2、停缓建 3、竣工验收 4、已完工 5、其他，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/productReplyReportExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject result = service.productReplyReport(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result.getJSONArray("records"));
        ExcelExport.getInstance().export("production-reply-export.xlsx", beans, response);
        return CommonResponse.success(result);
    }

}

