package com.ejianc.business.pro.other.service.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ImportContractVO;
import com.ejianc.business.pro.other.enums.OtherContractStatusEnum;
import com.ejianc.business.pro.other.vo.ImportOtherContractVO;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.other.mapper.OtherContractMapper;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.service.IOtherContractService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService{

    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_CONTRACT";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IContractPoolApi contractPoolApi;


    @Override
    public OtherContractVO saveOrUpdate(OtherContractVO otherContractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = BeanMapper.map(otherContractVO, OtherContractEntity.class);
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
            }
        }else{
            //新增
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_BILL_CODE, tenantId, otherContractVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
//            entity.setContractStatus("1");
            //新增设置 竣工结算标志
            entity.setIsFinish(0);
        }
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, otherContractVO.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setIsSuspend(0);
        entity.setIsRelieve(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        this.saveOrUpdate(entity,false);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        return vo;
    }


    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    /**
     * 获取合同签订时间
     * @param id
     * @return
     */
    @Override
    public Date getSignDate(Long id) {
        return contractMapper.getSignDate(id);
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = contractMapper.selectById(id);
        OtherContractVO otherContractVO = BeanMapper.map(entity, OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setSupplierId(otherContractVO.getSupplierId());
        vo.setSupplierName(otherContractVO.getSupplierName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }


    @Override
    public boolean pushContract(OtherContractVO vo,Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            if(updateLevel){ // 更新
                delContractFromPool(vo.getId());
            }
            if("1".equals(vo.getContractStatus())){
                data.setPerformanceStatus("1");
            }
            if("2".equals(vo.getContractStatus())){
                data.setPerformanceStatus("2");
            }
            if("3".equals(vo.getContractStatus())){
                data.setPerformanceStatus("3");
            }
            if("4".equals(vo.getContractStatus())){
                data.setPerformanceStatus("5");
            }
            if("5".equals(vo.getContractStatus())){
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.其他收入合同.getTypeCode());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/otherContract/otherContractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-proincome-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            }
            data.setPcCardUrl(url);
            data.setCategoryId(1524002474627813378L);// 其他收入合同类别为空，合同池写死
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public CommonResponse<JSONObject> excelImportProMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, OtherContractEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();

        Map<String, ContractReviewEntity> contractReviewEntityMap = new HashMap<>();

//        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportOtherContractVO> successList = new ArrayList<>();
            List<ImportOtherContractVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 12) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportOtherContractVO detailVO = new ImportOtherContractVO();
                    // 从Excel拿到的数据

                    String contractCodeEx = datas.get(0);// 合同编码，非必填
                    detailVO.setBillCode(contractCodeEx);
                    String contractNameEx = datas.get(1);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String projectNameEx = datas.get(2);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String partyaNameEx = datas.get(3);// 合同甲方，必填项，与【客户库】的“客户名称”进行匹配，如果匹配多了，就提示
                    detailVO.setCustomerName(partyaNameEx);
                    String partybNameEx = datas.get(4);// 合同乙方，必填项，与【供应商库】的“供应商名称”进行匹配，如果匹配多了，就提示
                    detailVO.setSupplierName(partybNameEx);
                    String supplierEmployeeName = datas.get(5); //乙方经办人,必填
                    detailVO.setSupplierEmployeeName(supplierEmployeeName);
                    String supplierEmployeeMobile = datas.get(6);//乙方电话，必填
                    detailVO.setSupplierEmployeeMobile(supplierEmployeeMobile);
                    String signDateStrEx = datas.get(7);// 签订日期，必填项，日期
                    String taxRateEx = datas.get(8);// 税率，数值，必填项，大于等于0，保留2位小数
                    String contractStatus = datas.get(9); //合同履约状态,当计租方式为月租时必填
                    detailVO.setContractStatus(contractStatus);
                    String employeeName = datas.get(10); //经办人,必填
                    detailVO.setEmployeeName(employeeName);
                    String memoEx = datas.get(11);// 备注，非必填
                    detailVO.setMemo(memoEx);
                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }
                    detailVO.setBillCode(contractCodeEx);
                    // 项目名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    }else{
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                }else{
                                    if (projectVOList.size() == 1) {
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        Long orgId = projectPoolSetVO.getOrgId();
                                        String orgCode = projectPoolSetVO.getOrgCode();
                                        String orgName = projectPoolSetVO.getOrgName();
                                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                        detailVO.setOrgId(projectDepartmentId1);
                                        detailVO.setOrgCode(projectDepartmentCode);
                                        detailVO.setOrgName(projectDepartmentName);
                                        detailVO.setParentOrgId(orgId);
                                        detailVO.setParentOrgCode(orgCode);
                                        detailVO.setParentOrgName(orgName);
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                    }else{
                                        detailVO.setErrorMessage("根据项目名称查询到多个项目信息");
                                    }
//
                                }
                            }else{
                                detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                            }
                        }else{
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            Long orgId = projectPoolSetVO.getOrgId();
                            String orgCode = projectPoolSetVO.getOrgCode();
                            String orgName = projectPoolSetVO.getOrgName();
                            Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                            String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                            String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                            detailVO.setOrgId(projectDepartmentId1);
                            detailVO.setOrgCode(projectDepartmentCode);
                            detailVO.setOrgName(projectDepartmentName);
                            detailVO.setParentOrgId(orgId);
                            detailVO.setParentOrgCode(orgCode);
                            detailVO.setParentOrgName(orgName);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        }
                    }

                    // 合同甲方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyaNameEx)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(partyaNameEx,tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partyaNameEx, orgVO);
                                    // 封装数据
                                    detailVO.setCustomerId(orgVO.getId());
                                    detailVO.setCustomerName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(partyaNameEx);
                            detailVO.setCustomerId(orgVO.getId());
                            detailVO.setCustomerName(orgVO.getName());

                        }
                    }
                    // 合同乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partybNameEx)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【供应商库】的“供应商名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<SupplierVO> supplierVORes = shareSupplierApi.findOneByName(partybNameEx, tenantid);
                            if (supplierVORes.isSuccess()) {
                                SupplierVO supplierVO = supplierVORes.getData();
                                if (supplierVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partybNameEx, supplierVO);
                                    // 封装数据

                                    detailVO.setSupplierId(supplierVO.getId());
                                    detailVO.setSupplierName(supplierVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO supplierVO = supplierVOMap.get(partybNameEx);

                            detailVO.setSupplierId(supplierVO.getId());
                            detailVO.setSupplierName(supplierVO.getName());
                        }
                    }

                    //乙方经办人
                    if (StringUtils.isBlank(supplierEmployeeName)){
                        detailVO.setErrorMessage("乙方经办人不能为空");
                    }else{
                        detailVO.setSupplierEmployeeName(supplierEmployeeName);
                    }

                    //乙方联系人
                    if (StringUtils.isBlank(supplierEmployeeMobile)){
                        detailVO.setErrorMessage("乙方经办人电话不可为空");
                    }else{
                        detailVO.setSupplierEmployeeMobile(supplierEmployeeMobile);
                    }

                    // 签订日期
                    if (org.apache.commons.lang3.StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRateEx)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate = new BigDecimal(taxRateEx);
                            if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }
                    //经办人
                    if (StringUtils.isBlank(employeeName)){
                        detailVO.setErrorMessage("经办人不可为空");
                    }else{
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName)==null){
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                            if (map.isSuccess() && null != map.getData()){
                                Map<String, EmployeeVO> employee = map.getData();
                                if (MapUtils.isEmpty(employee) || employee.get(employeeName)==null){
                                    detailVO.setErrorMessage("经办人不存在");
                                }else{
                                    EmployeeVO employeeVO = employee.get(employeeName);
                                    detailVO.setEmployeeId(employeeVO.getId());
                                    detailVO.setEmployeeName(employeeVO.getName());
                                    detailVO.setDeptId(employeeVO.getDeptId());
                                    detailVO.setDeptName(employeeVO.getDeptName());
                                }
                            }
                        }else{
                            EmployeeVO employeeVO = employeeVOMap.get(employeeName);
                            detailVO.setEmployeeId(employeeVO.getId());
                            detailVO.setEmployeeName(employeeVO.getName());
                            detailVO.setDeptId(employeeVO.getDeptId());
                            detailVO.setDeptName(employeeVO.getDeptName());
                        }
                    }
                    //合同履约状态
                    if (org.apache.commons.lang.StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else{
                        if (org.apache.commons.lang3.StringUtils.isBlank(contractStatus)){
                            detailVO.setContractStatus(OtherContractStatusEnum.未签订.getCode());
                        }
                        if (OtherContractStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(OtherContractStatusEnum.未签订.getCode());
                        } else if (OtherContractStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(OtherContractStatusEnum.履约中.getCode());
                        } else if (OtherContractStatusEnum.已封账.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(OtherContractStatusEnum.已封账.getCode());
                        } else if (OtherContractStatusEnum.已解除.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(OtherContractStatusEnum.已解除.getCode());
                        } else if (OtherContractStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(OtherContractStatusEnum.已冻结.getCode());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }


                    // 备注
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(memoEx) && memoEx.length() > 100) {
                        detailVO.setErrorMessage("备注长度不可大于100");
                    } else {
                        detailVO.setMemo(memoEx);
                    }
                    // 封装返回的数据
                    if (org.apache.commons.lang3.StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
                    detailVO.setChangeStatus("1");
                    detailVO.setSupplementFlag(0);
                    detailVO.setIsSuspend(0);
                    detailVO.setIsRelieve(0);
//                    detailVO.setSupplementFlagName("否");
//                    detailVO.setFilingStatus(0);
//                    detailVO.setSignatureStatus("1");
//                    detailVO.setDraftType("3");
//                    detailVO.setPurchaseType("1");
                }


            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<OtherContractVO> sucVoList = BeanMapper.mapList(successList, OtherContractVO.class);
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (CollectionUtils.isNotEmpty(sucVoList)) {
                for (OtherContractVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = IdWorker.getId();
//                   vo.setContractId(contractId);
//                   vo.setSourceId(contractId);
                    if (org.apache.commons.lang3.StringUtils.isBlank(vo.getBillCode())) {
                        BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_BILL_CODE, tenantId, vo);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            vo.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        }else{
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                }
                List<OtherContractEntity> sucEntityList = BeanMapper.mapList(sucVoList, OtherContractEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }


}
