package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.GeneralDetailVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.GeneralMapper;
import com.ejianc.business.pro.income.bean.GeneralEntity;
import com.ejianc.business.pro.income.service.IGeneralService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 总包结算计划主表
 *
 * @author generator
 */
@Service("generalService")
public class GeneralServiceImpl extends BaseServiceImpl<GeneralMapper, GeneralEntity> implements IGeneralService {

    @Autowired
    private IProjectPoolApi projectPoolApi;

    /*
     * 数据导入
     * */
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request,
                                                  HttpServletResponse response, Integer flg) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        // 获取文件存储信息
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        //租户ID
        Long tenantId = InvocationInfoProxy.getTenantid();
        //判断文件格式是否正确
        boolean isFailed = false;
        //获取文件数据
        MultipartFile mf = null;
        //遍历文件,校验格式是否正确
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            //获取文件所有内容
            mf = entity.getValue();
            //获取文件名
            String originalFileName = mf.getOriginalFilename();
            // 替换文件名中的非法字符
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        if (mf == null) {
            throw new BusinessException("导入的文件中没有数据");
        }
        // 获取文件数据
        List<List<String>> result = ExcelReader.readExcel(mf);
        //解析成功的数据
        List<GeneralDetailVO> successList = new ArrayList<>();
        //解析失败的数据
        List<GeneralDetailVO> errorList = new ArrayList<>();
        //检查获取的数据
        if (result == null || result.isEmpty()) {
            throw new BusinessException("数据表格错误");
        }
        if (result.get(0).size() != 10) {
            throw new BusinessException("请按照导入模板导入数据");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
        }
        for (int i = 2; i < result.size(); i++) {
            //生产唯一ID 雪花算法
            long id = IdWorker.getId();
            GeneralDetailVO vo = new GeneralDetailVO();
            vo.setId(id);
            List<String> datas = result.get(i);
            //获取项目名称
            String contractNameEx = datas.get(0);
            //获取项目池项目数据
            CommonResponse<List<ProjectPoolSetVO>> commonResponse =
                    projectPoolApi.queryProjectListByNameAndTenantId(contractNameEx, tenantId);
            if (!commonResponse.isThisTimeDone()) {
                errorMessage(vo, contractNameEx, errorList, "未找到项目池项目数据");
                continue;
            }
            List<ProjectPoolSetVO> projectPoolSetVOList = commonResponse.getData();
            if (projectPoolSetVOList == null || projectPoolSetVOList.isEmpty()) {
                errorMessage(vo, contractNameEx, errorList, "未找到项目池项目数据");
                continue;
            }
            if (projectPoolSetVOList.size() > 1) {
                errorMessage(vo, contractNameEx, errorList, "项目池项目数据重复");
                continue;
            }
            List<ProjectPoolSetVO> data = commonResponse.getData();
            ProjectPoolSetVO setVO = data.get(0);
            vo.setProjrctName(contractNameEx);
            vo.setProjectId(setVO.getProjectId());
            //合同金额
            //ProjectPoolSetVO setVO = null;
            try {
                //setVO = projectPoolSetVOList.get(0);
                String amount = setVO.getContractAmount();
                if(amount == null){
                    amount = datas.get(1);
                }
                BigDecimal decimal = BigDecimal.valueOf(Double.parseDouble(amount));
                vo.setContractTaxMny(decimal);
            } catch (Exception e) {
                errorMessage(vo, contractNameEx, errorList, "合同金额查询错误");
                continue;
            }
            //竣工日期
            try {
                String actualEndDate = datas.get(2);
                if (setVO.getActualEndDate() == null) {
                    Date date = convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                    vo.setConstructionTime(date);
                } else {
                    vo.setConstructionTime(setVO.getActualEndDate());
                }
                if (datas.get(4) != null) {
                    //一审完成
                    actualEndDate = datas.get(4);
                    Date date = convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                    vo.setFirstTime(date);
                }
                //报出时间
                if (datas.get(3) != null) {
                    actualEndDate = datas.get(3);
                    Date date = convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                    vo.setSettlementTime(date);
                }
                //终审完成
                if (datas.get(5) != null) {
                    actualEndDate = datas.get(5);
                    Date date = convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                    vo.setFinalTime(date);
                }
            } catch (Exception e) {
                errorMessage(vo, contractNameEx, errorList, "竣工日期查询错误");
                continue;
            }
            //项目责任人
            vo.setProjectUser(datas.get(6));
            //分公司协助人
            vo.setBranchUser(datas.get(7));
            //建司督责人
            vo.setSupervisesUser(datas.get(8));
            //备注
            vo.setMemo(datas.get(9));
            successList.add(vo);
        }
        //失败的数据不入数据表格，返回前端查看错误原因
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        //统计金额,计算个数
        long settlementNums = 0,firstNums = 0,finalNums = 0;
        BigDecimal contractTaxMny = new BigDecimal(0);
        for (GeneralDetailVO vo : successList) {
            //合计金额
            if (vo.getContractTaxMny() != null) {
                contractTaxMny = MathUtil.safeAdd(contractTaxMny, vo.getContractTaxMny());
            }
            if(vo.getFirstTime() != null){
                firstNums++;
            }else if(vo.getFinalTime() != null){
                finalNums++;
            }else {
                settlementNums++;
            }
        }
        //统计个数
        json.put("settlementNums", settlementNums);
        json.put("firstNums", firstNums);
        json.put("finalNums", finalNums);
        json.put("contractTaxMny", contractTaxMny);
        // 返回数据信息
        return CommonResponse.success(json);
    }

    private static void errorMessage(GeneralDetailVO vo,
                                     String contractNameEx,
                                     List<GeneralDetailVO> errorList,
                                     String errorMessage) {
        vo.setErrorMessage(errorMessage);
        vo.setProjrctName(contractNameEx);
        errorList.add(vo);
    }
    /**
     * 将Excel数字日期转换为Java Date对象
     * @param excelDate Excel中的数字日期(如34)
     * @return 对应的Date对象
     */
    public static Date convertExcelDateToJavaDate(int excelDate) {
        // Excel的日期系统从1900年1月1日开始(Excel错误地认为1900年是闰年)
        Calendar calendar = Calendar.getInstance();

        // 设置基准日期为1900年1月1日
        // 注意: Excel错误地将1900年视为闰年，所以1900年2月28日之后的所有日期在Excel中都比实际多1天
        calendar.set(1900, Calendar.JANUARY, 1);

        // 减去2天来修正Excel的日期系统错误
        // 因为Excel认为1900年2月29日是有效日期(实际上不是)
        calendar.add(Calendar.DAY_OF_MONTH, excelDate - 2);

        return calendar.getTime();
    }
}
