/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.arch.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.arch.bean.ArchitectEntity;
import com.ejianc.business.pro.arch.mapper.ArchitectMapper;
import com.ejianc.business.pro.arch.service.IArchitectService;
import com.ejianc.business.pro.arch.utils.DetailIndexExcelReader2;
import com.ejianc.business.pro.arch.vo.ArchitectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="architectService")
public class ArchitectServiceImpl
extends BaseServiceImpl<ArchitectMapper, ArchitectEntity>
implements IArchitectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ARC_N_C";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result != null && result.size() > 0) {
            ArrayList<ArchitectEntity> arcList = new ArrayList<ArchitectEntity>();
            Map<Object, Object> collect = new HashMap();
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-mm-dd");
            CommonResponse defDocByDefId = this.defdocApi.getDefDocByDefId(Long.valueOf(744509734572658785L));
            if (!defDocByDefId.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List ddd = (List)defDocByDefId.getData();
            collect = ddd.stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            CommonResponse oneById = this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId());
            if (!oneById.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            OrgVO data = (OrgVO)oneById.getData();
            for (int i = 0; i < result.size(); ++i) {
                Object date;
                List<String> datas = result.get(i);
                ArchitectVO architectVO = new ArchitectVO();
                boolean flag = false;
                String warnType = "";
                if (StringUtils.isNotBlank((CharSequence)datas.get(0))) {
                    String name = datas.get(0);
                    architectVO.setName(name);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(1))) {
                    String idCard = datas.get(1);
                    architectVO.setIdCard(idCard);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(2))) {
                    String sex = datas.get(2);
                    architectVO.setSex("\u7537".equals(sex) ? "1" : "2");
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(3))) {
                    String age = datas.get(3);
                    architectVO.setUserAge(Integer.valueOf(Integer.parseInt(age)));
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(4))) {
                    String architectMajorName = datas.get(4);
                    architectVO.setArchitectMajorName(architectMajorName);
                    architectVO.setArchitectMajor((Long)collect.get(architectMajorName));
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(5))) {
                    String registrationNumber = datas.get(5);
                    architectVO.setRegistrationNumber(registrationNumber);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(6))) {
                    String validity = datas.get(6);
                    date = null;
                    try {
                        date = ft.parse(validity);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    architectVO.setValidity((Date)date);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(7))) {
                    String certificateNumber = datas.get(7);
                    architectVO.setCertificateNumber(certificateNumber);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(8))) {
                    String certificateValidity = datas.get(8);
                    date = null;
                    try {
                        date = ft.parse(certificateValidity);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    architectVO.setCertificateValidity((Date)date);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(9))) {
                    String titleLevel = datas.get(9);
                    switch (titleLevel) {
                        case "\u6b63\u9ad8\u7ea7": {
                            architectVO.setTitleLevel("0");
                            break;
                        }
                        case "\u526f\u9ad8\u7ea7": {
                            architectVO.setTitleLevel("1");
                            break;
                        }
                        case "\u4e2d\u7ea7": {
                            architectVO.setTitleLevel("2");
                            break;
                        }
                        case "\u521d\u7ea7": {
                            architectVO.setTitleLevel("3");
                            break;
                        }
                        case "\u5458\u7ea7": {
                            architectVO.setTitleLevel("4");
                            break;
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(10))) {
                    String addItemOne = datas.get(10);
                    architectVO.setAddItemOne(addItemOne);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(11))) {
                    String addItemTwo = datas.get(11);
                    architectVO.setAddItemTwo(addItemTwo);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(12))) {
                    String addItemThree = datas.get(12);
                    architectVO.setAddItemThree(addItemThree);
                }
                if (StringUtils.isNotBlank((CharSequence)datas.get(13))) {
                    String memo = datas.get(13);
                    architectVO.setMemo(memo);
                }
                architectVO.setEmployeeId(InvocationInfoProxy.getUserid());
                architectVO.setEmployeeName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                architectVO.setBillState(Integer.valueOf(1));
                architectVO.setOrgId(InvocationInfoProxy.getOrgId());
                architectVO.setOrgName(data.getName());
                ArchitectEntity entity = (ArchitectEntity)((Object)BeanMapper.map((Object)architectVO, ArchitectEntity.class));
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)architectVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
                arcList.add(entity);
            }
            super.saveOrUpdateBatch(arcList);
        }
        return null;
    }
}

