package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.CompositiveCoefficientEntity;
import com.ejianc.business.pro.income.mapper.CompositiveCoefficientMapper;
import com.ejianc.business.pro.income.service.ICompositiveCoefficientService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 综合系数实体类
 * 
 * @author generator
 * 
 */
@Service("compositiveCoefficientService")
public class CompositiveCoefficientServiceImpl extends BaseServiceImpl<CompositiveCoefficientMapper, CompositiveCoefficientEntity> implements ICompositiveCoefficientService{

    @Override
    public List<CompositiveCoefficientEntity> getByNames(Set<String> compositiveCoefficientNames) {
        QueryWrapper<CompositiveCoefficientEntity> query = new QueryWrapper<>();
        query.in("name", compositiveCoefficientNames);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(query);
    }
}
