/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.GeneralEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.mapper.FinalizedMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IGeneralService;
import com.ejianc.business.pro.income.utils.CommonUtils;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.GeneralDetailVO;
import com.ejianc.business.pro.income.vo.SettleAnalysisVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"finalized"})
public class FinalizedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinalizedService service;
    @Autowired
    private IGeneralService generalService;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private FinalizedMapper finalizedMapper;

    @GetMapping(value={"contractByProject"})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> contractByProject(@RequestParam Long projectId) {
        ContractRegisterVO resp = null;
        List<ContractRegisterVO> contractList = this.contractRegisterService.getAllValidConsByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(contractList)) {
            for (ContractRegisterVO con : contractList) {
                if (null == resp) {
                    resp = con;
                    continue;
                }
                resp.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)resp.getContractTaxMny(), (BigDecimal)con.getContractTaxMny()));
                resp.setContractMny(ComputeUtil.safeAdd((BigDecimal)resp.getContractMny(), (BigDecimal)con.getContractMny()));
            }
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getByProjectId"})
    @ResponseBody
    public CommonResponse<FinalizedVO> getByProjectId(@RequestParam Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        List list = this.service.list((Wrapper)query);
        return CommonResponse.success(CollectionUtils.isNotEmpty((Collection)list) ? (FinalizedVO)BeanMapper.map(list.get(0), FinalizedVO.class) : null);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)entity), FinalizedVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("diffDateType")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String todayStr = sdf.format(new Date());
            switch (((Parameter)param.getParams().get("diffDateType")).getValue().toString()) {
                case "0": {
                    param.getParams().put("finalStage", Parameter.getEqInstance((Object)"0"));
                    break;
                }
                case "1": {
                    param.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >=0 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 365")));
                    break;
                }
                case "2": {
                    param.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >365 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 1095")));
                    break;
                }
                case "3": {
                    param.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') > 1095")));
                    break;
                }
            }
            param.getParams().remove("diffDateType");
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
        for (FinalizedVO f : pageData.getRecords()) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
                Integer days;
                if ("0".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("\u672a\u62a5\u9001" + (days > 60 ? "(\u5df2\u8d85" + (days - 60) + "\u5929)" : ""));
                    continue;
                }
                if ("1".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("\u4e00\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                    continue;
                }
                if ("2".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getFirstInstanceDate());
                    f.setFinalStageName("\u7ec8\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                    continue;
                }
                f.setFinalStageName("\u7ec8\u5ba1\u5b8c\u6210");
                continue;
            }
            f.setFinalStageName("\u672a\u62a5\u9001");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("diffDateType")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String todayStr = sdf.format(new Date());
            param.getParams().put("billState", Parameter.getInInstance((Object)new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
            param.getParams().put("finalStage", Parameter.getInInstance((Object)new String[]{"1", "2"}));
            switch (((Parameter)param.getParams().get("diffDateType")).getValue().toString()) {
                case "0": {
                    param.getParams().put("finalStage", Parameter.getEqInstance((Object)"0"));
                    break;
                }
                case "1": {
                    param.getParams().put("finalInstanceDate", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >=0 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 365")));
                    break;
                }
                case "2": {
                    param.getParams().put("finalInstanceDate", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >365 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 1095")));
                    break;
                }
                case "3": {
                    param.getParams().put("finalInstanceDate", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') > 1095")));
                    break;
                }
            }
            param.getParams().remove("diffDateType");
        }
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, FinalizedVO.class);
        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
        for (FinalizedVO f : voList) {
            if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
                Integer days;
                if ("0".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("\u672a\u62a5\u9001" + (days > 60 ? "(\u5df2\u8d85" + (days - 60) + "\u5929)" : ""));
                } else if ("1".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("\u4e00\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                } else if ("2".equals(f.getFinalStage())) {
                    days = DateUtil.getSubDay(today, f.getFirstInstanceDate());
                    f.setFinalStageName("\u7ec8\u5ba1\u4e2d" + (days > 180 ? "(\u5df2\u8d85" + (days - 180) + "\u5929)" : ""));
                } else {
                    f.setFinalStageName("\u7ec8\u5ba1\u5b8c\u6210");
                }
            } else {
                f.setFinalStageName("\u672a\u62a5\u9001");
            }
            f.setBillStateName(BillStateEnum.getEnumByStateCode(f.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFinalizedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySettleReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required=false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.querySettleReport(projectId, contractId));
    }

    @RequestMapping(value={"/queryFinalizedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedList(projectId, contractId, id));
    }

    @RequestMapping(value={"/validateFinalStage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    @RequestMapping(value={"/queryFinalizedRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryFinalizedRecord(id));
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        FinalizedEntity finalizedEntity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)finalizedEntity), FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())) {
            boolean pool = this.service.pushSettleToPool(vo);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        } else {
            return CommonResponse.success((String)"\u65e0\u9700\u63a8\u9001\uff01", (Object)true);
        }
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)true);
    }

    @ApiOperation(value="\u603b\u5305\u7ed3\u7b97-\u6210\u672c\u95e8\u6237")
    @RequestMapping(value={"/queryAllSettleList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SettleAnalysisVO>> queryAllSettleList(@RequestParam String year, @RequestParam(value="orgId", required=false) Long orgId) throws ParseException {
        ArrayList<SettleAnalysisVO> analysisVOList = new ArrayList<SettleAnalysisVO>();
        SettleAnalysisVO settleAnalysisVO1 = new SettleAnalysisVO();
        settleAnalysisVO1.setQuarterName("\u4e00\u5b63\u5ea6");
        settleAnalysisVO1.setStartTime(year + "-01-01");
        settleAnalysisVO1.setEndTime(year + "-03-31");
        settleAnalysisVO1.setEndTime(year + "-03-31");
        settleAnalysisVO1.setOrder(Integer.valueOf(1));
        analysisVOList.add(settleAnalysisVO1);
        SettleAnalysisVO settleAnalysisVO2 = new SettleAnalysisVO();
        settleAnalysisVO2.setQuarterName("\u4e8c\u5b63\u5ea6");
        settleAnalysisVO2.setStartTime(year + "-04-01");
        settleAnalysisVO2.setEndTime(year + "-06-30");
        settleAnalysisVO2.setOrder(Integer.valueOf(2));
        analysisVOList.add(settleAnalysisVO2);
        SettleAnalysisVO settleAnalysisVO3 = new SettleAnalysisVO();
        settleAnalysisVO3.setQuarterName("\u4e09\u5b63\u5ea6");
        settleAnalysisVO3.setStartTime(year + "-07-01");
        settleAnalysisVO3.setEndTime(year + "-09-30");
        settleAnalysisVO3.setOrder(Integer.valueOf(3));
        analysisVOList.add(settleAnalysisVO3);
        SettleAnalysisVO settleAnalysisVO4 = new SettleAnalysisVO();
        settleAnalysisVO4.setQuarterName("\u56db\u5b63\u5ea6");
        settleAnalysisVO4.setStartTime(year + "-10-01");
        settleAnalysisVO4.setEndTime(year + "-12-31");
        settleAnalysisVO4.setOrder(Integer.valueOf(4));
        analysisVOList.add(settleAnalysisVO4);
        List<Long> orgList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(FinalizedEntity::getBillState, new Object[]{1, 3});
        lambdaQueryWrapper.in(FinalizedEntity::getOrgId, orgList);
        List finalizedEntities = this.service.list((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper lambdaQueryGeneralWrapper = new LambdaQueryWrapper();
        lambdaQueryGeneralWrapper.in(GeneralEntity::getBillState, new Object[]{1, 3});
        lambdaQueryGeneralWrapper.in(GeneralEntity::getOrgId, orgList);
        List<GeneralDetailVO> generalEntities = this.finalizedMapper.getGeneralList(orgList);
        Integer yearNum = Integer.parseInt(year);
        Calendar calStart = Calendar.getInstance();
        calStart.set(1, yearNum);
        calStart.set(2, 0);
        calStart.set(5, 1);
        calStart.set(11, 0);
        calStart.set(12, 0);
        calStart.set(13, 0);
        calStart.set(14, 0);
        Calendar calEnd = Calendar.getInstance();
        calEnd.set(1, yearNum + 1);
        calEnd.set(2, 0);
        calEnd.set(5, 1);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        long countAll1 = 0L;
        long countAll2 = 0L;
        long countAll3 = 0L;
        long sumAll1 = 0L;
        long sumAll2 = 0L;
        long sumAll3 = 0L;
        for (SettleAnalysisVO settleAnalysisVO : analysisVOList) {
            Date yearStart = this.parseDate(settleAnalysisVO.getStartTime());
            Date yearEnd = this.parseDate(settleAnalysisVO.getEndTime());
            long count1 = 0L;
            long count2 = 0L;
            long count3 = 0L;
            if (CollectionUtils.isNotEmpty((Collection)finalizedEntities)) {
                String finalStage = "1";
                count1 = this.getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll1 += count1;
                finalStage = "2";
                count2 = this.getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll2 += count2;
                finalStage = "3";
                count3 = this.getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll3 += count3;
            }
            long sum1 = 0L;
            long sum2 = 0L;
            long sum3 = 0L;
            if (CollectionUtils.isNotEmpty(generalEntities)) {
                Date finalYearStart1 = yearStart;
                Date finalYearEnd1 = yearEnd;
                sum1 = generalEntities.stream().filter(entity -> entity.getSettlementTime() != null && !entity.getSettlementTime().before(finalYearStart1) && !entity.getSettlementTime().after(finalYearEnd1)).collect(Collectors.groupingBy(GeneralDetailVO::getOrgId)).values().stream().mapToLong(group -> {
                    Optional<Integer> maxEdition = group.stream().map(GeneralDetailVO::getEditon).max(Comparator.naturalOrder());
                    if (!maxEdition.isPresent()) {
                        return 0L;
                    }
                    return group.stream().filter(e -> e.getEditon() == maxEdition.get()).count();
                }).sum();
                sumAll1 += sum1;
                sum2 = generalEntities.stream().filter(entity -> entity.getFirstTime() != null && !entity.getFirstTime().before(finalYearStart1) && !entity.getFirstTime().after(finalYearEnd1)).collect(Collectors.groupingBy(GeneralDetailVO::getOrgId)).values().stream().mapToLong(group -> {
                    Optional<Integer> maxEdition = group.stream().map(GeneralDetailVO::getEditon).max(Comparator.naturalOrder());
                    if (!maxEdition.isPresent()) {
                        return 0L;
                    }
                    return group.stream().filter(e -> e.getEditon() == maxEdition.get()).count();
                }).sum();
                sumAll2 += sum2;
                sum3 = generalEntities.stream().filter(entity -> entity.getFirstTime() != null && !entity.getFirstTime().before(finalYearStart1) && !entity.getFirstTime().after(finalYearEnd1)).collect(Collectors.groupingBy(GeneralDetailVO::getOrgId)).values().stream().mapToLong(group -> {
                    Optional<Integer> maxEdition = group.stream().map(GeneralDetailVO::getEditon).max(Comparator.naturalOrder());
                    if (!maxEdition.isPresent()) {
                        return 0L;
                    }
                    return group.stream().filter(e -> e.getEditon() == maxEdition.get()).count();
                }).sum();
                sumAll3 += sum3;
            }
            BigDecimal decimalCount1 = ComputeUtil.toBigDecimal((Long)count1);
            BigDecimal decimalSum1 = ComputeUtil.toBigDecimal((Long)sum1);
            BigDecimal decimalCount2 = ComputeUtil.toBigDecimal((Long)count2);
            BigDecimal decimalSum2 = ComputeUtil.toBigDecimal((Long)sum2);
            BigDecimal decimalCount3 = ComputeUtil.toBigDecimal((Long)count3);
            BigDecimal decimalSum3 = ComputeUtil.toBigDecimal((Long)sum3);
            settleAnalysisVO.setBcRate(CommonUtils.calculateRate2(decimalCount1, decimalSum1));
            settleAnalysisVO.setYsRate(CommonUtils.calculateRate2(decimalCount2, decimalSum2));
            settleAnalysisVO.setZsRate(CommonUtils.calculateRate2(decimalCount3, decimalSum3));
        }
        SettleAnalysisVO settleAnalysisAllVO = new SettleAnalysisVO();
        BigDecimal countAllS1 = ComputeUtil.toBigDecimal((Long)countAll1);
        BigDecimal sumAllS1 = ComputeUtil.toBigDecimal((Long)sumAll1);
        BigDecimal countAllS2 = ComputeUtil.toBigDecimal((Long)countAll2);
        BigDecimal sumAllS2 = ComputeUtil.toBigDecimal((Long)sumAll2);
        BigDecimal countAllS3 = ComputeUtil.toBigDecimal((Long)countAll3);
        BigDecimal sumAllS3 = ComputeUtil.toBigDecimal((Long)sumAll3);
        settleAnalysisAllVO.setQuarterName("\u5e74\u5ea6");
        settleAnalysisAllVO.setOrder(Integer.valueOf(0));
        settleAnalysisAllVO.setBcRate(CommonUtils.calculateRate2(countAllS1, sumAllS1));
        settleAnalysisAllVO.setYsRate(CommonUtils.calculateRate2(countAllS2, sumAllS2));
        settleAnalysisAllVO.setZsRate(CommonUtils.calculateRate2(countAllS3, sumAllS3));
        analysisVOList.add(settleAnalysisAllVO);
        analysisVOList.sort(Comparator.comparingInt(SettleAnalysisVO::getOrder));
        return CommonResponse.success((String)"\u67e5\u8be2\u603b\u5305\u7ed3\u7b97\u6210\u529f\uff01", analysisVOList);
    }

    private long getFinalizedCount(List<FinalizedEntity> finalizedEntities, Date yearStart, Date yearEnd, String finalStage) {
        Date finalYearStart = yearStart;
        Date finalYearEnd = yearEnd;
        long count = finalizedEntities.stream().filter(s -> s.getFinalStage() != null && finalStage.equals(s.getFinalStage()) && s.getCreateTime() != null && !s.getCreateTime().before(finalYearStart) && s.getCreateTime().before(finalYearEnd)).count();
        return count;
    }

    private Date parseDate(String dateStr) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
    }
}

