package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 分部分项清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_budget_sub")
public class BudgetSubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="sub_code")
    private String subCode; // 编码

    @TableField(value="sub_name")
    private String subName; // 名称
    @TableField(value="sub_feature")
    private String subFeature; // 特征
    @TableField(value="sub_unit")
    private String subUnit; // 单位
    @TableField(value="sub_num")
    private BigDecimal subNum; // 工程量
    @TableField(value="sub_tax_rate")
    private BigDecimal subTaxRate; // 税率
    @TableField(value="sub_price")
    private BigDecimal subPrice; // 综合单价(无税)
    @TableField(value="sub_tax_price")
    private BigDecimal subTaxPrice; // 综合单价(含税)
    @TableField(value="sub_mny")
    private BigDecimal subMny; // 合价(无税)
    @TableField(value="sub_tax_mny")
    private BigDecimal subTaxMny; // 合价(含税)
    @TableField(value="sub_tax")
    private BigDecimal subTax; // 税额
    @TableField(value="sub_memo")
    private String subMemo; // 备注
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="sub_subject_id")
    private Long subSubjectId; // 成本科目id
    @TableField(value="sub_subject_name")
    private String subSubjectName; // 成本科目名称

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    @TableField(value = "sub_compositive_coefficient_name")
    private String subCompositiveCoefficientName; //综合系数名称
    @TableField(value = "sub_compositive_coefficient_id")
    private Long subCompositiveCoefficientId; //综合系数id
    @TableField(value = "sub_compositive_coefficient")
    private BigDecimal subCompositiveCoefficient; //综合系数

    @TableField(value = "sub_item_type")
    private String subItemType; //清单类型  用于导入数据区分

    @TableField(value = "sub_price_type")
    private Integer subPriceType; //价税计算类型：0-无税优先， 1-含税优先
    @TableField(value="sub_de_name")
    private String subDeName; // 定额编号/名称
    @TableField(value="sub_content")
    private String subContent; // 工作内容

    public String getSubDeName() {
        return subDeName;
    }

    public void setSubDeName(String subDeName) {
        this.subDeName = subDeName;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public Integer getSubPriceType() {
        return subPriceType;
    }

    public void setSubPriceType(Integer subPriceType) {
        this.subPriceType = subPriceType;
    }

    public String getSubItemType() {
        return subItemType;
    }

    public void setSubItemType(String subItemType) {
        this.subItemType = subItemType;
    }

    public String getSubCompositiveCoefficientName() {
        return subCompositiveCoefficientName;
    }

    public void setSubCompositiveCoefficientName(String subCompositiveCoefficientName) {
        this.subCompositiveCoefficientName = subCompositiveCoefficientName;
    }

    public Long getSubCompositiveCoefficientId() {
        return subCompositiveCoefficientId;
    }

    public void setSubCompositiveCoefficientId(Long subCompositiveCoefficientId) {
        this.subCompositiveCoefficientId = subCompositiveCoefficientId;
    }

    public BigDecimal getSubCompositiveCoefficient() {
        return subCompositiveCoefficient;
    }

    public void setSubCompositiveCoefficient(BigDecimal subCompositiveCoefficient) {
        this.subCompositiveCoefficient = subCompositiveCoefficient;
    }

    public Long getSubSubjectId() {
        return subSubjectId;
    }

    public void setSubSubjectId(Long subSubjectId) {
        this.subSubjectId = subSubjectId;
    }

    public String getSubSubjectName() {
        return subSubjectName;
    }

    public void setSubSubjectName(String subSubjectName) {
        this.subSubjectName = subSubjectName;
    }

    public BigDecimal getSubTax() {
        return subTax;
    }

    public void setSubTax(BigDecimal subTax) {
        this.subTax = subTax;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 编码
     */
    public String getSubCode() {
        return subCode;
    }

    /**
     * 编码
     */
    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }
    /**
     * 名称
     */
    public String getSubName() {
        return subName;
    }

    /**
     * 名称
     */
    public void setSubName(String subName) {
        this.subName = subName;
    }
    /**
     * 特征
     */
    public String getSubFeature() {
        return subFeature;
    }

    /**
     * 特征
     */
    public void setSubFeature(String subFeature) {
        this.subFeature = subFeature;
    }
    /**
     * 单位
     */
    public String getSubUnit() {
        return subUnit;
    }

    /**
     * 单位
     */
    public void setSubUnit(String subUnit) {
        this.subUnit = subUnit;
    }
    /**
     * 工程量
     */
    public BigDecimal getSubNum() {
        return subNum;
    }

    /**
     * 工程量
     */
    public void setSubNum(BigDecimal subNum) {
        this.subNum = subNum;
    }
    /**
     * 税率
     */
    public BigDecimal getSubTaxRate() {
        return subTaxRate;
    }

    /**
     * 税率
     */
    public void setSubTaxRate(BigDecimal subTaxRate) {
        this.subTaxRate = subTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public BigDecimal getSubPrice() {
        return subPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setSubPrice(BigDecimal subPrice) {
        this.subPrice = subPrice;
    }
    /**
     * 综合单价(含税)
     */
    public BigDecimal getSubTaxPrice() {
        return subTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setSubTaxPrice(BigDecimal subTaxPrice) {
        this.subTaxPrice = subTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getSubMny() {
        return subMny;
    }

    /**
     * 合价(无税)
     */
    public void setSubMny(BigDecimal subMny) {
        this.subMny = subMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getSubTaxMny() {
        return subTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setSubTaxMny(BigDecimal subTaxMny) {
        this.subTaxMny = subTaxMny;
    }
    /**
     * 备注
     */
    public String getSubMemo() {
        return subMemo;
    }

    /**
     * 备注
     */
    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
}
