package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.home.util.DateUtil;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.mapper.ClaimRecordsMapper;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.business.pro.income.vo.ClaimReportVO;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商签证索赔记录
 * 
 * @author generator
 * 
 */
@Service("claimRecordsService")
public class ClaimRecordsServiceImpl extends BaseServiceImpl<ClaimRecordsMapper, ClaimRecordsEntity> implements IClaimRecordsService{

    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IClaimService claimService;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "INCOME_CLAIM_RECORDS";//此处需要根据实际修改


    @Autowired
    private IClaimRecordsService service;


    @Override
    public void updateClaimRecords(Long claimId, String replyStatus, List<Long> claimRecordIds,String billCode) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, claimId);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
        wrapper.set(ClaimRecordsEntity::getClaimCode, null);
        wrapper.set(ClaimRecordsEntity::getHandleState, 1);
//        wrapper.set(ClaimRecordsEntity::getReplyStatus, CommonConstants.WU);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.WYY);
        this.update(wrapper);
        if (CollectionUtils.isNotEmpty(claimRecordIds)) {
            claimRecordIds.forEach(e -> {
                LambdaUpdateWrapper<ClaimRecordsEntity> lambda = new LambdaUpdateWrapper();
                lambda.eq(ClaimRecordsEntity::getId, e);
                lambda.set(ClaimRecordsEntity::getClaimId, claimId);
                lambda.set(ClaimRecordsEntity::getReplyStatus, replyStatus);
                lambda.set(ClaimRecordsEntity::getClaimCode, billCode);
                lambda.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.SLZ);
                lambda.set(ClaimRecordsEntity::getHandleState, 2);
                this.update(lambda);
            });
        }
    }

    @Override
    public List<ClaimRecordsVO> selectByClaimId(Long claimId) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, claimId);
        wrapper.eq(ClaimRecordsEntity::getDr, 0);
        wrapper.eq(ClaimRecordsEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<ClaimRecordsEntity> list = this.list(wrapper);
        List<ClaimRecordsVO> budgetVOS = BeanMapper.mapList(list, ClaimRecordsVO.class);
        return budgetVOS;
    }

    @Override
    public void deleteClaimId(List<Long> claimIds) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.in(ClaimRecordsEntity::getClaimId, claimIds);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
        wrapper.set(ClaimRecordsEntity::getReplyStatus, null);
        wrapper.set(ClaimRecordsEntity::getClaimCode, null);
        wrapper.set(ClaimRecordsEntity::getHandleState,1);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.WYY);
        this.update(wrapper);
    }

    @Override
    public JSONObject claimReport(QueryParam queryParam) {
        LinkedHashMap<String,String> orderMap = queryParam.getOrderMap();
        if(!orderMap.containsKey("buildUnitName")){
            queryParam.getOrderMap().put("buildUnitName", QueryParam.ASC);
        }
        if(!orderMap.containsKey("projectDate")){
            queryParam.getOrderMap().put("projectDate", QueryParam.DESC);
        }

        CommonResponse<Page<ProjectPoolSetVO>> pageCommonResponse = projectSetApi.queryProjectIPage(queryParam);
        if (!pageCommonResponse.isSuccess()){
            throw new BusinessException("查询项目信息失败!");
        }
        Page<ProjectPoolSetVO> projectPoolSetVOPage = pageCommonResponse.getData();
        List<ProjectPoolSetVO> records = projectPoolSetVOPage.getRecords();
        List<Long> projectIds = new ArrayList<>();
        List<ClaimReportVO> claimReportVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(records)){
            projectIds = records.stream().map(x->x.getId()).distinct().collect(Collectors.toList());
            claimReportVOList = BeanMapper.mapList(records,ClaimReportVO.class);
        }
        Integer pageNumber = queryParam.getPageIndex();
        Integer pageSize = queryParam.getPageSize();
        JSONObject page = new JSONObject();
        page.put("current", "" + pageNumber);
        page.put("size", "" + pageSize);
        page.put("records", new ArrayList<>());
        page.put("total", "" + 0);
        page.put("pages", "" + 0);
        if(CollectionUtils.isEmpty(claimReportVOList)){
            return page;
        }

        //合同金额
        LambdaQueryWrapper<ContractRegisterEntity> lambdaContract = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambdaContract.in(ContractRegisterEntity::getBillState, 1,3);
        lambdaContract.in(ContractRegisterEntity::getProjectId, projectIds);
        List<ContractRegisterEntity> contractRegisterEntityList = contractRegisterService.list(lambdaContract);
        Map<Long, BigDecimal> contractMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractRegisterEntityList)){
            contractMnyMap = contractRegisterEntityList.stream().filter(s -> s.getBaseTaxMoney() != null).collect(Collectors.groupingBy(ContractRegisterEntity::getProjectId,                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getBaseTaxMoney()).reduce(BigDecimal.ZERO, BigDecimal::add))));
         }

         //查询签证索赔记录单
        LambdaQueryWrapper<ClaimRecordsEntity> lambdaRecord = Wrappers.<ClaimRecordsEntity>lambdaQuery();
        lambdaRecord.in(ClaimRecordsEntity::getBillState, 1,3);
        lambdaRecord.in(ClaimRecordsEntity::getProjectId, projectIds);
        List<ClaimRecordsEntity> recordList = super.list(lambdaRecord);
        //事项总数(个)
        Map<Long, Long> matterNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            matterNumMap = recordList.stream().collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }

        //未到报送节点(个)
        Map<Long, Long> noNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            noNumMap = recordList.stream().filter(s ->s.getApprovalFlag() != null && s.getApprovalFlag()== 1 && s.getFinishState() != null && s.getFinishState() == 0).collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId,Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }

        //查询签证索赔单
        LambdaQueryWrapper<ClaimEntity> lambdaClaim = Wrappers.<ClaimEntity>lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState, 1,3);
        lambdaClaim.in(ClaimEntity::getProjectId, projectIds);
        List<ClaimEntity> claimList = claimService.list(lambdaClaim);
        //审定金额
        Map<Long, BigDecimal> approveMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(claimList)){
            //审定金额
            approveMnyMap = claimList.stream().filter(s -> s.getReplyTaxMny() != null && "1".equals(s.getReplyStatus())).collect(Collectors.groupingBy(ClaimEntity::getProjectId,Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReplyTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //已测算(份)
        Map<Long, Long> calculateNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            calculateNumMap = claimList.stream().filter(s ->s.getApprovalFlag() != null && s.getApprovalFlag()== 0).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen                   (Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        //已测算金额(元)
        Map<Long, BigDecimal> calculateMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractRegisterEntityList)){
            calculateMnyMap = claimList.stream().filter(s -> s.getClaimTaxMny() != null && s.getApprovalFlag() != null && s.getApprovalFlag()== 0).collect(Collectors.groupingBy(ClaimEntity::getProjectId,                 Collectors.collectingAndThen(Collectors.toList(), m-> m.stream().map(a -> a.getClaimTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        //应报送(份)
        Map<Long, Long> shouldNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            shouldNumMap = recordList.stream().filter(s ->s.getApprovalFlag() != null && s.getApprovalFlag()== 1 && s.getFinishState() != null && s.getFinishState() == 1).collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId,                  Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }

        //已报送(份)
        Map<Long, Long> alreadyNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            alreadyNumMap = claimList.stream().filter(s ->s.getApprovalFlag() != null && s.getApprovalFlag()== 1).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen                     (Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }

        //报送金额(元)
        Map<Long, BigDecimal> submissionMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractRegisterEntityList)){
            submissionMnyMap = claimList.stream().filter(s -> s.getClaimTaxMny() != null && s.getApprovalFlag() != null && s.getApprovalFlag()== 1).collect(Collectors.groupingBy(ClaimEntity::getProjectId,                 Collectors.collectingAndThen(Collectors.toList(), m-> m.stream().map(a -> a.getClaimTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //已审定(份)
        Map<Long, Long> approveNumMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(recordList)){
            approveNumMap = claimList.stream().filter(s ->"1".equals(s.getReplyStatus())).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen              (Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }


        if(CollectionUtils.isNotEmpty(claimReportVOList)){
            for (ClaimReportVO claimVO : claimReportVOList){
                Long projectId = claimVO.getId();
                if (contractMnyMap.containsKey(projectId)){
                    BigDecimal contractMny = contractMnyMap.get(projectId);
                    claimVO.setContractMny(contractMny);
                }
                if (matterNumMap.containsKey(projectId)){
                    Long matterNum = matterNumMap.get(projectId);
                    claimVO.setMatterNum(matterNum);
                }
                if (noNumMap.containsKey(projectId)){
                    Long noNum = noNumMap.get(projectId);
                    claimVO.setNoNum(noNum);
                }
                if (approveMnyMap.containsKey(projectId)){
                    BigDecimal approveMny = approveMnyMap.get(projectId);
                    claimVO.setApproveMny(approveMny);
                }
                if (calculateNumMap.containsKey(projectId)){
                    Long calculateNum = calculateNumMap.get(projectId);
                    claimVO.setCalculateNum(calculateNum);
                }
                if (calculateMnyMap.containsKey(projectId)){
                    BigDecimal calculateMny = calculateMnyMap.get(projectId);
                    claimVO.setCalculateMny(calculateMny);
                }
                if (shouldNumMap.containsKey(projectId)){
                    Long shouldNum = shouldNumMap.get(projectId);
                    claimVO.setShouldNum(shouldNum);
                }
                if (alreadyNumMap.containsKey(projectId)){
                    Long alreadyNum = alreadyNumMap.get(projectId);
                    claimVO.setAlreadyNum(alreadyNum);
                }
                if (submissionMnyMap.containsKey(projectId)){
                    BigDecimal submissionMny = submissionMnyMap.get(projectId);
                    claimVO.setSubmissionMny(submissionMny);
                }
                if (approveNumMap.containsKey(projectId)){
                    Long approveNum = approveNumMap.get(projectId);
                    claimVO.setApproveNum(approveNum);
                }
                //【签变增收率】=【审定金额】/【合同金额
                claimVO.setSignRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(claimVO.getApproveMny(),claimVO.getContractMny()),new BigDecimal(100)));
                //报送率】=【已报送(份)】/【应报送(份)】
                claimVO.setSubmissionRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.toBigDecimal(claimVO.getAlreadyNum()),ComputeUtil.toBigDecimal(claimVO.getShouldNum())),new BigDecimal(100)));
                //确权率】=【已审定(份)】/【已报送(份)】；字段注释
                claimVO.setApproveRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.toBigDecimal(claimVO.getApproveNum()),ComputeUtil.toBigDecimal(claimVO.getShouldNum())),new BigDecimal(100)));
            }

            page.put("current", "" + projectPoolSetVOPage.getCurrent());
            page.put("size", "" + projectPoolSetVOPage.getSize());
            page.put("records", claimReportVOList);
            page.put("total", "" + projectPoolSetVOPage.getTotal());
            page.put("pages", "" + projectPoolSetVOPage.getPages());
        }

        return page;
    }

    @Override
    public ClaimRecordsVO insert(ClaimRecordsVO saveOrUpdateVO) {
        ClaimRecordsEntity entity = BeanMapper.map(saveOrUpdateVO, ClaimRecordsEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setIsClose(CommonConstants.OPEN);
        }
        service.saveOrUpdate(entity, false);
        ClaimRecordsVO vo = BeanMapper.map(entity, ClaimRecordsVO.class);
        return vo;
    }

}
