/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.AccountEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IAccountService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="account")
public class AccountBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IAccountService accountService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AccountEntity accountEntity = (AccountEntity)((Object)this.accountService.selectById(billId));
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(accountEntity.getContractId()));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        BigDecimal sumMaterialSettleMny = MathUtil.safeAdd(contractEntity.getSumMaterialSettleMny(), accountEntity.getMaterialSettleMny());
        wrapper.eq(BaseEntity::getId, (Object)accountEntity.getContractId());
        wrapper.set(ContractRegisterEntity::getSumMaterialSettleMny, (Object)sumMaterialSettleMny);
        this.contractRegisterService.update((Wrapper)wrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AccountEntity accountEntity = (AccountEntity)((Object)this.accountService.selectById(billId));
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(accountEntity.getContractId()));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        BigDecimal sumMaterialSettleMny = MathUtil.safeSub(contractEntity.getSumMaterialSettleMny(), accountEntity.getMaterialSettleMny());
        wrapper.eq(BaseEntity::getId, (Object)accountEntity.getContractId());
        wrapper.set(ContractRegisterEntity::getSumMaterialSettleMny, (Object)sumMaterialSettleMny);
        this.contractRegisterService.update((Wrapper)wrapper);
        return CommonResponse.success();
    }
}

