/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractReview"})
public class ContractReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractReviewService service;
    @Autowired
    private IContractRegisterService registerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractReviewVO> saveOrUpdate(@RequestBody ContractReviewVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/addSupplementByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractReviewVO> addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = this.service.addSupplementByConId(mainContractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractReviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.pageList(param));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractReviewVO> list = this.service.excelExport(param);
        HashMap<String, List<ContractReviewVO>> beans = new HashMap<String, List<ContractReviewVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-review-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractReviewVO>> refContractReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List reviewIdList;
        List list;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Long mainContractId;
            ContractRegisterEntity registerEntity;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (!Objects.equals(conditionMap.get("projectId"), null)) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                wrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
            }
            if (!Objects.equals(conditionMap.get("supplementFlag"), null)) {
                int supplementFlag = Integer.parseInt(conditionMap.get("supplementFlag").toString());
                param.getParams().put("supplementFlag", new Parameter("eq", (Object)supplementFlag));
            }
            if (!Objects.equals(conditionMap.get("mainContractId"), null) && !Objects.equals(null, (registerEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(mainContractId = Long.valueOf(conditionMap.get("mainContractId").toString())))).getReviewId())) {
                param.getParams().put("mainContractId", new Parameter("eq", (Object)registerEntity.getReviewId()));
            }
        }
        if (ListUtil.isNotEmpty((List)(list = this.registerService.list((Wrapper)wrapper))) && ListUtil.isNotEmpty(reviewIdList = list.stream().map(ContractRegisterEntity::getReviewId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            param.getParams().put("id", new Parameter("not_in", reviewIdList));
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter("in", billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/relationProject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> relationProject(@RequestBody ContractReviewVO vo) {
        this.service.relationProject(vo);
        return CommonResponse.success((String)"\u5173\u8054\u9879\u76ee\u6210\u529f\uff01");
    }

    @GetMapping(value={"/validateReview"})
    @ResponseBody
    public CommonResponse<Boolean> validateReview(@RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="id", required=false) Long id) {
        this.service.validateReview(projectId, id);
        return CommonResponse.success((String)"\u5173\u8054\u9879\u76ee\u6210\u529f\uff01");
    }
}

