/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.mapper.ClaimRecordsMapper;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.business.pro.income.vo.ClaimReportVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="claimRecordsService")
public class ClaimRecordsServiceImpl
extends BaseServiceImpl<ClaimRecordsMapper, ClaimRecordsEntity>
implements IClaimRecordsService {
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCOME_CLAIM_RECORDS";
    @Autowired
    private IClaimRecordsService service;

    @Override
    public void updateClaimRecords(Long claimId, String replyStatus, List<Long> claimRecordIds, String billCode) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, (Object)claimId);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
        wrapper.set(ClaimRecordsEntity::getClaimCode, null);
        wrapper.set(ClaimRecordsEntity::getHandleState, (Object)1);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, (Object)CommonConstants.WYY);
        this.update((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(claimRecordIds)) {
            claimRecordIds.forEach(e -> {
                LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                lambda.eq(BaseEntity::getId, e);
                lambda.set(ClaimRecordsEntity::getClaimId, (Object)claimId);
                lambda.set(ClaimRecordsEntity::getReplyStatus, (Object)replyStatus);
                lambda.set(ClaimRecordsEntity::getClaimCode, (Object)billCode);
                lambda.set(ClaimRecordsEntity::getQuoteStatus, (Object)CommonConstants.SLZ);
                lambda.set(ClaimRecordsEntity::getHandleState, (Object)2);
                this.update((Wrapper)lambda);
            });
        }
    }

    @Override
    public List<ClaimRecordsVO> selectByClaimId(Long claimId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, (Object)claimId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.list((Wrapper)wrapper);
        List budgetVOS = BeanMapper.mapList((Iterable)list, ClaimRecordsVO.class);
        return budgetVOS;
    }

    @Override
    public void deleteClaimId(List<Long> claimIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(ClaimRecordsEntity::getClaimId, claimIds);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
        wrapper.set(ClaimRecordsEntity::getReplyStatus, null);
        wrapper.set(ClaimRecordsEntity::getClaimCode, null);
        wrapper.set(ClaimRecordsEntity::getHandleState, (Object)1);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, (Object)CommonConstants.WYY);
        this.update((Wrapper)wrapper);
    }

    @Override
    public JSONObject claimReport(QueryParam queryParam) {
        CommonResponse pageCommonResponse;
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (!orderMap.containsKey("buildUnitName")) {
            queryParam.getOrderMap().put("buildUnitName", "asc");
        }
        if (!orderMap.containsKey("projectDate")) {
            queryParam.getOrderMap().put("projectDate", "desc");
        }
        if (!(pageCommonResponse = this.projectSetApi.queryProjectIPage(queryParam)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25!");
        }
        Page projectPoolSetVOPage = (Page)pageCommonResponse.getData();
        List records = projectPoolSetVOPage.getRecords();
        List<Object> projectIds = new ArrayList();
        List claimReportVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            projectIds = records.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            claimReportVOList = BeanMapper.mapList((Iterable)records, ClaimReportVO.class);
        }
        Integer pageNumber = queryParam.getPageIndex();
        Integer pageSize = queryParam.getPageSize();
        JSONObject page = new JSONObject();
        page.put("current", (Object)("" + pageNumber));
        page.put("size", (Object)("" + pageSize));
        page.put("records", new ArrayList());
        page.put("total", (Object)"0");
        page.put("pages", (Object)"0");
        if (CollectionUtils.isEmpty(claimReportVOList)) {
            return page;
        }
        LambdaQueryWrapper lambdaContract = Wrappers.lambdaQuery();
        lambdaContract.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        lambdaContract.in(ContractRegisterEntity::getProjectId, projectIds);
        List contractRegisterEntityList = this.contractRegisterService.list((Wrapper)lambdaContract);
        Map<Object, Object> contractMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterEntityList)) {
            contractMnyMap = contractRegisterEntityList.stream().filter(s -> s.getBaseTaxMoney() != null).collect(Collectors.groupingBy(ContractRegisterEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getBaseTaxMoney()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.in(ClaimRecordsEntity::getBillState, new Object[]{1, 3});
        lambdaRecord.in(ClaimRecordsEntity::getProjectId, projectIds);
        List recordList = super.list((Wrapper)lambdaRecord);
        Map<Object, Object> matterNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            matterNumMap = recordList.stream().collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        Map<Object, Object> noNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            noNumMap = recordList.stream().filter(s -> s.getApprovalFlag() != null && s.getApprovalFlag() == 1 && s.getFinishState() != null && s.getFinishState() == 0).collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        LambdaQueryWrapper lambdaClaim = Wrappers.lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState, new Object[]{1, 3});
        lambdaClaim.in(ClaimEntity::getProjectId, projectIds);
        List claimList = this.claimService.list((Wrapper)lambdaClaim);
        Map<Object, Object> approveMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)claimList)) {
            approveMnyMap = claimList.stream().filter(s -> s.getReplyTaxMny() != null && "1".equals(s.getReplyStatus())).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReplyTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        Map<Object, Object> calculateNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            calculateNumMap = claimList.stream().filter(s -> s.getApprovalFlag() != null && s.getApprovalFlag() == 0).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        Map<Object, Object> calculateMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterEntityList)) {
            calculateMnyMap = claimList.stream().filter(s -> s.getClaimTaxMny() != null && s.getApprovalFlag() != null && s.getApprovalFlag() == 0).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getClaimTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        Map<Object, Object> shouldNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            shouldNumMap = recordList.stream().filter(s -> s.getApprovalFlag() != null && s.getApprovalFlag() == 1 && s.getFinishState() != null && s.getFinishState() == 1).collect(Collectors.groupingBy(ClaimRecordsEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        Map<Object, Object> alreadyNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            alreadyNumMap = claimList.stream().filter(s -> s.getApprovalFlag() != null && s.getApprovalFlag() == 1).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        Map<Object, Object> submissionMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterEntityList)) {
            submissionMnyMap = claimList.stream().filter(s -> s.getClaimTaxMny() != null && s.getApprovalFlag() != null && s.getApprovalFlag() == 1).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getClaimTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        Map<Object, Object> approveNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            approveNumMap = claimList.stream().filter(s -> "1".equals(s.getReplyStatus())).collect(Collectors.groupingBy(ClaimEntity::getProjectId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));
        }
        if (CollectionUtils.isNotEmpty(claimReportVOList)) {
            for (ClaimReportVO claimVO : claimReportVOList) {
                Long projectId = claimVO.getId();
                if (contractMnyMap.containsKey(projectId)) {
                    BigDecimal contractMny = (BigDecimal)contractMnyMap.get(projectId);
                    claimVO.setContractMny(contractMny);
                }
                if (matterNumMap.containsKey(projectId)) {
                    Long matterNum = (Long)matterNumMap.get(projectId);
                    claimVO.setMatterNum(matterNum);
                }
                if (noNumMap.containsKey(projectId)) {
                    Long noNum = (Long)noNumMap.get(projectId);
                    claimVO.setNoNum(noNum);
                }
                if (approveMnyMap.containsKey(projectId)) {
                    BigDecimal approveMny = (BigDecimal)approveMnyMap.get(projectId);
                    claimVO.setApproveMny(approveMny);
                }
                if (calculateNumMap.containsKey(projectId)) {
                    Long calculateNum = (Long)calculateNumMap.get(projectId);
                    claimVO.setCalculateNum(calculateNum);
                }
                if (calculateMnyMap.containsKey(projectId)) {
                    BigDecimal calculateMny = (BigDecimal)calculateMnyMap.get(projectId);
                    claimVO.setCalculateMny(calculateMny);
                }
                if (shouldNumMap.containsKey(projectId)) {
                    Long shouldNum = (Long)shouldNumMap.get(projectId);
                    claimVO.setShouldNum(shouldNum);
                }
                if (alreadyNumMap.containsKey(projectId)) {
                    Long alreadyNum = (Long)alreadyNumMap.get(projectId);
                    claimVO.setAlreadyNum(alreadyNum);
                }
                if (submissionMnyMap.containsKey(projectId)) {
                    BigDecimal submissionMny = (BigDecimal)submissionMnyMap.get(projectId);
                    claimVO.setSubmissionMny(submissionMny);
                }
                if (approveNumMap.containsKey(projectId)) {
                    Long approveNum = (Long)approveNumMap.get(projectId);
                    claimVO.setApproveNum(approveNum);
                }
                claimVO.setSignRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)claimVO.getApproveMny(), (BigDecimal)claimVO.getContractMny()), (BigDecimal)new BigDecimal(100)));
                claimVO.setSubmissionRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.toBigDecimal((Long)claimVO.getAlreadyNum()), (BigDecimal)ComputeUtil.toBigDecimal((Long)claimVO.getShouldNum())), (BigDecimal)new BigDecimal(100)));
                claimVO.setApproveRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.toBigDecimal((Long)claimVO.getApproveNum()), (BigDecimal)ComputeUtil.toBigDecimal((Long)claimVO.getShouldNum())), (BigDecimal)new BigDecimal(100)));
            }
            page.put("current", (Object)("" + projectPoolSetVOPage.getCurrent()));
            page.put("size", (Object)("" + projectPoolSetVOPage.getSize()));
            page.put("records", claimReportVOList);
            page.put("total", (Object)("" + projectPoolSetVOPage.getTotal()));
            page.put("pages", (Object)("" + projectPoolSetVOPage.getPages()));
        }
        return page;
    }

    @Override
    public Long insert(ClaimRecordsVO saveOrUpdateVO) {
        ClaimRecordsEntity entity = (ClaimRecordsEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ClaimRecordsEntity.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setBillCode((String)billCode.getData());
        entity.setIsClose(CommonConstants.OPEN);
        this.service.saveOrUpdate((Object)entity, false);
        ClaimRecordsEntity one = (ClaimRecordsEntity)((Object)((LambdaQueryChainWrapper)this.service.lambdaQuery().eq(ClaimRecordsEntity::getBillCode, billCode.getData())).one());
        return one.getId();
    }
}

