/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.recipetApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.service.IAccountService;
import com.ejianc.business.pro.income.service.IAwardPunishService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAccountEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyAwardPunishEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyEntity;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyQuoteEntity;
import com.ejianc.business.pro.recipetApply.mapper.RecipetApplyMapper;
import com.ejianc.business.pro.recipetApply.service.IRecipetApplyService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recipetApplyService")
public class RecipetApplyServiceImpl
extends BaseServiceImpl<RecipetApplyMapper, RecipetApplyEntity>
implements IRecipetApplyService {
    @Autowired
    private IAccountService accounts;
    @Autowired
    private IQuoteService quotes;
    @Autowired
    private IAwardPunishService answerPun;

    @Override
    public Map<String, BigDecimal> getTotalMny(QueryParam param) {
        QueryWrapper wrapper = RecipetApplyServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(IFNULL(total_apply_tax_mny,0)) as totalApplyTaxMny,sum(IFNULL(actual_received_mny,0)) as actualReceivedMny"});
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        HashMap<String, BigDecimal> result = super.getMap((Wrapper)wrapper);
        if (result != null) {
            BigDecimal totalApplyTaxMny = result.get("totalApplyTaxMny") != null ? (BigDecimal)result.get("totalApplyTaxMny") : BigDecimal.ZERO;
            BigDecimal actualReceivedMny = result.get("actualReceivedMny") != null ? (BigDecimal)result.get("actualReceivedMny") : BigDecimal.ZERO;
            result.put("totalApplyTaxMny", totalApplyTaxMny);
            result.put("actualReceivedMny", actualReceivedMny);
        } else {
            result = new HashMap<String, BigDecimal>();
            result.put("totalApplyTaxMny", BigDecimal.ZERO);
            result.put("actualReceivedMny", BigDecimal.ZERO);
        }
        return result;
    }

    @Override
    public String wbActualReceivedMny(Long id, boolean flag) {
        RecipetApplyEntity entity = (RecipetApplyEntity)((Object)super.selectById((Serializable)id));
        if (entity != null) {
            List<RecipetApplyAwardPunishEntity> awvos;
            List<RecipetApplyAccountEntity> accvos;
            List<RecipetApplyQuoteEntity> qvos = entity.getRecipetApplyQuoteList();
            if (CollectionUtils.isNotEmpty(qvos)) {
                qvos.forEach(e -> {
                    LambdaUpdateWrapper qld = new LambdaUpdateWrapper();
                    qld.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    qld.eq(BaseEntity::getId, (Object)e.getSourceId());
                    if (flag) {
                        qld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) + IFNULL(" + e.getTheApplyMny() + ",0)");
                    } else {
                        qld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) - IFNULL(" + e.getTheApplyMny() + ",0)");
                    }
                    this.quotes.update((Wrapper)qld);
                });
            }
            if (CollectionUtils.isNotEmpty(accvos = entity.getRecipetApplyAccountList())) {
                accvos.forEach(e -> {
                    LambdaUpdateWrapper accld = new LambdaUpdateWrapper();
                    accld.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    accld.eq(BaseEntity::getId, (Object)e.getSourceId());
                    if (flag) {
                        accld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) + IFNULL(" + e.getTheApplyMny() + ",0)");
                    } else {
                        accld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) - IFNULL(" + e.getTheApplyMny() + ",0)");
                    }
                    this.accounts.update((Wrapper)accld);
                });
            }
            if (CollectionUtils.isNotEmpty(awvos = entity.getRecipetApplyAwardPunishList())) {
                awvos.forEach(e -> {
                    LambdaUpdateWrapper awld = new LambdaUpdateWrapper();
                    awld.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    awld.eq(BaseEntity::getId, (Object)e.getSourceId());
                    if (flag) {
                        awld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) + IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) + IFNULL(" + e.getTheApplyMny() + ",0)");
                    } else {
                        awld.setSql("applied_tax_mny = IFNULL(applied_tax_mny,0) - IFNULL(" + e.getTheApplyTaxMny() + ",0),applied_mny = IFNULL(applied_mny,0) - IFNULL(" + e.getTheApplyMny() + ",0)");
                    }
                    this.answerPun.update((Wrapper)awld);
                });
            }
        }
        return "\u56de\u5199\u6210\u529f";
    }

    @Override
    public String validateContract(Long contractId, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.notIn(RecipetApplyEntity::getBillState, new Object[]{1, 3});
        if (id != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)id);
        }
        queryWrapper.eq(RecipetApplyEntity::getContractId, (Object)contractId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u6536\u6b3e\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u6210\u529f\uff01";
    }
}

