package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.CompositiveCoefficientCategoryEntity;
import com.ejianc.business.pro.income.bean.CompositiveCoefficientEntity;
import com.ejianc.business.pro.income.service.ICompositiveCoefficientCategoryService;
import com.ejianc.business.pro.income.service.ICompositiveCoefficientService;
import com.ejianc.business.pro.income.vo.CompositiveCoefficientCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 综合系数分类实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("compositiveCoefficientCategory")
public class CompositiveCoefficientCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICompositiveCoefficientCategoryService service;

    @Autowired
    private ICompositiveCoefficientService compositiveCoefficientService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompositiveCoefficientCategoryVO> saveOrUpdate(@RequestBody CompositiveCoefficientCategoryVO saveOrUpdateVO) {
    	CompositiveCoefficientCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, CompositiveCoefficientCategoryEntity.class);

    	//校验编码是否重复
    	QueryWrapper<CompositiveCoefficientCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", saveOrUpdateVO.getCode());
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }
        int count = service.count(query);
        if(count > 0) {
            return CommonResponse.error("编码重复，保存失败！");
        }

    	service.saveOrUpdate(entity, false);
    	CompositiveCoefficientCategoryVO vo = BeanMapper.map(entity, CompositiveCoefficientCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompositiveCoefficientCategoryVO> queryDetail(Long id) {
    	CompositiveCoefficientCategoryEntity entity = service.selectById(id);
    	CompositiveCoefficientCategoryVO vo = BeanMapper.map(entity, CompositiveCoefficientCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompositiveCoefficientCategoryVO> vos) {
        List<Long> categoryIds = vos.stream().map(CompositiveCoefficientCategoryVO::getId).collect(Collectors.toList());

        QueryWrapper<CompositiveCoefficientEntity> query = new QueryWrapper<>();
        query.in("pid", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        long count = compositiveCoefficientService.count(query);
        if(count > 0) {
            return CommonResponse.error("分类下有综合系数项，不能删除！");
        }

        service.removeByIds(categoryIds,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompositiveCoefficientCategoryVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<CompositiveCoefficientCategoryEntity> page = service.queryPage(param,false);
        IPage<CompositiveCoefficientCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompositiveCoefficientCategoryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CompositiveCoefficientCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompositiveCoefficientCategory-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCompositiveCoefficientCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map> refCompositiveCoefficientCategoryData(@RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(1);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("searchText")) {
                param.setSearchText(conditionMap.get("searchText").toString());
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("sequence", "asc");
        param.setOrderMap(orderMap);
        List<CompositiveCoefficientCategoryEntity> list = service.queryList(param);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for(CompositiveCoefficientCategoryEntity entity : list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("sequence", entity.getSequence());
            resultMapList.add(map);
        }

        return resultMapList;
     }
}
