/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.other.bean.OtherChangeEntity;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.bean.OtherSupplementEntity;
import com.ejianc.business.pro.other.history.OtherSupplementHistoryVO;
import com.ejianc.business.pro.other.mapper.OtherSupplementMapper;
import com.ejianc.business.pro.other.service.IOtherChangeService;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.service.IOtherSupplementService;
import com.ejianc.business.pro.other.vo.OtherSupplementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSupplementService")
public class OtherSupplementServiceImpl
extends BaseServiceImpl<OtherSupplementMapper, OtherSupplementEntity>
implements IOtherSupplementService {
    private static final String SUPPLEMENT_BILL_CODE = "OTHER_SUPPLEMENT";
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherChangeService changeService;

    @Override
    public OtherSupplementVO saveOrUpdate(OtherSupplementVO saveOrUpdateVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        OtherSupplementEntity entity = (OtherSupplementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OtherSupplementEntity.class));
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(OtherSupplementEntity::getMainContractId, (Object)entity.getMainContractId());
        if (entity.getId() != null && entity.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)entity.getId());
        }
        lambdaQuery.ne(OtherSupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(OtherSupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdaQuery);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(OtherChangeEntity::getContractId, (Object)entity.getMainContractId());
        lambdachange.ne(OtherChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(OtherChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = this.changeService.count((Wrapper)lambdachange);
        if (changeNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)SUPPLEMENT_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() != null && entity.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSupplementEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSupplementEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity, false);
        OtherSupplementVO vo = (OtherSupplementVO)BeanMapper.map((Object)((Object)entity), OtherSupplementVO.class);
        return vo;
    }

    @Override
    public OtherSupplementVO addConvertByConId(Long id) {
        OtherContractEntity contractVO = (OtherContractEntity)((Object)this.contractService.selectById(id));
        OtherSupplementVO otherSupplementVO = new OtherSupplementVO();
        otherSupplementVO.setProjectId(contractVO.getProjectId());
        otherSupplementVO.setProjectName(contractVO.getProjectName());
        otherSupplementVO.setOrgId(contractVO.getOrgId());
        otherSupplementVO.setOrgName(contractVO.getOrgName());
        otherSupplementVO.setSupplierId(contractVO.getSupplierId());
        otherSupplementVO.setSupplierName(contractVO.getSupplierName());
        otherSupplementVO.setCustomerId(contractVO.getCustomerId());
        otherSupplementVO.setCustomerName(contractVO.getCustomerName());
        otherSupplementVO.setTaxRate(contractVO.getTaxRate());
        otherSupplementVO.setSupplementFlag(Integer.valueOf(1));
        otherSupplementVO.setContractStatus("2");
        otherSupplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        otherSupplementVO.setMainContractId(contractVO.getId());
        otherSupplementVO.setMainContractCode(contractVO.getBillCode());
        otherSupplementVO.setMainContractName(contractVO.getContractName());
        return otherSupplementVO;
    }

    @Override
    public OtherSupplementHistoryVO queryDetailRecord(Long id) {
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        OtherSupplementHistoryVO recordVO = new OtherSupplementHistoryVO();
        BigDecimal contractTaxMny = otherContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : otherContractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = otherContractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : otherContractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setChangeStatus(otherContractEntity.getChangeStatus());
        recordVO.setIsFinish(otherContractEntity.getIsFinish());
        recordVO.setIsSuspend(otherContractEntity.getIsSuspend());
        recordVO.setIsRelieve(otherContractEntity.getIsRelieve());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherSupplementEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(OtherSupplementEntity::getSignDate);
        List entities = super.list((Wrapper)lambda);
        recordVO.setDetailList(BeanMapper.mapList((Iterable)entities, OtherSupplementVO.class));
        return recordVO;
    }
}

