package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;

/**
 * 施工合同解除
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_contract_relieve")
public class ContractRelieveEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="register_id")
    private Long registerId; // 合同登记主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方
    @TableField(value="customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 合同乙方
    @TableField(value="supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value="construction_partner")
    private String constructionPartner; // 施工联合方
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @TableField(value="relieve_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date relieveDate; // 解除日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="relieve_reason")
    private String relieveReason; // 解除原因
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="contract_partyc")
    private String contractPartyc; // 合同丙方
    @TableField(value="conjoined_contract_total_mny")
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额

    /**
     * 合同登记主键
     */
    public Long getRegisterId() {
        return registerId;
    }

    /**
     * 合同登记主键
     */
    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 合同乙方
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 合同乙方
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 合同乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 合同乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 施工联合方
     */
    public String getConstructionPartner() {
        return constructionPartner;
    }

    /**
     * 施工联合方
     */
    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同(签订)金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同(签订)金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同(签订)金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同(签订)金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 解除日期
     */
    public java.util.Date getRelieveDate() {
        return relieveDate;
    }

    /**
     * 解除日期
     */
    public void setRelieveDate(java.util.Date relieveDate) {
        this.relieveDate = relieveDate;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 解除原因
     */
    public String getRelieveReason() {
        return relieveReason;
    }

    /**
     * 解除原因
     */
    public void setRelieveReason(String relieveReason) {
        this.relieveReason = relieveReason;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 合同丙方
     */
    public String getContractPartyc() {
        return contractPartyc;
    }

    /**
     * 合同丙方
     */
    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }
    /**
     * 联体合同总金额
     */
    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    /**
     * 联体合同总金额
     */
    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }
}
