package com.ejianc.business.pro.income.cons;

import java.util.HashMap;
import java.util.Map;

public class CommonConstants {

    public static final String QS = "1"; //变更洽商
    public static final String QZ = "2"; //经济签证
    public static final String SP = "3"; //索赔

    public static final String WPF = "0"; //未批复
    public static final String YPF = "1"; //已批复
    public static final String WTG = "2"; //未通过
    public static final String WU = "3"; //无

    /**
     * 变更签证索赔记录 关闭状态
     */
    public static final Integer CLOSE = 1;

    /**
     * 变更签证索赔记录 开启状态
     */
    public static final Integer OPEN = 0;

    /**
     * 变更签证索赔记录 未引用
     */
    public static final Integer WYY = 0;

    /**
     * 变更签证索赔记录 已引用
     */
    public static final Integer SLZ = 1;

    /**
     * 变更签证索赔记录 已受理
     */
    public static final Integer YSL = 2;

    public static final String 未报送= "0";
    public static final String 一审中= "1";
    public static final String 终审中= "2";
    public static final String 终审完成= "3";

    public static final Map<Integer, String> ReplyStatusMap = new HashMap<>();

    static{
        ReplyStatusMap.put(0,"未批复");
        ReplyStatusMap.put(1,"已批复");
        ReplyStatusMap.put(2,"未通过");
    }

}
