package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.ProductionClaimEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IProductionClaimService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.ParamUtil;
import com.ejianc.business.pro.income.vo.ProductionHistoryVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 产值报量
 * 
 * @author generator
 * 
 */
@RestController
@RequestMapping("production")
public class ProductionController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProductionService service;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IProductionClaimService productionClaimService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionVO> saveOrUpdate(@RequestBody ProductionVO saveorUpdateVO) {
        ProductionVO vo = service.saveOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryDetail(Long id) {
        ProductionVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return CommonResponse.success("删除成功！");
        }
        List<Long> ids = vos.stream().map(ProductionVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        param.getParams().put("useId", new Parameter(QueryParam.NE, null));
        List<ProductionEntity> list = service.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("单据被下游单据引用,暂不允许删除");
        }
        // 修改引用状态
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(queryParam);
        List<Long> claimIds = claimList.stream().map(x->x.getClaimId()).collect(Collectors.toList());
        service.updateClaimsUseCzFlag(claimIds, false);

        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 单据编号、所属单位、项目名称、发包方、经办人、经办部门
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("productionDate") ? param.getOrderMap().get("productionDate") : QueryParam.DESC);

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("productionDate") ? param.getOrderMap().get("productionDate") : QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<ProductionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ProductionVO> voList = BeanMapper.mapList(list, ProductionVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("production-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refProductionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> refProductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));
//        param.getParams().put("use_flag", new Parameter(QueryParam.NE, CommonConstants.SLZ));// 未引用
        ComplexParam useFlag = ParamUtil.getOrParam("useFlag", new Parameter(QueryParam.EQ, null), new Parameter(QueryParam.NE, CommonConstants.SLZ));
        param.getComplexParams().add(useFlag);
        param.getOrderMap().put("createTime", "desc");
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (null != _con.get("projectId")) {
                Long projectId = Long.valueOf(_con.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<ProductionEntity> page = service.queryPage(param,false);
        IPage<ProductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateContract 校验合同
     * @param id 合同ID
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(Long id) {
        String msg = service.validateContract(id);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description validateProjectId 校验项目
     * @param id 合同ID
     */
    @RequestMapping(value = "/validateProjectOrPeriod", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProjectOrPeriod(@RequestParam("projectId") Long projectId, @RequestParam(value = "id", required = false) Long id,
            @RequestParam(value = "period", required = false) String period) {
        String msg = service.validateProjectOrPeriod(projectId, id, period);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 产值报量历史记录
     * @param id 合同ID
     * @return
     */
    @RequestMapping(value = "/queryProductionHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionHistoryVO> queryProductionHistory(@RequestParam Long id) {
        ProductionHistoryVO vo = service.queryProductionHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        ProductionEntity productionEntity = service.selectById(id);
        ProductionVO vo = BeanMapper.map(productionEntity, ProductionVO.class);

        return CommonResponse.success("同步结算池成功！", service.pushSettleToPool(vo));
    }

    /**
     * @param projectId
     * @Description queryProductionVO 根据项目查询产值报量数据
     */
    @RequestMapping(value = "/queryProductionVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVO> queryProductionVO(Long projectId) {
        ProductionVO result = new ProductionVO();
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<BudgetEntity> budgetList = budgetService.queryList(param);
        List<ProductionEntity> list = service.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            result = BeanMapper.map(list.get(0), ProductionVO.class);
        }
        result.setBudgetMny(budgetList.stream().map(x->x.getBudgetMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        result.setBudgetTaxMny(budgetList.stream().map(x->x.getBudgetTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        BigDecimal sumMny = list.stream().map(x->x.getProductionMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal sumTaxMny = list.stream().map(x->x.getProductionTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.setLastProductionMny(sumMny);
        result.setLastProductionTaxMny(sumTaxMny);
        result.setSumProductionMny(sumMny);
        result.setSumProductionTaxMny(sumTaxMny);
        result.setReserveMny(ComputeUtil.safeSub(result.getBudgetMny(), sumMny));
        result.setReserveTaxMny(ComputeUtil.safeSub(result.getBudgetTaxMny(), sumTaxMny));
        return CommonResponse.success("查询详情数据成功！", result);
    }
}
