package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.BudgetFeeMapper;
import com.ejianc.business.pro.income.bean.BudgetFeeEntity;
import com.ejianc.business.pro.income.service.IBudgetFeeService;

import java.util.List;

/**
 * 费税清单
 * 
 * @author generator
 * 
 */
@Service("budgetFeeService")
public class BudgetFeeServiceImpl extends BaseServiceImpl<BudgetFeeMapper, BudgetFeeEntity> implements IBudgetFeeService{

    @Override
    public void delFeeByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetFeeEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delFeeBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetFeeEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetFeeEntity> queryFeeByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetFeeEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
