/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.other.service.impl;

import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.bean.OtherSettleEntity;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.service.IOtherSettleService;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import com.ejianc.business.pro.other.vo.OtherSettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettle")
public class OtherSettleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherSettleService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.service.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if ("1".equals(entity.getSettleType())) {
            boolean pushResult;
            if ("sucPushed".equals(contractEntity.getBillPushFlag()) && !(pushResult = this.service.pushContract((OtherContractVO)BeanMapper.map((Object)((Object)contractEntity), OtherContractVO.class), "3"))) {
                return CommonResponse.error((String)"\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25");
            }
        } else {
            OtherSettleVO settlementVO = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
            boolean pool = this.service.pushSettleToPool(settlementVO);
            if (!pool) {
                return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSettleEntity otherSettleEntity = (OtherSettleEntity)((Object)this.service.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(otherSettleEntity.getContractId()));
        BigDecimal quoteTaxMny = otherSettleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : otherSettleEntity.getSettleTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        contractEntity.setSumSettleTaxMny(quoteTaxMny.add(sumQuoteTaxMny));
        BigDecimal quoteMny = otherSettleEntity.getSettleMny() == null ? BigDecimal.ZERO : otherSettleEntity.getSettleMny();
        BigDecimal sumQuoteMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        contractEntity.setSumSettleMny(quoteMny.add(sumQuoteMny));
        if ("1".equals(otherSettleEntity.getSettleType())) {
            contractEntity.setContractStatus("3");
        }
        this.contractService.updateById((Object)contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSettleEntity quoteEntity = (OtherSettleEntity)((Object)this.service.selectById(billId));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(quoteEntity.getContractId()));
        if ("1".equals(quoteEntity.getSettleType())) {
            boolean pushResult;
            if ("sucPushed".equals(contractEntity.getBillPushFlag()) && !(pushResult = this.service.pushContract((OtherContractVO)BeanMapper.map((Object)((Object)contractEntity), OtherContractVO.class), "2"))) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25");
            }
            boolean pool = this.service.delSettleFromPool(billId);
            if (!pool) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
        }
        BigDecimal quoteTaxMny = quoteEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getSettleTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        contractEntity.setSumSettleTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));
        BigDecimal quoteMny = quoteEntity.getSettleMny() == null ? BigDecimal.ZERO : quoteEntity.getSettleMny();
        BigDecimal sumQuoteMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        contractEntity.setSumSettleMny(sumQuoteMny.subtract(quoteMny));
        if ("1".equals(quoteEntity.getSettleType())) {
            contractEntity.setContractStatus("2");
        }
        this.contractService.updateById((Object)contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

