package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.GeneralEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.mapper.FinalizedMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IGeneralService;
import com.ejianc.business.pro.income.utils.CommonUtils;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.business.tender.rent.vo.RentInviteDetailRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.text.ParseException;

/**
 * 工程定案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("finalized")
public class FinalizedController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private IFinalizedService service;
    @Autowired
    private IGeneralService generalService;

    @Autowired
    private IContractRegisterService registerService;


    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private FinalizedMapper finalizedMapper;

    @GetMapping(value = "contractByProject")
    @ResponseBody
    public CommonResponse<ContractRegisterVO> contractByProject(@RequestParam Long projectId) {
        ContractRegisterVO resp = null;
        List<ContractRegisterVO> contractList = contractRegisterService.getAllValidConsByProjectId(projectId); //查询项目下所有生效的施工合同Id
        if(CollectionUtils.isNotEmpty(contractList)) {
            for(ContractRegisterVO con : contractList) {
                if(null == resp) {
                    resp = con;
                } else {
                    resp.setContractTaxMny(ComputeUtil.safeAdd(resp.getContractTaxMny(), con.getContractTaxMny()));
                    resp.setContractMny(ComputeUtil.safeAdd(resp.getContractMny(), con.getContractMny()));
                }
            }
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value = "getByProjectId")
    @ResponseBody
    public CommonResponse<FinalizedVO> getByProjectId(@RequestParam Long projectId) {
        QueryWrapper<FinalizedEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        List<FinalizedEntity> list = service.list(query);

        return CommonResponse.success(CollectionUtils.isNotEmpty(list) ? BeanMapper.map(list.get(0), FinalizedVO.class) : null);
    }

    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {

//        QueryWrapper<FinalizedEntity> query = new QueryWrapper<>();
//        query.eq("project_id", saveOrUpdateVO.getProjectId());
//        if(null != saveOrUpdateVO.getId()) {
//            query.ne("id", saveOrUpdateVO.getId());
//        }
//        List<FinalizedEntity> list = service.list(query);
//        if(CollectionUtils.isNotEmpty(list)) {
//            return CommonResponse.error("操作失败，当前项目已存在竣工结算单！");
//        }

    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
    	FinalizedEntity entity = service.selectById(id);
    	FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List<Long> ids = vos.stream().map(FinalizedVO::getId).collect(Collectors.toList());
        
//        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
//        wrapper.in(FinalizedEntity::getId, ids);
//        List<FinalizedEntity> list = service.list(wrapper);
////        if(ListUtil.isNotEmpty(list)){
////            List<Long> contractIds = list.stream().filter(e -> e.getFinalStage().equals(FinalStageEnum.终审.getCode())).map(FinalizedEntity::getContractId).collect(Collectors.toList());
////            if(ListUtil.isNotEmpty(contractIds)){
////                // 删除终审单据后回写合同终审状态
////                LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
////                updateWrapper.set(ContractRegisterEntity::getIsFinish, 0);
////                updateWrapper.set(ContractRegisterEntity::getContractStatus, 1);
////                updateWrapper.in(ContractRegisterEntity::getId, contractIds);
////                registerService.update(updateWrapper);
////            }
////        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(param.getParams().containsKey("diffDateType")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String todayStr = sdf.format(new Date());
            switch (param.getParams().get("diffDateType").getValue().toString()) {
                case "0":
                    param.getParams().put("finalStage", Parameter.getEqInstance(CommonConstants.未报送));
                    break;
                case "1":
                    //一年内
                    param.getParams().put("report_date",
                            new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"+todayStr+"') >=0 AND DATEDIFF(DAY, report_date, '"
                                    +todayStr+"') <= 365"));
                    break;
                case "2":
                    //1~3年内
                    param.getParams().put("report_date", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"
                            +todayStr+"') >365 AND DATEDIFF(DAY, report_date, '"+todayStr+"') <= 1095"));
                    break;
                case "3":
                    //3年以上
                    param.getParams().put("report_date", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"
                            +todayStr+"') > 1095"));
                    break;
                default:;
            }

            param.getParams().remove("diffDateType");
        }

        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
  		for(FinalizedVO f : pageData.getRecords()) {
  		    if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
  		        if("0".equals(f.getFinalStage())) {
  		            //未报送时，超出竣工验收日期60天时 给予超出天数提示
                    Integer days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("未报送" + (days > 60 ? "(已超"+(days -60) + "天)" : ""));
                } else if("1".equals(f.getFinalStage())) {
                    //一审中时，超出报送日期180天时 给予超出天数提示
                    Integer days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("一审中" + (days > 180 ? "(已超"+(days -180) + "天)" : ""));
                } else if("2".equals(f.getFinalStage())) {
  		            //终审时，超出一身日期180天时，给予超出天数提示
                    Integer days = DateUtil.getSubDay(today, f.getFirstInstanceDate());
                    f.setFinalStageName("终审中" + (days > 180 ? "(已超"+(days -180) + "天)" : ""));
                } else {
                    f.setFinalStageName("终审完成");
                }
            } else {
                f.setFinalStageName("未报送");
            }
        }

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        if(param.getParams().containsKey("diffDateType")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String todayStr = sdf.format(new Date());

            param.getParams().put("billState", Parameter.getInInstance(new Integer[]{
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()
            }));
            param.getParams().put("finalStage", Parameter.getInInstance(new String[]{
                    CommonConstants.一审中, CommonConstants.终审中
            }));
            switch (param.getParams().get("diffDateType").getValue().toString()) {
                case "0":
                    param.getParams().put("finalStage", Parameter.getEqInstance(CommonConstants.未报送));
                    break;
                case "1":
                    //一年内
                    param.getParams().put("finalInstanceDate",
                            new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"+todayStr+"') >=0 AND DATEDIFF(DAY, report_date, '"
                                    +todayStr+"') <= 365"));
                    break;
                case "2":
                    //1~3年内
                    param.getParams().put("finalInstanceDate", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"
                            +todayStr+"') >365 AND DATEDIFF(DAY, report_date, '"+todayStr+"') <= 1095"));
                    break;
                case "3":
                    //3年以上
                    param.getParams().put("finalInstanceDate", new Parameter(QueryParam.SQL, " DATEDIFF(DAY, report_date, '"
                            +todayStr+"') > 1095"));
                    break;
                default:;
            }

            param.getParams().remove("diffDateType");
        }

        
        List<FinalizedEntity> list = service.queryList(param);
        List<FinalizedVO> voList = BeanMapper.mapList(list, FinalizedVO.class);
        Date today = DateUtil.parseDate(DateUtil.formatDate(new Date()));
        for(FinalizedVO f : voList) {
            if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(f.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(f.getBillState())) {
                if("0".equals(f.getFinalStage())) {
                    Integer days = DateUtil.getSubDay(today, f.getEndDate());
                    f.setFinalStageName("未报送" + (days > 60 ? "(已超"+(days -60) + "天)" : ""));
                } else if("1".equals(f.getFinalStage())) {
                    Integer days = DateUtil.getSubDay(today, f.getReportDate());
                    f.setFinalStageName("一审中" + (days > 180 ? "(已超"+(days -180) + "天)" : ""));
                } else if("2".equals(f.getFinalStage())) {
                    Integer days = DateUtil.getSubDay(today, f.getFirstInstanceDate());
                    f.setFinalStageName("终审中" + (days > 180 ? "(已超"+(days -180) + "天)" : ""));
                } else {
                    f.setFinalStageName("终审完成");
                }
            } else {
                f.setFinalStageName("未报送");
            }

            f.setBillStateName(BillStateEnum.getEnumByStateCode(f.getBillState()).getDescription());
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refFinalizedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize
            , String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    
    /**
     * 根据项目id、合同id查询结算报审单数据
     * @param projectId
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySettleReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required = false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success("查询数据成功！", service.querySettleReport(projectId, contractId));
    }
    
    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedList(projectId, contractId, id));
    }

    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/validateFinalStage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , String finalStage, @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedRecord(id));
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        FinalizedEntity finalizedEntity = service.selectById(id);
        FinalizedVO vo = BeanMapper.map(finalizedEntity, FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())){
            boolean pool = service.pushSettleToPool(vo);
            if(!pool){
                return CommonResponse.error("推送结算池失败");
            }
        } else {
            return CommonResponse.success("无需推送！", true);
        }
        return CommonResponse.success("同步结算池成功！", true);
    }

    @ApiOperation("总包结算-成本门户")
    @RequestMapping(value = "/queryAllSettleList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettleAnalysisVO>> queryAllSettleList(@RequestParam String year,
                                                                         @RequestParam(value = "orgId", required = false) Long orgId
    ) throws ParseException {
//        String startDate = null;
//        if ("thisYear".equals(dateIn)) {
//            startDate = DateFormatUtil.formatDate("yyyy-MM-dd", com.ejianc.framework.core.kit.time.DateUtil.beginOfYear(new Date()));
//        }

        //获取当前的年份的季度时间
//        Q1 (First Quarter): 2025-01-01 to 2025-03-31
//        Q2 (Second Quarter): 2025-04-01 to 2025-06-30
//        Q3 (Third Quarter): 2025-07-01 to 2025-09-30
//        Q4 (Fourth Quarter): 2025-10-01 to 2025-12-31
        List<SettleAnalysisVO> analysisVOList = new ArrayList<>();

        SettleAnalysisVO settleAnalysisVO1 = new SettleAnalysisVO();
        settleAnalysisVO1.setQuarterName("一季度");
        settleAnalysisVO1.setStartTime(year+ "-01-01");
        settleAnalysisVO1.setEndTime(year+ "-03-31");
        settleAnalysisVO1.setEndTime(year+ "-03-31");
        settleAnalysisVO1.setOrder(1);
        analysisVOList.add(settleAnalysisVO1);
        SettleAnalysisVO settleAnalysisVO2 = new SettleAnalysisVO();
        settleAnalysisVO2.setQuarterName("二季度");
        settleAnalysisVO2.setStartTime(year+ "-04-01");
        settleAnalysisVO2.setEndTime(year+ "-06-30");
        settleAnalysisVO2.setOrder(2);
        analysisVOList.add(settleAnalysisVO2);
        SettleAnalysisVO settleAnalysisVO3 = new SettleAnalysisVO();
        settleAnalysisVO3.setQuarterName("三季度");
        settleAnalysisVO3.setStartTime(year+ "-07-01");
        settleAnalysisVO3.setEndTime(year+ "-09-30");
        settleAnalysisVO3.setOrder(3);
        analysisVOList.add(settleAnalysisVO3);
        SettleAnalysisVO settleAnalysisVO4 = new SettleAnalysisVO();
        settleAnalysisVO4.setQuarterName("四季度");
        settleAnalysisVO4.setStartTime(year+ "-10-01");
        settleAnalysisVO4.setEndTime(year+ "-12-31");
        settleAnalysisVO4.setOrder(4);
        analysisVOList.add(settleAnalysisVO4);
        List<Long> orgList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        //获取竣工结算单的数据
        LambdaQueryWrapper<FinalizedEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(FinalizedEntity::getBillState,1,3);
        lambdaQueryWrapper.in(FinalizedEntity::getOrgId,orgList);
        List<FinalizedEntity> finalizedEntities = service.list(lambdaQueryWrapper);

        //获取总包结算单的数据
        LambdaQueryWrapper<GeneralEntity> lambdaQueryGeneralWrapper = new LambdaQueryWrapper<>();
        lambdaQueryGeneralWrapper.in(GeneralEntity::getBillState,1,3);
        lambdaQueryGeneralWrapper.in(GeneralEntity::getOrgId,orgList);
//        List<GeneralEntity> generalEntities = generalService.list(lambdaQueryGeneralWrapper);
        List<GeneralDetailVO> generalEntities = finalizedMapper.getGeneralList(orgList);

        Integer yearNum = Integer.parseInt(year);
        // 设置指定年份的时间范围
        Calendar calStart = Calendar.getInstance();
        calStart.set(Calendar.YEAR, yearNum);
        calStart.set(Calendar.MONTH, Calendar.JANUARY);
        calStart.set(Calendar.DAY_OF_MONTH, 1);
        calStart.set(Calendar.HOUR_OF_DAY, 0);
        calStart.set(Calendar.MINUTE, 0);
        calStart.set(Calendar.SECOND, 0);
        calStart.set(Calendar.MILLISECOND, 0);

        Calendar calEnd = Calendar.getInstance();
        calEnd.set(Calendar.YEAR, yearNum + 1);
        calEnd.set(Calendar.MONTH, Calendar.JANUARY);
        calEnd.set(Calendar.DAY_OF_MONTH, 1);
        calEnd.set(Calendar.HOUR_OF_DAY, 0);
        calEnd.set(Calendar.MINUTE, 0);
        calEnd.set(Calendar.SECOND, 0);
        calEnd.set(Calendar.MILLISECOND, 0);

//        Date yearStart = calStart.getTime();
//        Date yearEnd = calEnd.getTime();

        long countAll1 = 0L;
        long countAll2 = 0L;
        long countAll3 = 0L;
        long sumAll1 = 0L;
        long sumAll2 = 0L;
        long sumAll3 = 0L;
        for (SettleAnalysisVO settleAnalysisVO : analysisVOList){
//            if (!settleAnalysisVO.getQuarterName().equals("年度")){
            Date yearStart = parseDate(settleAnalysisVO.getStartTime());
            Date yearEnd = parseDate(settleAnalysisVO.getEndTime());
//            }

            //报出完成率
            //获取竣工结算单中一审中的单据数量
            long count1 = 0L;
            long count2 = 0L;
            long count3 = 0L;
            if (CollectionUtils.isNotEmpty(finalizedEntities)){

                String finalStage = "1";
                count1 = getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll1 = countAll1 + count1;
                finalStage = "2";
                count2 = getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll2 = countAll2 + count2;
                finalStage = "3";
                count3 = getFinalizedCount(finalizedEntities, yearStart, yearEnd, finalStage);
                countAll3 = countAll3 + count3;
            }

            long sum1 = 0L;
            long sum2 = 0L;
            long sum3 = 0L;
            if (CollectionUtils.isNotEmpty(generalEntities)){

                Date finalYearStart1 = yearStart;
                Date finalYearEnd1 = yearEnd;
                //报出数量
                sum1 = generalEntities.stream()
                        .filter(entity ->
                                entity.getSettlementTime() != null &&
                                        !entity.getSettlementTime().before(finalYearStart1) &&
                                        !entity.getSettlementTime().after(finalYearEnd1))
                        // 按orgId分组
                        .collect(Collectors.groupingBy(GeneralDetailVO::getOrgId))
                        .values().stream()
                        // 处理每个分组：计算该分组中最大edition的记录数
                        .mapToLong(group -> {
                            // 获取分组中的最大edition值
                            Optional<Integer> maxEdition = group.stream()
                                    .map(GeneralDetailVO::getEditon)
                                    .max(Comparator.naturalOrder());

                            if (!maxEdition.isPresent()) return 0L;

                            // 统计最大edition值的出现次数（包括重复）
                            return group.stream()
                                    .filter(e -> e.getEditon() == maxEdition.get())
                                    .count();
                        })
                        // 累计所有分组的记录数
                        .sum();
                sumAll1 = sumAll1 + sum1;
                //一审数量
                sum2 = generalEntities.stream()
                        .filter(entity ->
                                entity.getFirstTime() != null &&
                                        !entity.getFirstTime().before(finalYearStart1) &&
                                        !entity.getFirstTime().after(finalYearEnd1))
                        // 按orgId分组
                        .collect(Collectors.groupingBy(GeneralDetailVO::getOrgId))
                        .values().stream()
                        // 处理每个分组：计算该分组中最大edition的记录数
                        .mapToLong(group -> {
                            // 获取分组中的最大edition值
                            Optional<Integer> maxEdition = group.stream()
                                    .map(GeneralDetailVO::getEditon)
                                    .max(Comparator.naturalOrder());

                            if (!maxEdition.isPresent()) return 0L;

                            // 统计最大edition值的出现次数（包括重复）
                            return group.stream()
                                    .filter(e -> e.getEditon() == maxEdition.get())
                                    .count();
                        })
                        // 累计所有分组的记录数
                        .sum();
                sumAll2 = sumAll2 + sum2;
                //终审数量
                sum3 = generalEntities.stream()
                        .filter(entity ->
                                entity.getFirstTime() != null &&
                                        !entity.getFirstTime().before(finalYearStart1) &&
                                        !entity.getFirstTime().after(finalYearEnd1))
                        // 按orgId分组
                        .collect(Collectors.groupingBy(GeneralDetailVO::getOrgId))
                        .values().stream()
                        // 处理每个分组：计算该分组中最大edition的记录数
                        .mapToLong(group -> {
                            // 获取分组中的最大edition值
                            Optional<Integer> maxEdition = group.stream()
                                    .map(GeneralDetailVO::getEditon)
                                    .max(Comparator.naturalOrder());

                            if (!maxEdition.isPresent()) return 0L;

                            // 统计最大edition值的出现次数（包括重复）
                            return group.stream()
                                    .filter(e -> e.getEditon() == maxEdition.get())
                                    .count();
                        })
                        // 累计所有分组的记录数
                        .sum();
                sumAll3 = sumAll3 + sum3;
            }
            BigDecimal decimalCount1 = ComputeUtil.toBigDecimal(count1);
            BigDecimal decimalSum1 = ComputeUtil.toBigDecimal(sum1);
            BigDecimal decimalCount2 = ComputeUtil.toBigDecimal(count2);
            BigDecimal decimalSum2 = ComputeUtil.toBigDecimal(sum2);
            BigDecimal decimalCount3 = ComputeUtil.toBigDecimal(count3);
            BigDecimal decimalSum3 = ComputeUtil.toBigDecimal(sum3);
            settleAnalysisVO.setBcRate(CommonUtils.calculateRate2(decimalCount1,decimalSum1));
            settleAnalysisVO.setYsRate(CommonUtils.calculateRate2(decimalCount2,decimalSum2));
            settleAnalysisVO.setZsRate(CommonUtils.calculateRate2(decimalCount3,decimalSum3));

        }

    SettleAnalysisVO settleAnalysisAllVO = new SettleAnalysisVO();
    BigDecimal countAllS1 = ComputeUtil.toBigDecimal(countAll1);
    BigDecimal sumAllS1 = ComputeUtil.toBigDecimal(sumAll1);
    BigDecimal countAllS2 = ComputeUtil.toBigDecimal(countAll2);
    BigDecimal sumAllS2 = ComputeUtil.toBigDecimal(sumAll2);
    BigDecimal countAllS3 = ComputeUtil.toBigDecimal(countAll3);
    BigDecimal sumAllS3 = ComputeUtil.toBigDecimal(sumAll3);

    settleAnalysisAllVO.setQuarterName("年度");
    settleAnalysisAllVO.setOrder(0);
    settleAnalysisAllVO.setBcRate(CommonUtils.calculateRate2(countAllS1,sumAllS1));
    settleAnalysisAllVO.setYsRate(CommonUtils.calculateRate2(countAllS2,sumAllS2));
    settleAnalysisAllVO.setZsRate(CommonUtils.calculateRate2(countAllS3,sumAllS3));

    analysisVOList.add(settleAnalysisAllVO);
    analysisVOList.sort(Comparator.comparingInt(SettleAnalysisVO::getOrder));

    return CommonResponse.success("查询总包结算成功！", analysisVOList);
    }

    private long getFinalizedCount(List<FinalizedEntity> finalizedEntities, Date yearStart, Date yearEnd, String finalStage) {
        long count;
        Date finalYearStart = yearStart;
        Date finalYearEnd = yearEnd;
        count = finalizedEntities.stream()
                .filter(s -> s.getFinalStage() != null && finalStage.equals(s.getFinalStage()) && s.getCreateTime() != null &&
                        !s.getCreateTime().before(finalYearStart) &&
                        s.getCreateTime().before(finalYearEnd))
                .count();
        return count;
    }

    private Date parseDate(String dateStr) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
    }
    
}
